<?php
include '../url.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="GIFAM - General Investment Fund Assets & Management Company. Specialized in financial support for global projects. Based in Cyprus with branches worldwide.">
    <meta name="keywords" content="GIFAM, investment fund, financial support, global projects, Cyprus, Brussels, asset management, project financing">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title>About GIFAM - General Investment Fund Assets & Management Company</title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>about/">About Us</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
<br>
<br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h2>About GIFAM</h2>
                            <p class="lead">At General Investment Fund Assets & Management Company (GIFAM), we specialize in the provision of financial support for a diverse range of global projects. Incorporated in Agios Dometios, Cyprus with branches in Brussels, Belgium and many other places in the World.</p>
                            <p>With decades of experience in international finance and investment management, GIFAM has established itself as a trusted partner for businesses seeking comprehensive financial solutions. Our global presence allows us to serve clients across multiple jurisdictions while maintaining the highest standards of professional excellence.</p>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/about/about.jpg" alt="GIFAM Office" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Company Overview -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Our Global Presence</h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-world" style="font-size: 3rem; color: #007bff;"></i>
                                </div>
                                <h4>Headquarters - Cyprus</h4>
                                <p>Our main office is located in Agios Dometios, Cyprus, providing a strategic base for European and Middle Eastern operations.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> European Union jurisdiction</li>
                                    <li><i class="icofont-check-circled text-success"></i> Strategic location</li>
                                    <li><i class="icofont-check-circled text-success"></i> Regulatory compliance</li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-building" style="font-size: 3rem; color: #28a745;"></i>
                                </div>
                                <h4>European Hub - Brussels</h4>
                                <p>Our Brussels branch serves as our European headquarters, connecting us to the heart of EU financial markets and regulatory bodies.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> EU financial center</li>
                                    <li><i class="icofont-check-circled text-success"></i> Regulatory access</li>
                                    <li><i class="icofont-check-circled text-success"></i> International networking</li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-globe" style="font-size: 3rem; color: #ffc107;"></i>
                                </div>
                                <h4>Global Network</h4>
                                <p>With offices and partners worldwide, we provide local expertise combined with global reach for all our clients' needs.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> Worldwide presence</li>
                                    <li><i class="icofont-check-circled text-success"></i> Local expertise</li>
                                    <li><i class="icofont-check-circled text-success"></i> Cultural understanding</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Our Mission & Vision -->
                    <div class="row mb-5">
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded h-100">
                                <h3><i class="icofont-target text-primary me-2"></i>Our Mission</h3>
                                <p>To provide innovative financial solutions that empower businesses and individuals to achieve their investment goals while maintaining the highest standards of integrity, transparency, and professional excellence.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> Innovative financial solutions</li>
                                    <li><i class="icofont-check-circled text-success"></i> Client empowerment</li>
                                    <li><i class="icofont-check-circled text-success"></i> Integrity and transparency</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded h-100">
                                <h3><i class="icofont-eye text-success me-2"></i>Our Vision</h3>
                                <p>To be the leading global investment management company, recognized for our expertise, innovation, and commitment to delivering exceptional value to our clients across all markets and sectors.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> Global leadership</li>
                                    <li><i class="icofont-check-circled text-success"></i> Innovation focus</li>
                                    <li><i class="icofont-check-circled text-success"></i> Exceptional value delivery</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Core Values -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Our Core Values</h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                    <i class="icofont-shield-check" style="font-size: 2rem;"></i>
                                </div>
                                <h5>Integrity</h5>
                                <p>We maintain the highest ethical standards in all our business practices and client relationships.</p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-success text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                    <i class="icofont-lightbulb" style="font-size: 2rem;"></i>
                                </div>
                                <h5>Innovation</h5>
                                <p>We continuously seek innovative solutions to meet the evolving needs of our global client base.</p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-warning text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                    <i class="icofont-users" style="font-size: 2rem;"></i>
                                </div>
                                <h5>Excellence</h5>
                                <p>We strive for excellence in every aspect of our service delivery and client satisfaction.</p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-info text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                    <i class="icofont-handshake-deal" style="font-size: 2rem;"></i>
                                </div>
                                <h5>Partnership</h5>
                                <p>We build long-term partnerships based on trust, mutual respect, and shared success.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Services Overview -->
                    <div class="row mb-5">
                        <div class="col-lg-6">
                            <img src="<?php echo $url; ?>images/case-study/case-study-1.jpg" alt="GIFAM Services" class="img-fluid rounded shadow">
                        </div>
                        <div class="col-lg-6">
                            <h3>Our Comprehensive Services</h3>
                            <p>GIFAM offers a wide range of financial services designed to meet the diverse needs of our global clientele:</p>
                            <div class="feature-list">
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5>Project Financing</h5>
                                        <p>Expert advice on securing financing for large-scale projects across various industries.</p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5>Investment Analysis</h5>
                                        <p>Comprehensive investment analysis and strategic recommendations for optimal returns.</p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5>Risk Management</h5>
                                        <p>Advanced risk assessment and mitigation strategies to protect your investments.</p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5>Asset Management</h5>
                                        <p>Professional portfolio management and diversification strategies for optimal performance.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Global Reach -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Our Global Reach</h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url; ?>images/case-study/case-study-2.jpg" alt="Europe" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5>Europe</h5>
                                <p>Strong presence across European markets with offices in Cyprus and Belgium, serving clients throughout the EU.</p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url; ?>images/case-study/case-study-3.jpg" alt="Middle East" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5>Middle East</h5>
                                <p>Strategic partnerships and operations in key Middle Eastern markets, providing local expertise with global standards.</p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url; ?>images/case-study/case-study-4.jpg" alt="Global Markets" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5>Global Markets</h5>
                                <p>Worldwide network of partners and representatives, enabling us to serve clients in emerging and developed markets.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Why Choose GIFAM -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Why Choose GIFAM?</h3>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded">
                                <h4><i class="icofont-chart-flow text-primary me-2"></i>Expert Team</h4>
                                <p>Our team consists of experienced financial professionals with deep expertise in international markets, regulatory compliance, and investment strategies.</p>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded">
                                <h4><i class="icofont-globe text-success me-2"></i>Global Network</h4>
                                <p>With offices and partners worldwide, we provide local expertise combined with global reach for all our clients' needs.</p>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded">
                                <h4><i class="icofont-shield-check text-warning me-2"></i>Regulatory Compliance</h4>
                                <p>We maintain strict compliance with international financial regulations and standards across all jurisdictions where we operate.</p>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded">
                                <h4><i class="icofont-handshake-deal text-info me-2"></i>Client-Centric Approach</h4>
                                <p>We prioritize our clients' success, providing personalized solutions and dedicated support throughout our partnership.</p>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Ready to Partner with GIFAM?</h3>
                                <p class="lead mb-4">Join our global network of satisfied clients and discover how our expertise can help you achieve your financial goals.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Contact Us Today</a>
                                <a href="<?php echo $url; ?>our-services/" class="btn btn-outline-primary btn-lg">Explore Our Services</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

</body>
</html>