<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="FAQ - Frequently Asked Questions about GIFAM's investment and funding services. Get answers about our financing process, services, and requirements.">
    <meta name="keywords" content="FAQ, frequently asked questions, GIFAM, investment, funding, financing, project financing, Cyprus">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title>FAQ - Frequently Asked Questions - GIFAM</title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>faq/">FAQ</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
    <br>
  <br>

    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    <br>
                    <br>
                    <!-- Investment and Funding Process FAQ -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="custom-heading" style="margin-top: -80px;">
                                <h2 class="heading-title" style="color:#383838">ABOUT INVESTMENT AND FUNDING PROCESS</h2>
                            </div>
                            
                            <div class="accordion">
                                <div class="accordion-item">
                                    <h2 id="accordion-button-1" aria-expanded="false">
                                        <span class="accordion-title">How I can leverage on GIFAM's solutions for CAPEX & OPEX</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>At GIFAM, we provide a strategic approach to managing both Capital Expenditures (CAPEX) and Operating Expenses (OPEX), offering our clients a robust platform to optimize their investments and operational costs. Our specialized services in financial and risk management enable clients to make informed decisions about CAPEX, ensuring that their investments in physical assets or long-term projects are sound, efficient, and aligned with their long-term strategic goals.</p>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 id="accordion-button-2" aria-expanded="false">
                                        <span class="accordion-title">What is General Investment Fund Assets & Management Company (GIFAM)?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>GIFAM is an International Business Company, incorporated in Ayiou Pavlou 61 Agios Dometios, Cyprus. We specialize in financing projects worldwide, offering soft loans to entrepreneurs and businesses for new and revitalizing projects.</p>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 id="accordion-button-3" aria-expanded="false">
                                        <span class="accordion-title">What financial services does GIFAM offer?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>Our services include Asset Management, Investment Banking Brokerage, Real Estate, and Private Finance. We provide loans and asset financing, partner with companies on projects, and have an extensive investment portfolio in various sectors.</p>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 id="accordion-button-4" aria-expanded="false">
                                        <span class="accordion-title">What is the minimum project value for which GIFAM provides financing?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>We finance projects with a minimum value of $20 million globally, catering to both corporate and private companies.</p>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 id="accordion-button-5" aria-expanded="false">
                                        <span class="accordion-title">What are the terms and conditions for GIFAM's loans?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>Our loans are offered at a low annual Return on Investment (ROI) rate with flexible terms. We require a thorough review of business plans before drafting a Memorandum of Understanding (MOU) and FTCA form, which are provided prior to disbursing funds through our reliable banking channels.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- General Questions FAQ -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="custom-heading">
                                <h2 class="heading-title">GENERAL QUESTIONS</h2>
                            </div>
                            
                            <div class="accordion">
                                <div class="accordion-item">
                                    <h2 id="accordion-button-6" aria-expanded="false">
                                        <span class="accordion-title">How does GIFAM ensure the success of the projects it finances?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>We commit to entrepreneurs and business owners by thoroughly reviewing and considering their projects. We negotiate precise and defined terms and timeframes that are agreeable to all parties involved, ensuring a collaborative approach to success.</p>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 id="accordion-button-7" aria-expanded="false">
                                        <span class="accordion-title">Can individuals apply for financing from GIFAM, or is it only for companies?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>Both companies and individuals with viable project proposals and clear visions can apply for financing from GIFAM.</p>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 id="accordion-button-8" aria-expanded="false">
                                        <span class="accordion-title">What makes GIFAM unique in the investment market?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>GIFAM stands out for its dynamic, diversified approach and its strong presence in the GCC. We integrate global financial markets with regional projects, driven by our integrity and commitment to assisting serious-minded investors.</p>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 id="accordion-button-9" aria-expanded="false">
                                        <span class="accordion-title">How can I contact GIFAM for a project or investment inquiry?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>Interested parties can contact us through our designated communication channels. We are always ready to listen to real business owners or entrepreneurs who need funding or have viable project proposals to present.</p>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 id="accordion-button-10" aria-expanded="false">
                                        <span class="accordion-title">How does GIFAM ensure the confidentiality and security of client information and projects?</span>
                                        <span class="icon" aria-hidden="true"></span>
                                    </h2>
                                    <div class="accordion-content">
                                        <p>At GIFAM, we place utmost importance on maintaining the confidentiality and security of our clients' information and projects. We employ stringent security measures and adhere to strict confidentiality protocols to protect sensitive data. Our team is bound by non-disclosure agreements, ensuring that all client information remains secure and confidential.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Still Have Questions?</h3>
                                <p class="lead mb-4">If you couldn't find the answer you're looking for, our team is here to help. Contact us for personalized assistance.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Contact Us</a>
                                <a href="<?php echo $url; ?>our-services/" class="btn btn-outline-primary btn-lg">View Our Services</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

<style>
@import url('https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap');

.accordion{
  padding:100px;
}

.accordion .accordion-item {
  box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
  padding:15px 20px;
  margin-top:20px;
  border-radius:10px;
}
.accordion .accordion-item button[aria-expanded=true] {
/*   border-bottom: 1px solid #dc3545; */
}
.accordion h2 {
  position: relative;
  display: block;
  text-align: left;
  width: 100%;
/*    padding: 1em 0; */
  color: #333333;
  font-size: 1.15rem;
  font-weight: 400;
  border: none;
  background: none;
  outline: none;
  padding:0px;
  line-height:25px;
  margin:0px;
  font-family: 'Open Sans', sans-serif;
}
.accordion h2:hover, .accordion h2:focus {
  cursor: pointer;
  color: #dc3545;
}
.accordion h2:hover::after, .accordion h2:focus::after {
  cursor: pointer;
  color: #dc3545;
  border: 1px solid #dc3545;
}
.accordion h2 .accordion-title {
  padding: 1em 1.5em 1em 0;
}
.accordion h2 .icon {
  display: inline-block;
  position: absolute;
  top: 2px;
  right: 0;
  width: 22px;
  height: 22px;
  border: 1px solid;
  border-radius: 22px;
}
.faq-content {
    padding: 80px 0px;
}
.accordion h2 .icon::before {
  display: block;
  position: absolute;
  content: "";
  top: 9px;
  left: 5px;
  width: 10px;
  height: 2px;
  background: currentColor;
}
.accordion h2 .icon::after {
  display: block;
  position: absolute;
  content: "";
  top: 5px;
  left: 9px;
  width: 2px;
  height: 10px;
  background: currentColor;
}
.accordion h2[aria-expanded=true] {
  color: #dc3545;
}
.accordion h2[aria-expanded=true] .icon::after {
  width: 0;
}
.accordion h2[aria-expanded=true] + .accordion-content {
  opacity: 1;
  max-height: 5000px;
  transition: all 200ms linear;
  will-change: opacity, max-height;
}
.accordion .accordion-content {
  opacity: 0;
  max-height: 0;
  overflow: hidden;
  transition: opacity 200ms linear, max-height 200ms linear;
  will-change: opacity, max-height;
}
.accordion .accordion-content p {
  font-size: 1rem;
  font-weight: 300;
  margin: 0px;
  margin-top: 10px;
  font-family: 'Open Sans', sans-serif;
}
</style>

<script>
const items = document.querySelectorAll(".accordion-item h2");

function toggleAccordion() {
  const itemToggle = this.getAttribute('aria-expanded');
  
  for (i = 0; i < items.length; i++) {
    items[i].setAttribute('aria-expanded', 'false');
  }
  
  if (itemToggle == 'false') {
    this.setAttribute('aria-expanded', 'true');
  }
}

items.forEach(item => item.addEventListener('click', toggleAccordion));
</script>

</body>
</html> 