<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestion d'Investissement - GIFAM | Services de Gestion de Portefeuille Professionnelle</title>
    <meta name="description" content="GIFAM offre des services de gestion d'investissement professionnelle. Notre équipe d'experts gère votre portefeuille avec des stratégies personnalisées pour maximiser vos rendements.">
    <meta name="keywords" content="gestion d'investissement, gestion de portefeuille, investissement professionnel, GIFAM, conseil financier">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo $url; ?>investment-management/">
    <meta property="og:title" content="Gestion d'Investissement - GIFAM">
    <meta property="og:description" content="Services de gestion d'investissement professionnelle avec des stratégies personnalisées pour maximiser vos rendements.">
    <meta property="og:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">

    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo $url; ?>investment-management/">
    <meta property="twitter:title" content="Gestion d'Investissement - GIFAM">
    <meta property="twitter:description" content="Services de gestion d'investissement professionnelle avec des stratégies personnalisées.">
    <meta property="twitter:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo $url; ?>images/logos/fav.png">
    
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/responsive.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/icofont.css">
    
    <!-- Custom CSS for Investment Management -->
    <style>
        .investment-hero {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .investment-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('<?php echo $url; ?>images/primary-blur-bg.png') center/cover;
            opacity: 0.1;
        }
        
        .investment-hero .container {
            position: relative;
            z-index: 2;
        }
        
        .hero-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 30px;
            margin-top: 60px;
        }
        
        .stat-item {
            text-align: center;
            padding: 30px 20px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 15px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .stat-number {
            font-size: 3rem;
            font-weight: 700;
            color: #ff6b35;
            margin-bottom: 10px;
        }
        
        .stat-label {
            font-size: 1.1rem;
            color: #e0e0e0;
        }
        
        .management-section {
            padding: 80px 0;
        }
        
        .service-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid #f0f0f0;
        }
        
        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
        }
        
        .service-icon {
            width: 80px;
            height: 80px;
            background: #DB2913;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 25px;
            color: white;
            font-size: 2rem;
        }
        
        .process-step {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
            position: relative;
            margin-bottom: 30px;
        }
        
        .step-number {
            position: absolute;
            top: -15px;
            left: 30px;
            width: 40px;
            height: 40px;
            background: #ff6b35;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 1.2rem;
        }
        
        .strategy-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 50px;
        }
        
        .strategy-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
            border-left: 5px solid #ff6b35;
        }
        
        .strategy-card h4 {
            color: #333;
            margin-bottom: 15px;
            font-weight: 600;
        }
        
        .strategy-card ul {
            list-style: none;
            padding: 0;
        }
        
        .strategy-card li {
            padding: 8px 0;
            position: relative;
            padding-left: 25px;
        }
        
        .strategy-card li::before {
            content: '✓';
            position: absolute;
            left: 0;
            color: #ff6b35;
            font-weight: bold;
        }
        
        .cta-section {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white;
            padding: 80px 0;
            text-align: center;
        }
        
        .cta-button {
            background: #DB2913;
            color: white;
            padding: 15px 40px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            display: inline-block;
            margin-top: 30px;
            transition: all 0.3s ease;
            border: none;
        }
        
        .cta-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(219,41,19,0.4);
            color: white;
            text-decoration: none;
        }
        .btn-primary {
            background: #DB2913 !important;
            border-color: #DB2913 !important;
        }
        .btn-primary:hover, .btn-primary:focus {
            background: #a81f0f !important;
            border-color: #a81f0f !important;
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="investment-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-4 fw-bold mb-4">Gestion d'Investissement Professionnelle</h1>
                    <p class="lead mb-4">Confiez votre avenir financier à nos experts. Nous gérons votre portefeuille avec des stratégies personnalisées pour maximiser vos rendements tout en minimisant les risques.</p>
                    <div class="hero-buttons">
                        <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Consultation Gratuite</a>
                        <a href="#services" class="btn btn-outline-light btn-lg">Nos Services</a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <img src="<?php echo $url; ?>images/case-study/project-result.png" alt="Gestion d'Investissement" class="img-fluid rounded-3">
                </div>
            </div>
            
            <div class="hero-stats">
                <div class="stat-item">
                    <div class="stat-number">15+</div>
                    <div class="stat-label">Années d'Expérience</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">500M+</div>
                    <div class="stat-label">€ d'Actifs Gérés</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">95%</div>
                    <div class="stat-label">Clients Satisfaits</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">12%</div>
                    <div class="stat-label">Rendement Moyen</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section id="services" class="management-section">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-8 mx-auto">
                    <h2 class="display-5 fw-bold mb-4">Nos Services de Gestion</h2>
                    <p class="lead">Nous offrons une gamme complète de services de gestion d'investissement adaptés à vos besoins spécifiques.</p>
                </div>
            </div>
            
            <div class="row g-4">
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-briefcase"></i></div>
                        <h4>Gestion de Portefeuille</h4>
                        <p>Gestion personnalisée de votre portefeuille d'investissements avec allocation d'actifs optimisée selon votre profil de risque.</p>
                        <ul class="list-unstyled">
                            <li>✓ Allocation d'actifs dynamique</li>
                            <li>✓ Rééquilibrage automatique</li>
                            <li>✓ Suivi de performance</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-chart-bar-graph"></i></div>
                        <h4>Analyse et Recherche</h4>
                        <p>Analyse approfondie des marchés et recherche d'opportunités d'investissement dans tous les secteurs.</p>
                        <ul class="list-unstyled">
                            <li>✓ Analyse fondamentale</li>
                            <li>✓ Recherche sectorielle</li>
                            <li>✓ Veille économique</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-shield"></i></div>
                        <h4>Gestion des Risques</h4>
                        <p>Stratégies de gestion des risques pour protéger votre capital et optimiser le ratio risque/rendement.</p>
                        <ul class="list-unstyled">
                            <li>✓ Diversification intelligente</li>
                            <li>✓ Hedging stratégique</li>
                            <li>✓ Monitoring continu</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-certificate"></i></div>
                        <h4>Optimisation Fiscale</h4>
                        <p>Stratégies d'investissement optimisées pour minimiser votre charge fiscale et maximiser vos gains nets.</p>
                        <ul class="list-unstyled">
                            <li>✓ Planification fiscale</li>
                            <li>✓ Produits fiscalement avantageux</li>
                            <li>✓ Reporting fiscal</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-ui-calendar"></i></div>
                        <h4>Planification de Retraite</h4>
                        <p>Stratégies d'épargne et d'investissement pour sécuriser votre avenir et maintenir votre niveau de vie.</p>
                        <ul class="list-unstyled">
                            <li>✓ Épargne retraite</li>
                            <li>✓ Produits de retraite</li>
                            <li>✓ Projections financières</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6">
                    <div class="service-card">
                        <div class="service-icon"><i class="icofont-bank"></i></div>
                        <h4>Gestion de Patrimoine</h4>
                        <p>Approche globale de la gestion de votre patrimoine incluant investissements, immobilier et succession.</p>
                        <ul class="list-unstyled">
                            <li>✓ Conseil patrimonial</li>
                            <li>✓ Transmission de patrimoine</li>
                            <li>✓ Optimisation successorale</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section class="management-section bg-light">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-8 mx-auto">
                    <h2 class="display-5 fw-bold mb-4">Notre Processus de Gestion</h2>
                    <p class="lead">Une approche méthodique et transparente pour optimiser vos investissements.</p>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number"><i class="icofont-users-alt-3"></i></div>
                        <h4>Évaluation Initiale</h4>
                        <p>Analyse approfondie de votre situation financière, objectifs et tolérance au risque pour définir votre profil d'investisseur.</p>
                        <ul>
                            <li>Analyse de votre situation actuelle</li>
                            <li>Définition de vos objectifs</li>
                            <li>Évaluation de votre profil de risque</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number"><i class="icofont-handshake-deal"></i></div>
                        <h4>Stratégie Personnalisée</h4>
                        <p>Élaboration d'une stratégie d'investissement sur mesure adaptée à vos besoins et objectifs spécifiques.</p>
                        <ul>
                            <li>Allocation d'actifs optimisée</li>
                            <li>Sélection d'instruments financiers</li>
                            <li>Plan de diversification</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number"><i class="icofont-chart-growth"></i></div>
                        <h4>Exécution et Suivi</h4>
                        <p>Mise en œuvre de la stratégie avec un suivi continu et des ajustements en temps réel selon l'évolution des marchés.</p>
                        <ul>
                            <li>Exécution des ordres</li>
                            <li>Monitoring quotidien</li>
                            <li>Ajustements stratégiques</li>
                        </ul>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number"><i class="icofont-pie-chart"></i></div>
                        <h4>Reporting et Optimisation</h4>
                        <p>Rapports réguliers sur la performance et optimisation continue de la stratégie pour maximiser les rendements.</p>
                        <ul>
                            <li>Rapports de performance</li>
                            <li>Analyse comparative</li>
                            <li>Optimisation continue</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Strategies Section -->
    <section class="management-section">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-8 mx-auto">
                    <h2 class="display-5 fw-bold mb-4">Nos Stratégies d'Investissement</h2>
                    <p class="lead">Des approches éprouvées pour différents profils d'investisseurs et objectifs financiers.</p>
                </div>
            </div>
            
            <div class="strategy-grid">
                <div class="strategy-card">
                    <h4>Stratégie Conservatrice</h4>
                    <p>Pour les investisseurs privilégiant la préservation du capital avec un rendement stable.</p>
                    <ul>
                        <li>Allocation majoritairement en obligations</li>
                        <li>Actions de grandes entreprises stables</li>
                        <li>Produits monétaires</li>
                        <li>Rendement attendu : 3-5% annuel</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie Équilibrée</h4>
                    <p>Équilibre entre croissance et stabilité pour un portefeuille diversifié.</p>
                    <ul>
                        <li>Mix actions/obligations 60/40</li>
                        <li>Diversification internationale</li>
                        <li>Produits alternatifs</li>
                        <li>Rendement attendu : 6-8% annuel</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie Dynamique</h4>
                    <p>Pour les investisseurs recherchant une croissance agressive du capital.</p>
                    <ul>
                        <li>Majorité en actions</li>
                        <li>Exposition aux marchés émergents</li>
                        <li>Produits structurés</li>
                        <li>Rendement attendu : 8-12% annuel</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie Alternative</h4>
                    <p>Investissements non traditionnels pour diversifier et améliorer les rendements.</p>
                    <ul>
                        <li>Private Equity</li>
                        <li>Immobilier d'entreprise</li>
                        <li>Commodities et matières premières</li>
                        <li>Hedge Funds</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie ESG</h4>
                    <p>Investissement responsable intégrant les critères environnementaux, sociaux et de gouvernance.</p>
                    <ul>
                        <li>Fonds verts et durables</li>
                        <li>Entreprises à impact positif</li>
                        <li>Exclusion des secteurs controversés</li>
                        <li>Mesure de l'impact</li>
                    </ul>
                </div>
                
                <div class="strategy-card">
                    <h4>Stratégie Tactique</h4>
                    <p>Approche flexible s'adaptant aux conditions de marché en temps réel.</p>
                    <ul>
                        <li>Rotation sectorielle</li>
                        <li>Timing de marché</li>
                        <li>Gestion des liquidités</li>
                        <li>Ajustements fréquents</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 mx-auto text-center">
                    <h2 class="display-5 fw-bold mb-4">Prêt à Optimiser Vos Investissements ?</h2>
                    <p class="lead mb-4">Nos experts en gestion d'investissement sont là pour vous accompagner vers vos objectifs financiers. Contactez-nous pour une consultation gratuite et personnalisée.</p>
                    <a href="<?php echo $url; ?>contact-us/" class="cta-button">Commencer Maintenant</a>
                </div>
            </div>
        </div>
    </section>

    <?php include '../footer.php'; ?>

    <!-- JavaScript Files -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
    <script src="<?php echo $url; ?>js/main.js"></script>
    
    <!-- Custom JavaScript for Investment Management -->
    <script>
        $(document).ready(function() {
            // Animation des statistiques avec gestion des suffixes
            $('.stat-number').each(function() {
                var $this = $(this);
                var original = $this.text().trim();
                var match = original.match(/([\d,.]+)/);
                var number = match ? parseFloat(match[1].replace(',', '.')) : 0;
                var suffix = original.replace(match ? match[1] : '', '');
                $this.text('0' + suffix);
                $({Counter: 0}).animate({Counter: number}, {
                    duration: 2000,
                    easing: 'swing',
                    step: function(now) {
                        var display = Math.ceil(now) + suffix;
                        $this.text(display);
                    },
                    complete: function() {
                        $this.text(original);
                    }
                });
            });
            // Smooth scrolling for anchor links
            $('a[href^="#"]').on('click', function(event) {
                var target = $(this.getAttribute('href'));
                if (target.length) {
                    event.preventDefault();
                    $('html, body').stop().animate({
                        scrollTop: target.offset().top - 100
                    }, 1000);
                }
            });
            // Add hover effects to service cards
            $('.service-card').hover(
                function() {
                    $(this).find('.service-icon').css('transform', 'scale(1.1)');
                },
                function() {
                    $(this).find('.service-icon').css('transform', 'scale(1)');
                }
            );
        });
    </script>
</body>
</html> 