<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="Investment Services - GIFAM offers comprehensive investment solutions including portfolio management, investment analysis, and strategic advisory services.">
    <meta name="keywords" content="investment, portfolio management, investment analysis, financial advisory, GIFAM, Cyprus, Brussels">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title>Investment Services - GIFAM</title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <!-- Tabs CSS -->
    <style>
        /* Tabs Container */
        .tabs-container {
            background: #fff;
            border-radius: 0px;
            overflow: hidden;
        }
        
        /* Tabs Navigation */
        .tabs-nav {
            display: flex;
            flex-wrap: wrap;
            background: #f8f9fa;
            border-bottom: 2px solid #e9ecef;
            overflow-x: auto;
            scrollbar-width: thin;
            scrollbar-color: #d12907 #f8f9fa;
        }
        
        .tabs-nav::-webkit-scrollbar {
            height: 6px;
        }
        
        .tabs-nav::-webkit-scrollbar-track {
            background: #f8f9fa;
        }
        
        .tabs-nav::-webkit-scrollbar-thumb {
            background: #d12907;
            border-radius: 3px;
        }
        
        .tab-item {
            flex: 1;
            min-width: 250px;
            padding: 12px 16px;
            text-align: center;
            background: #f8f9fa;
            color: #666;
            border: none;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.9rem;
            font-weight: 500;
            white-space: nowrap;
            border-right: 1px solid #e9ecef;
        }
        
        .tab-item:hover {
            background: #e9ecef;
            color: #333;
        }
        
        .tab-item.active {
            background: #dc3545;
            color: white;
            font-weight: 600;
            padding:12px 20px;
        }
        
        /* Tab Content */
        .tab-content-container {
            padding: 30px;
            min-height: 400px;
        }
        
        .tab-content {
            display: none;
            animation: fadeIn 0.3s ease-in;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .tab-header {
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f8f9fa;
        }
        
        .tab-header h3 {
            color: #333;
            font-weight: 700;
            margin: 0;
        }
        
        /* Form Styling */
        .form-section {
            margin-bottom: 25px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        
        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: #fff;
        }
        
        .form-control:focus {
            border-color: #dc3545;
            box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
            outline: none;
        }
        
        .checkbox-group {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }
        
        .form-check {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .form-check-input {
            margin-right: 8px;
            width: 18px;
            height: 18px;
        }
        
        .form-check-label {
            margin: 0;
            font-weight: 500;
            color: #555;
        }
        
        /* Navigation Buttons */
        .tab-navigation {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px 30px;
            background: #f8f9fa;
            border-top: 1px solid #e9ecef;
        }
        
        .btn {
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
        }
        
        .btn-primary {
            background: #dc3545;
            color: white;
        }
        
        .btn-primary:hover {
            background: #c82333;
            transform: translateY(-2px);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }
        
        .btn-success {
            background: #28a745;
            color: white;
        }
        
        .btn-success:hover {
            background: #218838;
            transform: translateY(-2px);
        }
        
        /* Progress Indicator */
        .progress-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .progress-step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #e9ecef;
            color: #666;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 5px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .progress-step.active {
            background: #dc3545;
            color: white;
        }
        
        .progress-step.completed {
            background: #28a745;
            color: white;
        }
        
        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .tabs-nav {
                flex-direction: column;
            }
            
            .tab-item {
                min-width: auto;
                border-right: none;
                border-bottom: 1px solid #e9ecef;
            }
            
            .tab-content-container {
                padding: 20px;
            }
            
            .checkbox-group {
                flex-direction: column;
                gap: 10px;
            }
            
            .tab-navigation {
                flex-direction: column;
                gap: 10px;
            }
            
            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>investment/">Investment Services</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Page Title -->

    <br>
    <br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h2>Investment Services</h2>
                            <p class="lead">GIFAM provides comprehensive investment services designed to help you achieve your financial objectives. Our expert team offers personalized investment strategies, portfolio management, and ongoing advisory services to maximize your returns while managing risk effectively.</p>
                            <p>Whether you're an individual investor, institutional client, or corporate entity, our investment solutions are tailored to meet your specific needs and financial goals.</p>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/case-study/case-study-1.jpg" alt="Investment Services" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Investment Services Grid -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Our Investment Services</h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-chart-flow" style="font-size: 3rem; color: #007bff;"></i>
                                </div>
                                <h4>Portfolio Management</h4>
                                <p>Professional portfolio management services with customized investment strategies designed to meet your specific financial objectives.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> Asset allocation optimization</li>
                                    <li><i class="icofont-check-circled text-success"></i> Risk management</li>
                                    <li><i class="icofont-check-circled text-success"></i> Regular rebalancing</li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-calculator-alt-1" style="font-size: 3rem; color: #28a745;"></i>
                                </div>
                                <h4>Investment Analysis</h4>
                                <p>Comprehensive investment analysis including market research, financial modeling, and strategic recommendations for optimal returns.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> Market research</li>
                                    <li><i class="icofont-check-circled text-success"></i> Financial modeling</li>
                                    <li><i class="icofont-check-circled text-success"></i> Risk assessment</li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-shield-check" style="font-size: 3rem; color: #ffc107;"></i>
                                </div>
                                <h4>Risk Management</h4>
                                <p>Advanced risk management strategies to protect your investments and ensure long-term portfolio stability.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> Risk identification</li>
                                    <li><i class="icofont-check-circled text-success"></i> Hedging strategies</li>
                                    <li><i class="icofont-check-circled text-success"></i> Diversification</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Investment tabs form -->
                    
                    <!-- Feasibility Study Application Form -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="card border-0 shadow-lg">
                                <div class="card-header bg-primary text-white text-center">
                                    <h2 class="mb-0">Feasibility Study Application Form</h2>
                                    <p class="mb-0">Complete all sections to submit your application</p>
                                </div>
                                <div class="card-body p-0">
                                    <!-- Tabs Navigation -->
                                    <div class="tabs-container">
                                        <div class="tabs-nav" id="tabsNav">
                                            <div class="tab-item active" data-tab="0">Applicant Information</div>
                                            <div class="tab-item" data-tab="1">Company Current Situation</div>
                                            <div class="tab-item" data-tab="2">Project Information</div>
                                            <div class="tab-item" data-tab="3">Funding</div>
                                            <div class="tab-item" data-tab="4">Data</div>
                                            <div class="tab-item" data-tab="5">Methodology</div>
                                            <div class="tab-item" data-tab="6">Architectural Conception</div>
                                            <div class="tab-item" data-tab="7">Economic Study</div>
                                            <div class="tab-item" data-tab="8">Financial Study</div>
                                            <div class="tab-item" data-tab="9">Impact</div>
                                            <div class="tab-item" data-tab="10">Time Frame</div>
                                            <div class="tab-item" data-tab="11">Resources</div>
                                            <div class="tab-item" data-tab="12">Consultant's Profile</div>
                                            <div class="tab-item" data-tab="13">Additional Expertise</div>
                                            <div class="tab-item" data-tab="14">Endorsements</div>
                                            <div class="tab-item" data-tab="15">Budget</div>
                                            <div class="tab-item" data-tab="16">Results</div>
                                            <div class="tab-item" data-tab="17">Next Step</div>
                                            <div class="tab-item" data-tab="18">Additional Information</div>
                                            <div class="tab-item" data-tab="19">Applicant's Approval</div>
                                        </div>

                                        <!-- Tab Content -->
                                        <div class="tab-content-container">
                                            <!-- Tab 1: Applicant Information -->
                                            <div class="tab-content active" id="tab-0">
                                                <div class="tab-header">
                                                    <h3>1. APPLICANT INFORMATION</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="applicantName">Applicant's name(s):</label>
                                                                <input type="text" id="applicantName" name="applicantName" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="applicantSurname">Applicant's surname:</label>
                                                                <input type="text" id="applicantSurname" name="applicantSurname" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="country">Country:</label>
                                                                <input type="text" id="country" name="country" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="city">City:</label>
                                                                <input type="text" id="city" name="city" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="street">Street:</label>
                                                                <input type="text" id="street" name="street" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="zip">Zip:</label>
                                                                <input type="text" id="zip" name="zip" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="phoneNumber">Phone number(s):</label>
                                                                <input type="text" id="phoneNumber" name="phoneNumber" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label for="email">Email address:</label>
                                                                <input type="email" id="email" name="email" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 2: Company Current Situation -->
                                            <div class="tab-content" id="tab-1">
                                                <div class="tab-header">
                                                    <h3>2. COMPANY CURRENT SITUATION</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="currentState">What is the company's current state of affairs?</label>
                                                        <textarea id="currentState" name="currentState" class="form-control" rows="4"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="businessChallenges">What business challenges is the applicant facing?</label>
                                                        <textarea id="businessChallenges" name="businessChallenges" class="form-control" rows="4"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="businessOpportunities">What business opportunities is the applicant viewing?</label>
                                                        <textarea id="businessOpportunities" name="businessOpportunities" class="form-control" rows="4"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Specify the company's role in the project:</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="owner" name="role" class="form-check-input">
                                                                <label class="form-check-label" for="owner">Owner</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="subcontractor" name="role" class="form-check-input">
                                                                <label class="form-check-label" for="subcontractor">Subcontractor</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 3: Project Information -->
                                            <div class="tab-content" id="tab-2">
                                                <div class="tab-header">
                                                    <h3>3. PROJECT INFORMATION</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="projectPurpose">What is the purpose of the feasibility study?</label>
                                                        <textarea id="projectPurpose" name="projectPurpose" class="form-control" rows="4"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="projectGoals">What are the applicant's goals and objectives?</label>
                                                        <textarea id="projectGoals" name="projectGoals" class="form-control" rows="4"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Is the applicant the owner of the project?</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="projectOwnerYes" name="projectOwner" class="form-check-input">
                                                                <label class="form-check-label" for="projectOwnerYes">Yes</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="projectOwnerNo" name="projectOwner" class="form-check-input">
                                                                <label class="form-check-label" for="projectOwnerNo">No</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="role">If the applicant is not the owner, what is their role?</label>
                                                        <textarea id="role" name="role" class="form-control" rows="3"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="projectLocation">Please specify the location(s) of the project:</label>
                                                        <input type="text" id="projectLocation" name="projectLocation" class="form-control">
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Is the applicant the owner of the land where the project will be located?</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="landOwnerYes" name="landOwner" class="form-check-input">
                                                                <label class="form-check-label" for="landOwnerYes">Yes</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="landOwnerNo" name="landOwner" class="form-check-input">
                                                                <label class="form-check-label" for="landOwnerNo">No</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 4: Funding -->
                                            <div class="tab-content" id="tab-3">
                                                <div class="tab-header">
                                                    <h3>4. FUNDING</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="fundingSource">Please specify the origin of the funding:</label>
                                                        <input type="text" id="fundingSource" name="fundingSource" class="form-control">
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Loan:</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="loan" name="fundingType" class="form-check-input">
                                                                <label class="form-check-label" for="loan">Loan</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="loanDetails">Please specify the amount and terms (if applicable):</label>
                                                        <textarea id="loanDetails" name="loanDetails" class="form-control" rows="4"></textarea>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 5: Data -->
                                            <div class="tab-content" id="tab-4">
                                                <div class="tab-header">
                                                    <h3>5. DATA</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="dataCollection">What data will be collected and analyzed?</label>
                                                        <textarea id="dataCollection" name="dataCollection" class="form-control" rows="4"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>What type of data will be needed for the feasibility study?</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="quantitative" name="dataType" class="form-check-input">
                                                                <label class="form-check-label" for="quantitative">Quantitative</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="qualitative" name="dataType" class="form-check-input">
                                                                <label class="form-check-label" for="qualitative">Qualitative</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Will the applicant provide data, or will it need to be collected by GIFAM's team?</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="applicantData" name="dataSource" class="form-check-input">
                                                                <label class="form-check-label" for="applicantData">The applicant</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="gifamTeamData" name="dataSource" class="form-check-input">
                                                                <label class="form-check-label" for="gifamTeamData">GIFAM's team</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 6: Methodology -->
                                            <div class="tab-content" id="tab-5">
                                                <div class="tab-header">
                                                    <h3>6. METHODOLOGY</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="methodology">How will the feasibility study be conducted?</label>
                                                        <textarea id="methodology" name="methodology" class="form-control" rows="6"></textarea>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 7: Architectural Conception -->
                                            <div class="tab-content" id="tab-6">
                                                <div class="tab-header">
                                                    <h3>7. ARCHITECTURAL CONCEPTION</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="checkbox-group">
                                                        <div class="form-check">
                                                            <input type="checkbox" id="architecturalAnalysis" name="architecturalConception" class="form-check-input">
                                                            <label class="form-check-label" for="architecturalAnalysis">Architectural Technical Analysis</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="architecturalPlans" name="architecturalConception" class="form-check-input">
                                                            <label class="form-check-label" for="architecturalPlans">Architectural Plans</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="elevationSections" name="architecturalConception" class="form-check-input">
                                                            <label class="form-check-label" for="elevationSections">Elevation and Sections</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="groundPlan" name="architecturalConception" class="form-check-input">
                                                            <label class="form-check-label" for="groundPlan">Ground Plan</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="sketchUp" name="architecturalConception" class="form-check-input">
                                                            <label class="form-check-label" for="sketchUp">Sketch up</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="3dModeling" name="architecturalConception" class="form-check-input">
                                                            <label class="form-check-label" for="3dModeling">3D modeling</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="3dVideo" name="architecturalConception" class="form-check-input">
                                                            <label class="form-check-label" for="3dVideo">3D Video</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="rendering" name="architecturalConception" class="form-check-input">
                                                            <label class="form-check-label" for="rendering">Rendering</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 8: Economic Study -->
                                            <div class="tab-content" id="tab-7">
                                                <div class="tab-header">
                                                    <h3>8. ECONOMIC STUDY</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="checkbox-group">
                                                        <div class="form-check">
                                                            <input type="checkbox" id="marketStudy" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="marketStudy">Market Study</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="industryInsight" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="industryInsight">Industry Insight</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="demandAnalysis" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="demandAnalysis">Demand analysis</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="supplyAnalysis" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="supplyAnalysis">Supply-side analysis</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="competitiveAnalysis" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="competitiveAnalysis">Competitive analysis</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="pestleAnalysis" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="pestleAnalysis">PESTLE Analysis</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="swotAnalysis" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="swotAnalysis">SWOT Analysis</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="marketingStrategy" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="marketingStrategy">Marketing Strategy</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="operationalFeasibility" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="operationalFeasibility">Operational feasibility</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="organizationalAnalysis" name="economicStudy" class="form-check-input">
                                                            <label class="form-check-label" for="organizationalAnalysis">Organizational Analysis</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 9: Financial Study -->
                                            <div class="tab-content" id="tab-8">
                                                <div class="tab-header">
                                                    <h3>9. FINANCIAL STUDY</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="checkbox-group">
                                                        <div class="form-check">
                                                            <input type="checkbox" id="financialOverview" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="financialOverview">Financial Overview</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="loanAmortizationTable" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="loanAmortizationTable">Loan Amortization Table</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="capexOpexFunding" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="capexOpexFunding">Capex & Opex funding</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="fundingPeriods" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="fundingPeriods">Funding Periods</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="investmentPlan" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="investmentPlan">Investment Plan</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="fixedAssetsDepreciation" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="fixedAssetsDepreciation">Fixed Assets Depreciation Table</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="operatingExpensesForecasting" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="operatingExpensesForecasting">Operating Expenses Forecasting</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="salesForecasting" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="salesForecasting">Sales Forecasting</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="incomeStatement" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="incomeStatement">Income Statement</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="balanceSheet" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="balanceSheet">Balance Sheet</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="cashFlowStatement" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="cashFlowStatement">Cash-Flow Statement</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="financialRatios" name="financialStudy" class="form-check-input">
                                                            <label class="form-check-label" for="financialRatios">Financial Ratios Analysis</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 10: Impact -->
                                            <div class="tab-content" id="tab-9">
                                                <div class="tab-header">
                                                    <h3>10. IMPACT</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="checkbox-group">
                                                        <div class="form-check">
                                                            <input type="checkbox" id="economicImpact" name="impact" class="form-check-input">
                                                            <label class="form-check-label" for="economicImpact">Economic impact (e.g., job creation, GDP growth)</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="socialImpact" name="impact" class="form-check-input">
                                                            <label class="form-check-label" for="socialImpact">Social impact (e.g., education, healthcare)</label>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="checkbox" id="environmentalImpact" name="impact" class="form-check-input">
                                                            <label class="form-check-label" for="environmentalImpact">Environmental impact (e.g., sustainability, carbon footprint)</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 11: Time Frame -->
                                            <div class="tab-content" id="tab-10">
                                                <div class="tab-header">
                                                    <h3>11. TIME FRAME</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="timeline">What is the timeline for the feasibility study?</label>
                                                        <input type="text" id="timeline" name="timeline" class="form-control">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="startDate">When will it begin?</label>
                                                        <input type="text" id="startDate" name="startDate" class="form-control">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="deliveryDate">What is the deadline for delivery?</label>
                                                        <input type="text" id="deliveryDate" name="deliveryDate" class="form-control">
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 12: Resources -->
                                            <div class="tab-content" id="tab-11">
                                                <div class="tab-header">
                                                    <h3>12. RESOURCES</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label>Which resources will be needed for the study?</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="gifamTeam" name="resources" class="form-check-input">
                                                                <label class="form-check-label" for="gifamTeam">GIFAM's Team</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="thirdParty" name="resources" class="form-check-input">
                                                                <label class="form-check-label" for="thirdParty">Third Party</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Will additional staff or consultants be required?</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="additionalStaffYes" name="resources" class="form-check-input">
                                                                <label class="form-check-label" for="additionalStaffYes">Yes</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="additionalStaffNo" name="resources" class="form-check-input">
                                                                <label class="form-check-label" for="additionalStaffNo">No</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 13: Consultant's Profile -->
                                            <div class="tab-content" id="tab-12">
                                                <div class="tab-header">
                                                    <h3>13. CONSULTANT'S PROFILE</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="consultantProfile">Please select the consultant's profile needed for conducting the feasibility study:</label>
                                                        <input type="text" id="consultantProfile" name="consultantProfile" class="form-control">
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 14: Additional Expertise -->
                                            <div class="tab-content" id="tab-13">
                                                <div class="tab-header">
                                                    <h3>14. ADDITIONAL EXPERTISE</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label>Please specify if any additional expertise shall be required for the project.</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="additionalExpertiseYes" name="expertise" class="form-check-input">
                                                                <label class="form-check-label" for="additionalExpertiseYes">Yes</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="additionalExpertiseNo" name="expertise" class="form-check-input">
                                                                <label class="form-check-label" for="additionalExpertiseNo">No</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="expertiseArea">If yes, please indicate the area for which additional expertise would be required:</label>
                                                        <input type="text" id="expertiseArea" name="expertiseArea" class="form-control">
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 15: Endorsements -->
                                            <div class="tab-content" id="tab-14">
                                                <div class="tab-header">
                                                    <h3>15. ENDORSEMENTS</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label>Does the feasibility study need endorsements from a certified expert corporation?</label>
                                                        <div class="checkbox-group">
                                                            <div class="form-check">
                                                                <input type="checkbox" id="endorsementsYes" name="endorsements" class="form-check-input">
                                                                <label class="form-check-label" for="endorsementsYes">Yes</label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input type="checkbox" id="endorsementsNo" name="endorsements" class="form-check-input">
                                                                <label class="form-check-label" for="endorsementsNo">No</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 16: Budget -->
                                            <div class="tab-content" id="tab-15">
                                                <div class="tab-header">
                                                    <h3>16. BUDGET</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="budget">What is the applicant's budget for the feasibility study?</label>
                                                        <input type="text" id="budget" name="budget" class="form-control">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="budgetFinancing">How will the feasibility study cost be financed?</label>
                                                        <input type="text" id="budgetFinancing" name="budgetFinancing" class="form-control">
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 17: Results -->
                                            <div class="tab-content" id="tab-16">
                                                <div class="tab-header">
                                                    <h3>17. RESULTS</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="resultsPresentation">How will the results of the feasibility study be presented?</label>
                                                        <input type="text" id="resultsPresentation" name="resultsPresentation" class="form-control">
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 18: Next Step -->
                                            <div class="tab-content" id="tab-17">
                                                <div class="tab-header">
                                                    <h3>18. NEXT STEP</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="nextStepIfViable">If the feasibility study indicates the project is viable, what will be the next steps?</label>
                                                        <textarea id="nextStepIfViable" name="nextStepIfViable" class="form-control" rows="4"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="nextStepIfNotViable">If the feasibility study indicates the project is not viable, what will be the next steps?</label>
                                                        <textarea id="nextStepIfNotViable" name="nextStepIfNotViable" class="form-control" rows="4"></textarea>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 19: Additional Information -->
                                            <div class="tab-content" id="tab-18">
                                                <div class="tab-header">
                                                    <h3>19. ADDITIONAL INFORMATION</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="additionalInformation">Please provide any additional information relevant to your project:</label>
                                                        <textarea id="additionalInformation" name="additionalInformation" class="form-control" rows="6"></textarea>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Tab 20: Applicant's Approval -->
                                            <div class="tab-content" id="tab-19">
                                                <div class="tab-header">
                                                    <h3>20. APPLICANT'S APPROVAL</h3>
                                                </div>
                                                <div class="form-section">
                                                    <div class="form-group">
                                                        <label for="applicantNameApproval">Applicant's full name:</label>
                                                        <input type="text" id="applicantNameApproval" name="applicantNameApproval" class="form-control">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="signature">Signature:</label>
                                                        <input type="text" id="signature" name="signature" class="form-control">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="approvalDate">Date:</label>
                                                        <input type="date" id="approvalDate" name="approvalDate" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Navigation Buttons -->
                                        <div class="tab-navigation">
                                            <button type="button" class="btn btn-secondary" id="prevBtn" onclick="previousTab()">Previous</button>
                                            <button type="button" class="btn btn-primary" id="nextBtn" onclick="nextTab()">Next</button>
                                            <button type="submit" class="btn btn-success" id="submitBtn" style="display: none;">Submit Application</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Investment tabs form -->




                    <!-- Investment Types -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Investment Types We Manage</h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url; ?>images/case-study/case-study-2.jpg" alt="Equities" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5>Equities</h5>
                                <p>Domestic and international stocks across various sectors and market capitalizations for growth potential.</p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url; ?>images/case-study/case-study-3.jpg" alt="Fixed Income" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5>Fixed Income</h5>
                                <p>Government and corporate bonds providing stable income and capital preservation.</p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url; ?>images/case-study/case-study-4.jpg" alt="Real Estate" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5>Real Estate</h5>
                                <p>Real estate investment trusts (REITs) and direct property investments for diversification.</p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url; ?>images/case-study/case-study-5.jpg" alt="Alternative Investments" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5>Alternative Investments</h5>
                                <p>Commodities, hedge funds, private equity, and other alternative investment vehicles.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Investment Process -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Our Investment Process</h3>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="process-timeline">
                                <div class="d-flex mb-4">
                                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">1</span>
                                    </div>
                                    <div>
                                        <h5>Initial Consultation</h5>
                                        <p>Understanding your financial goals, risk tolerance, and investment timeline through comprehensive consultation.</p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">2</span>
                                    </div>
                                    <div>
                                        <h5>Portfolio Analysis</h5>
                                        <p>Comprehensive analysis of your current portfolio and identification of optimization opportunities.</p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">3</span>
                                    </div>
                                    <div>
                                        <h5>Strategy Development</h5>
                                        <p>Development of a customized investment strategy with optimal asset allocation for your goals.</p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">4</span>
                                    </div>
                                    <div>
                                        <h5>Implementation & Monitoring</h5>
                                        <p>Execution of the strategy with ongoing monitoring and periodic rebalancing for optimal performance.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <img src="<?php echo $url; ?>images/case-study/case-study-6.jpg" alt="Investment Process" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Performance Metrics -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Investment Performance Metrics</h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded">
                                    <h4 class="text-primary">15.2%</h4>
                                    <p>Average Annual Return</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded">
                                    <h4 class="text-success">8.5%</h4>
                                    <p>Risk-Adjusted Return</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded">
                                    <h4 class="text-info">0.85</h4>
                                    <p>Sharpe Ratio</p>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded">
                                    <h4 class="text-warning">12.3%</h4>
                                    <p>Maximum Drawdown</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Benefits Section -->
                    <div class="row mb-5">
                        <div class="col-lg-6">
                            <img src="<?php echo $url; ?>images/case-study/case-study-7.jpg" alt="Investment Benefits" class="img-fluid rounded shadow">
                        </div>
                        <div class="col-lg-6">
                            <h3>Benefits of Professional Investment Management</h3>
                            <div class="feature-list">
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5>Expert Management</h5>
                                        <p>Access to experienced investment professionals with deep market knowledge and proven track records.</p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5>Risk Reduction</h5>
                                        <p>Strategic diversification and risk management to protect your capital while pursuing growth opportunities.</p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5>Time Savings</h5>
                                        <p>Focus on your core activities while our team handles your investment portfolio management.</p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5>Access to Opportunities</h5>
                                        <p>Access to exclusive investment opportunities and alternative investment vehicles not available to individual investors.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Investment Strategies -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Investment Strategies</h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="bg-light p-4 rounded h-100">
                                <h4><i class="icofont-chart-flow text-primary me-2"></i>Growth Strategy</h4>
                                <p>Focused on capital appreciation through investments in high-growth potential assets and emerging markets.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> High-growth equities</li>
                                    <li><i class="icofont-check-circled text-success"></i> Emerging markets</li>
                                    <li><i class="icofont-check-circled text-success"></i> Technology sector</li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="bg-light p-4 rounded h-100">
                                <h4><i class="icofont-shield-check text-success me-2"></i>Income Strategy</h4>
                                <p>Designed to generate consistent income through dividend-paying stocks, bonds, and income-generating assets.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> Dividend stocks</li>
                                    <li><i class="icofont-check-circled text-success"></i> Corporate bonds</li>
                                    <li><i class="icofont-check-circled text-success"></i> REITs</li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="bg-light p-4 rounded h-100">
                                <h4><i class="icofont-balance text-warning me-2"></i>Balanced Strategy</h4>
                                <p>Combines growth and income objectives with moderate risk tolerance for long-term wealth building.</p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> Mixed asset allocation</li>
                                    <li><i class="icofont-check-circled text-success"></i> Moderate risk</li>
                                    <li><i class="icofont-check-circled text-success"></i> Steady growth</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Ready to Start Your Investment Journey?</h3>
                                <p class="lead mb-4">Let our expert investment team help you build a portfolio that aligns with your financial goals and risk tolerance.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Start Investing Today</a>
                                <a href="<?php echo $url; ?>our-services/" class="btn btn-outline-primary btn-lg">View All Services</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

<!-- Tabs JavaScript -->
<script>
    // Variables globales
    let currentTab = 0;
    const totalTabs = 20;
    
    // Initialisation
    document.addEventListener('DOMContentLoaded', function() {
        initializeTabs();
        updateNavigationButtons();
    });
    
    // Initialisation des tabs
    function initializeTabs() {
        // Ajouter les événements click aux tabs
        const tabItems = document.querySelectorAll('.tab-item');
        tabItems.forEach((item, index) => {
            item.addEventListener('click', () => {
                showTab(index);
            });
        });
        
        // Ajouter les événements aux boutons de navigation
        document.getElementById('prevBtn').addEventListener('click', previousTab);
        document.getElementById('nextBtn').addEventListener('click', nextTab);
        document.getElementById('submitBtn').addEventListener('click', submitForm);
        
        // Ajouter la navigation par clavier
        document.addEventListener('keydown', handleKeyboardNavigation);
    }
    
    // Afficher un tab spécifique
    function showTab(tabIndex) {
        // Masquer tous les tabs
        const tabContents = document.querySelectorAll('.tab-content');
        const tabItems = document.querySelectorAll('.tab-item');
        
        tabContents.forEach(content => {
            content.classList.remove('active');
        });
        
        tabItems.forEach(item => {
            item.classList.remove('active');
        });
        
        // Afficher le tab sélectionné
        if (tabContents[tabIndex]) {
            tabContents[tabIndex].classList.add('active');
        }
        
        if (tabItems[tabIndex]) {
            tabItems[tabIndex].classList.add('active');
        }
        
        currentTab = tabIndex;
        updateNavigationButtons();
        scrollToActiveTab();
    }
    
    // Tab précédent
    function previousTab() {
        if (currentTab > 0) {
            showTab(currentTab - 1);
        }
    }
    
    // Tab suivant
    function nextTab() {
        if (currentTab < totalTabs - 1) {
            showTab(currentTab + 1);
        }
    }
    
    // Mettre à jour les boutons de navigation
    function updateNavigationButtons() {
        const prevBtn = document.getElementById('prevBtn');
        const nextBtn = document.getElementById('nextBtn');
        const submitBtn = document.getElementById('submitBtn');
        
        // Bouton Previous
        if (currentTab === 0) {
            prevBtn.style.display = 'none';
        } else {
            prevBtn.style.display = 'inline-block';
        }
        
        // Bouton Next/Submit
        if (currentTab === totalTabs - 1) {
            nextBtn.style.display = 'none';
            submitBtn.style.display = 'inline-block';
        } else {
            nextBtn.style.display = 'inline-block';
            submitBtn.style.display = 'none';
        }
        
        // Mettre à jour le texte du bouton Next
        if (currentTab === totalTabs - 2) {
            nextBtn.textContent = 'Final Step';
        } else {
            nextBtn.textContent = 'Next';
        }
    }
    
    // Faire défiler vers le tab actif
    function scrollToActiveTab() {
        const activeTab = document.querySelector('.tab-item.active');
        if (activeTab) {
            const tabsNav = document.getElementById('tabsNav');
            const navRect = tabsNav.getBoundingClientRect();
            const tabRect = activeTab.getBoundingClientRect();
            
            if (tabRect.left < navRect.left || tabRect.right > navRect.right) {
                activeTab.scrollIntoView({
                    behavior: 'smooth',
                    block: 'nearest',
                    inline: 'center'
                });
            }
        }
    }
    
    // Navigation par clavier
    function handleKeyboardNavigation(e) {
        if (e.key === 'ArrowLeft' && currentTab > 0) {
            e.preventDefault();
            previousTab();
        } else if (e.key === 'ArrowRight' && currentTab < totalTabs - 1) {
            e.preventDefault();
            nextTab();
        } else if (e.key === 'Enter' && currentTab === totalTabs - 1) {
            e.preventDefault();
            submitForm();
        }
    }
    
    // Soumettre le formulaire
    function submitForm() {
        // Validation des champs requis
        const requiredFields = document.querySelectorAll('input[required], textarea[required]');
        let isValid = true;
        
        requiredFields.forEach(field => {
            if (!field.value.trim()) {
                field.classList.add('is-invalid');
                isValid = false;
            } else {
                field.classList.remove('is-invalid');
            }
        });
        
        if (!isValid) {
            alert('Please fill in all required fields before submitting.');
            return;
        }
        
        // Collecter les données du formulaire
        const formData = new FormData();
        const formElements = document.querySelectorAll('input, textarea, select');
        
        formElements.forEach(element => {
            if (element.type === 'checkbox') {
                if (element.checked) {
                    formData.append(element.name, element.value || 'checked');
                }
            } else {
                formData.append(element.name, element.value);
            }
        });
        
        // Simulation de soumission (remplacer par votre logique de soumission)
        console.log('Form data collected:', Object.fromEntries(formData));
        
        // Afficher un message de succès
        showSuccessMessage();
    }
    
    // Afficher le message de succès
    function showSuccessMessage() {
        const container = document.querySelector('.tabs-container');
        const successMessage = document.createElement('div');
        successMessage.className = 'alert alert-success text-center';
        successMessage.innerHTML = `
            <h4><i class="icofont-check-circled"></i> Application Submitted Successfully!</h4>
            <p>Thank you for your application. We will review your information and contact you within 2-3 business days.</p>
            <button class="btn btn-primary" onclick="location.reload()">Submit Another Application</button>
        `;
        
        container.innerHTML = '';
        container.appendChild(successMessage);
    }
    
    // Validation en temps réel
    function validateField(field) {
        const value = field.value.trim();
        const isValid = value.length > 0;
        
        if (isValid) {
            field.classList.remove('is-invalid');
            field.classList.add('is-valid');
        } else {
            field.classList.remove('is-valid');
            field.classList.add('is-invalid');
        }
        
        return isValid;
    }
    
    // Ajouter la validation en temps réel
    document.addEventListener('DOMContentLoaded', function() {
        const inputs = document.querySelectorAll('input, textarea');
        inputs.forEach(input => {
            input.addEventListener('blur', () => validateField(input));
            input.addEventListener('input', () => {
                if (input.classList.contains('is-invalid')) {
                    validateField(input);
                }
            });
        });
    });
    
    // Auto-sauvegarde des données
    function saveFormData() {
        const formData = {};
        const formElements = document.querySelectorAll('input, textarea, select');
        
        formElements.forEach(element => {
            if (element.type === 'checkbox') {
                formData[element.name] = element.checked;
            } else {
                formData[element.name] = element.value;
            }
        });
        
        localStorage.setItem('feasibilityFormData', JSON.stringify(formData));
    }
    
    // Restaurer les données sauvegardées
    function loadFormData() {
        const savedData = localStorage.getItem('feasibilityFormData');
        if (savedData) {
            const formData = JSON.parse(savedData);
            const formElements = document.querySelectorAll('input, textarea, select');
            
            formElements.forEach(element => {
                if (formData[element.name] !== undefined) {
                    if (element.type === 'checkbox') {
                        element.checked = formData[element.name];
                    } else {
                        element.value = formData[element.name];
                    }
                }
            });
        }
    }
    
    // Auto-sauvegarde toutes les 5 secondes
    setInterval(saveFormData, 5000);
    
    // Charger les données au démarrage
    document.addEventListener('DOMContentLoaded', loadFormData);
</script>

</body>
</html>