<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Legal Notices - GIFAM | Compliance & Regulatory Information</title>
    <meta name="description" content="Comprehensive legal notices and compliance information for GIFAM. Access privacy policies, terms and conditions, cookie policies, and legal disclaimers.">
    <meta name="keywords" content="legal notices, compliance, privacy policy, terms and conditions, cookie policy, legal disclaimer, GIFAM">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    
    <style>
        .legal-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #d12907;
        }
        
        .legal-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 20px;
            transition: all 0.3s ease;
            border: 1px solid #e9ecef;
        }
        
        .legal-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        
        .legal-card h4 {
            color: #d12907;
            margin-bottom: 15px;
        }
        
        .legal-links a {
            color: #d12907;
            text-decoration: none;
            font-weight: 600;
        }
        
        .legal-links a:hover {
            text-decoration: underline;
        }
        
        .compliance-badge {
            display: inline-block;
            background: #28a745;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .update-info {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>legal-notices/">Legal Notices</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
<br><br>

    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1>Legal Notices & Compliance</h1>
                            <p class="lead">GIFAM is committed to transparency and legal compliance. Our comprehensive legal framework ensures that all our operations, data handling practices, and client interactions adhere to the highest standards of legal and regulatory requirements.</p>
                            <div class="compliance-badge">GDPR Compliant</div>
                            <div class="compliance-badge">ISO 27001 Certified</div>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/case-study/case-study-1.jpg" alt="Legal Compliance" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Update Information -->
                    <div class="update-info">
                        <h5><i class="icofont-info-circle"></i> Last Updated</h5>
                        <p class="mb-0">These legal notices were last updated on <strong>December 15, 2024</strong>. We regularly review and update our legal documents to ensure compliance with current regulations and best practices.</p>
                    </div>

                    <!-- Legal Documents Overview -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h2>Our Legal Framework</h2>
                            <p>GIFAM operates under a comprehensive legal framework designed to protect our clients, partners, and stakeholders while ensuring full compliance with international regulations and industry standards.</p>
                        </div>
                        
                        <div class="col-lg-6 col-md-6 mb-4">
                            <div class="legal-card">
                                <h4><i class="icofont-shield-check text-success me-2"></i>Privacy Policy</h4>
                                <p>Comprehensive information about how we collect, use, store, and protect your personal data in accordance with GDPR and other privacy regulations.</p>
                                <a href="<?php echo $url; ?>privacy-policy/" class="btn btn-outline-primary">Read Privacy Policy</a>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6 mb-4">
                            <div class="legal-card">
                                <h4><i class="icofont-file-text text-primary me-2"></i>Terms and Conditions</h4>
                                <p>Detailed terms governing the use of our services, website, and the relationship between GIFAM and our clients.</p>
                                <a href="<?php echo $url; ?>terms-and-conditions/" class="btn btn-outline-primary">Read Terms & Conditions</a>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6 mb-4">
                            <div class="legal-card">
                                <h4><i class="icofont-cookie text-warning me-2"></i>Cookie Policy</h4>
                                <p>Information about how we use cookies and similar technologies to enhance your browsing experience and provide personalized services.</p>
                                <a href="<?php echo $url; ?>cookie-policy/" class="btn btn-outline-primary">Read Cookie Policy</a>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6 mb-4">
                            <div class="legal-card">
                                <h4><i class="icofont-gavel text-danger me-2"></i>Legal Disclaimer</h4>
                                <p>Important disclaimers regarding the use of our website, services, and the limitations of liability under applicable law.</p>
                                <a href="<?php echo $url; ?>legal-disclaimer/" class="btn btn-outline-primary">Read Legal Disclaimer</a>
                            </div>
                        </div>
                    </div>

                    <!-- Compliance Section -->
                    <div class="legal-section">
                        <h2>Regulatory Compliance</h2>
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>International Standards</h4>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success me-2"></i>GDPR (General Data Protection Regulation)</li>
                                    <li><i class="icofont-check-circled text-success me-2"></i>ISO 27001 Information Security Management</li>
                                    <li><i class="icofont-check-circled text-success me-2"></i>SOX (Sarbanes-Oxley Act) Compliance</li>
                                    <li><i class="icofont-check-circled text-success me-2"></i>PCI DSS (Payment Card Industry Standards)</li>
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h4>Industry Regulations</h4>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success me-2"></i>Financial Services Regulations</li>
                                    <li><i class="icofont-check-circled text-success me-2"></i>Investment Advisory Standards</li>
                                    <li><i class="icofont-check-circled text-success me-2"></i>Anti-Money Laundering (AML) Compliance</li>
                                    <li><i class="icofont-check-circled text-success me-2"></i>Know Your Customer (KYC) Procedures</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Data Protection Section -->
                    <div class="legal-section">
                        <h2>Data Protection & Privacy</h2>
                        <p>At GIFAM, we take data protection seriously. Our comprehensive privacy framework ensures that your personal and business information is handled with the utmost care and in full compliance with international privacy laws.</p>
                        
                        <div class="row">
                            <div class="col-lg-4 col-md-6 mb-4">
                                <div class="text-center">
                                    <i class="icofont-lock text-primary" style="font-size: 3rem;"></i>
                                    <h5>Secure Data Storage</h5>
                                    <p>Enterprise-grade encryption and secure data centers ensure your information remains protected.</p>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6 mb-4">
                                <div class="text-center">
                                    <i class="icofont-eye-blocked text-success" style="font-size: 3rem;"></i>
                                    <h5>Privacy by Design</h5>
                                    <p>Our systems are built with privacy protection as a fundamental component from the ground up.</p>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-6 mb-4">
                                <div class="text-center">
                                    <i class="icofont-handshake-deal text-warning" style="font-size: 3rem;"></i>
                                    <h5>Transparent Practices</h5>
                                    <p>Clear communication about how we use your data and your rights regarding your information.</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="legal-section">
                        <h2>Legal Contact Information</h2>
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Data Protection Officer</h4>
                                <p><strong>Email:</strong> dpo@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4567<br>
                                <strong>Address:</strong> 123 Business Street, Suite 100, New York, NY 10001</p>
                            </div>
                            <div class="col-lg-6">
                                <h4>Legal Department</h4>
                                <p><strong>Email:</strong> legal@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4568<br>
                                <strong>For urgent matters:</strong> +1 (555) 123-4569</p>
                            </div>
                        </div>
                    </div>

                    <!-- Updates and Changes -->
                    <div class="legal-section">
                        <h2>Updates and Changes</h2>
                        <p>We may update these legal notices from time to time to reflect changes in our practices, technology, legal requirements, or other factors. When we make changes, we will:</p>
                        <ul>
                            <li>Update the "Last Updated" date at the top of each document</li>
                            <li>Provide notice of significant changes through our website or email</li>
                            <li>Maintain version history for transparency</li>
                            <li>Ensure changes are communicated clearly and in advance</li>
                        </ul>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Questions About Our Legal Framework?</h3>
                                <p class="lead mb-4">Our legal team is here to help clarify any questions about our policies, procedures, or compliance measures.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Contact Legal Team</a>
                                <a href="<?php echo $url; ?>about/" class="btn btn-outline-primary btn-lg">Learn More About GIFAM</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

</body>
</html> 