<?php include '../url.php'; ?>
<div id="wpwrap">
<?php include '../menu.php'; ?>
	<div id="wpcontent">
	<?php include '../wpadminbar.php'; ?>
		<div id="wpbody" role="main">
			<div id="wpbody-content" aria-label="Main content" tabindex="0" style="overflow: hidden;">
				<br><br>
				<?php
							include '../../db.php';

// CRUD Actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update'])) {
        $stmt = $pdo->prepare("UPDATE case_studies SET title=?, description=?, image_path=?, image_alt=?, css_class=?, project_link=?, item_order=? WHERE id=?");
        $stmt->execute([
            $_POST['title'], $_POST['description'], $_POST['image_path'], $_POST['image_alt'],
            $_POST['css_class'], $_POST['project_link'], $_POST['item_order'], $_POST['id']
        ]);
    } elseif (isset($_POST['add'])) {
        $stmt = $pdo->prepare("INSERT INTO case_studies (title, description, image_path, image_alt, css_class, project_link, item_order) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $_POST['title'], $_POST['description'], $_POST['image_path'], $_POST['image_alt'],
            $_POST['css_class'], $_POST['project_link'], $_POST['item_order']
        ]);
    } elseif (isset($_POST['delete'])) {
        $stmt = $pdo->prepare("DELETE FROM case_studies WHERE id=?");
        $stmt->execute([$_POST['id']]);
    }
}

$cases = $pdo->query("SELECT * FROM case_studies ORDER BY item_order ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

    <style>
        body { font-family: Arial; padding: 20px; }
        input, textarea { width: 100%; margin-bottom: 10px; padding: 8px; }
        .case-box { border: 1px solid #ccc; padding: 15px; margin-bottom: 30px; background: #f9f9f9; }
        label { font-weight: bold; }
        button { padding: 10px 15px; background-color: #007bff; color: white; border: none; margin-top: 10px; }
        h1, h2 { margin-bottom: 20px; }
    </style>

<h1>Admin - Case Studies</h1>
<h2>Recently completed projects</h2>

<!-- Add New Project -->
<div class="case-box">
    <h3>Add New Case Study</h3>
    <form method="post">
        <input type="hidden" name="add" value="1">
        <label>Title:</label>
        <input type="text" name="title">

        <label>Description:</label>
        <textarea name="description" rows="3"></textarea>

        <label>Image Path (e.g. images/case-study/image.jpg):</label>
        <input type="text" name="image_path">

        <label>Alt Text:</label>
        <input type="text" name="image_alt">

        <label>CSS Class (e.g. case-study-orange):</label>
        <input type="text" name="css_class">

        <label>Link:</label>
        <input type="text" name="project_link">

        <label>Order:</label>
        <input type="number" name="item_order">

        <button type="submit">Add Project</button>
    </form>
</div>

<!-- Existing Case Studies -->
<?php foreach ($cases as $c): ?>
    <div class="case-box">
        <h3>Edit: <?php echo htmlspecialchars($c['title']); ?></h3>
        <form method="post">
            <input type="hidden" name="update" value="1">
            <input type="hidden" name="id" value="<?php echo $c['id']; ?>">

            <label>Title:</label>
            <input type="text" name="title" value="<?php echo htmlspecialchars($c['title']); ?>">

            <label>Description:</label>
            <textarea name="description" rows="3"><?php echo htmlspecialchars($c['description']); ?></textarea>

            <label>Image Path:</label>
            <input type="text" name="image_path" value="<?php echo htmlspecialchars($c['image_path']); ?>">

            <label>Alt Text:</label>
            <input type="text" name="image_alt" value="<?php echo htmlspecialchars($c['image_alt']); ?>">

            <label>CSS Class:</label>
            <input type="text" name="css_class" value="<?php echo htmlspecialchars($c['css_class']); ?>">

            <label>Link:</label>
            <input type="text" name="project_link" value="<?php echo htmlspecialchars($c['project_link']); ?>">

            <label>Order:</label>
            <input type="number" name="item_order" value="<?php echo $c['item_order']; ?>">

            <button type="submit">Save Changes</button>
        </form>
        <form method="post" onsubmit="return confirm('Delete this project?');">
            <input type="hidden" name="delete" value="1">
            <input type="hidden" name="id" value="<?php echo $c['id']; ?>">
            <button type="submit" style="background:#dc3545;">Delete</button>
        </form>
    </div>
<?php endforeach; ?>




				<div class="wrap"></div>
			</div>
			<!-- wpbody-content -->
			<div class="clear"></div>
		</div>
		<!-- wpbody -->
		<div class="clear"></div>
	</div>
  <?php include '../css.php'; ?>
