<?php include '../url.php'; ?>
<div id="wpwrap">
<?php include '../menu.php'; ?>
	<div id="wpcontent">
	<?php include '../wpadminbar.php'; ?>
		<div id="wpbody" role="main">
			<div id="wpbody-content" aria-label="Main content" tabindex="0" style="overflow: hidden;">
				<br><br>
				<?php
							include '../../db.php';

// Actions CRUD section_titles
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['update'])) {
        $stmt = $pdo->prepare("UPDATE services_testimonials SET name=?, title=?, content=?, image_path=?, rating=?, order_index=? WHERE id=?");
        $stmt->execute([
            $_POST['name'], $_POST['title'], $_POST['content'], $_POST['image_path'], $_POST['rating'], $_POST['order_index'], $_POST['id']
        ]);
    } elseif (isset($_POST['add'])) {
        $stmt = $pdo->prepare("INSERT INTO services_testimonials (name, title, content, image_path, rating, order_index) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $_POST['name'], $_POST['title'], $_POST['content'], $_POST['image_path'], $_POST['rating'], $_POST['order_index']
        ]);
    } elseif (isset($_POST['delete'])) {
        $stmt = $pdo->prepare("DELETE FROM services_testimonials WHERE id=?");
        $stmt->execute([$_POST['id']]);
    } elseif (isset($_POST['update_title'])) {
        $stmt = $pdo->prepare("UPDATE section_titlesd SET title=? WHERE section_key='testimonials'");
        $stmt->execute([$_POST['section_title']]);
    }
}

$testimonials = $pdo->query("SELECT * FROM services_testimonials ORDER BY order_index ASC")->fetchAll(PDO::FETCH_ASSOC);
$sectionTitle = $pdo->query("SELECT title FROM section_titlesd WHERE section_key='testimonials'")->fetchColumn();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin - Testimonials</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        input, textarea { width: 100%; margin-bottom: 10px; padding: 8px; }
        .box { border: 1px solid #ccc; padding: 15px; margin-bottom: 30px; background: #f9f9f9; }
        label { font-weight: bold; }
        button { padding: 10px 15px; background-color: #007bff; color: white; border: none; margin-top: 10px; cursor: pointer; }
        h1, h2 { margin-bottom: 20px; }
    </style>
</head>
<body>
<h1>Admin - Testimonials</h1>

<!-- Modifier le titre de section -->
<div class="box">
    <form method="post">
        <input type="hidden" name="update_title" value="1">
        <label>Section Title (h2)</label>
        <input type="text" name="section_title" value="<?php echo htmlspecialchars($sectionTitle); ?>">
        <button type="submit">Update Title</button>
    </form>
</div>

<!-- Ajouter un témoignage -->
<div class="box">
    <h3>Add New Testimonial</h3>
    <form method="post">
        <input type="hidden" name="add" value="1">
        <label>Name</label>
        <input type="text" name="name" required>

        <label>Title</label>
        <input type="text" name="title" required>

        <label>Testimonial Content</label>
        <textarea name="content" required></textarea>

        <label>Image Path (e.g. images/testimonial/testi-6.jpg)</label>
        <input type="text" name="image_path" required>

        <label>Rating (1-5)</label>
        <input type="number" name="rating" min="1" max="5" value="5">

        <label>Order Index</label>
        <input type="number" name="order_index" value="0">

        <button type="submit">Add Testimonial</button>
    </form>
</div>

<!-- Liste et édition -->
<?php foreach ($testimonials as $testi): ?>
<div class="box">
    <form method="post">
        <input type="hidden" name="update" value="1">
        <input type="hidden" name="id" value="<?php echo $testi['id']; ?>">

        <label>Name</label>
        <input type="text" name="name" value="<?php echo htmlspecialchars($testi['name']); ?>">

        <label>Title</label>
        <input type="text" name="title" value="<?php echo htmlspecialchars($testi['title']); ?>">

        <label>Testimonial Content</label>
        <textarea name="content"><?php echo htmlspecialchars($testi['content']); ?></textarea>

        <label>Image Path</label>
        <input type="text" name="image_path" value="<?php echo htmlspecialchars($testi['image_path']); ?>">

        <label>Rating</label>
        <input type="number" name="rating" min="1" max="5" value="<?php echo $testi['rating']; ?>">

        <label>Order Index</label>
        <input type="number" name="order_index" value="<?php echo $testi['order_index']; ?>">

        <button type="submit">Update</button>
    </form>
    <form method="post" onsubmit="return confirm('Delete this testimonial?');">
        <input type="hidden" name="delete" value="1">
        <input type="hidden" name="id" value="<?php echo $testi['id']; ?>">
        <button type="submit" style="background-color:red;">Delete</button>
    </form>
</div>
<?php endforeach; ?>

</body>
</html>


				<div class="wrap"></div>
			</div>
			<!-- wpbody-content -->
			<div class="clear"></div>
		</div>
		<!-- wpbody -->
		<div class="clear"></div>
	</div>
  <?php include '../css.php'; ?>
