<?php
 include 'url.php';
 ?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta name="author" content="thecodude">
    <meta name="description" content="">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title>Gifam  Gifam Consulting</title>

    <!-- Balises SEO optimises -->
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="googlebot" content="index, follow">
    <meta name="bingbot" content="index, follow">
    <meta name="description" content="GIFAM - Conseil en investissement financier, gestion d'actifs, analyse financire, accompagnement de projets internationaux, expertise en gestion des risques, solutions de financement innovantes.">
    <meta name="keywords" content="investissement, finance, gestion d'actifs, analyse financire, conseil financier, financement de projet, gestion des risques, GIFAM, consulting, international, solutions financires">
    <link rel="canonical" href="https://www.gifam.eu/">
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="GIFAM  Conseil en investissement et gestion d'actifs">
    <meta property="og:description" content="Expertise en investissement, gestion d'actifs, analyse financire et accompagnement de projets internationaux.">
    <meta property="og:url" content="https://www.gifam.eu/">
    <meta property="og:image" content="https://www.gifam.eu/images/logos/logo_default.png">
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="GIFAM  Conseil en investissement et gestion d'actifs">
    <meta name="twitter:description" content="Expertise en investissement, gestion d'actifs, analyse financire et accompagnement de projets internationaux.">
    <meta name="twitter:image" content="https://www.gifam.eu/images/logos/logo_default.png">

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css"> <!-- Template Stylesheet -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

</head>
<body>
<?php include 'header.php'; ?>

<main class="ras-main-content">

    <!-- Banner Start -->
    <?php
// Connexion  la base
include 'db.php';

// Charger les slides
$stmt = $pdo->query("SELECT * FROM services_banner_slides ORDER BY slide_order ASC");
$slides = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<section class="ras-banner ras-banner-1">
    <div class="slider-active text-center">
        <?php foreach ($slides as $slide): ?>
            <div class="ras-slide">
                <div class="container">
                    <div class="ras-slide-content">
                        <h3 class="ras-slide-sub-heading text-white"><?php echo htmlspecialchars($slide['sub_heading']); ?></h3>
                        <h2 class="ras-slide-heading text-white"><?php echo htmlspecialchars($slide['heading']); ?></h2>
                        <p class="ras-slide-desc text-white mb-50"><?php echo htmlspecialchars($slide['description']); ?></p>
                        <a href="<?php echo $url . $slide['button_link']; ?>" class="btn btn-primary btn-large hero-btn">
                            <?php echo htmlspecialchars($slide['button_text']); ?>
                            <i class="icofont-long-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</section>

    <!-- Banner End -->

    <!-- Video Start -->
	 <?php
	// Rcupration des donnes
	$video = $pdo->query("SELECT * FROM services_video LIMIT 1")->fetch(PDO::FETCH_ASSOC);
	?>

	<section class="ras-video">
		<h2 class="sr-only"><?php echo htmlspecialchars($video['video_title']); ?></h2>
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-12">
					<div class="ras-video-container wow fadeInUp">
						<img src="<?php echo $url . $video['video_image']; ?>" alt="Banner Video">
						<a style="display:none;" class="ras-vid-icon ras-video-lightbox vbox-item more" href="<?php echo htmlspecialchars($video['video_link']); ?>">
							<i class="icofont-ui-play"></i>
						</a>
					</div>
				</div>
			</div>
		</div>
	</section>

    <!-- Video End -->
	

    <!-- Services Start -->
    <?php

$services = $pdo->query("SELECT * FROM services_items ORDER BY service_order ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<section class="ras-services ras-services-1 ras-service-1-spacer-bottom">
    <div class="container">
	<?php
// Connexion ( mettre avant)
$sectionTitle = $pdo->query("SELECT * FROM services_section_title LIMIT 1")->fetch(PDO::FETCH_ASSOC);
?>

<section class="ras-services ras-services-1 ras-service-1-spacer-bottom">
    <div class="container">
        <h2 class="mb-50 text-center wow fadeInUp">
            <?php echo $sectionTitle['title_line1']; ?><br>
            <?php echo $sectionTitle['title_line2']; ?>
        </h2>

        <!-- ici le reste des services comme avant -->


        <div class="row align-items-center mb-50">
            <?php
            // Afficher services 1  3
            for ($i=0; $i < 3 && $i < count($services); $i++): 
                $service = $services[$i];
            ?>
            <div class="col-lg-4">
                <div class="ras-services-item wow fadeInLeft">
                    <div class="ras-service-info">
                        <div class="d-flex flex-column justify-content-between">
                            <div class="ras-service-icon <?php echo htmlspecialchars($service['icon_bg_class']); ?>">
                                <i class="<?php echo htmlspecialchars($service['icon_class']); ?>"></i>
                            </div>
                            <div class="ras-service-title-wrap">
                                <h3 class="ras-service-title">
                                    <a href="<?php echo htmlspecialchars($service['link']); ?>">
                                        <?php echo htmlspecialchars($service['title']); ?>
                                    </a>
                                </h3>
                                <p class="ras-service-details"><?php echo htmlspecialchars($service['description']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endfor; ?>
        </div>

        <div class="row align-items-center mb-50">
            <?php
            // Afficher services 4  6
            for ($i=3; $i < 6 && $i < count($services); $i++): 
                $service = $services[$i];
            ?>
            <div class="col-lg-4">
                <div class="ras-services-item wow fadeInLeft">
                    <div class="ras-service-info">
                        <div class="d-flex flex-column justify-content-between">
                            <div class="ras-service-icon <?php echo htmlspecialchars($service['icon_bg_class']); ?>">
                                <i class="<?php echo htmlspecialchars($service['icon_class']); ?>"></i>
                            </div>
                            <div class="ras-service-title-wrap">
                                <h3 class="ras-service-title">
                                    <a href="<?php echo htmlspecialchars($service['link']); ?>">
                                        <?php echo htmlspecialchars($service['title']); ?>
                                    </a>
                                </h3>
                                <p class="ras-service-details"><?php echo htmlspecialchars($service['description']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endfor; ?>
        </div>
    </div>
</section>

    <!-- Services End -->

    <!-- Who We Are Start -->
    <?php
	$feature = $pdo->query("SELECT * FROM features_section LIMIT 1")->fetch(PDO::FETCH_ASSOC);
	$services = $pdo->query("SELECT * FROM features_services ORDER BY service_order ASC")->fetchAll(PDO::FETCH_ASSOC);
	?>

	<section class="ras-features ras-features-1 sec-spacer-bottom-120">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6">
					<div class="ras-features-details wow fadeInLeft">
						<h2><?php echo htmlspecialchars($feature['title']); ?></h2>

						<p><?php echo nl2br(htmlspecialchars($feature['paragraph1'])); ?></p>
						<p><?php echo nl2br(htmlspecialchars($feature['paragraph2'])); ?></p>
						<p><?php echo nl2br(htmlspecialchars($feature['paragraph3'])); ?></p>

						<div class="services-list wow fadeInLeft" data-wow-delay="0.3s" style="margin-top:30px; z-index: 999999999;
 ">
							<?php foreach ($services as $service): ?>
								<a class="service-item" href="<?php echo $url . $service['link']; ?>">
									<i class="<?php echo htmlspecialchars($service['icon_class'] . ' ' . $service['icon_bg_class']); ?>"></i>
									<?php echo htmlspecialchars($service['text_service']); ?>
								</a>
							<?php endforeach; ?>
						</div>
					</div>
				</div>

				<div class="col-lg-6">
					<div class="ras-features-image wow fadeInRight" data-wow-duration="1s">
						<img src="<?php echo $url . $feature['image']; ?>" alt="<?php echo htmlspecialchars($feature['title'] . ' - GIFAM Team'); ?>">
					</div>
				</div>
			</div>
		</div>
	</section>

		<!-- Who We Are End -->

		<!-- Our Strengths Start -->
	   <?php

	$section = $pdo->query("SELECT * FROM whychoose_section LIMIT 1")->fetch(PDO::FETCH_ASSOC);
	$strengths = $pdo->query("SELECT * FROM whychoose_strengths ORDER BY item_order ASC")->fetchAll(PDO::FETCH_ASSOC);
	$items = $pdo->query("SELECT * FROM whychoose_items ORDER BY item_order ASC")->fetchAll(PDO::FETCH_ASSOC);
	?>

	<section class="ras-why-choose-us ras-why-choose-us-1">
		<div class="container">
			<div class="row align-items-center">

				<!-- Colonne Gauche -->
				<div class="col-lg-5 col-md-12">
					<h2 class="wow fadeInUp"><?php echo htmlspecialchars($section['title']); ?></h2>
					<p class="wow fadeInUp" data-wow-delay="0.2s"><?php echo nl2br(htmlspecialchars($section['paragraph_top'])); ?></p>

					<div class="strength-features wow fadeInUp" data-wow-delay="0.4s">
						<?php foreach ($strengths as $s): ?>
							<div class="strength-item">
								<i class="<?php echo htmlspecialchars($s['icon_class']) . ' ' . htmlspecialchars($s['icon_bg_class']); ?>"></i>
								<span><?php echo htmlspecialchars($s['label']); ?></span>
							</div>
						<?php endforeach; ?>
					</div>

					<p class="wow fadeInUp" data-wow-delay="0.6s"><?php echo nl2br(htmlspecialchars($section['paragraph_bottom'])); ?></p>
				</div>

				<!-- Colonne Droite -->
				<div class="col-lg-7 col-md-12">
					<div class="choose-us-items">
						<?php foreach ($items as $item): ?>
							<div class="choose-us-item wow fadeInUp">
								<div class="choose-us-icon <?php echo htmlspecialchars($item['icon_bg_class']); ?>">
									<i class="<?php echo htmlspecialchars($item['icon_class']); ?>"></i>
								</div>
								<div class="choose-us-details">
									<h3><?php echo htmlspecialchars($item['title']); ?></h3>
									<p><?php echo htmlspecialchars($item['description']); ?></p>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>

			</div>
		</div>
	</section>

    <!-- Our Strengths End -->

    <!-- Recently completed projects Start -->
    <?php
$caseStudies = $pdo->query("SELECT * FROM case_studies ORDER BY item_order ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<section class="ras-case-study ras-case-study-1">
    <div class="container">
        <?php
		$sectionTitleStmt = $pdo->prepare("SELECT title FROM section_titles WHERE section_key = ?");
		$sectionTitleStmt->execute(['case_studies']);
		$sectionTitle = $sectionTitleStmt->fetchColumn();
		?>

		<h2 class="text-center mb-50 wow fadeInUp"><?php echo htmlspecialchars($sectionTitle); ?></h2>

        <div class="row align-items-center">
            <?php foreach ($caseStudies as $case): ?>
                <div class="col-md-12 col-lg-6">
                    <div class="ras-single-case-study wow fadeInLeft">
                        <div class="case-study-image <?php echo htmlspecialchars($case['css_class']); ?>">
                            <img src="<?php echo $url . htmlspecialchars($case['image_path']); ?>" alt="<?php echo htmlspecialchars($case['image_alt']); ?>">
                        </div>
                        <h4><a href="<?php echo htmlspecialchars($case['project_link']); ?>" class="case-study-title"><?php echo htmlspecialchars($case['title']); ?></a></h4>
                        <p><?php echo htmlspecialchars($case['description']); ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

    <!-- Recently completed projects End -->

    <!-- Business overview Start -->
    <?php
	$stmt = $pdo->prepare("SELECT title, content FROM features_sections WHERE section_key = 'business_overview'");
	$stmt->execute();
	$features = $stmt->fetch(PDO::FETCH_ASSOC);
	?>

	<section class="ras-features ras-features-1 sec-spacer-bottom-120">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-12">
					<div class="ras-features-details wow fadeInRight">
						<h2><?php echo htmlspecialchars($features['title']); ?></h2>
						<p><?php echo nl2br(htmlspecialchars($features['content'])); ?></p>
					</div>
				</div>
			</div>
		</div>
	</section>
    <!-- Business overview End -->

    <!-- Testimonials Start -->
    <?php
$stmt = $pdo->query("SELECT * FROM services_testimonials ORDER BY order_index ASC");
$testimonials = $stmt->fetchAll(PDO::FETCH_ASSOC);

$sectionTitle = $pdo->prepare("SELECT title FROM section_titlesd WHERE section_key = 'testimonials'");
$sectionTitle->execute();
$title = $sectionTitle->fetchColumn();

?>

<section class="ras-testimonial ras-testimonial-1 sec-spacer-bottom-100">
    <div class="container">
        <h2 class="text-center mb-50 wow fadeInUp"><?php echo $title; ?></h2>

        <div class="ras-slider-three-col">
            <?php foreach ($testimonials as $testimonial): ?>
                <div class="ras-single-testimonial" style="height:420px;">
                    <p>"<?php echo htmlspecialchars($testimonial['content']); ?>"</p>
                    <div class="testi-info">
                        <h4 class="ras-testi-name"><?php echo htmlspecialchars($testimonial['name']); ?></h4>
                        <p class="ras-testi-designation"><?php echo htmlspecialchars($testimonial['title']); ?></p>
                    </div>
                    <div class="ras-rating">
                        <?php for ($i = 0; $i < $testimonial['rating']; $i++): ?>
                            <i class="icofont-star"></i>
                        <?php endfor; ?>
                    </div>
                    <img class="ras-testi-photo" src="<?php echo $url . htmlspecialchars($testimonial['image_path']); ?>" alt="<?php echo htmlspecialchars($testimonial['name']); ?>">
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

    <!-- Testimonials End -->
<?php
// if (isset($_POST['newsletter_submit'])) {
    // $email = trim($_POST['subscriber_email']);

    // if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // echo "<script>alert('Invalid email address.');</script>";
    // } else {
        // try {
            // $pdo = new PDO("mysql:host=localhost;dbname=ta_base", "user", "motdepasse");
            // $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            // $stmt = $pdo->prepare("INSERT IGNORE INTO newsletter_subscribers (email) VALUES (?)");
            // $stmt->execute([$email]);

            // echo "<script>alert('Subscription successful.');</script>";
        // } catch (PDOException $e) {
            // echo "<script>alert('Error: Unable to subscribe.');</script>";
        // }
    // }
// }
?>
<?php
if (isset($_POST['newsletter_submit'])) {
    $email = trim($_POST['subscriber_email']);

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo "<script>alert('Invalid email address.');</script>";
    } else {
        try {
            // $pdo = new PDO("mysql:host=localhost;dbname=ta_base", "user", "motdepasse");
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            $stmt = $pdo->prepare("INSERT IGNORE INTO newsletter_subscribers (email) VALUES (?)");
            $stmt->execute([$email]);

            // ? Envoi email  l'admin
            $admin_email = "gifam@dayrep.com";
            $subject = "New Newsletter Subscription";
            $message = "A new user has subscribed to the newsletter:\n\nEmail: $email\nDate: " . date("Y-m-d H:i:s");
            $headers = "From: gifam@dayrep.com\r\nReply-To: gifam@dayrep.com";

            mail($admin_email, $subject, $message, $headers);

            echo "<script>alert('Subscription successful. Thank you!');</script>";
        } catch (PDOException $e) {
            echo "<script>alert('Error: Unable to subscribe.');</script>";
        }
    }
}
?>

    <!-- Newsletter Start -->
    <section class="ras-newsletter-1">
    <div class="container">
        <div class="row flex-column align-items-center">
            <h2 class="text-center wow fadeInUp">To get weekly & monthly our news<br>subscribe Newsletter.</h2>
            <form method="post" action="" class="wow fadeInUp" style="display: flex; flex-direction: column; align-items: center; gap: 15px;">
                <label for="subscribe" class="sr-only">Subscribe</label>
                <input type="email" name="subscriber_email" placeholder="Enter your email" id="subscribe" style="width:400px;" required>
                <button type="submit" name="newsletter_submit" class="btn btn-primary btn-large">Subscribe</button>
            </form>
        </div>
    </div>
</section>

    <!-- Newsletter End-->

    <!-- Blog Start -->
    <?php
// Connexion PDO


try {
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
} catch (PDOException $e) {
    die("Erreur connexion BDD : " . $e->getMessage());
}

// Rcuprer l'intro (id=1)
$stmtIntro = $pdo->prepare("SELECT intro_title, intro_text FROM services_portfolios WHERE id = 1");
$stmtIntro->execute();
$intro = $stmtIntro->fetch(PDO::FETCH_ASSOC);

// Rcuprer les portfolios (tout sauf id=1)
$stmtPortfolios = $pdo->prepare("SELECT location, description, image FROM services_portfolios WHERE id != 1 ORDER BY created_at DESC");
$stmtPortfolios->execute();
$portfolios = $stmtPortfolios->fetchAll(PDO::FETCH_ASSOC);
?>

<section class="ras-blog ras-blog-2">
    <div class="container">
        <h1 class="text-center mb-50 wow fadeInUp">
            <span class="color-title"><?php echo htmlspecialchars($intro['intro_title']); ?></span>
            <p class="text-center mb-50 wow fadeInUp"><?php echo nl2br(htmlspecialchars($intro['intro_text'])); ?></p>
        </h1>

        <div class="ras-blog-2-slider">
            <?php foreach ($portfolios as $portfolio): ?>
                <div class="ras-blog-single">
                    <div class="ras-blog-img">
                        <a href="<?php echo $url; ?>blog-details.php">
                            <img src="<?php echo htmlspecialchars($portfolio['image']); ?>" alt="<?php echo htmlspecialchars($portfolio['location']); ?>">
                        </a>
                    </div>
                    <div class="ras-blog-info" style="height: 400px; background: rgb(59 130 246 / 4%);">
                        <div class="ras-blog-meta">
                            <h3 class="ras-blog-user">
                                <a href="#" style="text-align:center !important;"><?php echo htmlspecialchars($portfolio['location']); ?></a>
                            </h3>
                        </div>
                        <h3 class="ras-blog-title">
                            <p><?php echo nl2br(htmlspecialchars($portfolio['description'])); ?></p>
                        </h3>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

    <!-- Blog End-->
</main>


<?php include 'footer.php'; ?>

</body>
</html>
