<?php
// Page configuration
$page_title = 'GIFAM - Investment Advisory and Asset Management';
$page_description = 'Expertise in investment, asset management, financial analysis and international project support.';
$page_keywords = 'investment, finance, asset management, financial analysis, financial advisory, project financing, risk management, GIFAM, consulting, international, financial solutions';
$canonical_url = 'https://www.gifam.eu/';
$og_title = 'GIFAM – Investment Advisory and Asset Management';
$og_description = 'Expertise in investment, asset management, financial analysis and international project support.';
$og_url = 'https://www.gifam.eu/';
$og_image = 'https://www.gifam.eu/images/logos/logo_default.png';
$twitter_title = 'GIFAM – Investment Advisory and Asset Management';
$twitter_description = 'Expertise in investment, asset management, financial analysis and international project support.';
$twitter_image = 'https://www.gifam.eu/images/logos/logo_default.png';

// Page content
ob_start();
?>

<!-- Hero Banner Section -->
<section class="ras-banner ras-banner-1" aria-labelledby="hero-heading">
    <div class="slider-active text-center">
        <div class="ras-slide">
            <div class="container">
                <div class="ras-slide-content">
                    <h3 class="ras-slide-sub-heading text-white">Financial Planners</h3>
                    <h2 id="hero-heading" class="ras-slide-heading text-white">FINANCIAL INVESTMENT ANALYSIS</h2>
                    <p class="ras-slide-desc text-white mb-50">
                        At General Investment Fund Assets & Management Company (GIFAM), we specialize 
                        in providing financial support for a wide range of global projects.
                    </p>
                    <a href="<?php echo $url; ?>investment/" 
                       class="btn btn-primary btn-large hero-btn" 
                       aria-label="Discover our investment services">
                        Invest Now
                        <i class="icofont-long-arrow-right" aria-hidden="true"></i>
                    </a>
                </div>
            </div>
        </div>
        
        <div class="ras-slide">
            <div class="container">
                <div class="ras-slide-content">
                    <h3 class="ras-slide-sub-heading text-white">Investment Advisors</h3>
                    <h2 class="ras-slide-heading text-white">ASSET MANAGEMENT & CONSULTING</h2>
                    <p class="ras-slide-desc text-white mb-50">
                        Our expertise in asset management and financial advisory supports you 
                        in your international investment projects.
                    </p>
                    <a href="<?php echo $url; ?>our-services/" 
                       class="btn btn-primary btn-large hero-btn" 
                       aria-label="Discover our services">
                        Our Services
                        <i class="icofont-long-arrow-right" aria-hidden="true"></i>
                    </a>
                </div>
            </div>
        </div>
        
        <div class="ras-slide">
            <div class="container">
                <div class="ras-slide-content">
                    <h3 class="ras-slide-sub-heading text-white">Financial Experts</h3>
                    <h2 class="ras-slide-heading text-white">INNOVATIVE FINANCIAL SOLUTIONS</h2>
                    <p class="ras-slide-desc text-white mb-50">
                        Discover our innovative financial solutions and personalized approach 
                        for each investment project.
                    </p>
                    <a href="<?php echo $url; ?>contact-us/" 
                       class="btn btn-primary btn-large hero-btn" 
                       aria-label="Contact us for more information">
                        Contact Us
                        <i class="icofont-long-arrow-right" aria-hidden="true"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Video Section -->
<section class="ras-video" aria-labelledby="video-heading">
    <h2 id="video-heading" class="sr-only">Presentation video</h2>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-12">
                <div class="ras-video-container wow fadeInUp">
                    <img src="<?php echo $url; ?>images/video/video-img.jpg" 
                         alt="GIFAM presentation video" 
                         width="1200" 
                         height="600">
                    <a class="ras-vid-icon ras-video-lightbox vbox-item more" 
                       href="https://www.youtube.com/watch?v=yzCkM5MRaaI&t=10s"
                       aria-label="Watch presentation video">
                        <i class="icofont-ui-play" aria-hidden="true"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="ras-services ras-services-1 ras-service-1-spacer-bottom" aria-labelledby="services-heading">
    <div class="container">
        <header class="section-header">
            <h2 id="services-heading" class="mb-50 text-center wow fadeInUp">
                25 Years of Quality<br>Service in <span class="color-title">Finance</span>
            </h2>
        </header>
        
        <div class="row align-items-center mb-50">
            <!-- Service 1 -->
            <div class="col-lg-4">
                <article class="ras-services-item wow fadeInLeft">
                    <div class="ras-service-info">
                        <div class="d-flex flex-column justify-content-between">
                            <div class="ras-service-icon purple-bg-icon">
                                <i class="flaticon-start-up" aria-hidden="true"></i>
                            </div>
                            <div class="ras-service-title-wrap">
                                <h3 class="ras-service-title">
                                    <a href="<?php echo $url; ?>project-financing-consultation/">
                                        Project Financing Consultation
                                    </a>
                                </h3>
                                <p class="ras-service-details">
                                    GIFAM can offer expert advice on securing financing 
                                    for large-scale projects.
                                </p>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
            
            <!-- Service 2 -->
            <div class="col-lg-4">
                <article class="ras-services-item wow fadeInLeft">
                    <div class="ras-service-info">
                        <div class="d-flex flex-column justify-content-between">
                            <div class="ras-service-icon orange-bg-icon">
                                <i class="flaticon-digital-marketing" aria-hidden="true"></i>
                            </div>
                            <div class="ras-service-title-wrap">
                                <h3 class="ras-service-title">
                                    <a href="<?php echo $url; ?>investment-analysis-advisory/">
                                        Investment Analysis and Advisory
                                    </a>
                                </h3>
                                <p class="ras-service-details">
                                    Providing clients with comprehensive investment analysis 
                                    and advice is crucial.
                                </p>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
            
            <!-- Service 3 -->
            <div class="col-lg-4">
                <article class="ras-services-item wow fadeInLeft">
                    <div class="ras-service-info">
                        <div class="d-flex flex-column justify-content-between">
                            <div class="ras-service-icon skyblue-bg-icon">
                                <i class="flaticon-strategy" aria-hidden="true"></i>
                            </div>
                            <div class="ras-service-title-wrap">
                                <h3 class="ras-service-title">
                                    <a href="<?php echo $url; ?>our-services/">
                                        Risk Management Consulting
                                    </a>
                                </h3>
                                <p class="ras-service-details">
                                    In any financial venture, managing risk is paramount.
                                </p>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
        </div>
        
        <div class="row align-items-center mb-50">
            <!-- Service 4 -->
            <div class="col-lg-4">
                <article class="ras-services-item wow fadeInLeft">
                    <div class="ras-service-info">
                        <div class="d-flex flex-column justify-content-between">
                            <div class="ras-service-icon purple-bg-icon">
                                <i class="flaticon-web-programming" aria-hidden="true"></i>
                            </div>
                            <div class="ras-service-title-wrap">
                                <h3 class="ras-service-title">
                                    <a href="<?php echo $url; ?>our-services/">
                                        Asset Management and Portfolio
                                    </a>
                                </h3>
                                <p class="ras-service-details">
                                    GIFAM can provide asset management services.
                                </p>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
            
            <!-- Service 5 -->
            <div class="col-lg-4">
                <article class="ras-services-item wow fadeInLeft">
                    <div class="ras-service-info">
                        <div class="d-flex flex-column justify-content-between">
                            <div class="ras-service-icon orange-bg-icon">
                                <i class="flaticon-vector" aria-hidden="true"></i>
                            </div>
                            <div class="ras-service-title-wrap">
                                <h3 class="ras-service-title">
                                    <a href="<?php echo $url; ?>our-services/">
                                        Market Entry and Expansion Strategy
                                    </a>
                                </h3>
                                <p class="ras-service-details">
                                    New markets or expand their operations.
                                </p>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
            
            <!-- Service 6 -->
            <div class="col-lg-4">
                <article class="ras-services-item wow fadeInLeft">
                    <div class="ras-service-info">
                        <div class="d-flex flex-column justify-content-between">
                            <div class="ras-service-icon skyblue-bg-icon">
                                <i class="flaticon-chat" aria-hidden="true"></i>
                            </div>
                            <div class="ras-service-title-wrap">
                                <h3 class="ras-service-title">
                                    <a href="<?php echo $url; ?>our-services/">
                                        Financial Strategy Consulting
                                    </a>
                                </h3>
                                <p class="ras-service-details">
                                    Personalized financial strategies for your business.
                                </p>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
        </div>
    </div>
</section>

<?php
$page_content = ob_get_clean();

// Include base template
include '../templates/base.php';
?> 
