<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - GIFAM | Data Protection & GDPR Compliance</title>
    <meta name="description" content="GIFAM's comprehensive privacy policy outlines how we collect, use, and protect your personal data in compliance with GDPR and international privacy regulations.">
    <meta name="keywords" content="privacy policy, GDPR, data protection, personal data, GIFAM privacy">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    
    <style>
        .privacy-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #d12907;
        }
        
        .data-table {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .data-table table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .data-table th,
        .data-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        
        .data-table th {
            background: #d12907;
            color: white;
            font-weight: 600;
        }
        
        .rights-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin: 20px 0;
        }
        
        .right-card {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            border-left: 4px solid #dc3545;
        }
        
        .right-card h5 {
            color: #dc3545;
            margin-bottom: 10px;
        }
        
        .contact-info {
                background: #dc35450d;
    border: 1px solid #dc3545;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .update-badge {
            display: inline-block;
            background: #dc3545;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>legal-notices/">Legal Notices</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>privacy-policy/">Privacy Policy</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
    <br><br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1>Privacy Policy</h1>
                            <p class="lead">At GIFAM, we are committed to protecting your privacy and ensuring the security of your personal data. This comprehensive privacy policy outlines how we collect, use, store, and protect your information in compliance with GDPR and international privacy regulations.</p>
                            <div class="update-badge">Last Updated: 11, 07, 2025</div>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/case-study/case-study-2.jpg" alt="Privacy Protection" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Introduction -->
                    <div class="privacy-section">
                        <h2>1. Introduction</h2>
                        <p>GIFAM ("we," "our," or "us") is committed to protecting your privacy and ensuring the security of your personal data. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website, use our services, or interact with us in any way.</p>
                        
                        <h4>Key Principles:</h4>
                        <ul>
                            <li><strong>Transparency:</strong> We are clear about what data we collect and how we use it</li>
                            <li><strong>Security:</strong> We implement robust security measures to protect your data</li>
                            <li><strong>Control:</strong> You have control over your personal information</li>
                            <li><strong>Compliance:</strong> We adhere to GDPR and other applicable privacy laws</li>
                        </ul>
                    </div>

                    <!-- Information We Collect -->
                    <div class="privacy-section">
                        <h2>2. Information We Collect</h2>
                        
                        <h4>2.1 Personal Information</h4>
                        <p>We may collect the following types of personal information:</p>
                        
                        <div class="data-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Category</th>
                                        <th>Examples</th>
                                        <th>Purpose</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong>Contact Information</strong></td>
                                        <td>Name, email address, phone number, postal address</td>
                                        <td>Communication, service delivery, account management</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Professional Information</strong></td>
                                        <td>Company name, job title, industry</td>
                                        <td>Service customization, business development</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Financial Information</strong></td>
                                        <td>Payment details, billing information</td>
                                        <td>Transaction processing, financial services</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Technical Information</strong></td>
                                        <td>IP address, browser type, device information</td>
                                        <td>Website functionality, security, analytics</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Usage Information</strong></td>
                                        <td>Pages visited, time spent, interactions</td>
                                        <td>Website improvement, user experience</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h4>2.2 How We Collect Information</h4>
                        <ul>
                            <li><strong>Direct Collection:</strong> When you provide information directly to us through forms, applications, or communications</li>
                            <li><strong>Automated Collection:</strong> Through cookies, web beacons, and similar technologies</li>
                            <li><strong>Third-Party Sources:</strong> From business partners, service providers, and public sources</li>
                            <li><strong>Client Interactions:</strong> During service delivery and client relationship management</li>
                        </ul>
                    </div>

                    <!-- How We Use Your Information -->
                    <div class="privacy-section">
                        <h2>3. How We Use Your Information</h2>
                        
                        <h4>3.1 Primary Purposes</h4>
                        <ul>
                            <li><strong>Service Delivery:</strong> To provide our investment and consulting services</li>
                            <li><strong>Communication:</strong> To respond to inquiries and provide updates</li>
                            <li><strong>Account Management:</strong> To manage client relationships and accounts</li>
                            <li><strong>Legal Compliance:</strong> To meet regulatory and legal obligations</li>
                        </ul>

                        <h4>3.2 Secondary Purposes</h4>
                        <ul>
                            <li><strong>Business Development:</strong> To improve our services and develop new offerings</li>
                            <li><strong>Marketing:</strong> To send relevant information about our services (with consent)</li>
                            <li><strong>Analytics:</strong> To analyze website usage and improve user experience</li>
                            <li><strong>Security:</strong> To protect against fraud and ensure system security</li>
                        </ul>

                        <h4>3.3 Legal Basis for Processing</h4>
                        <p>We process your personal data based on the following legal grounds:</p>
                        <ul>
                            <li><strong>Consent:</strong> When you have given explicit consent</li>
                            <li><strong>Contract Performance:</strong> To fulfill our contractual obligations</li>
                            <li><strong>Legitimate Interest:</strong> For business development and service improvement</li>
                            <li><strong>Legal Obligation:</strong> To comply with applicable laws and regulations</li>
                        </ul>
                    </div>

                    <!-- Information Sharing -->
                    <div class="privacy-section">
                        <h2>4. Information Sharing and Disclosure</h2>
                        
                        <h4>4.1 When We Share Your Information</h4>
                        <p>We may share your information in the following circumstances:</p>
                        
                        <div class="data-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Recipient</th>
                                        <th>Purpose</th>
                                        <th>Data Protection</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong>Service Providers</strong></td>
                                        <td>IT support, payment processing, analytics</td>
                                        <td>Data processing agreements, security measures</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Business Partners</strong></td>
                                        <td>Joint service delivery, strategic partnerships</td>
                                        <td>Confidentiality agreements, limited access</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Regulatory Authorities</strong></td>
                                        <td>Legal compliance, regulatory reporting</td>
                                        <td>Legal obligation, secure transmission</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Legal Representatives</strong></td>
                                        <td>Legal proceedings, dispute resolution</td>
                                        <td>Legal privilege, confidentiality</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h4>4.2 International Transfers</h4>
                        <p>Your data may be transferred to countries outside the European Economic Area (EEA). We ensure adequate protection through:</p>
                        <ul>
                            <li>Standard Contractual Clauses (SCCs)</li>
                            <li>Adequacy decisions by the European Commission</li>
                            <li>Certification schemes and codes of conduct</li>
                            <li>Binding corporate rules where applicable</li>
                        </ul>
                    </div>

                    <!-- Data Security -->
                    <div class="privacy-section">
                        <h2>5. Data Security</h2>
                        
                        <h4>5.1 Security Measures</h4>
                        <p>We implement comprehensive security measures to protect your personal data:</p>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <h5><i class="icofont-lock text-primary"></i> Technical Security</h5>
                                <ul>
                                    <li>Encryption in transit and at rest</li>
                                    <li>Multi-factor authentication</li>
                                    <li>Regular security audits</li>
                                    <li>Intrusion detection systems</li>
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h5><i class="icofont-shield-check text-success"></i> Organizational Security</h5>
                                <ul>
                                    <li>Access controls and permissions</li>
                                    <li>Employee training and awareness</li>
                                    <li>Incident response procedures</li>
                                    <li>Regular policy reviews</li>
                                </ul>
                            </div>
                        </div>

                        <h4>5.2 Data Breach Response</h4>
                        <p>In the event of a data breach, we will:</p>
                        <ul>
                            <li>Immediately assess the scope and impact</li>
                            <li>Notify relevant authorities within 72 hours</li>
                            <li>Inform affected individuals without undue delay</li>
                            <li>Implement remedial measures to prevent recurrence</li>
                        </ul>
                    </div>

                    <!-- Your Rights -->
                    <div class="privacy-section">
                        <h2>6. Your Rights</h2>
                        <p>Under GDPR and other privacy laws, you have the following rights regarding your personal data:</p>
                        
                        <div class="rights-grid">
                            <div class="right-card">
                                <h5><i class="icofont-eye"></i> Right to Access</h5>
                                <p>You can request a copy of the personal data we hold about you and information about how we process it.</p>
                            </div>
                            
                            <div class="right-card">
                                <h5><i class="icofont-edit"></i> Right to Rectification</h5>
                                <p>You can request correction of inaccurate or incomplete personal data we hold about you.</p>
                            </div>
                            
                            <div class="right-card">
                                <h5><i class="icofont-trash"></i> Right to Erasure</h5>
                                <p>You can request deletion of your personal data in certain circumstances (the "right to be forgotten").</p>
                            </div>
                            
                            <div class="right-card">
                                <h5><i class="icofont-pause"></i> Right to Restriction</h5>
                                <p>You can request that we limit how we process your personal data in certain circumstances.</p>
                            </div>
                            
                            <div class="right-card">
                                <h5><i class="icofont-download"></i> Right to Portability</h5>
                                <p>You can request a copy of your data in a structured, machine-readable format.</p>
                            </div>
                            
                            <div class="right-card">
                                <h5><i class="icofont-hand"></i> Right to Object</h5>
                                <p>You can object to processing of your personal data in certain circumstances.</p>
                            </div>
                        </div>

                        <h4>6.1 How to Exercise Your Rights</h4>
                        <p>To exercise any of these rights, please contact us using the information provided below. We will respond to your request within one month, unless the request is complex or we receive multiple requests.</p>
                    </div>

                    <!-- Data Retention -->
                    <div class="privacy-section">
                        <h2>7. Data Retention</h2>
                        
                        <h4>7.1 Retention Periods</h4>
                        <p>We retain your personal data only for as long as necessary to fulfill the purposes for which it was collected:</p>
                        
                        <div class="data-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Data Category</th>
                                        <th>Retention Period</th>
                                        <th>Reason</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong>Client Data</strong></td>
                                        <td>7 years after service completion</td>
                                        <td>Legal obligations, tax requirements</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Marketing Data</strong></td>
                                        <td>3 years from last interaction</td>
                                        <td>Business development, consent period</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Website Analytics</strong></td>
                                        <td>2 years</td>
                                        <td>Website improvement, user experience</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Financial Records</strong></td>
                                        <td>10 years</td>
                                        <td>Regulatory requirements, audit purposes</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h4>7.2 Data Disposal</h4>
                        <p>When we no longer need your personal data, we will securely delete or anonymize it in accordance with our data disposal procedures.</p>
                    </div>

                    <!-- Cookies and Tracking -->
                    <div class="privacy-section">
                        <h2>8. Cookies and Tracking Technologies</h2>
                        
                        <h4>8.1 Types of Cookies We Use</h4>
                        <ul>
                            <li><strong>Essential Cookies:</strong> Required for website functionality</li>
                            <li><strong>Analytics Cookies:</strong> Help us understand how visitors use our website</li>
                            <li><strong>Marketing Cookies:</strong> Used for targeted advertising and content</li>
                            <li><strong>Preference Cookies:</strong> Remember your settings and preferences</li>
                        </ul>

                        <h4>8.2 Managing Cookies</h4>
                        <p>You can control cookies through your browser settings. However, disabling certain cookies may affect website functionality.</p>
                        
                        <p>For detailed information about our use of cookies, please see our <a href="<?php echo $url; ?>cookie-policy/">Cookie Policy</a>.</p>
                    </div>

                    <!-- Children's Privacy -->
                    <div class="privacy-section">
                        <h2>9. Children's Privacy</h2>
                        <p>Our services are not intended for children under 16 years of age. We do not knowingly collect personal information from children under 16. If you believe we have collected information from a child under 16, please contact us immediately.</p>
                    </div>

                    <!-- Changes to This Policy -->
                    <div class="privacy-section">
                        <h2>10. Changes to This Privacy Policy</h2>
                        <p>We may update this Privacy Policy from time to time to reflect changes in our practices, technology, legal requirements, or other factors. When we make changes, we will:</p>
                        <ul>
                            <li>Update the "Last Updated" date at the top of this policy</li>
                            <li>Provide notice of significant changes through our website or email</li>
                            <li>Obtain consent for material changes where required by law</li>
                            <li>Maintain version history for transparency</li>
                        </ul>
                    </div>

                    <!-- Contact Information -->
                    <div class="contact-info">
                        <h2>11. Contact Us</h2>
                        <p>If you have any questions about this Privacy Policy or our data practices, please contact us:</p>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Data Protection Officer</h4>
                                <p><strong>Email:</strong> dpo@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4567<br>
                                <strong>Address:</strong> 123 Business Street, Suite 100, New York, NY 10001</p>
                            </div>
                            <div class="col-lg-6">
                                <h4>General Privacy Inquiries</h4>
                                <p><strong>Email:</strong> privacy@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4568<br>
                                <strong>Response Time:</strong> Within 48 hours</p>
                            </div>
                        </div>

                        <h4>Supervisory Authority</h4>
                        <p>You also have the right to lodge a complaint with your local data protection supervisory authority if you believe we have not addressed your concerns adequately.</p>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Questions About Your Privacy?</h3>
                                <p class="lead mb-4">Our privacy team is here to help clarify any questions about how we handle your personal data.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Contact Privacy Team</a>
                                <a href="<?php echo $url; ?>legal-notices/" class="btn btn-outline-primary btn-lg">View All Legal Documents</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

</body>
</html> 
