<?php

/* ------------------------------------------------------------------------ */
/* Redux Configuration
/* ------------------------------------------------------------------------ */

    if ( ! class_exists( 'Redux' ) ) 
	{
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "finance_option";
	global $logo_tmp_src;
    $theme = wp_get_theme(); // For use with some settings. Not necessary.

   $args = array(
        'opt_name'          => 'tmc_options',       // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'      => $theme->get('Name'),     // Name that appears at the top of your panel
        'display_version'   => $theme->get('Version'),  // Version that appears at the top of your panel
        'menu_type'         => 'submenu',               //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'    => false,                   // Show the sections below the admin menu item or not
        'menu_title'        => __('Theme Options', 'finance'),
        'page_title'        => __('Theme Options', 'finance'),
        'save_defaults'     => true,
        'async_typography'  => true,                    // Use a asynchronous font on the front end or font string
        'admin_bar'         => false,                    // Show the panel pages on the admin bar
        'global_variable'   => 'finance_option',        // Set a different name for your global variable other than the opt_name
        'dev_mode'          => false,                    // Show the time the page took to load, etc
        'customizer'        => false,                    // Enable basic customizer support
        'page_slug'         => 'finance_options',
        'system_info'       => false,
        'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    );

	 
	
    Redux::setArgs( $opt_name, $args, $logo_tmp_src  );

    /* Set Extensions /-------------------------------------------------- */
    Redux::setExtensions( $opt_name, dirname( __FILE__ ) . '/extensions/' );

    /* General /--------------------------------------------------------- */
    Redux::setSection( $opt_name, array(
        'title'     => __('General', 'finance'),
		'desc'   => '',
        'icon'      => 'el-icon-home',
		'class'     => 'main_background',
		'submenu' => true, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
        'fields'    => array(
			
			array(
                'id'       => 'switch_comments',
                'type'     => 'switch', 
                'title'    => __('Global Page Comments', 'finance'),
                'subtitle' => __('You can globally disable the Page Comments.', 'finance'),
                'default'  => true,
            ),
        ),
    ) );

	/* Layout  */
	
		Redux::setSection( $opt_name, array(
			'title'     => esc_html__('Layout', 'finance'),
			'desc'   => '',
			'class'     => 'main_background',
			'icon'   => 'el el-th',
			'submenu' => true,
			'fields'    => array(
	
			array(
				'id'       => 'top_back_button_one',
				'type'     => 'select',
				'title'    => __('Back to Top Button', 'finance'),
				'subtitle' => esc_html__('Enable / Disable Back to Top Button.', 'finance'),
				'options'  => array(
					'1' => 'Enable on All Devices',
					'2' => 'Enable on Desktop Only',
					'3' => 'Enable on Mobile Only',
					'4' => 'Disable'
				),
				'default'  => '1',
			),
			
			array(
				'id'       => 'layout_style',
				'type'     => 'select',
				'title'    => __('Layout Style', 'finance'),
				'subtitle' => esc_html__('Choose your Layout Style.', 'finance'),
				'options'  => array(
					'1' => 'Fullwidth',
					'2' => 'Boxed Layout',
				),
				'default'  => '1',
			), 
			array(
				'id'       => 'boxed_bg',
				'type'     => 'background',
				'compiler' => true,
				'output'   => array('.layout-boxed, body'),
				'title'    => esc_html__('Body Background for boxed layout', 'finance'),
				'default'  => '',
				'required' => array('layout_style','=','2'),
			),			
			array
			(				
				'id'       => 'primary_color',
				'type'     => 'color',	
				'compiler' => true,			
				'title'    => esc_html__('Primary Color Schema', 'finance'),	
				'default'  => '',		
				'output'   => array(			
				'color'             => 'body.tmc_header_4 .top_nav .top_nav_wrapper > ul  > li.current_page_item a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul > li > a:hover, .icon_text .icon, .welcome-section .sec-title1 span, a, .primary-color, .tmc-menu a:hover, .tmc-menu > li.current-menu-item > a, .tmc-menu > li.current-menu-ancestor > a, .entry-footer .post-categories li a:hover, .entry-footer .post-tags li a:hover, .heading-404, .grid-item .grid-title a:hover, .widget a:hover, .widget #calendar_wrap a, .widget_recent_comments a, #secondary .widget.widget_nav_menu ul li a:hover, #secondary .widget.widget_nav_menu ul li li a:hover, #secondary .widget.widget_nav_menu ul li li li a:hover, #secondary .widget.widget_nav_menu ul li.current-menu-item a, .woocommerce ul.products li.product .price, .woocommerce .star-rating, .iconbox-wrapper .iconbox-icon .primary, .iconbox-wrapper .iconbox-image .primary, .iconbox-wrapper a:hover, .breadcrumbs a:hover, #comments .comment .comment-wrapper .comment-meta .comment-time:hover, #comments .comment .comment-wrapper .comment-meta .comment-reply-link:hover, #comments .comment .comment-wrapper .comment-meta .comment-edit-link:hover, .nav-toggle-active i, .header-transparent .header-right-wrap .extract-element .phone-text, .site-header .header-right-wrap .extract-element .phone-text, .wpb_wrapper .tmc-projects-light .esg-navigationbutton:hover, .wpb_wrapper .tmc-projects-light .esg-filterbutton:hover, .wpb_wrapper .tmc-projects-light .esg-sortbutton:hover, .wpb_wrapper .tmc-projects-light .esg-sortbutton-order:hover, .wpb_wrapper .tmc-projects-light .esg-cartbutton-order:hover, .wpb_wrapper .tmc-projects-light .esg-filterbutton.selected, .wpb_wrapper .tmc-projects-dark .esg-navigationbutton:hover, .wpb_wrapper .tmc-projects-dark .esg-filterbutton:hover, .wpb_wrapper .tmc-projects-dark .esg-sortbutton:hover, .wpb_wrapper .tmc-projects-dark .esg-sortbutton-order:hover, .wpb_wrapper .tmc-projects-dark .esg-cartbutton-order:hover, .wpb_wrapper .tmc-projects-dark .esg-filterbutton.selected, .icon-box-faq, .name-content .client-name h3, .statics ul li p, .right-box .single-blog-post:hover .date-box h4, .tel-box .text-box h4, .single-service h3 a:hover, .single-sidebar-widget .single-service-contact a, .service-single-page .single-service-box ul.list-box li, .single-blog-post h3:hover, #footer .socials ul li a:hover, ul.list-box li,.comming-soon-sec .time .box-time,.comming-soon-sec .time .box-time span:first-child,.comming-soon-sec .time .box-time span:last-child, .post-page-meta i,.entry-meta i.fa, .widget-posts-list .content a h4:hover, body.tmc_header_2 .header_top .top_nav .top_nav_wrapper > ul > li.current_page_item > a, body.tmc_header_2 .header_top .top_nav .top_nav_wrapper > ul > li.current-menu-ancestor > a, body.tmc_header_2 .header_top .top_nav .top_nav_wrapper > ul > li.current-menu-parent > a, body.tmc_header_2 .header_top .top_nav .top_nav_wrapper > ul > li.current_page_parent > a, body.tmc_header_2 .header_top .top_nav .top_nav_wrapper > ul > li.current_page_ancestor > a, body.tmc_header_2 .header_top .top_nav .main_menu_nav > ul > li.current_page_item > a, body.tmc_header_2 .header_top .top_nav .main_menu_nav > ul > li.current-menu-ancestor > a, body.tmc_header_2 .header_top .top_nav .main_menu_nav > ul > li.current-menu-parent > a, body.tmc_header_2 .header_top .top_nav .main_menu_nav > ul > li.current_page_parent > a, body.tmc_header_2 .header_top .top_nav .main_menu_nav > ul > li.current_page_ancestor > a, body.tmc_header_2 .header_top .top_nav .top_nav_wrapper > ul > li:hover > a, body.tmc_header_2 .header_top .top_nav .main_menu_nav > ul > li:hover > a, #footer .footer_widgets .tp_recent_tweets li:before, .top_nav .top_nav_wrapper > ul > li.current_page_item > a, .top_nav .top_nav_wrapper > ul > li.current-menu-ancestor > a, .top_nav .top_nav_wrapper > ul > li.current-menu-parent > a, .top_nav .top_nav_wrapper > ul > li.current_page_parent > a, .top_nav .top_nav_wrapper > ul > li.current_page_ancestor > a, .top_nav .main_menu_nav > ul > li.current_page_item > a, .top_nav .main_menu_nav > ul > li.current-menu-ancestor > a, .top_nav .main_menu_nav > ul > li.current-menu-parent > a, .top_nav .main_menu_nav > ul > li.current_page_parent > a, .top_nav .main_menu_nav > ul > li.current_page_ancestor > a, .top_nav .top_nav_wrapper > ul > li:hover > a, .top_nav .main_menu_nav > ul > li:hover > a, .post-resource ul li i, body.tmc_header_1 .icon_text .icon, .footer-contacts2 h2 strong, body.tmc_header_5 .header_top .top_nav .top_nav_wrapper > ul > li.current_page_item > a, body.tmc_header_5 .header_top .top_nav .top_nav_wrapper > ul > li.current-menu-ancestor > a, body.tmc_header_5 .header_top .top_nav .top_nav_wrapper > ul > li.current-menu-parent > a, body.tmc_header_5 .header_top .top_nav .top_nav_wrapper > ul > li.current_page_parent > a, body.tmc_header_5 .header_top .top_nav .top_nav_wrapper > ul > li.current_page_ancestor > a, body.tmc_header_5 .header_top .top_nav .main_menu_nav > ul > li.current_page_item > a, body.tmc_header_5 .header_top .top_nav .main_menu_nav > ul > li.current-menu-ancestor > a, body.tmc_header_5 .header_top .top_nav .main_menu_nav > ul > li.current-menu-parent > a, body.tmc_header_5 .header_top .top_nav .main_menu_nav > ul > li.current_page_parent > a, body.tmc_header_5 .header_top .top_nav .main_menu_nav > ul > li.current_page_ancestor > a, body.tmc_header_5 .header_top .top_nav .top_nav_wrapper > ul > li:hover > a, body.tmc_header_5 .header_top .top_nav .main_menu_nav > ul > li:hover > a, .return-customer a, .tp_recent_tweets li a, #footer .footer_widgets .tp_recent_tweets li .twitter_time, .home-cta a.thm-button-mine.mine-css',						
				'background'  => '.thm-button.thm-button1:hover, .awsm-btn-set.request-call-form .wpcf7-form-control.wpcf7-submit, .footer-contacts .thm-button:hover, .footer-contacts4 .thm-button, .profile-information p.note:before, .answer-question .wpcf7-form-control.wpcf7-submit, .new-app-color.thm-button.inverse,.error-404 .thm-button,.comming-soon-sec .thm-button,.project-page .single-project-item a.btn, body.tmc_header_1 .top_nav .top_nav_wrapper, .thm-button.mu-color:hover, .tmc_header_1 .footer-contacts .thm-button:hover, .get-quote-btn, body.tmc_header_1  .get-quote-btn:before, body.tmc_header_1  .top_nav, .tmc_header_1 .footer-contacts, .section_header h2:before, .woocommerce-shipping-fields h3:before, .tmc_header_2 .page_title h1.h2:after',		

				'background-color' => 'input[type="reset"], input[type="submit"], input[type="submit"], .tmc-menu ul li a:hover, .tmc-menu ul li.current-menu-item > a, .loop-pagination a:hover, .loop-pagination span:hover, .loop-pagination a.current, .loop-pagination span.current, .footer-social, .tagcloud a:hover, woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce #respond input#submit.alt:hover, .woocommerce #respond input#submit.alt:focus, .woocommerce #respond input#submit.alt:active, .woocommerce a.button.alt:hover, .woocommerce a.button.alt:focus, .woocommerce a.button.alt:active, .woocommerce button.button.alt:hover, .woocommerce button.button.alt:focus, .woocommerce button.button.alt:active, .woocommerce input.button.alt:hover, .woocommerce input.button.alt:focus, .woocommerce input.button.alt:active, .woocommerce span.onsale, .entry-content .wpb_content_element .wpb_tour_tabs_wrapper .wpb_tabs_nav li.ui-tabs-active a, .entry-content .wpb_content_element .wpb_accordion_header li.ui-tabs-active a, .entry-content .wpb_content_element .wpb_accordion_wrapper .wpb_accordion_header.ui-state-active a, .btn, .btn:hover, .btn-primary, .custom-heading .heading-line, .custom-heading .heading-line.primary, .wpb_wrapper .eg-tmc_projects-element-1, .sec-title h2:after, .custom-heading h2:before, .single-team-member .img-box .overlay .box .content ul, .right-box .single-blog-post:hover .text-box .date-box span.decor-line, .widget_tmc_services h4:after, .get-in-touch h4:after, .widget-links h4:after, .widget_mc4wp_form_widget h3.widget-title:after, .about-cta .single-count-box span.decor-line, .widget h2::after, .img-holder .date-box, .more-link:hover, .more-link:focus, .single-blog-post .qoute-box, .woocommerce ul.products li.product .button, .product-details-content .content-box .cart-btn, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .thm-button1:hover, .widget_mc4wp_form_widget h4:after, .widget_nav_menu h4:after, .answer-question .wpcf7-form-control.wpcf7-submit:hover, .thm-button:hover, .widget_archive h5:after, .widget_categories h5:after, .widget_links h5:after, .widget_meta h5:after, .widget_pages h5:after, .widget_recent_comments h5:after, .widget_recent_entries h5:after, .widget_rss h5:after, .widget_nav_menu h5:after, .widget_tmc_services_sidebar .widget_tmc_services:after, .widget_tmc_posts .widget_title:after, .widget_text .widget_title:after, .widget_tag_cloud .widget_title:after, .widget_tp_widget_recent_tweets h4:after, .widget.widget_tag_cloud .tagcloud a:hover, .thm-button.mine-css.thm-button-c:hover',	

				'border-color'      => '#footer .socials ul li a:hover,.comming-soon-sec .time .box-time, .widget.widget_tag_cloud .tagcloud a:hover, textarea:focus, input[type="date"]:focus, input[type="datetime"]:focus, input[type="datetime-local"]:focus, input[type="email"]:focus, input[type="month"]:focus, input[type="number"]:focus, input[type="password"]:focus, input[type="search"]:focus, input[type="tel"]:focus, input[type="text"]:focus, input[type="time"]:focus, input[type="url"]:focus, input[type="week"]:focus, .entry-content blockquote, .woocommerce ul.products li.product a img:hover, .woocommerce div.product div.images img:hover, .contact_media .media-left a, .wpcf7-form-control.wpcf7-submit, li.vc_tta-tab.vc_active, .product-tab-box .tab-title-box ul li.active a, .home-cta a.thm-button-mine.mine-css',						
				
				'border-left-color' => '#secondary .widget.widget_nav_menu ul li.current-menu-item a:before, .single-sidebar-widget .special-links li.active a, .single-sidebar-widget .special-links li a:before'					
				)			
			),			
			array
			(		
				'id'       => 'secondary_color',	
				'type'     => 'color',			
				'compiler' => true,				
				'title'    => esc_html__('Secondary Color Schema', 'finance'),	
				'default'  => '',				
				'output'   => array(					
								'color'    => '.tmc_header_4 .full-img-sec .left-content.awsm-settings li, #footer .footer_widgets .widget.widget_nav_menu ul li a:hover, .career-page .list-box li, .case-details-sec.item-case-details ul li, .secondary-color, .iconbox-wrapper .iconbox-icon .secondary, .iconbox-wrapper .iconbox-image .secondary, .full-img-sec .left-content ul li, .widget-posts-list .content span, .return-customer a:hover, .welcome-section2 .sec-title h2 .blue, .latest-blog.latest-blog4 a, .single-sidebar-widget .category-widget ul li a:hover',

								'background'  => '.single-project-item .btn, .awsm-btn-set.request-call-form .wpcf7-form-control.wpcf7-submit:hover, .footer-contacts .thm-button, .sec-page-advisors  .advisors-sec .col-md-9 .thm-button, .new-app-color.thm-button.inverse:hover,.inverse,.error-404 .thm-button:hover, .contact-form.left-box .wpcf7-form-control.wpcf7-submit.thm-button:hover, .about-us-section .thm-button, .mc4wp-form-fields .thm-button, .footer-contacts2 .thm-button, .welcome-section2 .sec-title .decor-line, .welcome-section2 .welcome2-box .thm-button:hover, .service-page4 .custom-heading h2:before, .footer-contacts3 .thm-button:hover, .why-choose-bg2 .custom-heading h2:before, .latest-blog.latest-blog4 .custom-heading h2:before, .request-call-form .wpcf7-form-control.wpcf7-submit:hover',					

								'background-color'  => '.btn-secondary, .custom-heading .heading-line.secondary, .form-submit input:hover, .woocommerce ul.products li.product .button:hover, .product-details-content .content-box .cart-btn:hover, .woocommerce input.button:hover, .woocommerce a.button.alt:hover, .thm-button1, .woocommerce #respond input#submit:hover',

								'border-color'      => '.request-call-form .wpcf7-form-control.wpcf7-submit:hover'
				)		
			),
					
		)
	) );
	
	/* Header /--------------------------------------------------------- */
	 
    Redux::setSection( $opt_name, array(
        'title'     => esc_html__('Header', 'finance'),
		'background-color' => '#ef9a9a',
		'desc'   => '',
		'class'     => 'main_background',
        'icon'   => 'el el-credit-card',
		'submenu' => true,
        'fields'    => array(
		
		array(
                'id'       => 'header_style',
                'type'     => 'image_select',
                'title'    => __('Header Layout', 'finance'), 
                'subtitle' => __('Select the Header Layout', 'finance'),
                'description' => __('Only Header 1 & 3 can be transparent. Keep that in mind when choosing your Page specific Headers.', 'finance'),
                'options'  => array(
                    'tmc_header_1'      => array(
                        'alt'   => 'Header 1', 
                        'img'   => get_template_directory_uri() .'/assets/images/headers/header_1.png'
                    ),
					
                    'tmc_header_2'      => array(
                        'alt'   => 'Header 2', 
                        'img'   => get_template_directory_uri() .'/assets/images/headers/header_2.png'
                    ),
                    'tmc_header_3'      => array(
                        'alt'   => 'Header 3', 
                        'img'   => get_template_directory_uri() .'/assets/images/headers/header_3.png'
                    ),
                    'tmc_header_4'      => array(
                        'alt'   => 'Header 4', 
                        'img'   => get_template_directory_uri() .'/assets/images/headers/header_4.png'
                    ),
                    'tmc_header_5'      => array(
                        'alt'   => 'Header 5', 
                        'img'   => get_template_directory_uri() .'/assets/images/headers/header_5.png'
                    ),
                ),
                'default' => 'tmc_header_4'
            ),
		
		array(
				'id'       => 'sep_header1',
				'title'   => esc_html__( 'Top Bar', 'finance' ),
				'type'    => 'text',
				'class'    => 'background_color',
				'required' => array(
									array('header_style','!=', 'tmc_header_1'),
									array('header_style','!=', 'tmc_header_4'),
									),
			),
		
		array(
				'id'       => 'top_bar',
				'type'     => 'switch',
				'title'    => esc_html__('Top Bar', 'finance'),
				'subtitle' => esc_html__('Enable/ Disable Top Bar', 'finance'),
				'default'  => true,
				'required' => array(
									array('header_style','!=', 'tmc_header_1'),
									array('header_style','!=', 'tmc_header_4'),
									),
			  ),
		
		array(
				'id'       => 'topbar_left_text',
				'type'     => 'text',
				'title'    => esc_html__('Text Info.', 'finance'),
				'default'  => esc_html__( "Welcome to Finance Pro - We are serving from 12 years", 'finance' ),
				'required' => array(
									array('top_bar','=', true),
									array('header_style','!=', 'tmc_header_1'),
									array('header_style','!=', 'tmc_header_4'),
									),
			  ),
		
		array(
				'id'       => 'top_phone_icon',
				'type'     => 'text',
				'title'    => esc_html__('Contact Number Icon', 'finance'),
				'default'  => esc_html__( "fa fa-phone", 'finance' ),
				'required' => array(
									array('top_bar','=', true),
									array('header_style','!=', 'tmc_header_1'),
									array('header_style','!=', 'tmc_header_2'),
									array('header_style','!=', 'tmc_header_4'),
									array('header_style','!=', 'tmc_header_5'),
									),
			  ),
		
		array(
				'id'       => 'top_phone',
				'type'     => 'text',
				'title'    => esc_html__('Contact Number', 'finance'),
				'default'  => esc_html__( "+ (1800) 456 7890", 'finance' ),
				'required' => array(
									array('top_bar','=', true),
									array('header_style','!=', 'tmc_header_1'),
									array('header_style','!=', 'tmc_header_4'),
									),
			  ),
			
		array(
				'id'       => 'topbar_email_icon',
				'type'     => 'text',
				'title'    => esc_html__('Email Icon', 'finance'),
				'default'  => esc_html__( "fa fa-envelope", 'finance' ),
				'required' => array(
									array('top_bar','=', true),
									array('header_style','!=', 'tmc_header_1'),
									array('header_style','!=', 'tmc_header_2'),
									array('header_style','!=', 'tmc_header_4'),
									array('header_style','!=', 'tmc_header_5'),
									),
			  ),
			
		array(
				'id'       => 'topbar_email',
				'type'     => 'text',
				'title'    => esc_html__('Email', 'finance'),
				'default'  => esc_html__( "info@financepro.com", 'finance' ),
				'required' => array(
									array('top_bar','=', true),
									array('header_style','!=', 'tmc_header_1'),
									array('header_style','!=', 'tmc_header_4'),
									),
			  ),
		
		array(
			'id'       => 'sep_header_logo',
			'title'   => esc_html__( 'Header Logo', 'finance' ),
			'type'    => 'text',
			'class'    => 'background_color',
			
			),
			  
		array(
			'id'       =>'site_logo',
			'url'      => false,
			'type'     => 'media',
			'title'    => esc_html__('Site Logo', 'finance'),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/tmp/'. $logo_tmp_src .'logo_default.png' ),
			'subtitle' => esc_html__('Upload your Logo here.', 'finance'),
			'required' => array(
								array('header_style','!=', 'tmc_header_2'),
								array('header_style','!=', 'tmc_header_3'),
								array('header_style','!=', 'tmc_header_5'),
								),
		),		
		array(
			'id'       =>'site_logo_header2',
			'url'      => false,
			'type'     => 'media',
			'title'    => esc_html__('Site Logo', 'finance'),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/tmp/'. $logo_tmp_src .'logo_dark.png' ),
			'subtitle' => esc_html__('Upload your Logo here.', 'finance'),
			'required' => array(
								array('header_style','=', 'tmc_header_2'),
								),
		),
			array(
			'id'       =>'site_logo_header3',
			'url'      => false,
			'type'     => 'media',
			'title'    => esc_html__('Site Logo', 'finance'),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/tmp/'. $logo_tmp_src .'logo3.png' ),
			'subtitle' => esc_html__('Upload your Logo here.', 'finance'),
			'required' => array(
									array('header_style','=', 'tmc_header_3'),
									),
		),
		array(
			'id'       =>'site_logo_header5',
			'url'      => false,
			'type'     => 'media',
			'title'    => esc_html__('Site Logo', 'finance'),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/tmp/'. $logo_tmp_src .'logo4.png' ),
			'subtitle' => esc_html__('Upload your Logo here.', 'finance'),
			'required' => array(
									array('header_style','=', 'tmc_header_5'),
								
									),
		),		
		array(
			'id'       =>'mobile_logo',
			'url'      => false,
			'type'     => 'media',
			'title'    => esc_html__('Mobile Logo', 'finance'),
			'default'  => array( 'url' => get_template_directory_uri() . '/assets/images/tmp/'. $logo_tmp_src .'default_dark.png' ),
			'subtitle' => esc_html__('Upload your Logo here.', 'finance'),			
		),		
		array(
			'id'       => 'logo_margin',
			'type'           => 'spacing',
			'output'         => array('.logo'),
			'mode'           => 'margin',
			'units'          => array('em','px','%'),
			'units_extended' => 'false',
			'title'   => esc_html__( 'Logo Margin', 'finance' ),
			'subtitle' => esc_html__('Enter your top margin value for the logo.', 'finance'),
			'default'        => array(
			
				'margin-top'     => '0px',
				'margin-right'   => '0px',
				'margin-bottom'  => '0px',
				'margin-left'    => '0px',
				'units'          => 'px',

			)
		),
		
		array(
				'id'       => 'sep_header',
				'title'   => esc_html__( 'Header Information Fields', 'finance' ),
				'type'    => 'text',
				'class'    => 'background_color',
				'required' => array(
									array('header_style','!=', 'tmc_header_2'),
									array('header_style','!=', 'tmc_header_3'),
									array('header_style','!=', 'tmc_header_5'),
									),
			),
		
		array(
			'id'       => 'header_address_icon',
			'title'   => esc_html__( 'Address Icon', 'finance' ),
			'type'    => 'text',
			'default' => esc_html__( "icon icon-Pointer", 'finance' ),
			
			'required' => array(
								array('header_style','!=', 'tmc_header_1'),
								array('header_style','!=', 'tmc_header_2'),
								array('header_style','!=', 'tmc_header_3'),
								array('header_style','!=', 'tmc_header_5'),
								),

			),
			
		array(
				'id'       => 'header_address',
				'title'   => esc_html__( 'Address', 'finance' ),
				'type'    => 'text',
				'default' => esc_html__( "130051 Greenville Avenue California, TX 70240", 'finance' ),
				
				'required' => array(
									array('header_style','!=', 'tmc_header_1'),
									array('header_style','!=', 'tmc_header_2'),
									array('header_style','!=', 'tmc_header_3'),
									array('header_style','!=', 'tmc_header_5'),
									),

				),	
		
		array(
				'id'       => 'header_phone_icon',
				'title'   => esc_html__( 'Contact Icon', 'finance' ),
				'type'    => 'text',
				'default' => esc_html__( "icon icon-Phone2", 'finance' ),
				'required' => array(
									array('header_style','!=', 'tmc_header_2'),
									array('header_style','!=', 'tmc_header_3'),
									array('header_style','!=', 'tmc_header_5'),
									),
				),
		
		array(
				'id'       => 'header_phone',
				'title'   => esc_html__( 'Contact Info', 'finance' ),
				'type'    => 'text',
				'default' => esc_html__( "+ (1800) 456 7890 info@finance.com", 'finance' ),
				'required' => array(
									array('header_style','!=', 'tmc_header_2'),
									array('header_style','!=', 'tmc_header_3'),
									array('header_style','!=', 'tmc_header_5'),
									),
				),
		
		array(
				'id'       => 'header_working_hours_icon',
				'title'   => esc_html__( 'Working Hours Icon', 'finance' ),
				'type'    => 'text',
				'default' => esc_html__( "icon icon-Timer", 'finance' ),
				'required' => array(
									array('header_style','!=', 'tmc_header_2'),
									array('header_style','!=', 'tmc_header_3'),
									array('header_style','!=', 'tmc_header_5'),
									),
				),
				
		array(
				'id'       => 'header_working_hours',
				'title'   => esc_html__( 'Working Hours', 'finance' ),
				'type'    => 'text',
				'default' => esc_html__( "Mon - Sat 9.00 - 19.00 Sunday Closed", 'finance' ),
				'required' => array(
									array('header_style','!=', 'tmc_header_2'),
									array('header_style','!=', 'tmc_header_3'),
									array('header_style','!=', 'tmc_header_5'),
									),
			),		
			
		array(
				'id'       => 'sep_header_settings',
				'title'   => esc_html__( 'Header Settings', 'finance' ),
				'type'    => 'text',
				'class'    => 'background_color',
				'required' => array(
									
									),
			),

		array(
				'id'       => 'header_height',
				'type'    =>  'dimensions',
				'units'    => array('em','px','%'),
				'output'         => array('.header_top'),
				'title'   => esc_html__( 'Header Height', 'finance' ),
				'subtitle' => esc_html__('Enter Header Height.', 'finance'),
				'default'  => array(
				'Width'   => '', 
				'Height'  => '',
				'units'   => 'px'
				)
			),
			
		array(
				'id'       => 'search_header',
				'type'     => 'switch',
				'title'    => esc_html__('Search in Header', 'finance'),
				'subtitle' => __('Enable / Disable Search in Header', 'finance'),
				'default'  => true,
				'required' => array(
									array('header_style','!=', 'tmc_header_1'),
									),
			  ),
		array(
				'id'       => 'contact_us',
				'type'     => 'select',
				'title'    => __( 'Contact Us', 'finance' ), 
				'data'     => 'pages',
				'default'  => '138',
				'required' => array(
						
								array('header_style','=','tmc_header_1'),
						
				),
		),		
        array(
			'id'       => 'sticky_menu',
			'type'     => 'switch',
			'title'    => esc_html__('Sticky Header', 'finance'),
			'subtitle' => __('Enable / Disable Sticky Header', 'finance'),
			'default'  => true,
		),
        ),
    ) );
	
	 /* Menu Styling /--------------------------------------------------------- */
    Redux::setSection( $opt_name, array(
        'title'     => __('Menu', 'finance'),
		'desc'   	=> '',
        'icon'      => 'el el-th-list',
		'class'     => 'main_background',
		'submenu'   => true, // Setting submenu to false on a given section will hide it from the WordPress sidebar menu!
        'fields'    => array(

			array(
				'id' => 'menu_padding_first_level',
				'title' => 'Menu Padding - First Level',
				'type' => 'spacing',
				'mode' => 'padding',
				'units' => array('px','%','em'),
				'output' => array('body.tmc_header_1 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_2 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_3 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_5 .top_nav .top_nav_wrapper > ul > li > a'),
				'default' => array(
					'padding-top' => '', 
					'padding-right' => '', 
					'padding-bottom' => '', 
					'padding-left' => ''
				),
			),
			array(
				'id' => 'menu_margin_first_level',
				'title' => 'Menu Margin - First Level',
				'output' => array('body.tmc_header_1 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_2 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_3 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_5 .top_nav .top_nav_wrapper > ul > li > a'),
				'type' => 'spacing',
				'mode' => 'margin',
				'units' => array('px', '%', 'em'),
			),
			array(
				'id'          => 'menu_fontsize_first_level',
				'type'        => 'typography', 
				'title'       => __('Menu- First Level', 'finance'),
				'google'      => true, 
				'font-backup' => true,
				'output'      => array('body.tmc_header_1 .top_nav .top_nav_wrapper > ul > li > a , body.tmc_header_2 .top_nav .top_nav_wrapper > ul > li > a , body.tmc_header_3 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul > li > a , body.tmc_header_5 .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_2 .header_top .top_nav .top_nav_wrapper > ul > li > a, body.tmc_header_5 .header_top .top_nav .top_nav_wrapper > ul > li > a'),
				'units'       =>array('px','%','em'),
				'default'     => array(
					'color'       => '', 
					'font-style'  => '', 
					'font-family' => '', 
					'google'      => true,
					'font-size'   => '', 
					'line-height' => ''
				),
			),
			array(
				'id' => 'menu_bg',
				'type' => 'color_rgba',
				'title' => esc_html__('Menu Background Color', 'finance'),
				'default' => array(
					'color'     => '',
					'alpha'     => 1
				),
				'output' => array( 'background' => 'body.tmc_header_4 .top_nav, body.tmc_header_5 .header_top, body.tmc_header_2 .header_top, body.tmc_header_1 .top_nav .top_nav_wrapper'),
			),
		   array(
				'id' => 'menu_color_first_level_hover',
				'type' => 'color',
				'title' => esc_html__('Menu Hover Color  - First Level', 'finance'),
				'output' => array('body.tmc_header_1 .top_nav .top_nav_wrapper > ul > li > a:hover, body.tmc_header_2 .top_nav .top_nav_wrapper > ul > li > a:hover, body.tmc_header_3 .top_nav .top_nav_wrapper > ul > li > a:hover, body.tmc_header_4 .top_nav .top_nav_wrapper > ul > li > a:hover, body.tmc_header_5 .top_nav .top_nav_wrapper > ul > li > a:hover, body.tmc_header_2 .header_top .top_nav .top_nav_wrapper > ul > li:hover > a, body.tmc_header_5 .header_top .top_nav .top_nav_wrapper > ul > li:hover > a'),
				'default' => ''
			),
		    array(
				'id' => 'menu_active_color_first_level',
				'type' => 'color',
				'title' => esc_html__('Menu Active Color - First Level', 'finance'),
				'output' => array('body.tmc_header_1 .top_nav .top_nav_wrapper > ul.main_menu_nav > li.menu-item.current_page_item a, body.tmc_header_2 .top_nav .top_nav_wrapper > ul.main_menu_nav > li.menu-item.current_page_item a, body.tmc_header_3 .top_nav .top_nav_wrapper > ul.main_menu_nav > li.menu-item.current_page_item a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul.main_menu_nav > li.menu-item.current_page_item a, body.tmc_header_5 .top_nav .top_nav_wrapper > ul.main_menu_nav > li.menu-item.current_page_item a'),
				'default' => ''
			),
			array(
				'id'       => 'seprater',
				'url'      => false,
				'type'     => 'text',
				'class'    => 'background_color',
				'title'    => esc_html__('Sub Menu', 'finance'),    
			),
			array(
				'id' => 'sub_menu_bg',
				'type' => 'color_rgba',
				'title' => esc_html__('Sub Menu Background Color', 'finance'),
				'default' => array(
					'color'     => '',
					'alpha'     => 1
				),
				'output' => array( 'background' => '.tmc_header_1 .top_nav .top_nav_wrapper > ul > li ul li a, .tmc_header_2 .top_nav .top_nav_wrapper > ul > li ul li a, .tmc_header_3 .top_nav .top_nav_wrapper > ul > li ul li a, .tmc_header_4 .top_nav .top_nav_wrapper > ul > li ul li a, .tmc_header_5 .top_nav .top_nav_wrapper > ul > li ul li a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a'),
			), 
			 array(
				'id' => 'sub_menu_bg_hover',
				'type' => 'color_rgba',
				'title' => esc_html__('Sub Menu Background Color On Hover', 'finance'),
				'default' => array(
					'color'     => '',
					'alpha'     => 1
				),
				'output' => array( 'background' => '.tmc_header_1 .top_nav .top_nav_wrapper > ul > li ul li a:hover, .tmc_header_2 .top_nav .top_nav_wrapper > ul > li ul li a:hover, .tmc_header_3 .top_nav .top_nav_wrapper > ul > li ul li a:hover, .tmc_header_4 .top_nav .top_nav_wrapper > ul > li ul li a:hover, .tmc_header_5 .top_nav .top_nav_wrapper > ul > li ul li a:hover, .tmc_header_4 .top_nav .top_nav_wrapper > ul > li ul.sub-menu li:hover > a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li:hover a'),
			),
			array(
				'id'          => 'menu_fontsize_sub_level',
				'type'        => 'typography', 
				'title'       => __('Menu- Sub Level', 'finance'),
				'google'      => true, 
				'font-backup' => true,
				'output'      => array('body.tmc_header_1 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a, body.tmc_header_2 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a, body.tmc_header_3 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a, body.tmc_header_5 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a, body.tmc_header_4 .top_nav .top_nav_wrapper > ul.main_menu_nav > li.menu-item.current_page_item ul li a'),
				'units'       =>array('px','%','em'),
				'default'     => array(
					'color'       => '', 
					'font-style'  => '', 
					'font-family' => '', 
					'google'      => true,
					'font-size'   => '', 
					'line-height' => ''
				),
			),
			array(
				'id' => 'menu_color_sub_hover',
				'type' => 'color',
				'title' => esc_html__('Menu Color Hover - Sub Level', 'finance'),
				'output' => array('body.tmc_header_1 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a:hover, body.tmc_header_2 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a:hover, body.tmc_header_3 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a:hover, body.tmc_header_4 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a:hover, body.tmc_header_5 .top_nav .top_nav_wrapper > ul.main_menu_nav > li ul.sub-menu li a:hover, body.tmc_header_4 .top_nav .top_nav_wrapper > ul.main_menu_nav > li.menu-item.current_page_item ul li:hover a'),
				'default' => ''
			),

			array(
				'id'       => 'seprater_sticky',
				'url'      => false,
				'type'     => 'text',
				'class'    => 'background_color',
				'title'    => esc_html__('Sticky Menu', 'finance'),    
			   ),
			array(
				'id' => 'sticky_menu_bg',
				'type' => 'color_rgba',
				'title' => esc_html__('Sticky Menu Background Color', 'finance'),
				'output' => array( 'background' => 'body.sticky_menu.tmc_header_2 #header .header_top.affix, body.sticky_menu.tmc_header_3 .header_top3.affix,  body.sticky_menu.tmc_header_4 #header .top_nav.affix, body.sticky_menu.tmc_header_5 .header_top3.affix, body.sticky_menu.tmc_header_3.admin-bar #header .top_nav.affix, body.tmc_header_1 .top_nav.affix, body.sticky_menu.tmc_header_1 #header .top_nav.affix .top_nav_wrapper'),
				'default' => array(
					'color'     => '',
					'alpha'     => 1
				),
			),
			array(
				'id'          => 'sticky_menu_color_first_level',
				'type'        => 'typography', 
				'title'       => __('Sticky Menu - First Level', 'finance'),
				'google'      => true, 
				'font-backup' => true,
				'output'      => array('body.sticky_menu.tmc_header_1 .top_nav.affix .top_nav_wrapper > ul > li > a, body.sticky_menu.tmc_header_2 .top_nav.affix .top_nav_wrapper > ul > li > a, body.sticky_menu.tmc_header_3 .top_nav.affix .top_nav_wrapper > ul > li > a, body.sticky_menu.tmc_header_4 .top_nav.affix .top_nav_wrapper > ul > li > a, body.sticky_menu.tmc_header_5 .top_nav.affix .top_nav_wrapper > ul > li > a'),
				'units'       =>array('px','%','em'),
				'default'     => array(
					'color'       => '', 
					'font-style'  => '', 
					'font-family' => '', 
					'google'      => true,
					'font-size'   => '', 
					'line-height' => ''
				),
			),
			array(
				'id' => 'sticky_menu_color_first_level_hover',
				'type' => 'color',
				'title' => esc_html__('Sticky Menu Color Hover - First Level', 'finance'),
				'output' => array('body.tmc_header_1 .top_nav.affix .top_nav_wrapper > ul > li > a:hover, body.tmc_header_2 .top_nav.affix .top_nav_wrapper > ul > li > a:hover, body.tmc_header_3 .top_nav.affix .top_nav_wrapper > ul > li > a:hover, body.tmc_header_4 .top_nav.affix .top_nav_wrapper > ul > li > a:hover, body.tmc_header_5 .top_nav.affix .top_nav_wrapper > ul > li > a:hover'),
				'default' => ''
			),
			array(
				'id' => 'sticky_active_color_level',
				'type' => 'color',
				'title' => esc_html__('Sticky Menu Color Active - First Level', 'finance'),
				'output' => array('body.sticky_menu.tmc_header_1 .top_nav.affix .top_nav_wrapper > ul > li.current-menu-item > a , body.sticky_menu.tmc_header_2 .top_nav.affix .top_nav_wrapper > ul > li.current-menu-item > a , body.sticky_menu.tmc_header_3 .top_nav.affix .top_nav_wrapper > ul > li.current-menu-item > a, body.sticky_menu.tmc_header_4 .top_nav.affix .top_nav_wrapper > ul > li.current-menu-item > a , body.sticky_menu.tmc_header_5 .top_nav.affix .top_nav_wrapper > ul > li.current-menu-item > a'),
				'default' => ''
			),

        ),  
    ) );

	/* Titlebar  */
	
		Redux::setSection( $opt_name, array(
			'title'     => esc_html__('Titlebar / Inner Header', 'finance'),
			'desc'   => '',
			'class'     => 'main_background',
			'icon'   => 'el el-text-width',
			'submenu' => true,
			'fields'    => array(	
		array(
				'id'       => 'image_switch',
				'type'     => 'switch',
				'title'    => esc_html__('Image In Titlebar', 'finance'),
				'subtitle' => esc_html__('Enable / Disable Image In Titlebar', 'finance'),
				'default'  => true,
				),
		array(
				'id'       =>'header_background1',
				'url'      => false,
				'type'     => 'media',
				'title'    => esc_html__('Inner Header1', 'finance'),
				'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/bg/inner-banner1.jpg' ),
				'required' => array(									
									array('header_style','=','tmc_header_1', ),
									array('image_switch','=',true, ),
									
				),
				'subtitle' => esc_html__('Upload your Inner Header image here.', 'finance'),
			),
		
		array(
				'id'       =>'header_background2',
				'url'      => false,
				'type'     => 'media',
				'title'    => esc_html__('Inner Header2', 'finance'),
				'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/bg/inner-banner2.jpg' ),
				'required' => array(
									array('header_style','=','tmc_header_2', ),
									array('image_switch','=',true, ),
				),
				'subtitle' => esc_html__('Upload your Inner Header image here.', 'finance'),
			),
		
		array(
				'id'       =>'header_background3',
				'url'      => false,
				'type'     => 'media',
				'title'    => esc_html__('Inner Header3', 'finance'),
				'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/bg/inner-banner3.jpg' ),
				'required' => array(
									array('header_style','=','tmc_header_3', ),
									array('image_switch','=',true, ),
				),
				'subtitle' => esc_html__('Upload your Inner Header image here.', 'finance'),
			),	
		array(
				'id'       =>'header_background',
				'url'      => false,
				'type'     => 'media',
				'title'    => esc_html__('Inner Header4', 'finance'),
				'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/bg/inner-banner4.jpg' ),
				'required' => array(
									array('header_style','=','tmc_header_4', ),
									array('image_switch','=',true, ),
				),
				'subtitle' => esc_html__('Upload your Inner Header image here.', 'finance'),
			),	
		array(
				'id'       =>'header_background5',
				'url'      => false,
				'type'     => 'media',
				'title'    => esc_html__('Inner Header5', 'finance'),
				'default'  => array( 'url' => get_template_directory_uri() .'/assets/images/bg/inner-banner5.jpg' ),
				'required' => array(
									array('header_style','=','tmc_header_5', ),
									array('image_switch','=',true, ),
				),
				'subtitle' => esc_html__('Upload your Inner Header image here.', 'finance'),
			),
		
			
			array(
				'id'       => 'title_background',
				'type'    => 'background',
				'background-repeat' => false,
				'background-image' => false,
				'background-attachment' => false,
				'background-size' => false,
				'background-position' => false,
				'title'   => esc_html__( 'Background', 'finance' ),
				'subtitle' => esc_html__('If Image is removed, Then color will be shown', 'finance'),
				'output'  => array('.tmc_header_1 .page_title, .tmc_header_2 .page_title, .tmc_header_3 .page_title, .tmc_header_4 .page_title, .tmc_header_5 .page_title'),
				'default'  => array(
					'background-color' => '#717e95',
					
				),
				'required' => array(
									array('image_switch','=',true, ),
				),
			),
			array(
				'id'       => 'title_text_sep',
				'url'      => false,
				'type'     => 'text',
				'class'    => 'background_color',
				'title'    => esc_html__('Title Text', 'finance'),
			),
		
			array(
				'id'       => 'title_switch',
				'type'     => 'switch',
				'title'    => esc_html__('Title', 'finance'),
				'subtitle' => esc_html__('Enable / Disable Title In Titlebar', 'finance'),
				'default'  => true,
				),
			array(
				'id'          => 'typography_title',
				'type'        => 'typography', 
				'title'       => __('Title Color & Font', 'finance'),
				'google'      => true, 
				'font-backup' => false,
				'output'      => array('.page_title h1, body.sticky_menu.tmc_header_1 .page_title h1, .tmc_header_2 .page_title h1, body.sticky_menu.tmc_header_3 .page_title h1, .tmc_header_5 .page_title h1'),
				'units'       =>'px',
				'default'     => array(
					'color'       => '', 
					'google'      => true
				),				
				'required' => array(									
									array('title_switch','=',true, ),
				),
			),
			
			
			array(
				'id'       => 'seprater_eight_breadcrumb',
				'url'      => false,
				'type'     => 'text',
				'class'    => 'background_color',
				'title'    => esc_html__('Breadcrumbs', 'finance'),
			),
			
			array(
				'id'       => 'breadcrumb_switch',
				'type'     => 'switch',
				'title'    => esc_html__('Breadcrumbs', 'finance'),
				'subtitle' => esc_html__('Enable / Disable Breadcrumbs', 'finance'),
				'default'  => true,
				),
			
			array(
				'id'             =>'breadcrumb_text',
				'type'           => 'typography',
				'title'          => esc_html__('Breadcrumb Text', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'all_styles'     =>true,
				'font-weight'    =>true,
				'font-style'     =>true,
				'subsets'        =>true,
				'font-size'      =>true,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>false,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('.bread-cumb .container span a, .bread-cumb, .bread-cumb2 span a, .tmc_header_2 .bread-cumb .container span a, .bread-cumb .container a span'),
				'units'          =>'px',
				'default'        => array(
					'color'       =>"",
					'font-family' =>'"Open Sans", sans-serif'
				),
				'required' => array(
									array('breadcrumb_switch','=', true),
				),
			),
			array(
				'id'       => 'breadcrumb_hover',
				'type'    => 'link_color',
				'regular' => false,
				'output'  => array('.bread-cumb .container span a, .bread-cumb, '),
				'title'   => esc_html__( 'Breadcrumb Hover Color', 'finance' ),
				'default'        => array(
					'regular'  => '',
					'hover'    => '',
					'active'   => '', 
					'visited'  => ''
				),
				'required' => array(
									array('breadcrumb_switch','=', true),
				),
			),
			array(
				'id'       => 'breadcrumb_margin_top',
				'type'           => 'spacing',
				'output'         => array('.bread-cumb, .bread-cumb .container span, .bread-cumb2 span'),
				'mode'           => 'margin',
				'units'          => array('em','px','%'),
				'units_extended' => 'false',
				'title'   => esc_html__( 'Breadcrumb Margin', 'finance' ),
				'default'        => array(
				
					'margin-top'     => '0px',
					'margin-right'   => '0px',
					'margin-bottom'  => '0px',
					'margin-left'    => '0px',
					'units'          => 'px',

				),
				'required' => array(
									array('breadcrumb_switch','=', true),
				),
			)
			
		)
	) );
	
	 /* Typography  /--------------------------------------------------------- */
	
	Redux::setSection( $opt_name, array(
        'title'     => __('Typography', 'finance'),
		'header'     => '',
		'desc'       => '',
		'class'     => 'main_background',
		'icon_class' => 'el-icon-large',
		'icon'       => 'el-icon-font',
		'submenu'    => true,
        'fields'    => array(
		 array(
				'id'             =>'typography_body',
				'type'           => 'typography',
				'title'          => esc_html__('Body', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'font-weight'    =>false,
				'all_styles'     =>true,
				'font-style'     =>false,
				'subsets'        =>true,
				'font-size'      =>true,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>false,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('body'),
				'units'          =>'px',
				'subtitle'       => esc_html__('Select custom font for your main body text.', 'finance'),
				'default'        => array(
					'font-family'=> '"Open Sans", sans-serif',
					'font-weight'=> '100%', 
					'height'=>'100%',
					'overflow-x'=> 'hidden',
					'letter-spacing'=> '0.2px'								
				)
			),
			 array(
				'id'             =>'typography_p',
				'type'           => 'typography',
				'title'          => esc_html__('Paragraph', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'font-weight'    =>false,
				'all_styles'     =>true,
				'font-style'     =>false,
				'subsets'        =>true,
				'font-size'      =>true,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>false,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('p'),
				'units'          =>'px',
				'subtitle'       => esc_html__('Select custom font for your Paragraph text.', 'finance'),
				
			),
			array(
				'id'             =>'typography_h1',
				'type'           => 'typography',
				'title'          => esc_html__('Heading H1', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'all_styles'     =>true,
				'font-weight'    =>true,
				'font-style'     =>false,
				'subsets'        =>true,
				'font-size'      =>false,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>true,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('h1, .h1'),
				'units'          =>'px',
				'subtitle'       => esc_html__('Select custom font for heading h1', 'finance'),
				
			),
			array(
				'id'             =>'typography_h2',
				'type'           => 'typography',
				'title'          => esc_html__('Heading H2', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'all_styles'     =>true,
				'font-weight'    =>true,
				'font-style'     =>false,
				'subsets'        =>true,
				'font-size'      =>false,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>true,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('h2, .h2'),
				'units'          =>'px',
				'subtitle'       => esc_html__('Select custom font for heading h2', 'finance'),
				
			),
			array(
				'id'             =>'typography_h3',
				'type'           => 'typography',
				'title'          => esc_html__('Heading H3', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'all_styles'     =>true,
				'font-weight'    =>true,
				'font-style'     =>false,
				'subsets'        =>true,
				'font-size'      =>false,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>true,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('h3, .h3'),
				'units'          =>'px',
				'subtitle'       => esc_html__('Select custom font for heading h3 ...', 'finance'),
				
			),
			array(
				'id'             =>'typography_h4',
				'type'           => 'typography',
				'title'          => esc_html__('Heading H4', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'all_styles'     =>true,
				'font-weight'    =>true,
				'font-style'     =>false,
				'subsets'        =>true,
				'font-size'      =>false,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>true,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('h4, .h4'),
				'units'          =>'px',
				'subtitle'       => esc_html__('Select custom font for heading h4 ...', 'finance'),
				
			),
			array(
				'id'             =>'typography_h5',
				'type'           => 'typography',
				'title'          => esc_html__('Heading H5', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'all_styles'     =>true,
				'font-weight'    =>true,
				'font-style'     =>false,
				'subsets'        =>true,
				'font-size'      =>false,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>true,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('h5, .h5'),
				'units'          =>'px',
				'subtitle'       => esc_html__('Select custom font for heading h5', 'finance'),
				
			),
			array(
				'id'             =>'typography_h6',
				'type'           => 'typography',
				'title'          => esc_html__('Heading H6', 'finance'),
				'compiler'       =>true,
				'google'         =>true,
				'font-backup'    =>false,
				'all_styles'     =>true,
				'font-weight'    =>true,
				'font-style'     =>false,
				'subsets'        =>true,
				'font-size'      =>false,
				'line-height'    =>false,
				'word-spacing'   =>false,
				'letter-spacing' =>true,
				'color'          =>true,
				'preview'        =>true,
				'output'         => array('h6, .h6'),
				'units'          =>'px',
				'subtitle'       => esc_html__('Select custom font for heading h6', 'finance'),
			),
		),
		
    ) );

	  /* Social Media /--------------------------------------------------------- */
    Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Social Media', 'finance' ),
		'desc'   => 'Enter social url here and then active them in footer or header options. Please add full URLs include http://',
		'icon'   => 'el-icon-address-book',
		'class'     => 'main_background',
		'submenu' => true,
        'fields'    => array(

            array(
					'id'       => 'footer_social',
					'type'     => 'switch',
					'title'    => esc_html__('Enable footer connect social icon', 'finance'),
					'default'  => true,
				),
			
			array(
				'id'       =>'twitter-value',
				'type'     => 'text',
				'title'    => esc_html__('Twitter', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Twitter URL.', 'finance'),
				'required' => array('footer_social','=',true,),
				'default'  => '#',          
			),
		
			array(
				'id'       =>'facebook-value',
				'type'     => 'text',
				'title'    => esc_html__('Facebook', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Facebook URL.', 'finance'),
				'required' => array('footer_social','=',true,),
				 'default'  => '#',          
			),
			
			array(
				'id'       =>'linkedin-value',
				'type'     => 'text',
				'title'    => esc_html__('Linkedin', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Linkedin URL.', 'finance'),
				'required' => array('footer_social','=',true,),
				'default'  => '#',          
			),
		
			array(
				'id'       =>'pinterest-value',
				'type'     => 'text',
				'title'    => esc_html__('Pinterest', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Pinterest URL.', 'finance'),
				'required' => array('footer_social','=',true,),
				'default'  => '#',          
			),
			
			array(
				'id'       =>'google-value',
				'type'     => 'text',
				'title'    => esc_html__('Google', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Google URL.', 'finance'),
				'required' => array('footer_social','=',true,),
			),
			
			array(
				'id'       =>'instagram-value',
				'type'     => 'text',
				'title'    => esc_html__('Instagram', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Instagram URL.', 'finance'),
				'required' => array('footer_social','=',true,),         
			),				
			
			array(
				'id'       =>'yelp-value',
				'type'     => 'text',
				'title'    => esc_html__('Yelp', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Yelp URL.', 'finance'),
				'required' => array('footer_social','=',true,),    
			),
			
			array(
				'id'       =>'foursquare-value',
				'type'     => 'text',
				'title'    => esc_html__('Foursquare', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Foursquare URL.', 'finance'),
				'required' => array('footer_social','=',true,),          
			),
			
			array(
				'id'       =>'flickr-value',
				'type'     => 'text',
				'title'    => esc_html__('Flickr', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Flickr URL.', 'finance'),
				'required' => array('footer_social','=',true,),          
			),
			
			array(
				'id'       =>'youtube-value',
				'type'     => 'text',
				'title'    => esc_html__('Youtube', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Youtube URL.', 'finance'),
				'required' => array('footer_social','=',true,),        
			),
			
			array(
				'id'       =>'email-value',
				'type'     => 'text',
				'title'    => esc_html__('Email', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Email URL.', 'finance'),
				'required' => array('footer_social','=',true,),          
			),
		
			array(
				'id'       =>'rss-value',
				'type'     => 'text',
				'title'    => esc_html__('Rss', 'finance'),
				'subtitle' => '',
				'desc'     => esc_html__('Enter your Rss URL.', 'finance'),
				'required' => array('footer_social','=',true,),          
			),
        ),
    ) );
/* Blog Pages Layout /--------------------------------------------------------- */
	
		Redux::setSection( $opt_name, array(
			'title'     => esc_html__('Blog', 'finance'),
			'desc'   => '',
			'class'     => 'main_background',
			'icon'   => 'el el-globe',
			'submenu' => true,
			'fields'    => array(
			array(
				'id'       => 'blog_title',
				'title'   => esc_html__( 'Blog Title', 'finance' ),
				'subtitle' => esc_html__('Title for the blog page.', 'finance'),
				'type'    => 'text',
				'default' => esc_html__( "Blog", 'finance' )
			),
     		array(
				'id'       => 'blog_metadata',
				'type'     => 'switch',
				'title'    => esc_html__('Metadata on Blog Posts', 'finance'),
				'subtitle'       => esc_html__('Enable / Disable Metadata on Blog Posts.', 'finance'),
				'default'  => true,
			),
			array(
				'id'       => 'blog_multi_checkbox',
				'type'     => 'checkbox',
				'title'    => __('Metadata Options', 'finance'), 
				'subtitle' => __('Check the Metadata you want to show on Blog Posts.', 'finance'),
				'options'  => array(
					'1' => 'Date',
					'2' => 'Author',
					'3' => 'Comments',
					'4' => 'Tags'
				),
				'default' => array(
					'1' => '1', 
					'2' => '1', 
					'3' => '1',
					'4' => '1'
				),
				'required' => array('blog_metadata','=',true,),
			),
			array(
				'id'       => 'blog_sidebar_type',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Sidebar Type', 'finance' ),
				'options' => array(
					'wp' => esc_html__( 'Wordpress Sidebars', 'finance' ),
					'vc' => esc_html__( 'VC Sidebars', 'finance' )
				),
				'default' => 'wp'
			),
			array(
				'id'       => 'blog_wp_sidebar',
				'type'      => 'select',
				'data' => 'sidebars',
				'title'     => esc_html__( 'Wordpress Sidebar', 'finance' ),
				'default'   => 'finance-right-sidebar',
				'required' => array('blog_sidebar_type','=','wp', ),
			),
			 array(
			'id'       => 'blog_vc_sidebar',
			'type'     => 'select',
			'multi'    => false,
			'data'     => 'posts',
			'args'     => array( 'post_type' =>  array( 'sidebar', 'nyheter_forbundet', 'stup' ), 'numberposts' => -1 ),
			'title'    => esc_html__( 'VC Sidebar', 'finance' ),
			'required' => array('blog_sidebar_type','=','vc', ),
			),
			array(
				'id'       => 'blog_sidebar_position',
				'type'    => 'image_select',
				'title'   => esc_html__( 'Blog Layout', 'finance' ),
				'subtitle' => __('Select the Sidebar Position for Blog Pages.', 'finance'),
				'options' => array(
					'left'  => array(
									'alt'   => '1', 
									'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-1.jpg'
								),
					'right' => array(
									'alt'   => '2', 
									'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-2.jpg'
								)
				),
				'default' => 'right'
			),
			array(
				'id'       => 'blog_pagination',
				'type'     => 'switch',
				'title'    => esc_html__('Previous / Next Pagination', 'finance'),
				'subtitle'       => esc_html__('Enable / Disable pagination for Blog Pages.', 'finance'),
				'default'  => true,
			),
			array(
				'id'       => 'seprater_blog_one',
				'url'      => false,
				'type'     => 'text',
				'class'    => 'background_color',
				'title'    => esc_html__('Blog Post Detail Page', 'finance'),
				
			),
			array(
				'id'       => 'detail_sidebar_position',
				'type'    => 'image_select',
				'title'   => esc_html__( 'Blog Detail Layout', 'finance' ),
				'subtitle' => __('Select the Sidebar Position for Blog Detail Pages.', 'finance'),
				'options' => array(
					'left'  => array(
									'alt'   => '1', 
									'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-1.jpg'
								),
					'right' => array(
									'alt'   => '2', 
									'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-2.jpg'
								)
				),
				'default' => 'right'
			),
			array(
				'id'       => 'blogdetail_metadata',
				'type'     => 'switch',
				'title'    => esc_html__('Metadata on Blog Detail Posts', 'finance'),
				'subtitle'       => esc_html__('Enable / Disable Metadata on Blog Detail Pages.', 'finance'),
				'default'  => true,
			),
			array(
				'id'       => 'blogdetail_multi_checkbox',
				'type'     => 'checkbox',
				'title'    => __('Metadata Options Of Blog Detail Page', 'finance'), 
				'subtitle' => __('Check the Metadata you want to show on Blog Detail Pages.', 'finance'),
				'options'  => array(
					'date' => 'Date',
					'author' => 'Author',
					'comment' => 'Comments',
					'tag' => 'Tags'
				),
				'default' => array(
						'date'    => '1', 
						'author'  => '1', 
						'comment' => '1',
						'tag'     => '1'
					),
				'required' => array('blogdetail_metadata','=',true,),
			),
		)
	) );
	
/* Woocommerce Pages Layout /--------------------------------------------------------- */
		
		Redux::setSection( $opt_name, array(
			'title'     => esc_html__('Woocommerce', 'finance'),
			'desc'   => '',
			'class'     => 'main_background',
			'icon'   => 'el el-shopping-cart',
			'submenu' => true,
			'fields'    => array(
					
			array(
				'id'       => 'woocommerce_title',
				'title'   => esc_html__( 'Woocommerce Title', 'finance' ),
				'subtitle' => esc_html__('Title for the Shop overview & product detail page.', 'finance'),
				'type'    => 'text',
				'default' => esc_html__( "Shop", 'finance' )
			),
			
			array(
				'id'       => 'shop_sidebar_type',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Sidebar Type', 'finance' ),
				'options' => array(
					'wp' => esc_html__( 'Wordpress Sidebars', 'finance' ),
					'vc' => esc_html__( 'VC Sidebars', 'finance' )
				),
				'default' => 'wp'
			),
			array(
				'id'       => 'shop_wp_sidebar',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Sidebar Type', 'finance' ),
				'options' => array(
					'wp' => esc_html__( 'Wordpress Sidebars', 'finance' ),
					'vc' => esc_html__( 'VC Sidebars', 'finance' )
				),
				'default' => 'wp'
			),
			array(
				'id'       => 'shop_wp_sidebar',
				'type'      => 'select',
				'data' => 'sidebars',
				'title'     => esc_html__( 'Wordpress Sidebar', 'finance' ),
				'default'   => 'finance-shop',
				'required' => array('shop_sidebar_type','=','wp', ),
			),	
			array(
			'id'       => 'shop_vc_sidebar',
			'type'     => 'select',
			'multi'    => false,
			'data'     => 'posts',
			'args'     => array( 'post_type' =>  array( 'sidebar', 'nyheter_forbundet', 'stup' ), 'numberposts' => -1 ),
			'title'    => esc_html__( 'VC Sidebar', 'finance' ),
			'required' => array('shop_sidebar_type','=','vc', ),
			),
			array(
				'id'       => 'shop_sidebar_position',
				'type'    => 'image_select',
				'title'   => esc_html__( 'Main Shop Layout', 'finance' ),
				'subtitle' => __('Select the Sidebar Position of the Main Shop Layout.', 'finance'),
				'options' => array(
					'no_sidebar'  => array(
								'alt'   => '1', 
								'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-3.jpg'
							),
					'left' => array(
								'alt'   => '2', 
								'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-1.jpg'
							),
					'right'      => array(
						'alt'   => '3', 
						'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-2.jpg'
					)
				),
				'default' => 'right'
			),
			array(
				'id'       => 'shop_detail_layout',
				'type'    => 'image_select',
				'title'    => __('Single Product Layout', 'finance'), 
				'subtitle' => __('Select the Sidebar Position of the Single Product Page.', 'finance'),
				'options' => array(
					'no_sidebar'  => array(
								'alt'   => '1', 
								'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-3.jpg'
							),
					'left' => array(
								'alt'   => '2', 
								'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-1.jpg'
							),
					'right'      => array(
						'alt'   => '3', 
						'img'   => get_template_directory_uri() .'/assets/images/blogLayout/layout-2.jpg'
					)
				),
				'default' => 'right'
			),
			array(
                'id'       => 'select_woocommercecolumns',
                'type'     => 'select',
                'title'    => __('WooCommerce Columns', 'finance'), 
                'subtitle' => __('WooCommerce Columns', 'finance'),
                'options'  => array(
                    'columns-2'   => '2 Columns',
                    'columns-3'   => '3 Columns',
                    'columns-4'   => '4 Columns',
                ),
                'default'  => 'columns-3',
            ),
            array(
                'id'       => 'text_shopitems',
                'type'     => 'text',
                'title'    => __('Items per Shop Page', 'finance'),
                'description' => __('Enter how many items you want to show on Shop pages & Categorie Pages before Pagination shows up (Default: 12)', 'finance'),
                'default'  => '12'
            ),
			array(
                'id'       => 'switch_shopsorting',
                'type'     => 'switch', 
                'title'    => __('Shop Sort', 'finance'),
                'subtitle' => __('Enable / Disable sort-by function on Shop Pages', 'finance'),
                'default'  => true,
            ),
            array(
                'id'       => 'switch_shopresultcount',
                'type'     => 'switch', 
                'title'    => __('Shop Result Count', 'finance'),
                'subtitle' => __('Enable / Disable Result Count on Shop Pages', 'finance'),
                'default'  => true,
            ),
			array(
                'id'       => 'switch_addtocart',
                'type'     => 'switch', 
                'title'    => __('Add to Cart Button', 'finance'),
                'subtitle' => __('Enable / Disable "Add to Cart"-Button on Shop Pages', 'finance'),
                'default'  => true,
            ),
		)
	) );
		 /* Footer /--------------------------------------------------------- */
		 
		 Redux::setSection( $opt_name, array(
        'title'     => __('Footer', 'finance'),
		'header'     => '',
		'desc'       => '',
		'icon'       => 'el-icon-photo',
		'class'     => 'main_background',
		'submenu'    => true,
        'fields'    =>  array(
				
				array(
						'id'       => 'footer_strip',
						'type'     => 'switch',
						'title'    => esc_html__('Enable Footer Strip', 'finance'),
						'subtitle' => esc_html__('Enable / Disable Footer Strip', 'finance'),
						'default'  => true,
                        ),
						 array(
                            'id'       => 'footer_strip_backgound_color',
                            'type'     => 'background',
                            'compiler' => true,
                            'output'   => array('.indurial-solution, .footer-contacts'),
                            'title'    => esc_html__('Background', 'finance'),
                            'default'  => array(
                                'background-color' =>'',
                                'background-image' =>get_template_directory_uri() .'/assets/images/bg/bg3.jpg',
								),
                            'required' => array('footer_strip','=',true, )
                        ),
						 array(
                            'id'       => 'footer_strip_text_color',
                            'type'     => 'color',
                            'compiler' => true,
                            'output'   => array('.indurial-solution-text h2, .footer-contacts h2'),
                            'title'    => esc_html__('Text Color', 'finance'),
                            'default'  => '#ffffff',
                            'required' => array('footer_strip','=',true, )
                        ),
					
						array(
                            'id'       =>'footer_stiptext',
                            'type'     => 'text',
                            'title'    => esc_html__('Text Info.', 'finance'),
                            'subtitle' => esc_html__('Enter the text for Footer Strip.', 'finance'),
							'default' 	=> 'We help you to make the best marketable strategy, asset and execution',
							'required' => array('footer_strip','=',true, ),
                        ),
						array(
							'id'       => 'footer_stipbuttonlink',
							'type'     => 'select',
							'data'     => 'pages',
							'title'    => esc_html__('Contact Us', 'finance'),
							'subtitle' => '',
							'desc'     => "",
							'default'  => '138',
							'required' => array('footer_strip','=',true, ),
						),
					
						array(
							'id'       => 'seprater_four',
							'url'      => false,
							'type'     => 'text',
							'class'    => 'background_color',
							'title'    => esc_html__('Footer Section', 'finance'),				
						),
						
						array(
						'id'       => 'footer_widget',
						'type'     => 'switch',
						'title'    => esc_html__('Footer Widget Area', 'finance'),
						'subtitle' => __('Enable / Disable Widgetzed Footer Area', 'finance'),
						'default'  => true,
						),
						array(
							'id'       => 'footer_sidebar_count',
							'type'     => 'image_select',
							'title'    => __('Footer Widget Columns', 'finance'), 
							'subtitle' => __('Select Footer Columns', 'finance'),
							'description' => __('', 'finance'),
							'options'  => array(
								'1'      => array(
									'alt'   => '1', 
									'img'   => get_template_directory_uri() .'/assets/images/footers/col-1.jpg'
								),
								
								'2'      => array(
									'alt'   => '2', 
									'img'   => get_template_directory_uri() .'/assets/images/footers/col-2.jpg'
								),
								'3'      => array(
									'alt'   => '3', 
									'img'   => get_template_directory_uri() .'/assets/images/footers/col-3.jpg'
								),
								'4'      => array(
									'alt'   => '4', 
									'img'   => get_template_directory_uri() .'/assets/images/footers/col-4.jpg'
								)
							),
							'default' => '3',
							'required' => array('footer_widget','=',true,),
						),
						array(
								 'id'       => 'footer_bg',
								 'type'     => 'background',
								 'compiler' => true,
								 'output'   => array('.widgets_row'),
								 'title'    => esc_html__('Footer Background', 'finance'),
								 'default'  => array( ),
								 'required' => array('footer_widget', '=', true ),
						),
												
						array(
								'id'       => 'seprater_three',
								'url'      => false,
								'type'     => 'text',
								'class'    => 'background_color',
								'title'    => esc_html__('Copyright', 'finance'),
							
						),
						array(
								'id'       => 'copyright_switch',
								'type'     => 'switch',
								'title'    => esc_html__('Copyright Area', 'finance'),
								'subtitle' => __('Enable / Disable Copyright Area', 'finance'),
								'default'  => true,
						),
						array(
								'id'       => 'footer_copyright',
								'type'     => 'textarea',
								'title'    => esc_html__('Text', 'finance'),
								'default'  => esc_html__( 'Copyright &copy; 2012-'.date('Y').' finance All rights reserved', 'finance'),
								'required' => array('copyright_switch','=',true,),
						),
						array(
								 'id'       => 'copyright_bg',
								 'type'     => 'background',
								 'compiler' => true,
								 'output'   => array('.footer-bottom'),
								 'title'    => esc_html__('Copyright Background', 'finance'),
								 'default'  => array( ),
								 'required' => array('copyright_switch', '=', true ),
						),
						array(
								'id'       => 'copyright_right_area_switch',
								'type'     => 'switch',
								'title'    => esc_html__('Copyright Right Area', 'finance'),
								'subtitle' => __('Enable / Disable Copyright Right Area', 'finance'),
								'default'  => true,
								'required' => array('copyright_switch','=',true,),
						),
						array(
								'id'       => 'developed_by',
								'type'      => 'text',
								'title'     => esc_html__( 'Author Info', 'finance' ),
								'default'   => esc_html__('Developed by: ', 'finance'),
								'required' => array('copyright_right_area_switch','=',true,),
						),
						array(
								'id'       => 'copy_right',
								'type'      => 'textarea',
								'title'     => esc_html__( 'Right Content', 'finance' ),
								'default'   => esc_html__('ThemeChampion', 'finance'),
								'required' => array('copyright_right_area_switch','=',true,),
						),
						array(
								'id'       => 'thememarket_url',
								'type'      => 'text',
								'title'     => esc_html__( 'Right Content Link', 'finance' ),
								'default'   => esc_html__('https://themeforest.net/user/themechampion', 'finance'),
								'required' => array('copyright_right_area_switch','=',true,),
						),
		)
) );

/* ------------------------------------------------------------------------ */
/* Custom function for financetheme's own CSS
/* ------------------------------------------------------------------------ */

function overridePanelCSS() 
{    
    wp_enqueue_style('redux-custom-css');
}
add_action( 'redux/page/finance_option/enqueue', 'overridePanelCSS' );

function tmc_option_styles() 
{
    $plugin_url =  plugins_url('', __FILE__);
    wp_enqueue_style( 'admin-styles', $plugin_url . '/style.css', null, null, 'all' );
}

add_action( 'admin_enqueue_scripts', 'tmc_option_styles' );