<?php 

add_action( 'widgets_init', 'finance_tmc_footer_socials' );
function finance_tmc_footer_socials() {

	register_widget( 'tmc_footer_socials' );
}

class tmc_footer_socials extends WP_Widget 
{
	public function __construct() 
	{
		// Widget actual processes
        parent::__construct(
	 		'tmc_footer_socials',                                                          // Base ID
			__('TMC Footer Socials','finance'),                                         // Name
			array( 'description' => __( 'Footer socials', 'finance' ), )  // Args
		);
	}
 	public function form( $instance )
	{
		/* Set up default widget settings. */
        $instance         = wp_parse_args( (array) $instance );
	}
	public function update( $new_instance, $old_instance ) 
	{
		// processes widget options to be saved
        $instance = array();
        $instance[ 'socials_title' ]= strip_tags( $new_instance['socials_title'] );
		return $instance;
	}

	public function widget( $args, $instance )
	{
		// Outputs the content of the widget
        extract( $args );
		global $tmc_option;
        $title      = apply_filters( 'widget_title', $instance['socials_title'] );

		echo $before_widget;
        
        $count     = 0;
	$socials = finance_get_socials( 'footer_socials' );
	if ( $socials): ?>
	<div class="socials">
		<ul>
			<?php foreach( $socials as $key => $val ): ?>
				<li>
					<a href="<?php echo esc_url( $val ); ?>" target="_blank" class="social-<?php echo esc_attr( $key ); ?>">
						<i class="fa fa-<?php echo esc_attr( $key ); ?>"></i>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; 
        wp_reset_postdata();
    	echo $after_widget;
	}
}