<?php

add_action( 'widgets_init', 'finance_tmc_info' );
function finance_tmc_info() {

	register_widget( 'tmc_info' );
}

class tmc_info extends WP_Widget 
{
	public function __construct() 
	{
		// Widget actual processes
		$widget = array(
            'classname' => 'tmc_info',
            'description' => 'Widget that uses the built in Media library.'
        );	
		parent::__construct( 'pu_media_upload', 'TMC Info', $widget );
        add_action('admin_enqueue_scripts', array($this, 'upload_scripts'));
	}
	public function upload_scripts()
    {
		wp_enqueue_media();
		wp_enqueue_script( 'upload_media_widget', get_template_directory_uri() . '/assets/js/upload-media.js', array( 'jquery' ), FINANCE_THEME_VERSION, true );
    }
 	public function form( $tmc_instance )
	{
		/* Set up default widget settings. */	
		 $tmc_instance         = wp_parse_args( (array) $tmc_instance, $defaults );
		$ind_pages = get_pages();
		$image = '';
		if(isset($tmc_instance['image']))
        {
            $image = $tmc_instance['image'];
        }
        $defaults = array(
							'footer_content' => '',
							'footer_logo' => '',
							'location_text' => '',
							'contact_info' => '',
							'email' => '',	
						);
        $tmc_instance         = wp_parse_args( (array) $tmc_instance, $defaults );
		$ind_pages = get_pages();
		$footer_logo = '';
		if ( isset( $tmc_instance[ 'footer_logo' ] ) ) 
		{
            $footer_logo = $tmc_instance[ 'footer_logo' ];
        } 
		$footer_content = '';
		if ( isset( $tmc_instance[ 'footer_content' ] ) ) 
		{
            $footer_content = $tmc_instance[ 'footer_content' ];
        } 
		$location_text = '';
		if ( isset( $tmc_instance[ 'location_text' ] ) ) 
		{
            $location_text = $tmc_instance[ 'location_text' ];
        } 
		$contact_info = '';
		if ( isset( $tmc_instance[ 'contact_info' ] ) ) 
		{
            $contact_info = $tmc_instance[ 'contact_info' ];
        } 
		$email = '';
		if ( isset( $tmc_instance[ 'email' ] ) ) 
		{
            $email = $tmc_instance[ 'email' ];
        }
        ?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('image_uri')); ?>"><?php echo esc_html( 'Logo:', 'resort' ); ?></label><br />
			<?php
				if ( $tmc_instance['image_uri'] != '' ) :		
				$allowedTypes = array(IMAGETYPE_PNG, IMAGETYPE_JPEG, IMAGETYPE_GIF);
				if(isset($tmc_instance['image']))
				{
					$detectedType = exif_imagetype($tmc_instance['image']['tmp_name']);
				}
				else
				{
					$detectedType = '';
				}
				$error = !in_array($detectedType, $allowedTypes);			
					echo '<img class="custom_media_image" src="'.esc_url($tmc_instance['image_uri']).'" style="margin:0;padding:0;float:left;display:inline-block" width=100px; height=100px; /><br />';
				endif;
			?>
			<input type="text" class="widefat custom_media_url" name="<?php echo esc_attr($this->get_field_name('image_uri')); ?>" id="<?php echo esc_attr($this->get_field_id('image_uri')); ?>" value="<?php echo esc_url($tmc_instance['image_uri']); ?>" style="margin-top:5px;">

			<input type="button" class="button button-primary custom_media_button" id="custom_media_button" name="<?php echo esc_attr($this->get_field_name('image_uri')); ?>" value="Upload Image" style="margin-top:5px;" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'content' )); ?>"><?php echo esc_html__('Content' ,'consultex') ?></label> 
			<textarea class="widefat" id="<?php echo esc_attr($this->get_field_id( 'footer_content' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'footer_content' )); ?>"><?php echo esc_attr( $footer_content ); 
			?></textarea>
		</p>	
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'location_text' )); ?>"><?php echo esc_html__('Location Text' ,'consultex') ?>
			</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'location_text' ); ?>" name="<?php echo $this->get_field_name( 'location_text' ); ?>" type="text" value="<?php echo esc_attr( $location_text ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'contact_info' )); ?>"><?php echo esc_html__('Contact Info' ,'consultex') ?>
			</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'contact_info' ); ?>" name="<?php echo $this->get_field_name( 'contact_info' ); ?>" type="text" value="<?php echo esc_attr( $contact_info ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'email' )); ?>"><?php echo esc_html__('Email' ,'consultex') ?>
			</label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" type="text" value="<?php echo esc_attr( $email ); ?>" />
		</p>
			<?php 
	}
	public function update( $new_instance, $old_instance ) 
	{
		// processes widget options to be saved
        $tmc_instance = array();
        //$tmc_instance[ 'footer_logo' ]= strip_tags( $new_instance['footer_logo'] );
		$tmc_instance['image_uri'] = strip_tags( $new_instance['image_uri'] );
        $tmc_instance[ 'footer_content' ]     = $new_instance[ 'footer_content' ];
		$tmc_instance[ 'location_text' ] = $new_instance[ 'location_text' ];
		$tmc_instance[ 'contact_info' ] = $new_instance[ 'contact_info' ];
		$tmc_instance[ 'email' ] = $new_instance[ 'email' ];
		return $tmc_instance;
	}
	public function widget( $args, $tmc_instance )
	{
		// Outputs the content of the widget
        extract( $args );
		global $consultex_option;
        $footer_content     = $tmc_instance['footer_content'];
        $location_text     = $tmc_instance['location_text'];
        $contact_info     = $tmc_instance['contact_info'];		
        $email     = $tmc_instance['email'];
		
		
		echo $before_widget; 
		if ($tmc_instance['image_uri']): ?>
		
		</a>
		<div class="footer_logo">
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="tt-footer-logo">
			<img class="img-responsive" src="<?php echo esc_url( $tmc_instance['image_uri'] ); ?>"  alt="<?php bloginfo( 'name' ); ?>" />
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>"></a>
		</div>
	
		<?php endif; ?>
		<div class="empty-space marg-lg-b30"></div>		   
		<div class="footer_text">
			<p>
				<?php echo esc_attr($tmc_instance['footer_content']); ?> 
			</p>	
		<div class="marg-xs-b30 mobile-marg-0"></div>	
		</div>	
		<?php 
			if( !empty($tmc_instance['location_text']) ): 
				?>
				<div class="tel-box">
					<div class="icon-box">
							<i class="fa fa-map-marker"></i>
					</div>
					<div class="text-box">	
							<?php echo esc_attr($tmc_instance['location_text']); ?> 
					</div>
				</div>
		<?php 	endif; 
			if( !empty($tmc_instance['contact_info'])): 
				?>
				<div class="tel-box">
					<div class="icon-box">
						<i class="fa fa-phone"></i>
					</div>
					<div class="text-box">	
							<?php echo esc_attr($tmc_instance['contact_info']); ?> 
					</div>
				</div>
			<?php 	endif; 
			if( !empty($tmc_instance['email']) ): 
				?>
				<div class="tel-box">
					<div class="icon-box">
							<i class="fa fa-envelope"></i>
					</div>
					<div class="text-box">	
							<?php echo esc_attr($tmc_instance['email']); ?> 
					</div>
				</div>
			<?php 	endif;
		
        wp_reset_postdata();        
    	echo $after_widget;
	}
}