<?php
add_action( 'widgets_init', 'finance_tmc_projects' );
function finance_tmc_projects() {

	register_widget( 'tmc_projects' );
}

class tmc_projects extends WP_Widget 
{
	public function __construct() 
	{
		// Widget actual processes
        parent::__construct(
	 		'tmc_projects',                                                          // Base ID
			__('TMC Products','finance'),                                         // Name
			array( 'description' => __( 'Eye catching posts widget', 'finance' ), )  // Args
		);
	}
 	public function form( $instance )
	{
		/* Set up default widget settings. */
        $defaults = array(
							'title'      => '',
							'post_order' => 'date'
						);
        $instance         = wp_parse_args( (array) $instance, $defaults );
		if ( isset( $instance[ 'footer_products_title' ] ) ) 
		{
            $footer_products_title = $instance[ 'footer_products_title' ];
        }
		else 
		{
            $footer_products_title = '';
        } 		
        ?>
		<p>
			<label for="<?php echo $this->get_field_id('footer_products_title'); ?>"><?php esc_html__( 'Title:', 'finance' ); ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'footer_products_title' ); ?>" name="<?php echo $this->get_field_name( 'footer_products_title' ); ?>" type="text" value="<?php echo esc_attr( $footer_products_title ); ?>" />	
		</p>
		<?php 
	}
	public function update( $new_instance, $old_instance ) 
	{
		// processes widget options to be saved
        $instance = array();
		$instance[ 'footer_products_title' ]= strip_tags( $new_instance['footer_products_title'] );
		return $instance;
	}
	public function widget( $args, $instance )
	{
		// Outputs the content of the widget
        extract( $args );
		global $tmc_option;
		echo $before_widget;

       $args = array(
            'post_type' => 'projects',
            'post_status' => 'publish',
			'posts_per_page' => 6
        );
        $the_query = new WP_Query( $args );
        $count     = 0;
		?>
            <div class="widget get-in-touch">
				<h4 class="widget_title">
					<?php echo esc_attr($instance[ 'footer_products_title' ]);?>
				</h4>
				<ul>
					<?php
						while ( $the_query->have_posts() ) : $the_query->the_post();
							?>
							<li> 
								<a href="<?php echo get_permalink();?>"><?php echo get_the_post_thumbnail( get_the_ID(), array( 86, 68) ); ?>
								</a>
							</li>
							<?php	
						endwhile;?>
				</ul>
           </div>
	<?php
        wp_reset_postdata();
    	echo $after_widget;
	}
}