<?php 

add_action( 'widgets_init', 'finance_tmc_services_layout2' );
function finance_tmc_services_layout2() {

	register_widget( 'tmc_services_layout2' );
}

class tmc_services_layout2 extends WP_Widget 
{
	public function __construct() 
	{
		// Widget actual processes
        parent::__construct(
							'tmc_services',                                                          // Base ID
							__('TMC Services Layout2','finance'),                                         // Name
							array( 'description' => __( 'Eye catching posts widget', 'finance' ), )  // Args
						);
	}
 	public function form( $instance )
	{
		/* Set up default widget settings. */
        $defaults = array(
							'title'      => '',
							'numberOfWords' => 30,
							'footer_logo' => '',
							'post_order' => 'date'
						);
        $instance         = wp_parse_args( (array) $instance, $defaults );
		if ( isset( $instance[ 'service_title' ] ) ) 
		{
            $service_title = $instance[ 'service_title' ];
        }
		else 
		{
            $service_title = '';
        }
		$pages = get_pages(); 
        ?>
    	<p>
    		<label for="<?php echo $this->get_field_id( 'service_title' ); ?>"><?php echo __('Services Title' ,'finance') ?></label> 
    		<input class="widefat" id="<?php echo $this->get_field_id( 'service_title' ); ?>" name="<?php echo $this->get_field_name( 'service_title' ); ?>" type="text" value="<?php echo esc_attr( $service_title ); ?>" />
		</p>
		<?php 
	}
	public function update( $new_instance, $old_instance ) 
	{
		// processes widget options to be saved
        $instance = array();
        $instance[ 'service_title' ]= strip_tags( $new_instance['service_title'] );
		return $instance;
	}
	public function widget( $args, $instance )
	{
		// Outputs the content of the widget
        extract( $args );
		global $tmc_option;
        $title      = apply_filters( 'widget_title', $instance['service_title'] );
		echo $before_widget;
		$args = array(
						'post_type' => 'services',
						'post_status' => 'publish',
						'orderby' => 'date',
						'posts_per_page' => 5
					);
        $the_query = new WP_Query( $args );
        $count     = 0;
		?>
		<h4 class="widget_title"><?php echo esc_attr($instance['service_title']);?></h4>
		<?php $count_services = wp_count_posts('services')->publish; 
		?>
		<div class="widget_tmc_services row m0">
			<ul class="services-list-max-height">
				<?php
				while ( $the_query->have_posts() ) : $the_query->the_post();
				?>
				 <li class="services-list">
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></li>
				<?php endwhile;?>					
			</ul>
		</div>				
		<?php
			wp_reset_postdata();
			echo $after_widget;
	}
}