<?php
/*
Plugin Name: TMC Post Type
Description: TMC Post Type
Author:ThemeChampion
Author URI: http://www.themechampion.com/
Text Domain: tmc_post_type
Version: 2.0
*/

define( 'TMC_POST_TYPE', 'tmc_post_type' );

function custom_post_type_init() {
		
$options_meta = get_option('tmc_post_types_options');

$tmcPostTypesOptions = array(

	'projects' => array(
		'title' => __( 'Projects', TMC_POST_TYPE ),
		'rewrite' => 'projects'
	),

	'services' => array(
		'title' => __( 'Services', TMC_POST_TYPE ),
		'rewrite' => 'services'
	),
		
	'testimonials' => array(
		'title' => __( 'Testimonials', TMC_POST_TYPE ),
		'rewrite' => 'testimonials'
	),
	
	'clients' => array(
		'title' => __( 'Clients', TMC_POST_TYPE ),
		'rewrite' => 'clients'
	),
		
	'team' => array(
		'title' => __( 'Team', TMC_POST_TYPE ),
		'rewrite' => 'team'
	),
				
);

$tmc_post_types_options = wp_parse_args( $options_meta, $tmcPostTypesOptions );
		
	$defaults = '';
	$defaults = array(
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'show_in_nav_menus'  => true,
			'query_var'          => true,
			'has_archive'        => true,
			'hierarchical'       => false,
			'menu_position'      => null,
			'menu_icon'          => null,
			'supports'           => array( 'title', 'editor' )
		);
	
  register_post_type(
    'sidebar', array(
      'labels' => array('name' => __( 'Sidebar' ), 'singular_name' => __( 'sidebar' ) ),
      'public' => true,
	  'menu_icon' => 'dashicons-schedule',
      'supports' => array( 'title', 'editor' ), 
	  'exclude_from_search' => true, 
	  'publicly_queryable' => false,
	  $defaults,
    )
  );

  register_post_type(
    'projects', array(
      'labels' => array('name' => $tmc_post_types_options['projects']['title'],
	  'singular_name' => __( 'projects' ) ),
      'public' => true,
	  'menu_icon' => 'dashicons-portfolio',
      'has_archive' => true,
      'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt'),
	  $defaults,
	  'rewrite' => array( 'slug' => $tmc_post_types_options['projects']['rewrite'] ),
    )
  );
  
   register_post_type(
    'services', array(
      'labels' => array('name' => $tmc_post_types_options['services']['title'],
	  'singular_name' => __( 'services' ) ),
      'public' => true,
	  'menu_icon' => 'dashicons-portfolio',
      'has_archive' => true,
      'supports' => array('title', 'editor', 'thumbnail', 'comments', 'excerpt'),
	  $defaults,
	  'rewrite' => array( 'slug' => $tmc_post_types_options['services']['rewrite'] ),
    )
  );
   
   register_post_type(
    'testimonials', array(
      'labels' => array('name' => $tmc_post_types_options['testimonials']['title'],
	  'singular_name' => __( 'testimonials' ) ),
      'public' => true,
	  'menu_icon' => 'dashicons-testimonial',
      'has_archive' => true,
      'supports' => array( 'title', 'editor', 'thumbnail', 'comments', 'excerpt' ) ,
	  $defaults,
	  'rewrite' => array( 'slug' => $tmc_post_types_options['testimonials']['rewrite'] ),
    )
  );
  
  register_post_type(
    'clients', array(
      'labels' => array('name' => $tmc_post_types_options['clients']['title'],
	  'singular_name' => __( 'clients' ) ),
      'public' => true,
	  'menu_icon' => 'dashicons-testimonial',
      'has_archive' => true,
      'supports' => array( 'title', 'editor', 'thumbnail', 'comments', 'excerpt' ) ,
	  $defaults,
	  'rewrite' => array( 'slug' => $tmc_post_types_options['clients']['rewrite'] ),
    )
  );
  
   register_post_type(
    'team', array(
      'labels' => array('name' => $tmc_post_types_options['team']['title'],
	  'singular_name' => __( 'team' ) ),
      'public' => true,
	  'menu_icon' => 'dashicons-testimonial',
      'has_archive' => true,
      'supports' => array( 'title', 'editor', 'thumbnail', 'comments', 'excerpt' ) ,
	  $defaults,
	  'rewrite' => array( 'slug' => $tmc_post_types_options['team']['rewrite'] ),
    )
  );
  
}
add_action( 'init', 'custom_post_type_init' );


function custom_post_type_tax_init() {
	
	register_taxonomy(
		'projects-category',
		'projects',
		array(
			'label' => __( 'Categories' ),
			'rewrite' => array( 'slug' => 'projects' ),
			'hierarchical' => true,
		)
	);
}
add_action( 'init', 'custom_post_type_tax_init' );

// TO add Meta boxes Units
function wdm_add_meta_box_unit() {

        add_meta_box('wdm_section_unit', 'Client Options', 'wdm_meta_box_testimonials', 'testimonials');
		
		add_meta_box('wdm_section_unit', 'Expert Socials', 'wdm_meta_box_team', 'team');
		
		add_meta_box('wdm_section_designation', 'Designation', 'wdm_meta_box_team_designation', 'team');

		add_meta_box('wdm_section_page', 'Page Title', 'wdm_meta_box_page', 'page');

		add_meta_box('wdm_section_services', 'Page Title', 'wdm_meta_box_title', 'services');
		
		add_meta_box('wdm_section_services_icon', 'Services Icon', 'wdm_meta_box_services', 'services');
}

add_action( 'add_meta_boxes', 'wdm_add_meta_box_unit' );



function wdm_meta_box_services( $post ) {
	
        $value = get_post_meta( $post->ID, '_tmc_services_icon', true );
        ?>
		
		<div class="row">
			<div class="meta-lable">
				<label>Services Icon</label>
			</div>
			<div class="meta-value"> 
			<?php 
					  $default_image = plugin_dir_url( __FILE__ ) . 'images/services3-1.png';
					$image = '';
					if ($value) {
						$image = wp_get_attachment_image_src($value, 'medium');
						$image = $image[0];
					}
					if( empty($image) ){
						$image = $default_image;
					}
					
					?>
						<div class="ind_metabox_image">
							<input name="_tmc_services_icon" type="hidden" class="custom_upload_image" value="<?php echo $value ; ?>" />
							<img src="<?php echo $image; ?>" class="custom_preview_image" alt="" />
							<input class="ind_upload_image upload_button_tmc_services_icon button-primary" type="button" value="<?php echo  __( 'Choose Image' ) ; ?>" />
							<a href="#" class="ind_remove_image button"><?php echo __( 'Remove Image' ); ?></a>
						</div>			
			</div>
		</div>
		
		<script type="text/javascript">
			jQuery(function($) {
				$(".upload_button_tmc_services_icon").click(function(){
					var btnClicked = $(this);
					var custom_uploader = wp.media({
						title   : "<?php echo __( 'Select image'); ?>",
						button  : {
							text: "<?php echo __( 'Attach' ) ; ?>"
						},
						multiple: true
					}).on("select", function () {
						var attachment = custom_uploader.state().get("selection").first().toJSON();
						btnClicked.closest(".ind_metabox_image").find(".custom_upload_image").val(attachment.id);
						btnClicked.closest(".ind_metabox_image").find(".custom_preview_image").attr("src", attachment.url);

					}).open();
				});
				$(".ind_remove_image").click(function(){
					$(this).closest(".ind_metabox_image").find(".custom_upload_image").val("");
					$(this).closest(".ind_metabox_image").find(".custom_preview_image").attr("src", "<?php echo $default_image ; ?>");
					return false;
				});
			});
		</script>
	<?php 	
}



function wdm_meta_box_testimonials( $post ) {
	
        $value = get_post_meta( $post->ID, '_tmc_testimonial_designation', true );
		
		$value1 = get_post_meta( $post->ID, '_tmc_testimonial_rating', true ); 

        ?>
        <div class="row">
			<div class="meta-lable">
				<label>Designation</label>
			</div>
			<div class="meta-value">
				<input type="text" name="_tmc_testimonial_designation" value="<?php if($value) echo $value; else echo 'Designation';  ?>">
			</div>
		</div>	

		<div class="row">
			<div class="meta-lable">
				<label>Rating</label>
			</div>
			<div class="meta-value">
				<select name="_tmc_testimonial_rating">
				  <option value="star1" <?php selected( $value1, 'star1' ); ?>>Star1</option>
				  <option value="star2" <?php selected( $value1, 'star2' ); ?>>Star2</option>
				  <option value="star3" <?php selected( $value1, 'star3' ); ?>>Star3</option>
				  <option value="star4" <?php selected( $value1, 'star4' ); ?>>Star4</option>
				  <option value="star5" <?php selected( $value1, 'star5' ); ?>>Star5</option>
				</select>
			</div>
		</div>
        <?php
}

function wdm_meta_box_team( $post ) {
	
        $facebook = get_post_meta( $post->ID, '_tmc_social_facebook', true ); 
		$twitter = get_post_meta( $post->ID, '_tmc_social_twitter', true ); 
		$googleplus = get_post_meta( $post->ID, '_tmc_social_googleplus', true ); 
		$linkedin = get_post_meta( $post->ID, '_tmc_social_linkedin', true ); 

        ?>
        <div class="row">
			<div class="meta-lable">
				<label>Facebook</label>
			</div>
			<div class="meta-value">
				<input type="text" name="_tmc_social_facebook" value="<?php if($facebook) echo $facebook; else echo '#';  ?>">
			</div>
		</div>
		
		<div class="row">
			<div class="meta-lable">
				<label>Twitter</label>
			</div>
			<div class="meta-value">
				<input type="text" name="_tmc_social_twitter" value="<?php if($twitter) echo $twitter; else echo '#';  ?>">
			</div>
		</div>

		<div class="row">
			<div class="meta-lable">
				<label>Google Plus</label>
			</div>
			<div class="meta-value">
				<input type="text" name="_tmc_social_googleplus" value="<?php if($googleplus) echo $googleplus; else echo '#';  ?>">
			</div>
		</div>

		<div class="row">
			<div class="meta-lable">
				<label>Linkedin</label>
			</div>
			<div class="meta-value">
				<input type="text" name="_tmc_social_linkedin" value="<?php if($linkedin) echo $linkedin; else echo '#';  ?>">
			</div>
		</div>
        <?php
}

function wdm_meta_box_team_designation( $post ) {
	
        $designation = get_post_meta( $post->ID, '_tmc_member_designation', true );
        ?>
        <div class="row">
			<div class="meta-lable">
				<label>Designation</label>
			</div>
			<div class="meta-value">
				<input type="text" name="_tmc_member_designation" value="<?php if($designation) echo $designation; else echo 'Designation';  ?>">
			</div>
		</div>		
        <?php
}

function wdm_meta_box_page( $post ) {
	
        $page_title = get_post_meta( $post->ID, '_tmc_page_title', true );
        ?>
        <div class="row">
			<div class="meta-lable">
				<label>Page Title</label>
			</div>
			<div class="meta-value">
				<input type="text" name="_tmc_page_title" value="<?php if($page_title) echo $page_title; else echo 'Money Doesn’t Come Without Guidence ...';  ?>">
			</div>
		</div>		
        <?php
}

function wdm_meta_box_title( $post ) {
	
        $page_title = get_post_meta( $post->ID, '_tmc_page_title', true );
        ?>
        <div class="row">
			<div class="meta-lable">
				<label>Page Title</label>
			</div>
			<div class="meta-value">
				<input type="text" class="title_width" name="_tmc_page_title" value="<?php if($page_title) echo $page_title; else echo 'Money Doesn’t Come Without Guidence ...';  ?>">
			</div>
		</div>		
        <?php
}

function wdm_save_meta_box_data_unit( $post_id ) {

        // Services Icon
        $icon = ( isset( $_POST['_tmc_services_icon'] ) ? $_POST['_tmc_services_icon'] : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_services_icon', $icon );
		
		// Sanitize user input.
        $designation = ( isset( $_POST['_tmc_testimonial_designation'] ) ? sanitize_html_class( $_POST['_tmc_testimonial_designation'] ) : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_testimonial_designation', $designation );
				
		// Sanitize user input.
        $rating = ( isset( $_POST['_tmc_testimonial_rating'] ) ? sanitize_html_class( $_POST['_tmc_testimonial_rating'] ) : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_testimonial_rating', $rating );
				
		// Sanitize user input.
        $facebook = ( isset( $_POST['_tmc_social_facebook'] ) ?  $_POST['_tmc_social_facebook'] : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_social_facebook', $facebook );
		
		// Sanitize user input.
        $twitter = ( isset( $_POST['_tmc_social_twitter'] ) ? $_POST['_tmc_social_twitter'] : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_social_twitter', $twitter );
		
		// Sanitize user input.
        $googleplus = ( isset( $_POST['_tmc_social_googleplus'] ) ?  $_POST['_tmc_social_googleplus'] : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_social_googleplus', $googleplus );
		
		// Sanitize user input.
        $linkedin = ( isset( $_POST['_tmc_social_linkedin'] ) ?  $_POST['_tmc_social_linkedin']  : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_social_linkedin', $linkedin );	

		// Sanitize user input.
        $teamdesignation = ( isset( $_POST['_tmc_member_designation'] ) ? sanitize_html_class( $_POST['_tmc_member_designation'] ) : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_member_designation', $teamdesignation );	
        		// TMC Page Title
        $title = ( isset( $_POST['_tmc_page_title'] ) ? $_POST['_tmc_page_title'] : '' );
        // Update the meta field in the database.
        update_post_meta( $post_id, '_tmc_page_title', $title );

        	
}
add_action( 'save_post', 'wdm_save_meta_box_data_unit' );


// Tmc Post Type Rewrite subplugin
add_action( 'admin_menu', 'tmc_post_types_options_menu' );

if( ! function_exists( 'tmc_post_types_options_menu' ) ){
	function tmc_post_types_options_menu(){
		add_options_page( __('TMC Post Types', TMC_POST_TYPE), __('TMC Post Types', TMC_POST_TYPE), 'manage_options', 'tmc_post_types', 'tmc_post_types_options' );
	}
}

if( ! function_exists( 'tmc_post_types_options' ) ){
	function tmc_post_types_options(){

		if ( ! empty( $_POST['tmc_post_types_options'] ) ) {
			update_option( 'tmc_post_types_options', $_POST['tmc_post_types_options'] );
		}

		$options_meta = get_option('tmc_post_types_options');

		$tmcPostTypesOptions = array(

			'projects' => array(
				'title' => __( 'Projects', TMC_POST_TYPE ),
				'rewrite' => 'projects'
			),

			'services' => array(
				'title' => __( 'Services', TMC_POST_TYPE ),
				'rewrite' => 'services'
			),
				
			'testimonials' => array(
				'title' => __( 'Testimonials', TMC_POST_TYPE ),
				'rewrite' => 'testimonials'
			),
			
			'clients' => array(
				'title' => __( 'Clients', TMC_POST_TYPE ),
				'rewrite' => 'clients'
			),
				
			'team' => array(
				'title' => __( 'Team', TMC_POST_TYPE ),
				'rewrite' => 'team'
			),
		);

		$options_meta = wp_parse_args( $options_meta, $tmcPostTypesOptions );
		
		$content = '';

		$content .= '
			<div class="tmcposttype">
		        <h2>' . __( 'TMC Post Type Settings', TMC_POST_TYPE ) . '</h2>

		        <form method="POST" action="">
		            <table class="form-table">';
						foreach ($tmcPostTypesOptions as $key => $value){
							$content .= '
								<tr valign="top">
									<th scope="row">
										<label for="'.$key.'_title">' . __( 'Module Name:', TMC_POST_TYPE ) . '</label>
									</th>
									<td>
				                        <input type="text" id="'.$key.'_title" name="tmc_post_types_options['.$key.'][title]" value="' . $options_meta[$key]['title'] . '"  size="25" />
				                    </td>
								</tr>
								
				                <tr valign="top">
				                    <th scope="row">
				                        <label for="'.$key.'_rewrite">' . __( 'Slug:', TMC_POST_TYPE ) . '</label>
				                    </th>
				                    <td>
				                        <input type="text" id="'.$key.'_rewrite" name="tmc_post_types_options['.$key.'][rewrite]" value="' . $options_meta[$key]['rewrite'] . '"  size="25" />
				                    </td>
				                </tr>
				                <tr valign="top"><th scope="row"></th></tr>
			                ';
						}
		 $content .='</table>
		            <p>' . __( "NOTE: After you change the rewrite field values, you'll need to refresh permalinks under Settings -> Permalinks", TMC_POST_TYPE ) . '</p>
		            <br/>
		            <p>
						<input type="submit" value="' . __( 'Save settings', TMC_POST_TYPE ) . '" class="button-primary"/>
					</p>
		        </form>
		    </div>
		';
		
		echo $content;
	}
}

function tmc_post_plugin_styles() {
    $plugin_url =  plugins_url('', __FILE__);
    wp_enqueue_style( 'admin', $plugin_url . '/admin.css', null, null, 'all' );
}

add_action( 'admin_enqueue_scripts', 'tmc_post_plugin_styles' );
 ?>