<?php
if ( ! function_exists( 'rasin_setup' ) ) :

function rasin_setup() {

    /*
     * Make theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    /* Pinegrow generated Load Text Domain Begin */
    load_theme_textdomain( 'rasin', get_template_directory() . '/languages' );
    /* Pinegrow generated Load Text Domain End */

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    /*
     * Let WordPress manage the document title.
     */
    add_theme_support( 'title-tag' );
    
    /*
     * Enable support for Post Thumbnails on posts and pages.
     */
    add_theme_support( 'post-thumbnails' );
    //Support custom logo
    add_theme_support( 'custom-logo' );

    // Add menus.
    register_nav_menus( array(
        'primary' => __( 'Primary Menu', 'rasin' ),
        'social'  => __( 'Social Links Menu', 'rasin' ),
    ) );

/*
     * Register custom menu locations
     */
    /* Pinegrow generated Register Menus Begin */

    /* Pinegrow generated Register Menus End */
    
/*
    * Set image sizes
     */
    /* Pinegrow generated Image sizes Begin */

    /* Pinegrow generated Image sizes End */
    
    /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.
     */
    add_theme_support( 'html5', array(
        'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
    ) );

    /*
     * Enable support for Post Formats.
     */
    add_theme_support( 'post-formats', array(
        'aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat'
    ) );

    /*
     * Enable support for Page excerpts.
     */
     add_post_type_support( 'page', 'excerpt' );
}
endif; // rasin_setup

add_action( 'after_setup_theme', 'rasin_setup' );


if ( ! function_exists( 'rasin_init' ) ) :

function rasin_init() {

    
    // Use categories and tags with attachments
    register_taxonomy_for_object_type( 'category', 'attachment' );
    register_taxonomy_for_object_type( 'post_tag', 'attachment' );

    /*
     * Register custom post types. You can also move this code to a plugin.
     */
    /* Pinegrow generated Custom Post Types Begin */

    /* Pinegrow generated Custom Post Types End */
    
    /*
     * Register custom taxonomies. You can also move this code to a plugin.
     */
    /* Pinegrow generated Taxonomies Begin */

    /* Pinegrow generated Taxonomies End */

}
endif; // rasin_setup

add_action( 'init', 'rasin_init' );


if ( ! function_exists( 'rasin_custom_image_sizes_names' ) ) :

function rasin_custom_image_sizes_names( $sizes ) {

    /*
     * Add names of custom image sizes.
     */
    /* Pinegrow generated Image Sizes Names Begin*/
    /* This code will be replaced by returning names of custom image sizes. */
    /* Pinegrow generated Image Sizes Names End */
    return $sizes;
}
add_action( 'image_size_names_choose', 'rasin_custom_image_sizes_names' );
endif;// rasin_custom_image_sizes_names



if ( ! function_exists( 'rasin_widgets_init' ) ) :

function rasin_widgets_init() {

    /*
     * Register widget areas.
     */
    /* Pinegrow generated Register Sidebars Begin */

    /* Pinegrow generated Register Sidebars End */
}
add_action( 'widgets_init', 'rasin_widgets_init' );
endif;// rasin_widgets_init



if ( ! function_exists( 'rasin_customize_register' ) ) :

function rasin_customize_register( $wp_customize ) {
    // Do stuff with $wp_customize, the WP_Customize_Manager object.

    /* Pinegrow generated Customizer Controls Begin */

    /* Pinegrow generated Customizer Controls End */

}
add_action( 'customize_register', 'rasin_customize_register' );
endif;// rasin_customize_register


if ( ! function_exists( 'rasin_enqueue_scripts' ) ) :
    function rasin_enqueue_scripts() {

        /* Pinegrow generated Enqueue Scripts Begin */

    wp_deregister_script( 'rasin-emaildecode' );
    wp_enqueue_script( 'rasin-emaildecode', get_template_directory_uri() . '/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-modernizr' );
    wp_enqueue_script( 'rasin-modernizr', get_template_directory_uri() . '/js/modernizr-3.5.0.min.js', [], '1.18', true);

    wp_enqueue_script( 'jquery' );
    wp_deregister_script( 'rasin-popper' );
    wp_enqueue_script( 'rasin-popper', get_template_directory_uri() . '/js/popper.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-bootstrap' );
    wp_enqueue_script( 'rasin-bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-jquerywaypoints' );
    wp_enqueue_script( 'rasin-jquerywaypoints', get_template_directory_uri() . '/js/jquery.waypoints.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-jquerycounterup' );
    wp_enqueue_script( 'rasin-jquerycounterup', get_template_directory_uri() . '/js/jquery.counterup.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-wow' );
    wp_enqueue_script( 'rasin-wow', get_template_directory_uri() . '/js/wow.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-slick' );
    wp_enqueue_script( 'rasin-slick', get_template_directory_uri() . '/js/slick.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-jqueryappear' );
    wp_enqueue_script( 'rasin-jqueryappear', get_template_directory_uri() . '/js/jquery.appear.js', [], '1.18', true);

    wp_deregister_script( 'rasin-jqueryaspieprogress' );
    wp_enqueue_script( 'rasin-jqueryaspieprogress', get_template_directory_uri() . '/js/jquery-asPieProgress.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-jquerymagnificpopup' );
    wp_enqueue_script( 'rasin-jquerymagnificpopup', get_template_directory_uri() . '/js/jquery.magnific-popup.min.js', [], '1.18', true);

    wp_deregister_script( 'rasin-main' );
    wp_enqueue_script( 'rasin-main', get_template_directory_uri() . '/js/main.js', [], '1.18', true);

    /* Pinegrow generated Enqueue Scripts End */

        /* Pinegrow generated Enqueue Styles Begin */

    wp_deregister_style( 'rasin-bootstrap' );
    wp_enqueue_style( 'rasin-bootstrap', get_template_directory_uri() . '/bootstrap_theme/bootstrap.css', [], '1.18', 'all');

    wp_deregister_style( 'rasin-icofont' );
    wp_enqueue_style( 'rasin-icofont', get_template_directory_uri() . '/fonts/icofont.css', [], '1.18', 'all');

    wp_deregister_style( 'rasin-flaticon' );
    wp_enqueue_style( 'rasin-flaticon', get_template_directory_uri() . '/fonts/flaticon/flaticon.css', [], '1.18', 'all');

    wp_deregister_style( 'rasin-slick' );
    wp_enqueue_style( 'rasin-slick', get_template_directory_uri() . '/css/slick.css', [], '1.18', 'all');

    wp_deregister_style( 'rasin-magnificpopup' );
    wp_enqueue_style( 'rasin-magnificpopup', get_template_directory_uri() . '/css/magnific-popup.css', [], '1.18', 'all');

    wp_deregister_style( 'rasin-animate' );
    wp_enqueue_style( 'rasin-animate', get_template_directory_uri() . '/css/animate.css', [], '1.18', 'all');

    wp_deregister_style( 'rasin-style' );
    wp_enqueue_style( 'rasin-style', get_template_directory_uri() . '/css/style.css', [], '1.18', 'all');

    wp_deregister_style( 'rasin-responsive' );
    wp_enqueue_style( 'rasin-responsive', get_template_directory_uri() . '/css/responsive.css', [], '1.18', 'all');

    wp_deregister_style( 'rasin-style-1' );
    wp_enqueue_style( 'rasin-style-1', get_bloginfo('stylesheet_url'), [], '1.18', 'all');

    /* Pinegrow generated Enqueue Styles End */

    }
    add_action( 'wp_enqueue_scripts', 'rasin_enqueue_scripts' );
endif;

function pgwp_sanitize_placeholder($input) { return $input; }
/*
 * Resource files included by Pinegrow.
 */
/* Pinegrow generated Include Resources Begin */
require_once "inc/custom.php";
if( !class_exists( 'PG_Helper_v2' ) ) { require_once "inc/wp_pg_helpers.php"; }
if( !class_exists( 'PG_WC_Helper' ) ) { require_once "inc/wc_pg_helpers.php"; }

    /* Pinegrow generated Include Resources End */

/* Setting up theme supports options */

function rasin_setup_theme_supports() {
    // Don't edit anything between the following comments.
    /* Pinegrow generated Theme Supports Begin */
    
//Enable site editor                    
add_theme_support('block-templates');
add_theme_support('block-template-parts');
    add_theme_support( 'woocommerce' );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );    
//Tell WP to scope loaded editor styles to the block editor                    
add_theme_support( 'editor-styles' );
    /* Pinegrow generated Theme Supports End */
}
add_action('after_setup_theme', 'rasin_setup_theme_supports');

/* End of setting up theme supports options */


/* Setting up WooCommerce filters */
/* Pinegrow generated WooCommerce Filters Begin */

    /* This filter lets us multiple variants of the same template name. It also handles locating the templates that are present in the theme or plugin. */        
    add_filter( 'wc_get_template', function( $template, $template_name, $args, $template_path, $default_path ) {
        global $pg_wc_use_template, $pg_wc_use_template_cache_rasin;
        if(!isset($pg_wc_use_template_cache_rasin)) $pg_wc_use_template_cache_rasin = array();
        
        if( !empty($pg_wc_use_template) ) {
            $template_variant = trailingslashit( get_template_directory() ) . 'woocommerce/' . str_replace( '.php', '-'.$pg_wc_use_template.'.php', $template_name);
            $template_key = $template_name . '-' . $pg_wc_use_template;
        } else {
            $template_key = $template_name;
            $template_variant = trailingslashit( get_template_directory() ) . 'woocommerce/' . $template_name;
        }
            
        if(isset($pg_wc_use_template_cache_rasin[ $template_key ])) {
            if($pg_wc_use_template_cache_rasin[ $template_key ]) {
                $template = $template_variant;
            }
        } else if(file_exists($template_variant)) {
            $template = $template_variant;
            $pg_wc_use_template_cache_rasin[ $template_key ] = true;
        } else {
            $pg_wc_use_template_cache_rasin[ $template_key ] = false;
        }
 
        return $template;
    }, 10, 5 );  
            
    /* Pinegrow generated WooCommerce Filters End */
/* End Setting up WooCommerce filters */


/* Loading editor styles for blocks */

function rasin_add_blocks_editor_styles() {
// Add blocks editor styles. Don't edit anything between the following comments.
/* Pinegrow generated Load Blocks Editor Styles Begin */
    add_editor_style( 'css/style.css' );
    add_editor_style( 'css/slick.css' );
    add_editor_style( 'css/responsive.css' );
    add_editor_style( 'css/nice-select.css' );
    add_editor_style( 'css/magnific-popup.css' );

    /* Pinegrow generated Load Blocks Editor Styles End */
}
add_action('admin_init', 'rasin_add_blocks_editor_styles');

/* End of loading editor styles for blocks */


/* Control how block assets are loaded on the front-end */
function rasin_should_load_separate_core_block_assets() {
    /* Pinegrow generated Load Block Assets Separately Begin */
    //Load only assets of blocks that are used on the page
    add_filter( 'should_load_separate_core_block_assets', '__return_true' );

    /* Pinegrow generated Load Block Assets Separately End */
}
add_action('init', 'rasin_should_load_separate_core_block_assets');
/* End of controlling how block assets are loaded on the front-end */


/* Register Blocks Categories */

function rasin_register_blocks_categories( $categories ) {

    // Don't edit anything between the following comments.
    /* Pinegrow generated Register Blocks Category Begin */

$categories = array_merge( $categories, array( array(
        'slug' => 'my_rasin_block',
        'title' => __( 'Name', 'rasin' ),
        'icon' => 'Icon'
    ) ) );

    /* Pinegrow generated Register Blocks Category End */
    
    return $categories;
}
add_action( version_compare('5.8', get_bloginfo('version'), '<=' ) ? 'block_categories_all' : 'block_categories', 'rasin_register_blocks_categories');

/* End of registering Blocks Categories */

?>