<?php
/**
 * The template for displaying comments.
 *
 * The area of the page that contains both current comments
 * and the comment form.
 *
 * @package finance
 */
/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) 
{
	return;
}
?>
<div id="comments">
	<?php 
		if ( have_comments() ): 
			?>
			<h4 class="comments-title">
				<?php comments_number(); ?>
			</h4>
			<ul class="comment-list">
				<?php
					wp_list_comments( array(
										'callback'    => 'finance_comment'
									) 
					);
				?>
			</ul>
			<?php 
				if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ): 
					?>
					<nav class="navigation comment-navigation" role="navigation">
						<h2 class="screen-reader-text">
							<?php esc_html_e( 'Comment navigation', 'finance' ); ?>
						</h2>
						<div class="nav-links">
							<div class="nav-previous">
								<?php previous_comments_link( esc_html__( '&larr; Older Comments', 'finance' ) ); ?>
							</div>
							<div class="nav-next">
								<?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'finance' ) ); ?>
							</div>				
						</div>
					</nav>
					<?php 
				endif;
		endif;
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ): ?>
		<p class="no-comments">
			<?php esc_html_e( 'Comments are closed.', 'finance' ); ?>
		</p>
	<?php 
	endif; 
	comment_form(); ?>
</div>