<?php $finance_info = wp_get_theme();
define( 'FINANCE_THEME_VERSION', ( WP_DEBUG ) ? time() : $finance_info->get( 'Version' ) );

if ( ! isset( $content_width ) ) {
	$content_width = 1170;
}

add_action( 'after_setup_theme', 'finance_theme_setup' );
if ( ! function_exists( 'finance_theme_setup' ) ) 
{
	function finance_theme_setup() 
	{
		if ( ! get_post_meta( get_the_ID(), 'disable_tags', true ) ) 
		{
			the_tags( '<div class="tags media-body">', ' ', '</div>' );
		}
		add_image_size( 'finance-image-1110x550-croped', 1110, 550, true );
		add_image_size( 'finance-image-350x250-croped', 350, 250, true );
		add_image_size( 'finance-image-350x204-croped', 350, 204, true );
		add_image_size( 'finance-image-350x195-croped', 350, 195, true );
		add_image_size( 'finance-image-255x182-croped', 255, 182, true );
		add_image_size( 'finance-image-50x50-croped', 50, 50, true );

		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'finance' );
		add_theme_support( 'html5', array(
											'search-form',
											'comment-form',
											'comment-list',
											'gallery',
											'caption'
										) 
						);

		/*
		 * Gutenberg Compatible
		 */
			add_theme_support( 'align-wide' );
			add_theme_support( 'wp-block-styles' );
			add_theme_support( 'editor-styles' );
				
		/*
		  * Enable support for custome header and background for the images.
		  */
		add_theme_support( 'custom-header' );
		add_theme_support( 'custom-background' ) ;
		 
		 //WooCommerce Theme Support
		add_theme_support('woocommerce');

		if ( class_exists('Woocommerce') ) 
		{
			global $finance_option;
			/* Init Redux API init since functions.php runs BEFORE after_setup_theme 
				https://github.com/reduxframework/redux-framework/issues/2362 */
			$finance_option = get_option('finance_option');
			// Increase Number of Related Products to 4
			if (!function_exists('woocommerce_related_output')) 
			{
				function woocommerce_related_output() 
				{
					global $product, $orderby, $related;
					$args = array(
									'posts_per_page'	=> '4',
									'columns'			=> '4',
								);
					return $args;
				}
			}
			add_filter( 'woocommerce_output_related_products_args', 'woocommerce_related_output' );
			// Change products per page
			if(!empty($finance_option['text_shopitems']))
			{
				add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 20 );
				function new_loop_shop_per_page( $cols ) {
					global $finance_option;
				  // $cols contains the current number of products per page based on the value stored on Options -> Reading
				  // Return the number of products you wanna show per page.
				  $cols = $finance_option['text_shopitems'];
				  return $cols;
				}
			}
			
			// Toggle Sort by Function
			if(isset($finance_option["switch_shopsorting"]) &&  $finance_option["switch_shopsorting"] == 0)
			{
				remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30 );
			}
			// Toggle Result Count
			if(isset($finance_option["switch_shopresultcount"]) && $finance_option["switch_shopresultcount"] == 0)
			{
				remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
			}
			// Toggle Upsell Products
			if(isset($finance_option["switch_shopupsells"]) && $finance_option["switch_shopupsells"] == 0){
				remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15);
			}
			// Toggle Related Products
			if(isset($finance_option["switch_shoprelatedproducts"]) && $finance_option["switch_shoprelatedproducts"] == 0)
			{
				remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20);
			}
			// Toggle Add to Cart Button
			if(isset($finance_option["switch_addtocart"]) && $finance_option["switch_addtocart"] == 0)
			{
				add_action('init','woocommerce_remove_loop_button');
			}
			// Remove Cart Cross Sells
			remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
			// Remove Add to Cart Button
			function woocommerce_remove_loop_button()
			{
				remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
			}
		}
		// end if woocommerce class exists
		  
		// This theme styles the visual editor to resemble the theme style.
		add_editor_style( 'assets/css/editor-style.css' );
		register_nav_menus(
							array(
								'finance-primary_menu'   => esc_html__( 'Top Menu', 'finance' ),
								'finance-footer' => esc_html__( 'Footer', 'finance' ),				
							)
						);
	}
}

if ( ! function_exists( 'finance_register_default_sidebars' ) ) 
{
	function finance_register_default_sidebars() 
	{
		register_sidebar( array(
			'id'            => 'finance-right-sidebar',
			'name'          => esc_html__( 'Right Sidebar', 'finance' ),
			'description'   => esc_html__( 'Add widgets here to appear in Right Sidebar', 'finance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget_title">',
			'after_title'   => '</h5>',
		) );

		register_sidebar( array(
			'id'            => 'finance-left-sidebar',
			'name'          => esc_html__( 'Left Sidebar', 'finance' ),
			'description'   => esc_html__( 'Add widgets here to appear in Left Sidebar', 'finance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget_title">',
			'after_title'   => '</h5>',
		) );
		register_sidebar( array(
			'id'            => 'finance-shop',
			'name'          => esc_html__( 'Shop Sidebar', 'finance' ),
			'description'   => esc_html__( 'Add widgets here to appear in Shop', 'finance' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s shop_widgets">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h5 class="widget_title">',
			'after_title'   => '</h5>',
		) );
		// Register Footer Sidebars
		for ( $footer = 1; $footer < 5; $footer ++ ) 
		{
			register_sidebar( array(
				'id'            => 'finance-footer-' . $footer,
				'description'   => esc_html__( 'Add widgets here to appear in footer', 'finance' ),
				'name'          => esc_html__( 'Footer ', 'finance' ) . $footer,
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h4 class="widget_title no_stripe">',
				'after_title'   => '</h4>',
			) );
		}
	}
}
add_action( 'widgets_init', 'finance_register_default_sidebars', 50 );
/*code to use woocommerce.css*/
function finance_woocommerce_style_sheet() 
{
	wp_enqueue_style( 'woocommerce', get_stylesheet_directory_uri() . '/woocommerce/woocommerce.css' );
	if ( class_exists( 'woocommerce' ) ) 
	{
		wp_enqueue_style( 'woocommerce' );
	}
}
add_action('wp_enqueue_scripts', 'finance_woocommerce_style_sheet');
/*code to use woocommerce.css*/

add_action( 'wp_enqueue_scripts', 'finance_load_theme_scripts_and_styles' );

if( ! function_exists( 'finance_load_theme_scripts_and_styles' ) )
{
	function finance_load_theme_scripts_and_styles()
	{
		if ( ! is_admin() ) 
		{
			global $finance_option;
			$finance_option['demo'] = 'demo1';
			
			/* Register Styles */
			
			wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css', null, FINANCE_THEME_VERSION, 'all' );
			wp_enqueue_style( 'finance-style', get_stylesheet_uri(), null,  FINANCE_THEME_VERSION, 'all' );
			wp_enqueue_style( 'finance-layout', get_template_directory_uri() . '/assets/css/'. $finance_option['demo'] .'/main.css', null,  FINANCE_THEME_VERSION, 'all' );
			wp_enqueue_style( 'finance-responsive', get_template_directory_uri() . '/assets/css/'. $finance_option['demo'] .'/responsive.css', null,  FINANCE_THEME_VERSION, 'all' );
			wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/css/font-awesome.min.css', null,  FINANCE_THEME_VERSION, 'all' );
			wp_enqueue_style( 'strock-icon', get_template_directory_uri() . '/assets/css/strock-icon.css', null,  FINANCE_THEME_VERSION, 'all' );
			wp_enqueue_style( 'owl.carousel', get_template_directory_uri() . '/assets/css/owl.carousel.css', null,  FINANCE_THEME_VERSION, 'all' );
		
		/* ---------------------------------------------------------------------------
			* Gutenberg
			* --------------------------------------------------------------------------- */
			wp_enqueue_style( 'finance-googleapis','//fonts.googleapis.com/css?family=Playfair+Display:400,400i,700,700i,900,900i|Source+Sans+Pro:200,200i,300,300i,400,400i,600,600i,700,700i,900,900i', array(), null );
			wp_enqueue_style( 'finance-gutenberg', get_theme_file_uri('assets/css/gutenberg.css'), false, FINANCE_THEME_VERSION, 'all' );
			
			/* Register Scripts */
			
			wp_enqueue_script( 'libs', get_template_directory_uri() . '/assets/js/libs.js', array( 'jquery' ), NULL, NULL, true );	
			wp_enqueue_script( 'tether', get_template_directory_uri() . '/assets/js/tether.min.js', array( 'jquery' ), NULL, NULL, true );			
			wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array( 'jquery' ), NULL, NULL, true );	
			wp_enqueue_script( 'owl.carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array( 'jquery' ), NULL, NULL, true );				
			wp_enqueue_script( 'libs', get_template_directory_uri() . '/assets/js/libs.js', array( 'jquery' ), NULL, NULL, true );			
			wp_enqueue_script( 'jquery.mixitup', get_template_directory_uri() . '/assets/js/jquery.mixitup.min.js', array( 'jquery' ), NULL, NULL, true );	
			wp_enqueue_script( 'owl.carousel', get_template_directory_uri() . '/assets/js/owl.carousel.min.js', array( 'jquery' ), NULL, NULL, true );			
			wp_enqueue_script( 'countdown', get_template_directory_uri() . '/assets/js/countdown.js', array( 'jquery' ), NULL, NULL, true );	
			wp_enqueue_script( 'jquery.counterup', get_template_directory_uri() . '/assets/js/jquery.counterup.min.js', array( 'jquery' ), NULL, NULL, true );	
			wp_enqueue_script( 'waypoints', get_template_directory_uri() . '/assets/js/waypoints.min.js', array( 'jquery' ), NULL, NULL, true );	
			wp_enqueue_script( 'finance-custom', get_template_directory_uri() . '/assets/js/custom.js', array( 'jquery' ), NULL, NULL, true );	
			wp_enqueue_script( 'Chart', get_template_directory_uri() . '/assets/js/Chart.min.js', array( 'jquery' ), NULL, NULL, true );	
			
			/* Enqueue Scripts */
			
			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) 
			{
				wp_enqueue_script( 'comment-reply' );
			}
			
		}
	}
}
if( ! function_exists( 'finance_excerpt_more' ) )
{
	function finance_excerpt_more( $more ) 
	{
		return '';
	}
}
add_filter( 'excerpt_more', 'finance_excerpt_more' );

add_action( 'wp_head', 'finance_ajaxurl' );

if( ! function_exists( 'finance_ajaxurl' ) )
{
	function finance_ajaxurl() 
	{
		?>
		<script type="text/javascript">
			var ajaxurl = '<?php echo esc_url( admin_url('admin-ajax.php') ); ?>';
		</script>
		<?php
	}
}

// Google fonts
function finance_fonts_url() 
{
	$fonts_url = '';

	 /* Translators: If there are characters in your language that are not
	* supported by Open Sans, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$open_sans = _x( 'on', 'Open Sans font: on or off', 'finance' );

	 /* Translators: If there are characters in your language that are not
	* supported by Raleway, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$raleway = _x( 'on', 'Raleway font: on or off', 'finance' );
	   
	/* Translators: If there are characters in your language that are not
	* supported by Open Sans Condensed, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$open_sans_condensed = _x( 'on', 'Open Sans Condensed font: on or off', 'finance' );
	 
	 /* Translators: If there are characters in your language that are not
	* supported by Roboto, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$roboto = _x( 'on', 'Roboto font: on or off', 'finance' ); 

	 /* Translators: If there are characters in your language that are not
	* supported by PT+Serif, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$PTSerif = _x( 'on', 'PT Serif font: on or off', 'finance' ); 
	 
	if ( 'off' !== $raleway || 'off' !== $open_sans  ||  'off' !== $open_sans_condensed || 'off' !== $roboto || 'off' !== $PTSerif)
	{					
		$font_families = array();
		if ( 'off' !== $raleway )
		{
			$font_families[] = 'Raleway:400,100,200,300,500,600,800,700,900';
		}
		if ( 'off' !== $open_sans ) 
		{
			$font_families[] = 'Open Sans:400,300,300italic,400italic,600,600italic,700,700italic,800,800italic';
		}			
		if ( 'off' !== $open_sans_condensed ) 
		{
			$font_families[] = 'Open Sans Condensed:300,300italic,700';
		}
		if ( 'off' !== $roboto ) 
		{
			$font_families[] = 'Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900,900italic';
		}
		if ( 'off' !== $PTSerif ) 
		{
			$font_families[] = 'Open Sans|PT Serif|Roboto';
		}	
		$query_args = array(
							'family' => urlencode( implode( '|', $font_families ) ),
							'subset' => urlencode( 'latin,latin-ext' )
						);
		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}
	return esc_url_raw( $fonts_url );
}
function finance_scripts_styles() 
{
	wp_enqueue_style( 'fonts', finance_fonts_url(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'finance_scripts_styles' );

/**
 * Custom Css Backend.
 */
/*
function finance_custom_scripts_styles() 
{	
	global $finance_option;
	$custom_css = $finance_option['site_css'];
	$css = '';
	if ( $custom_css ) 
	{
		$css .= preg_replace( '/\s+/', ' ', $custom_css );
	}
	wp_add_inline_style( 'finance-style', $css );
}
add_action( 'wp_enqueue_scripts', 'finance_custom_scripts_styles' );
*/
//Default Home on breadcumb 
add_filter('bcn_breadcrumb_title', function($title, $type, $id) 
{
	if ($type[0] === 'home') 
	{
		$title = get_the_title(get_option('page_on_front'));
	}
	return $title;
}, 42, 3);

if( ! function_exists( 'finance_body_class' ) ) 
{
	function finance_body_class( $classes ) 
	{	
		global $finance_option;
		if(isset($finance_option['layout_style']) && $finance_option['layout_style'] == '2') 
		{ 
			$classes[] = 'layout-boxed';
		}			
		$classes[] = finance_get_header_style();					
		if(isset($finance_option['sticky_menu']) && $finance_option['sticky_menu'] == '1') 
		{ 
			$classes[] = 'sticky_menu';
		}
		return $classes;
	}
}
add_filter( 'body_class', 'finance_body_class' );
define( 'FINANCE_INC_PATH', get_template_directory() . '/inc' );
require_once( FINANCE_INC_PATH . '/theme-essential.php' );
require_once( FINANCE_INC_PATH . '/tgm/tgm-plugin-registration.php' );
require_once( FINANCE_INC_PATH . '/visual-composer.php' );

if ( !function_exists( 'finance_extended_import' ) ) 
{
 function finance_extended_import( $demo_active_import , $demo_directory_path ) 
 {
	reset( $demo_active_import );
	$current_key = key( $demo_active_import );

	/************************************************************************
	* Import slider(s) for the current demo being imported
	*************************************************************************/

	if ( class_exists( 'RevSlider' ) )
	{
		//If it's demo3 or demo5
		$wbc_sliders_array = array(
		'demo1' => 'home1.zip', //Set slider zip name
		'demo2' => 'home1.zip', //Set slider zip name
		'demo3' => 'home1.zip', //Set slider zip name
		'demo4' => 'home1.zip', //Set slider zip name
		'demo5' => 'home1.zip', //Set slider zip name
		);

	   if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_sliders_array ) ) 
		{
			$wbc_slider_import = $wbc_sliders_array[$demo_active_import[$current_key]['directory']];
			if ( file_exists( $demo_directory_path.$wbc_slider_import ) ) 
			{
				$slider = new RevSlider();
				$slider->importSliderFromPost( true, true, $demo_directory_path.$wbc_slider_import );
			}
		}
	}
  
  /************************************************************************
  * Setting Menus
  *************************************************************************/

  // If it's demo1 - demo6
  
    $wbc_menu_array = array( 'demo1','demo2','demo3','demo4','demo5');
	if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) 
	{
		$top_menu = get_term_by( 'name', 'Primary', 'nav_menu' );
		if ( isset( $top_menu->term_id ) ) 
		{
			set_theme_mod( 'nav_menu_locations', array(
														'finance-primary_menu' => $top_menu->term_id					   
													)
			);
		}
	}
  /************************************************************************
  * Set HomePage
  *************************************************************************/

  // array of demos/homepages to check/select from
  $wbc_home_pages = array(
							'demo1' => 'Home',
							'demo2' => 'Home',
							'demo3' => 'Home',
							'demo4' => 'Home',
							'demo5' => 'Home'
						);
  if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) 
  {
	$page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
	if ( isset( $page->ID ) ) 
	{
		update_option( 'page_on_front', $page->ID );
		update_option( 'show_on_front', 'page' );
	}
  }
 }
  add_action( 'wbc_importer_after_content_import', 'finance_extended_import', 10, 2 );
}
add_filter( 'woocommerce_page_title', 'custom_woocommerce_page_title');
function custom_woocommerce_page_title( $page_title ) 
{
    return "Featured Products";
}

	function tmc_theme_style() {
		wp_enqueue_style( 'theme-style', get_template_directory_uri() . '/assets/css/theme-style.css', null, null, 'all' );
	}
	add_action( 'admin_enqueue_scripts', 'tmc_theme_style' );

	add_action('admin_menu', 'tmc_check_theme_activate');
	function tmc_check_theme_activate()
	{
		add_theme_page('Theme Activate', 'Theme Activate', 'activate_plugins', 'tmc-theme-activate', 'tmc_theme_activate');
	}