<?php 
global $finance_option; ?>
<div class="header_top clearfix">
	<div class="container">
		<div class="logo">
			<?php 
				$logo = get_template_directory_uri() .'/assets/images/tmp/logo_default.png';
				if (isset( $finance_option['site_logo']['url'] ) ):
					?>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $finance_option['site_logo']['url'] ); ?>"  alt="<?php bloginfo( 'name' ); ?>" />
					</a>
					<?php 
				elseif($logo ): 
					?>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>" />
					</a>
					<?php
				else: 
					?>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?>
					</a>
		<?php 	endif; ?>
		</div>
		<!-- code for working hours section -->
		<?php 
			if( !empty( $finance_option['header_working_hours'] ) ) : ?>
			<div class="icon_text icon_working clearfix">
				<div class="icon">
					<i class="<?php echo esc_attr($finance_option['header_working_hours_icon']); ?>"></i>
				</div>
				<div class="text">
					<?php 
						echo wp_kses_post(  $finance_option['header_working_hours'] ); 
					?>
				</div>
			</div>
			<?php 
			endif; ?>
			<!-- code for phone section -->
			<?php 
				if( !empty( $finance_option['header_phone'] ) ):
					?>
					<div class="icon_text big clearfix">
						<div class="icon">
							<i class="<?php echo esc_attr($finance_option['header_phone_icon']); ?>"></i>
						</div>
						<div class="text">
							<?php 
								echo wp_kses_post( $finance_option['header_phone']  ); 
							?>
						</div>
					</div>
		<?php 	endif; ?>
				<!-- code for address section -->
				<?php 
					if( !empty($finance_option['header_address'] ) ): 
						?>
						<div class="icon_text clearfix">
							<div class="icon">
								<i class="<?php echo esc_attr($finance_option['header_address_icon']); ?>"></i>
							</div>
							<div class="text">
								<?php echo wp_kses_post( $finance_option['header_address'] ); ?>
							</div>
						</div>
			<?php 	endif; ?>
	</div>
</div>
<!-- code for menu -->					
<div class="top_nav tp-header-menufour">
	<div class="container">
		<div class="top_nav_wrapper clearfix">
			<?php
			wp_nav_menu( array(
								'menu_id' => 'Primary',
								'theme_location' => 'finance-primary_menu',
								'container'      => false,
								'depth'          => 3,
								'menu_class'     => 'main_menu_nav'
							)
						);
			if ( isset($finance_option['search_header'] ) && $finance_option['search_header'] == '1'): ?>
			<!-- code for search box -->
				<div class="nav-search pull-right text-right">
					<div class="widget-t widget-t-search">  
						<div class="widget-t-inner">      
							<?php get_search_form(); ?>
						</div>                                    
					</div>               
				</div> 
	<?php 	endif; ?>				
		</div>
	</div>
</div>