<?php
require get_template_directory() . '/inc/tgm/tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'tmc_require_plugins' );

function tmc_require_plugins()
{
	$plugins      = array(
		array(
            'name'               => 'TMC Data options',
            'slug'               => 'tmc-data-options', 
            'source'             => 'http://themechampion.com/demo/financelst/theme-assets/download.php?file=options&pur_code='.get_option('tmc_purchase_code'),
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
		array(
            'name'               => 'TMC Post Type',
            'slug'               => 'tmc-post-type', 
            'source'             => 'http://themechampion.com/demo/financelst/theme-assets/download.php?file=type&pur_code='.get_option('tmc_purchase_code'),
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
		
		array(
			'name'         => esc_html__('WPBakery Visual Composer','finance'),
			'slug'         => 'vc-composer',
			'source'             => 'http://www.themechampion.com/demo/financelst/theme-assets/download.php?file=composer&pur_code='.get_option('tmc_purchase_code'),
			'required'         => true,
			'force_activation'  => false,
			'force_deactivation' => false,
			'external_url' => esc_url('http://vc.wpbakery.com','finance'),
		),
		array(
			'name'         => esc_html__('Revolution Slider','finance'),
			'slug'         => 'revslider',
			'source'             => 'http://www.themechampion.com/demo/financelst/theme-assets/download.php?file=slider&pur_code='.get_option('tmc_purchase_code'),
			'required'         => true,
			'force_activation'  => false,
			'force_deactivation' => false,
			'external_url' => esc_url('http://www.themepunch.com/revolution/','finance'),
		),
		array(
			'name'     => esc_html__('Breadcrumb NavXT','finance'),
			'slug'     => 'breadcrumb-navxt',
			'required'         => true,
			'force_activation'  => false,
			'force_deactivation' => false,
		),
	
		array(
			'name'      => esc_html__('WooCommerce','finance'),
			'slug'      => 'woocommerce',
			'required'         => true,
			'force_activation'  => false,
			'force_deactivation' => false,
		),
		array(
			'name'     => esc_html__('MailChimp for WordPress Lite','finance'),
			'slug'     => 'mailchimp-for-wp',
			'required'         => true,
			'force_activation'  => false,
			'force_deactivation' => false,
		),		
		array(
			'name'     => esc_html__('Contact Form 7','finance'),
			'slug'     => 'contact-form-7',
			'required'         => true,
			'force_activation'  => false,
			'force_deactivation' => false,
		),
		array(
            'name'      => 'Redux Framework',
            'slug'      => 'redux-framework',
            'required'           => true,
			'force_activation'   => false,
            'force_deactivation' => false,
        ),
		array(
            'name'               => 'Envato Market',
            'slug'               => 'envato-market', 
            'source'             => 'http://envato.github.io/wp-envato-market/dist/envato-market.zip', 
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
	);
	tgmpa( $plugins, array( 'is_automatic' => true ) );
}
function tmc_theme_activate()
{
	if(isset($_POST['submit']))
	{
		$tmc_data = wp_remote_get(add_query_arg(array('entered_code' => $_POST['tmc_theme_key']), 'http://www.themechampion.com/demo/auth/check.php'), array('timeout' => 20));
		
		$tmc_valid_data = json_decode($tmc_data['body']);
		
		if($tmc_valid_data->status)
		{
			update_option('tmc_activation', 1);
			update_option('tmc_purchase_code', $_POST['tmc_theme_key']);
		}
	}
?>
	<div class="header_section">
	   <div class="container">
		 <div class="row">
			 <div class="content">
				<img src="<?php echo get_template_directory_uri().'/assets/images/tmp/logo_default.png'?>">
				<h3><?php echo esc_html_x('Welcome to '.wp_get_theme().' - Best design to you','finance'); ?></h3>
				
				<?php
				if(!get_option('tmc_activation'))
				{ 
				?>
				<p><?php echo esc_attr('Thank you for purchasing '.wp_get_theme().'! To import data and all plugins. Please activate your Theme.','finance'); ?></p>
				<form method="POST">
					<div class="form-group">	
						<input type="text" class="form-control" name="tmc_theme_key" id="tmc_theme_key" placeholder="<?php esc_html__( 'Enter purchase key, e.g. ab0yonv8-ww2po', 'finance' ); ?>" value="<?php if(isset($_POST['tmc_theme_key'])){ echo esc_attr($_POST['tmc_theme_key']); } ?>" required />
						<button type="submit" class="btn btn-primary" name="submit"><?php echo esc_html__( 'Activate','finance');?></button>
					</div>
				 </form>
				<?php
				}
				else if(!isset($_POST['submit']))
				{
					?>
					<h2><?php echo esc_attr('Thank you for purchasing '.wp_get_theme().'! Your WP theme is alredy activated.','finance');?></h2>
				<?php	
				}
				?> 
			 </div>
			 <?php
				if(isset($_POST['submit']))
				{
					if(get_option('tmc_activation'))
					{
					?>
						<p class="theme-p green"> 
						<?php echo esc_html__('Thank you, your purchase code is valid and theme has been activated.', 'finance'); ?> 
						</p>
			<?php	}
					else
					{ ?>
						<p class="theme-p red"> 
							<?php echo esc_html__('Oops, your purchase code is not valid. Please enter corerct code and try again !!!', 'finance'); ?> 
						</p>
			<?php	} 
				} ?>
		   </div>
	   </div>
   </div>
	<?php
}

function tmc_is_theme_activate($arg) 
{
	if(!get_option('tmc_activation'))
	{
		return new WP_Error('tmc_key_empty', sprintf(wp_kses('Theme is not activated yet. Use theme purchase code to <a href="%s">Activate '.wp_get_theme().'</a>','finance'),esc_url(admin_url('themes.php?page=tmc-theme-activate'))));
	}
	return $arg;
}
add_filter('upgrader_pre_download', 'tmc_is_theme_activate', 10, 1);