<?php
	// Header function
	if ( ! function_exists( 'finance_get_header' ) ) 
	{
		function finance_get_header() 
		{
			$header = '';
			return get_header($header);
		}
	}
	// Comment Section
	function tmc_wp_move_comment_field_to_bottom( $fields )
	{
		$comment_field = $fields['comment'];
		unset( $fields['comment'] );
		$fields['comment'] = $comment_field;
		return $fields;
	}
	add_filter( 'comment_form_fields', 'tmc_wp_move_comment_field_to_bottom' );
	// To Add Place holders
	add_filter( 'comment_form_default_fields', 'tmc_wp_comment_placeholders' );
	function tmc_wp_comment_placeholders( $fields )
	{
		$fields['author'] = str_replace('<input','<input placeholder="'.__('Enter your name','finance'). '"', $fields['author'] );	
		$fields['email'] = str_replace('<input','<input placeholder="'. __('Enter your email','finance'). '"',$fields['email']);	
		return $fields;
	}
	add_filter( 'comment_form_defaults', 'tmc_wp_textarea_insert' );
	function tmc_wp_textarea_insert( $fields )
	{
		$fields['comment_field'] = str_replace('<textarea','<textarea placeholder="'.__('Write Comment','finance'). '"',$fields['comment_field']);	
		return $fields;
	}
	// To remove Website field
	function tmc_alter_comment_form_fields($fields)
	{
		$fields['url'] = '';  //removes website field
		return $fields;
	}
	add_filter('comment_form_default_fields','tmc_alter_comment_form_fields');
	if ( ! function_exists( 'finance_comment' ) ) :
		/**
		 * Template for comments and pingbacks.
		 *
		 * To override this walker in a child theme without modifying the comments template
		 * simply create your own finance_comment(), and that function will be used instead.
		 *
		 * Used as a callback by wp_list_comments() for displaying the comments.
		 *
		 * @return void
		 */
	function finance_comment( $comment, $args, $depth ) 
	{
		$GLOBALS['comment'] = $comment;
		switch ( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
			// Display trackbacks differently than normal comments.
			?>
			<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
				<p>
					<?php esc_html__( 'Pingback:', 'finance' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( '(Edit)', 'finance' ), '<span class="edit-link">', '</span>' ); ?>
				</p>
			<?php
			break;
			default :
			// Proceed with normal comments.
			global $post;
			?>
			<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
			<article id="comment-<?php comment_ID(); ?>" class="comment clearfix">
				<?php 
					echo get_avatar( $comment, 60 );
				?>
				<div class="comment-wrapper">
					<header class="comment-meta comment-author vcard">
						<?php
							printf( '<cite><b class="fn">%1$s</b>%2$s</cite>',
								get_comment_author_link(),
								// If current post author is also comment author, make it known visually.
								( $comment->user_id === $post->post_author ) ? '<span>' . __( 'Post author', 'finance' ) . '</span>' : ''
							);
							printf( '<a class="comment-time" href="%1$s"><time datetime="%2$s">%3$s</time></a>',
								esc_url( get_comment_link( $comment->comment_ID ) ),
								get_comment_time( 'c' ),
								/* translators: 1: date, 2: time */
								sprintf( __( '%1$s', 'finance' ), get_comment_date() )
							);
							comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'Reply', 'finance' ), 'after' => '', 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) );
							edit_comment_link( __( 'Edit', 'finance' ), '<span class="edit-link">', '</span>' );
						?>
					</header><!-- .comment-meta -->
					<?php 
						if ( '0' == $comment->comment_approved ) : ?>
						<p class="comment-awaiting-moderation">
							<?php esc_html__( 'Your comment is awaiting moderation.', 'finance' ); ?>
						</p>
					<?php endif; ?>
					<div class="comment-content entry-content">
						<?php comment_text();  ?>
					</div><!-- .comment-content -->

				</div><!--/comment-wrapper-->

			</article><!-- #comment-## -->
		<?php
			break;
		endswitch; // end comment_type check
	}
	endif;
	/**
	 * Automatic theme updates notifications
	 *
	 */
	if ( ! function_exists( 'finance_updater' ) ) 
	{
		function finance_updater()
		{
			global $finance_option;
			if ( isset( $finance_option['tf_username'] ) && trim( $finance_option['tf_username'] ) != '' ) 
			{
				if ( isset( $finance_option['tf_api'] ) && trim( $finance_option['tf_api'] ) != '' )
				{
					load_template( get_template_directory() . '/inc/updater/envato-theme-update.php' );
					if ( class_exists( 'Envato_Theme_Updater' ) ) 
					{
						Envato_Theme_Updater::init( $username, $api_key, 'finance' );
					}
				}
			}
		}
		add_action( 'after_setup_theme', 'finance_updater' );
	}
	function finance_header_layout($header_style)
	{	
		switch($header_style) 
		{	
			case 'tmc_header_1':
				get_template_part( 'header/header_style1' );
				break;
			case 'tmc_header_2':
				get_template_part( 'header/header_style2' );
				break;					 
			case 'tmc_header_3':			 
				get_template_part( 'header/header_style3' );
				break;	
			case 'tmc_header_5':
				get_template_part( 'header/header_style5' );
				break;	
			default:
				// header style 4
				get_template_part( 'header/header_style4' );
				break; 
		} 	
	}
	if ( ! function_exists( 'finance_get_header_style' ) ) 
	{
		function finance_get_header_style() 
		{
			global $finance_option;
			if(!empty($finance_option['header_style'])) 
			{
				$header_style = $finance_option['header_style'];
			}		
			else 
			{
				$header_style= 'tmc_header_4';
			}
			return $header_style;
		}
	}
	if ( ! function_exists( 'finance_get_socials' ) ) 
	{
		function finance_get_socials( $type ) 
		{
			global $finance_option;
			$socials_array  = array();
			$socials_enable = $finance_option['footer_social'];
			if($socials_enable)
			{	
				if($finance_option['twitter-value'])
				{
					$socials_array['twitter'] = $finance_option['twitter-value'];				
				}
				if($finance_option['facebook-value'])
				{
					$socials_array['facebook'] = $finance_option['facebook-value'];
				}									
				if($finance_option['linkedin-value'])
				{
					$socials_array['linkedin'] = $finance_option['linkedin-value'];
				}				
				if($finance_option['pinterest-value'])
				{
					$socials_array['pinterest'] = $finance_option['pinterest-value'];
				}				
				if($finance_option['google-value'])
				{
					$socials_array['google'] = $finance_option['google-value'];
				}
				if($finance_option['instagram-value'])
				{
					$socials_array['instagram'] = $finance_option['instagram-value'];
				}									
				if($finance_option['yelp-value'])
				{
					$socials_array['yelp'] = $finance_option['yelp-value'];
				}					
				if($finance_option['foursquare-value'])
				{
					$socials_array['foursquare'] = $finance_option['foursquare-value'];
				}													
				if($finance_option['flickr-value'])
				{
					$socials_array['flickr'] = $finance_option['flickr-value'];
				}		
				if($finance_option['youtube-value'])
				{
					$socials_array['youtube'] = $finance_option['youtube-value'];
				}									
				if($finance_option['email-value'])
				{
					$socials_array['email'] = $finance_option['email-value'];
				}									
				if($finance_option['rss-value'])
				{
					$socials_array['rss'] = $finance_option['rss-value'];
				}						
				return $socials_array;
			}
		}
	}
	if ( ! function_exists( 'finance_page_title' ) ) 
	{
		function finance_page_title( $display = true, $single_posts = '', $vacancies_posts = '' ) 
		{
			global $wp_locale;
			$title    = '';
			// If there is a post
			if ( is_single() || ( is_home() && ! is_front_page() ) || ( is_page() && ! is_front_page() ) || is_front_page() ) 
			{
				$title = single_post_title( '', false );
			}
			if ( is_home() ) 
			{
				if ( ! get_option( 'page_for_posts' ) ) 
				{
					$title = $single_posts;
				}
			}
			// If there's a post type archive
			if ( is_post_type_archive() ) 
			{
				$post_type = get_query_var( 'post_type' );
				if ( is_array( $post_type ) ) 
				{
					$post_type = reset( $post_type );
				}
				$post_type_object = get_post_type_object( $post_type );
				if ( ! $post_type_object->has_archive ) 
				{
					$title = post_type_archive_title( '', false );
				}
			}
			// If there's a category or tag
			if ( is_category() || is_tag() ) 
			{
				$title = single_term_title( '', false );
			}
			// If there's a taxonomy
			if ( is_tax() ) 
			{
				$term = get_queried_object();
				if ( $term ) 
				{
					$tax   = get_taxonomy( $term->taxonomy );
					$title = single_term_title( '', false );
				}
			}
			// If there's an author
			if ( is_author() && ! is_post_type_archive() ) 
			{
				$author = get_queried_object();
				if ( $author )
				{
					$title = $author->display_name;
				}
			}
			// Post type archives with has_archive should override terms.
			if ( is_post_type_archive() && $post_type_object->has_archive ) 
			{
				if ( function_exists( 'is_shop' ) && is_shop() ) 
				{
					$title = get_the_title( get_option( 'woocommerce_shop_page_id' ) );
				} 
				else 
				{
					$title = post_type_archive_title( '', false );
				}
			}
			// If it's a search
			if ( is_search() ) 
			{
				/* translators: 1: separator, 2: search phrase */
				$title = esc_html__( 'Search Results', 'finance' );
			}
			// If it's a 404 page
			if ( is_404() ) 
			{
				$title = esc_html__( 'Page not found', 'finance' );
			}
			if ( $display ) 
			{
				echo esc_html( $title );
			} 
			else 
			{
				return esc_html( $title );
			}
		}
	}
	function header_page_title()
	{
		$post_id        = get_the_ID();
		$is_shop        = false;
		$is_product     = false;
		global $finance_option;
		global $post;
		
		$tmc_post_type = get_post_type($post);

		$page_for_posts = get_option( 'page_for_posts' );
		if ( is_home() || is_category() || is_search() || is_tag() || is_tax() ) 
		{
			$post_id = $page_for_posts;
		}
		if ( ( function_exists( 'is_shop' ) && is_shop() )
			 || ( function_exists( 'is_product_category' ) && is_product_category() )
			 || ( function_exists( 'is_product_tag' ) && is_product_tag() )
		) 
		{
			$is_shop = true;
		}
		if ( function_exists( 'is_product' ) && is_product() ) 
		{
			$is_product = true;
		}
		if ( $is_shop ) 
		{
			$post_id = get_option( 'woocommerce_shop_page_id' );
		}
		$class = 'page_title';
		if ( get_post_meta( $post_id, 'enable_transparent', true ) ) 
		{
			$class .= ' transparent';
		}
		if ( get_post_meta( $post_id, 'disable_title', true ) ) 
		{
			$class .= ' disable_title';
		}
		if (isset($finance_option['image_switch']) && $finance_option['image_switch'] == '1')
		{
			if ( ! get_post_meta( $post_id, 'disable_title_box', true ) ): 
				if( isset($finance_option['header_background']['url']) && isset($finance_option['header_style']) && ($finance_option['header_style'] == 'tmc_header_4') )
				{
					$inner_background = $finance_option['header_background']['url'];
				}
				else if( isset($finance_option['header_background1']['url']) && isset($finance_option['header_style']) && ($finance_option['header_style'] == 'tmc_header_1') )
				{
					$inner_background = $finance_option['header_background1']['url'];
				}
				else if( isset($finance_option['header_background2']['url']) && isset($finance_option['header_style']) && ($finance_option['header_style'] == 'tmc_header_2') )
				{
					$inner_background = $finance_option['header_background2']['url'];
				}
				else if( isset($finance_option['header_background3']['url']) && isset($finance_option['header_style']) && ($finance_option['header_style'] == 'tmc_header_3') )
				{
					$inner_background = $finance_option['header_background3']['url'];
				}
				else if( isset($finance_option['header_background5']['url']) && isset($finance_option['header_style']) && ($finance_option['header_style'] == 'tmc_header_5') )
				{
					$inner_background = $finance_option['header_background5']['url'];
				}
				else
				{
					$inner_background = get_template_directory_uri() . '/assets/images/bg/inner-banner4.jpg';
				}
			
				?>		
		<div class="<?php echo esc_attr( $class ); ?>"  style="background-image:url(  <?php echo esc_url($inner_background); ?> )">	
				<?php
			endif;
		}
		if (isset($finance_option['title_switch']) && $finance_option['title_switch'] == '1')
		{ 	?>
			<div class="container">				
					<?php 
						if( finance_page_title( false ) ): 
							if ( ( function_exists( 'is_shop' ) && is_shop() )) 
							{ 
									?>
									<h1 class="h2">
										<?php echo esc_attr($finance_option['woocommerce_title']); ?>
									</h1>
					<?php 		  
							} 
							else if($tmc_post_type == 'post') 
							{ 
								?>
									<h1 class="h2">
										<?php echo esc_attr($finance_option['blog_title']); ?>
									</h1>
					<?php		
							} 
							else 
							{ 
								 ?>												
									<h1 class="h2">
										<?php echo finance_page_title( false ); ?>
									</h1>
					<?php 		 
							}
							if((finance_get_header_style() == 'tmc_header_1')) 
							{	
						
							}
							elseif((finance_get_header_style() == 'tmc_header_3')) 
							{ 

							} 
							elseif((finance_get_header_style() == 'tmc_header_5')) 
							{
								
							} 
							else
							{ 	?>
								<p class="page-subtitle"><?php  echo get_post_meta(get_the_ID(), '_tmc_page_title', true); ?>
								</p>
								<?php 
							} 
							 ?>
							
					<?php 	endif; 
		}
		if (isset($finance_option['breadcrumb_switch']) && $finance_option['breadcrumb_switch'] == '1')
		{ 		
			if((finance_get_header_style() == 'tmc_header_1') || (finance_get_header_style() == 'tmc_header_3')) 
			{ 
				finance_breadcrumbs();
			}  
		}		
		?>
		</div>
		</div>
		<?php 	 
		if (isset($finance_option['breadcrumb_switch']) && $finance_option['breadcrumb_switch'] == '1')
		{ 			
			if((finance_get_header_style() == 'tmc_header_2') || (finance_get_header_style() == 'tmc_header_4') || (finance_get_header_style() == 'tmc_header_5'))
			{
				finance_breadcrumbs();
			}					
		} 
	}
	if ( ! function_exists( 'finance_get_structure' ) ) 
	{
		function finance_get_structure( $sidebar_id, $sidebar_type, $sidebar_position, $layout = false ) 
		{
			$output                   = array();
			$output['content_before'] = $output['content_after'] = $output['sidebar_before'] = $output['sidebar_after'] = '';
			if ( $sidebar_type == 'vc' ) 
			{
				if ( $sidebar_id ) 
				{
					$sidebar = get_post( $sidebar_id );
				}
			} 
			else 
			{
				if ( $sidebar_id ) 
				{
					$sidebar = true;
				}
			}
			if ( $sidebar_position == 'right' && isset( $sidebar ) ) 
			{
				$output['content_before'] .= '<div class="row"><div class="col-lg-8 col-md-8 col-sm-12 col-xs-12"><div class="right-sidebar sidebar-container">';
				$output['content_after'] .= '</div></div>';
				$output['sidebar_before'] .= '<div class="col-lg-4 col-md-4">';
				$output['sidebar_after'] .= '</div></div>';
			}
			if ( $sidebar_position == 'left' && isset( $sidebar ) ) 
			{
				$output['content_before'] .= '<div class="row"><div class="col-lg-8 col-lg-push-4 col-md-8 col-md-push-4 col-sm-12 col-xs-12 sidebar-container"><div class="left-sidebar">';

				$output['content_after'] .= '</div></div>';
				$output['sidebar_before'] .= '<div class="col-lg-4 col-lg-pull-8 col-md-4 col-md-pull-8 ">';
				$output['sidebar_after'] .= '</div></div>';
			}
			if ( $sidebar_position == 'no_sidebar' && isset( $sidebar ) ) 
			{
				$output['content_before'] .= '<div class="row"><div class="col-sm-12 col-xs-12 sidebar-container"><div class="no-sidebar">';

				$output['content_after'] .= '</div></div></div>';
			}
			return $output;
		}
	}
	if ( ! function_exists( 'finance_breadcrumbs' ) ) 
	{
		function finance_breadcrumbs() 
		{
			if ( function_exists( 'bcn_display' ) && ! get_post_meta( get_the_ID(), 'disable_breadcrumbs', true ) ) 
			{ 
				if ((finance_get_header_style() == 'tmc_header_2') || (finance_get_header_style() == 'tmc_header_4') || (finance_get_header_style() == 'tmc_header_5')): ?>
					<div class="bread-cumb">
						<div class="container">
							<?php bcn_display(); ?>
						</div>
					</div>
					<?php 
				else: ?>
					<div class="bread-cumb2">
							<?php bcn_display(); ?>
					</div>
				<?php 
				endif; 
			}
		}
	}