<?php
if ( function_exists( 'vc_set_default_editor_post_types' ) ) {
	vc_set_default_editor_post_types( array('page','post','team','projects','sidebar','services',
	) );
}

add_action( 'vc_before_init', 'finance_vc_set_as_theme' );
if( ! function_exists( 'finance_vc_set_as_theme' ) ) {
	function finance_vc_set_as_theme() {
		vc_set_as_theme( true );
	}
}

if( ! function_exists( 'finance_animator_param' ) ){
	function finance_animator_param( $settings, $value ) {
		global $wp_filesystem;

		if ( empty( $wp_filesystem ) ) {
			require_once ABSPATH . '/wp-admin/includes/file.php';
			WP_Filesystem();
		}
		$param_name = isset( $settings['param_name'] ) ? $settings['param_name'] : '';
		$type       = isset( $settings['type'] ) ? $settings['type'] : '';
		$class      = isset( $settings['class'] ) ? $settings['class'] : '';
		$animations = json_decode( $wp_filesystem->get_contents( get_template_directory() . '/assets/js/animate-config.json' ), true );
		if ( $animations ) {
			$output = '<select name="' . esc_attr( $param_name ) . '" class="wpb_vc_param_value ' . esc_attr( $param_name . ' ' . $type . ' ' . $class ) . '">';
			foreach ( $animations as $key => $val ) {
				if ( is_array( $val ) ) {
					$labels = str_replace( '_', ' ', $key );
					$output .= '<optgroup label="' . ucwords( esc_attr( $labels ) ) . '">';
					foreach ( $val as $label => $style ) {
						$label = str_replace( '_', ' ', $label );
						if ( $label == $value ) {
							$output .= '<option selected value="' . esc_attr( $label ) . '">' . esc_html( $label ) . '</option>';
						} else {
							$output .= '<option value="' . esc_attr( $label ) . '">' . esc_html( $label ) . '</option>';
						}
					}
				} else {
					if ( $key == $value ) {
						$output .= "<option selected value=" . esc_attr( $key ) . ">" . esc_html( $key ) . "</option>";
					} else {
						$output .= "<option value=" . esc_attr( $key ) . ">" . esc_html( $key ) . "</option>";
					}
				}
			}

			$output .= '</select>';
		}

		return $output;
	}
}

add_action( 'admin_init', 'finance_update_existing_shortcodes' );

if ( ! function_exists( 'finance_update_existing_shortcodes' ) ) {
	function finance_update_existing_shortcodes() {

		if ( function_exists( 'vc_add_params' ) ) {

			vc_add_params( 'vc_gallery', array(
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Gallery type', 'finance' ),
					'param_name' => 'type',
					'value'      => array(
						__( 'Image grid', 'finance' )     => 'image_grid',
						__( 'Slick slider', 'finance' )   => 'slick_slider',
						__( 'Slick slider 2', 'finance' ) => 'slick_slider_2'
					)
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Thumbnail size', 'finance' ),
					'param_name' => 'thumbnail_size',
					'dependency' => array(
						'element' => 'type',
						'value'   => array( 'slick_slider_2' )
					),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			) );

			vc_add_params( 'vc_column_inner', array(
				array(
					'type'        => 'column_offset',
					'heading'     => esc_html__( 'Responsiveness', 'finance' ),
					'param_name'  => 'offset',
					'group'       => esc_html__( 'Width & Responsiveness', 'finance' ),
					'description' => esc_html__( 'Adjust column for different screen sizes. Control width, offset and visibility settings.', 'finance' )
				)
			) );

			vc_add_params( 'vc_separator', array(
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Type', 'finance' ),
					'param_name' => 'type',
					'value'      => array(
						esc_html__( 'Type 1', 'finance' ) => 'type_1',
						esc_html__( 'Type 2', 'finance' ) => 'type_2'
					)
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				),
			) );

			vc_add_params( 'vc_video', array(
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Video Width', 'finance' ),
					'param_name' => 'size'
				),
				array(
					'type'       => 'attach_image',
					'heading'    => esc_html__( 'Preview Image', 'finance' ),
					'param_name' => 'image'
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Image Size', 'finance' ),
					'param_name'  => 'img_size',
					'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "projects_gallery" size.', 'finance' )
				),
			) );

			vc_add_params( 'vc_wp_pages', array(
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			) );

			vc_add_params( 'vc_custom_heading', array(
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'finance' ),
					'param_name' => 'icon',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Icon Size (px)', 'finance' ),
					'param_name' => 'icon_size',
					'value'      => '',
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon - Position', 'finance' ),
					'param_name' => 'icon_pos',
					'value'      => array(
						esc_html__( 'Left', 'finance' ) => '',
						esc_html__( 'Right', 'finance' ) => 'right',
						esc_html__( 'Top', 'finance' ) => 'top',
						esc_html__( 'Bottom', 'finance' ) => 'bottom'
					),
					'weight'     => 1
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Subtitle', 'finance' ),
					'param_name' => 'subtitle',
					'weight'     => 1
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Subtitle - Color', 'finance' ),
					'param_name' => 'subtitle_color',
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Stripe - Position', 'finance' ),
					'param_name' => 'stripe_pos',
					'value'      => array(
						esc_html__( 'Bottom', 'finance' ) => 'bottom',
						esc_html__( 'Between Title and Subtitle', 'finance' ) => 'between',
						esc_html__( 'Hide', 'finance' ) => 'hide'
					),
					'weight'     => 1
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Font weight', 'finance' ),
					'param_name' => 'tmc_title_font_weight',
					'value'      => array(
						esc_html__( 'Select', 'finance' )    => '',
						esc_html__( 'Thin', 'finance' )      => 100,
						esc_html__( 'Light', 'finance' )     => 300,
						esc_html__( 'Regular', 'finance' )   => 400,
						esc_html__( 'Medium', 'finance' )    => 500,
						esc_html__( 'Semi-bold', 'finance' ) => 600,
						esc_html__( 'Bold', 'finance' )      => 700,
						esc_html__( 'Black', 'finance' )     => 900
					),
					'weight'     => 1
				)
			) );

			vc_add_params( 'vc_basic_grid', array(
				array(
					'type'             => 'dropdown',
					'heading'          => esc_html__( 'Gap', 'finance' ),
					'param_name'       => 'gap',
					'value'            => array(
						esc_html__( '0px', 'finance' )  => '0',
						esc_html__( '1px', 'finance' )  => '1',
						esc_html__( '2px', 'finance' )  => '2',
						esc_html__( '3px', 'finance' )  => '3',
						esc_html__( '4px', 'finance' )  => '4',
						esc_html__( '5px', 'finance' )  => '5',
						esc_html__( '10px', 'finance' ) => '10',
						esc_html__( '15px', 'finance' ) => '15',
						esc_html__( '20px', 'finance' ) => '20',
						esc_html__( '25px', 'finance' ) => '25',
						esc_html__( '30px', 'finance' ) => '30',
						esc_html__( '35px', 'finance' ) => '35',
						esc_html__( '40px', 'finance' ) => '40',
						esc_html__( '45px', 'finance' ) => '45',
						esc_html__( '50px', 'finance' ) => '50',
						esc_html__( '55px', 'finance' ) => '55',
						esc_html__( '60px', 'finance' ) => '60',
					),
					'std'              => '30',
					'description'      => esc_html__( 'Select gap between grid elements.', 'finance' ),
					'edit_field_class' => 'vc_col-sm-6 vc_column',
				)
			) );

			vc_add_params( 'vc_btn', array(
				array(
					'type'               => 'dropdown',
					'heading'            => esc_html__( 'Color', 'finance' ),
					'param_name'         => 'color',
					'description'        => esc_html__( 'Select button color.', 'finance' ),
					'param_holder_class' => 'vc_colored-dropdown vc_btn3-colored-dropdown',
					'value'              => array(
						                        esc_html__( 'Theme Style 1', 'finance' )     => 'theme_style_1',
						                        esc_html__( 'Theme Style 2', 'finance' )     => 'theme_style_2',
						                        esc_html__( 'Theme Style 3', 'finance' )     => 'theme_style_3',
						                        esc_html__( 'Theme Style 4', 'finance' )     => 'theme_style_4',
						                        esc_html__( 'Classic Grey', 'finance' )      => 'default',
						                        esc_html__( 'Classic Blue', 'finance' )      => 'primary',
						                        esc_html__( 'Classic Turquoise', 'finance' ) => 'info',
						                        esc_html__( 'Classic Green', 'finance' )     => 'success',
						                        esc_html__( 'Classic Orange', 'finance' )    => 'warning',
						                        esc_html__( 'Classic Red', 'finance' )       => 'danger',
						                        esc_html__( 'Classic Black', 'finance' )     => 'inverse',
					                        ) + vc_get_shared( 'colors-dashed' ),
					'std'                => 'grey',
					'dependency'         => array(
						'element'            => 'style',
						'value_not_equal_to' => array( 'custom', 'outline-custom' ),
					),
				)
			) );

		}

	}
}

if ( function_exists( 'vc_map' ) ) {
	add_action( 'init', 'finance_vc_elements' );
}

if ( ! function_exists( 'finance_vc_elements' ) ) {
	function finance_vc_elements() {

		$project_categories_array = get_terms( 'project_category' );
		$project_categories       = array(
			esc_html__( 'All', 'finance' ) => 'all'
		);
		if ( $project_categories_array && ! is_wp_error( $project_categories_array ) ) {
			foreach ( $project_categories_array as $cat ) {
				$project_categories[ $cat->name ] = $cat->slug;
			}
		}

		vc_map( array(
			'name'     => esc_html__( 'Contacts', 'finance' ),
			'base'     => 'tmc_contacts_widget',
			'category' => esc_html__( 'TMC', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Style', 'finance' ),
					'param_name' => 'style',
					'value'      => array(
						esc_html__( 'Style 1', 'finance' ) => 'style_1',
						esc_html__( 'Style 2', 'finance' ) => 'style_2',
						esc_html__( 'Style 3', 'finance' ) => 'style_3'
					),
				),
				array(
					'type'       => 'textfield',
					'holder'     => 'div',
					'heading'    => esc_html__( 'Title', 'finance' ),
					'param_name' => 'title',
					'dependency' => array('element' => 'style', 'value' => array('style_1'))
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Address', 'finance' ),
					'param_name' => 'address',
					'dependency' => array('element' => 'style', 'value' => array('style_1', 'style_3'))
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Phone', 'finance' ),
					'param_name' => 'phone',
					'dependency' => array('element' => 'style', 'value' => array('style_1', 'style_2'))
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Phone', 'finance' ),
					'param_name' => 'phones',
					'dependency' => array('element' => 'style', 'value' => array('style_3'))
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Email', 'finance' ),
					'param_name' => 'email'
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'Schedule', 'finance' ),
					'param_name' => 'schedule',
					'dependency' => array('element' => 'style', 'value' => array('style_3'))
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Facebook', 'finance' ),
					'param_name' => 'facebook',
					'dependency' => array('element' => 'style', 'value' => array('style_1'))
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Twitter', 'finance' ),
					'param_name' => 'twitter',
					'dependency' => array('element' => 'style', 'value' => array('style_1'))
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Linkedin', 'finance' ),
					'param_name' => 'linkedin',
					'dependency' => array('element' => 'style', 'value' => array('style_1'))
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Google+', 'finance' ),
					'param_name' => 'google_plus',
					'dependency' => array('element' => 'style', 'value' => array('style_1'))
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Skype', 'finance' ),
					'param_name' => 'skype',
					'dependency' => array('element' => 'style', 'value' => array('style_1'))
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Extra class name', 'finance' ),
					'param_name'  => 'class',
					'value'       => '',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			)
		) );

		vc_map( array(
			'name'     => esc_html__( 'Info Box', 'finance' ),
			'base'     => 'tmc_info_box',
			'category' => esc_html__( 'TMC', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'textfield',
					'holder'     => 'div',
					'heading'    => esc_html__( 'Title', 'finance' ),
					'param_name' => 'title'
				),
				array(
					'type'       => 'attach_image',
					'heading'    => esc_html__( 'Image', 'finance' ),
					'param_name' => 'image',
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style_1', 'style_2', 'style_3', 'style_4' )
					)
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Image Size', 'finance' ),
					'param_name' => 'vc_image_size',
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style_1', 'style_2', 'style_3', 'style_4' )
					),
					'description' => esc_html__( 'Example: Text - full, large, medium, Number - 340x200', 'finance' ),
				),
				array(
					'type'       => 'checkbox',
					'heading'    => esc_html__( 'Align Center', 'finance' ),
					'param_name' => 'align_center',
					'value'      => array(
						esc_html__( 'Yes', 'finance' ) => 'yes'
					),
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Style', 'finance' ),
					'param_name' => 'style',
					'value'      => array(
						esc_html__( 'Style 1', 'finance' ) => 'style_1',
						esc_html__( 'Style 2', 'finance' ) => 'style_2',
						esc_html__( 'Style 3', 'finance' ) => 'style_3',
						esc_html__( 'Style 4', 'finance' ) => 'style_4',
						esc_html__( 'Style 5', 'finance' ) => 'style_5',
						esc_html__( 'Style 6', 'finance' ) => 'style_6'
					),
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Title Icon', 'finance' ),
					'param_name' => 'title_icon',
					'value'      => '',
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style_3', 'style_6' )
					)
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Icon - Size', 'finance' ),
					'param_name' => 'title_icon_size',
					'description' => esc_html__( 'Enter icon size in "px"', 'finance'),
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style_6' )
					)
				),
				array(
					'type'       => 'textarea_html',
					'heading'    => esc_html__( 'Text', 'finance' ),
					'param_name' => 'content'
				),
				array(
					'type'       => 'vc_link',
					'heading'    => esc_html__( 'Link', 'finance' ),
					'param_name' => 'link'
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Link Icon', 'finance' ),
					'param_name' => 'icon',
					'value'      => '',
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'style_1', 'style_2', 'style_3', 'style_5', 'style_6' )
					)
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			)
		) );

		vc_map( array(
			'name'     => esc_html__( 'Icon Box', 'finance' ),
			'base'     => 'tmc_icon_box',
			'category' => esc_html__( 'TMC', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Style', 'finance' ),
					'param_name' => 'box_style',
					'value'      => array(
						esc_html__( 'Style 1', 'finance' ) => 'style_1',
						esc_html__( 'Style 2', 'finance' ) => 'style_2'
					)
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Alignment', 'finance' ),
					'param_name' => 'alignment',
					'value'      => array(
						esc_html__( 'Left', 'finance' )   => 'left',
						esc_html__( 'Right', 'finance' )  => 'right',
						esc_html__( 'Center', 'finance' ) => 'center'
					),
					'dependency' => array('element' => 'box_style', 'value' => 'style_2')
				),
				array(
					'type'       => 'textarea',
					'holder'     => 'div',
					'heading'    => esc_html__( 'Title', 'finance' ),
					'param_name' => 'title'
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title - Font size', 'finance' ),
					'param_name'  => 'title_font_size',
					'description' => esc_html__( 'Enter font size in px', 'finance' )
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Title - Line Height', 'finance' ),
					'param_name'  => 'title_line_height',
					'description' => esc_html__( 'Enter line-height in px', 'finance' )
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Title - Color', 'finance' ),
					'param_name' => 'title_color',
					'value'      => array(
						esc_html__( 'Base', 'finance' ) => 'base',
						esc_html__( 'Secondary', 'finance' ) => 'secondary',
						esc_html__( 'Third', 'finance' ) => 'third',
						esc_html__( 'Custom', 'finance' ) => 'custom'
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Title - Color Custom', 'finance' ),
					'param_name' => 'title_color_custom',
					'dependency' => array('element' => 'title_color', 'value' => 'custom')
				),
				array(
					'type'       => 'checkbox',
					'heading'    => '',
					'param_name' => 'hide_title_line',
					'value'      => array(
						esc_html__( 'Hide Title Line', 'finance' ) => 'hide_title_line'
					),
					'dependency' => array('element' => 'box_style', 'value' => 'style_1')
				),
				array(
					'type'       => 'checkbox',
					'heading'    => '',
					'param_name' => 'enable_hexagon',
					'value'      => array(
						esc_html__( 'Enable Hexagon', 'finance' ) => 'enable'
					),
					'dependency' => array('element' => 'box_style', 'value' => 'style_1')
				),
				array(
					'type'       => 'checkbox',
					'heading'    => '',
					'param_name' => 'enable_hexagon_animation',
					'value'      => array(
						esc_html__( 'Enable Hexagon Hover Animation', 'finance' ) => 'enable'
					),
					'dependency' => array('element' => 'box_style', 'value' => 'style_1')
				),
				array(
					'type'       => 'checkbox',
					'heading'    => '',
					'param_name' => 'v_align_middle',
					'value'      => array(
						esc_html__( 'Enable Middle Align', 'finance' ) => 'enable'
					),
					'dependency' => array('element' => 'box_style', 'value' => 'style_1')
				),
				array(
					'type'       => 'iconpicker',
					'heading'    => esc_html__( 'Icon', 'finance' ),
					'param_name' => 'icon',
					'value'      => ''
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon - Position', 'finance' ),
					'param_name' => 'style',
					'value'      => array(
						esc_html__( 'Icon Top', 'finance' )              => 'icon_top',
						esc_html__( 'Icon Top Transparent', 'finance' ) => 'icon_top_transparent',
						esc_html__( 'Icon Left', 'finance' )             => 'icon_left',
						esc_html__( 'Icon Left Transparent', 'finance' ) => 'icon_left_transparent'
					),
					'dependency' => array('element' => 'box_style', 'value' => 'style_1')
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Icon Size', 'finance' ),
					'param_name'  => 'icon_size',
					'value'       => '65',
					'description' => esc_html__( 'Enter icon size in px', 'finance' )
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Icon - Color', 'finance' ),
					'param_name' => 'icon_color',
					'value'      => array(
						esc_html__( 'Base', 'finance' ) => 'base',
						esc_html__( 'Secondary', 'finance' ) => 'secondary',
						esc_html__( 'Third', 'finance' ) => 'third',
						esc_html__( 'Custom', 'finance' ) => 'custom'
					)
				),
				array(
					'type'       => 'colorpicker',
					'heading'    => esc_html__( 'Icon - Color Custom', 'finance' ),
					'param_name' => 'icon_color_custom',
					'dependency' => array('element' => 'icon_color', 'value' => 'custom')
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Icon Height', 'finance' ),
					'param_name'  => 'icon_height',
					'value'       => '65',
					'description' => esc_html__( 'Enter icon height in px', 'finance' ),
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'icon_top', 'icon_top_transparent' )
					)
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Icon Width', 'finance' ),
					'param_name'  => 'icon_width',
					'value'       => '50',
					'description' => esc_html__( 'Enter icon width in px', 'finance' ),
					'dependency'  => array(
						'element' => 'style',
						'value'   => array( 'icon_left', 'icon_left_transparent' )
					)
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Icon Wrapper Width', 'finance' ),
					'param_name'  => 'icon_width_wr',
					'value'       => '',
					'description' => esc_html__( 'Enter icon wrapper width in px', 'finance' ),
					'dependency'  => array(
						'element' => 'box_style',
						'value'   => array( 'style_2' )
					)
				),
				array(
					'type'       => 'textarea_html',
					'heading'    => esc_html__( 'Text', 'finance' ),
					'param_name' => 'content',
					'dependency' => array('element' => 'box_style', 'value' => 'style_1')
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			)
		) );

		
		vc_map( array(
			'name'        => esc_html__( 'Spacing', 'finance' ),
			'base'        => 'tmc_spacing',
			'category' => esc_html__( 'TMC', 'finance' ),
			'params'      => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Large Screen', 'finance' ),
					'param_name' => 'lg_spacing'
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Medium Screen', 'finance' ),
					'param_name' => 'md_spacing'
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Small Screen', 'finance' ),
					'param_name' => 'sm_spacing'
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra Small Screen', 'finance' ),
					'param_name' => 'xs_spacing'
				)
			)
		) );

		vc_map( array(
			'name'     => esc_html__( 'Contact', 'finance' ),
			'base'     => 'tmc_contact',
			'category' => esc_html__( 'TMC', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Name', 'finance' ),
					'param_name' => 'name'
				),
				array(
					'type'       => 'attach_image',
					'heading'    => esc_html__( 'Image', 'finance' ),
					'param_name' => 'image'
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Image Size', 'finance' ),
					'param_name'  => 'image_size',
					'description' => esc_html__( 'Enter image size. Example: "thumbnail", "medium", "large", "full" or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "default" size.', 'finance' )
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Job', 'finance' ),
					'param_name' => 'job'
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Email', 'finance' ),
					'param_name' => 'email'
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Skype', 'finance' ),
					'param_name' => 'skype'
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			)
		) );

		$tmc_sidebars_array = get_posts( array( 'post_type' => 'tmc_vc_sidebar', 'posts_per_page' => - 1 ) );
		$tmc_sidebars       = array( esc_html__( 'Select', 'finance' ) => 0 );
		if ( $tmc_sidebars_array && ! is_wp_error( $tmc_sidebars_array ) ) {
			foreach ( $tmc_sidebars_array as $val ) {
				$tmc_sidebars[ get_the_title( $val ) ] = $val->ID;
			}
		}

		vc_map( array(
			'name'     => esc_html__( 'TMC Sidebar', 'finance' ),
			'base'     => 'tmc_sidebar',
			'category' => esc_html__( 'TMC', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Code', 'finance' ),
					'param_name' => 'sidebar',
					'value'      => $tmc_sidebars
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			)
		) );


		vc_map( array(
			'name'                    => esc_html__( 'Google Map', 'finance' ),
			'base'                    => 'tmc_gmap',
			'icon'                    => 'tmc_gmap',
			'as_parent'               => array( 'only' => 'tmc_gmap_address' ),
			'show_settings_on_create' => true,
			'js_view'                 => 'VcColumnView',
			'category'                => esc_html__( 'TMC', 'finance' ),
			'params'                  => array(
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Map Height', 'finance' ),
					'param_name'  => 'map_height',
					'value'       => '733px',
					'description' => esc_html__( 'Enter map height in px', 'finance' )
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Map Zoom', 'finance' ),
					'param_name' => 'map_zoom',
					'value'      => 18
				),
				array(
					'type'       => 'attach_image',
					'heading'    => esc_html__( 'Marker Image', 'finance' ),
					'param_name' => 'marker'
				),
				array(
					'type'       => 'checkbox',
					'param_name' => 'disable_mouse_whell',
					'value'      => array(
						esc_html__( 'Disable map zoom on mouse wheel scroll', 'finance' ) => 'disable'
					)
				),
				array(
					'type'       => 'textarea_raw_html',
					'heading'    => esc_html__( 'Style Code', 'finance' ),
					'param_name' => 'gmap_style',
					'group'      => esc_html__('Map Style', 'finance')
				),
				array(
					'type'        => 'textfield',
					'heading'     => esc_html__( 'Extra class name', 'finance' ),
					'param_name'  => 'el_class',
					'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'finance' )
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			)
		) );

		vc_map( array(
			'name'     => esc_html__( 'Bottom Info', 'finance' ),
			'base'     => 'tmc_post_bottom',
			'category' => esc_html__( 'TMC Post Partials', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css'
				)
			)
		) );

		vc_map( array(
			'name'     => esc_html__( 'Comments', 'finance' ),
			'base'     => 'tmc_post_comments',
			'category' => esc_html__( 'TMC Post Partials', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
				)
			)
		) );
		
		vc_map( array(
			'name'     => esc_html__( 'Charts', 'finance' ),
			'base'     => 'tmc_charts',
			'icon'     => 'tmc_charts',
			'category' => esc_html__( 'TMC', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Design', 'finance' ),
					'param_name' => 'design',
					'value'      => array(
						esc_html__( 'Line', 'finance' )   => 'line',
						esc_html__( 'Bar', 'finance' )    => 'bar',
						esc_html__( 'Circle', 'finance' ) => 'circle',
						esc_html__( 'Pie', 'finance' )    => 'pie',
					),
				),
				array(
					'type'        => 'checkbox',
					'heading'     => esc_html__( 'Show legend?', 'finance' ),
					'param_name'  => 'legend',
					'description' => esc_html__( 'If checked, chart will have legend.', 'finance' ),
					'value'       => array( esc_html__( 'Yes', 'finance' ) => 'yes' ),
					'std'         => 'yes',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Legend Position', 'finance' ),
					'param_name' => 'legend_position',
					'value'      => array(
						esc_html__( 'Bottom', 'finance' ) => 'bottom',
						esc_html__( 'Right', 'finance' )  => 'right',
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Width (px)', 'finance' ),
					'param_name' => 'width',
				),
				array(
					'type'       => 'textfield',
					'heading'    => esc_html__( 'Height (px)', 'finance' ),
					'param_name' => 'height',
				),
				array(
					'type'       => 'textarea',
					'heading'    => esc_html__( 'X-axis values', 'finance' ),
					'param_name' => 'x_values',
					'value'      => 'JAN; FEB; MAR; APR; MAY; JUN; JUL; AUG',
					'dependency' => array(
						'element' => 'design',
						'value'   => array( 'line', 'bar' )
					),
				),
				array(
					'type'       => 'param_group',
					'heading'    => esc_html__( 'Values', 'finance' ),
					'param_name' => 'values',
					'dependency' => array(
						'element' => 'design',
						'value'   => array( 'line', 'bar' )
					),
					'value'      => urlencode( json_encode( array(
						array(
							'title' => esc_html__( 'One', 'finance' ),
							'y_values' => '10; 15; 20; 25; 27; 25; 23; 25',
							'color' => '#fe6c61',
						),
						array(
							'title' => esc_html__( 'Two', 'finance' ),
							'y_values' => '25; 18; 16; 17; 20; 25; 30; 35',
							'color' => '#5472d2'
						)
					) ) ),
					'params'     => array(
						array(
							'type'        => 'textfield',
							'heading'     => esc_html__( 'Title', 'finance' ),
							'param_name'  => 'title',
							'description' => esc_html__( 'Enter title for chart dataset.', 'finance' ),
							'admin_label' => true,
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__( 'Y-axis values', 'finance' ),
							'param_name' => 'y_values'
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__( 'Color', 'finance' ),
							'param_name' => 'color'
						)
					),
					'callbacks'  => array(
						'after_add' => 'vcChartParamAfterAddCallback',
					),
				),
				array(
					'type'       => 'param_group',
					'heading'    => esc_html__( 'Values', 'finance' ),
					'param_name' => 'values_circle',
					'dependency' => array(
						'element' => 'design',
						'value'   => array( 'circle', 'pie' )
					),
					'value'      => urlencode( json_encode( array(
						array(
							'title' => esc_html__( 'One', 'finance' ),
							'value' => '40',
							'color' => '#fe6c61',
						),
						array(
							'title' => esc_html__( 'Two', 'finance' ),
							'value' => '30',
							'color' => '#5472d2'
						),
						array(
							'title' => esc_html__( 'Three', 'finance' ),
							'value' => '40',
							'color' => '#8d6dc4'
						)
					) ) ),
					'params'     => array(
						array(
							'type'        => 'textfield',
							'heading'     => esc_html__( 'Title', 'finance' ),
							'param_name'  => 'title',
							'description' => esc_html__( 'Enter title for chart dataset.', 'finance' ),
							'admin_label' => true,
						),
						array(
							'type'       => 'textfield',
							'heading'    => esc_html__( 'Value', 'finance' ),
							'param_name' => 'value'
						),
						array(
							'type'       => 'colorpicker',
							'heading'    => esc_html__( 'Color', 'finance' ),
							'param_name' => 'color'
						)
					),
					'callbacks'  => array(
						'after_add' => 'vcChartParamAfterAddCallback',
					),
				),
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
					'group'      => esc_html__( 'Design options', 'finance' )
				)
			)
		) );

		vc_map( array(
			'name'     => esc_html__( 'About Vacancy', 'finance' ),
			'base'     => 'tmc_about_vacancy',
			'category' => esc_html__( 'TMC Vacancy Partials', 'finance' ),
			'params'   => array(
				array(
					'type'       => 'css_editor',
					'heading'    => esc_html__( 'Css', 'finance' ),
					'param_name' => 'css',
				)
			)
		) );
	
	
/*------------------------------------------------------*/
/* Client Listing
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Client Listing", "finance"),
	"base"                      => 'tmc_clientlisting',
	"category"                  => __('TMC Client Listing', 'finance'),
	"description"               => __('Display project listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),
			array(
				'type'        => 'dropdown',
				'heading'     => __( 'Display Mode', 'finance' ),
				'param_name'  => 'layout',
				'description' => __( 'The layout your page children being display', 'finance' ),
				'value'       => array(
					__("Grid", "finance")     => "grid",
					__("Carousel", "finance") => "carousel"
				)
			),
		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),
		
		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
			
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5",
				__("6 Columns", "finance") => "6"
			)
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Our Client
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Our Client", "finance"),
	"base"                      => 'tmc_our_client',
	"category"                  => __('TMC Our Client', 'finance'),
	"description"               => __('Display Client listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),


		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Our Counter
/*------------------------------------------------------*/

vc_map( array(
		"name"                      => __("Our Counter", "finance"),
		"base"                      => 'tmc_counter',
		"category"                  => __('TMC Elements', 'finance'),
		"description"               => __('Our Counter', 'finance'),
		"save_always" 				=> true,
		'params'      => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'heading' => __( 'Widget Title', 'finance' ),
				'param_name' => 'widget_title',
				'value'       => '',
				'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
			),
			
			array(
				'type' 				=> 'textfield',
				'heading' 			=> __( 'Counter Value1', 'finance' ),
				'param_name' 		=> 'counter_value1',
				'value'				=> '1000'
			),
			array(
				'type' => 'textfield',
				'holder' => 'p',
				'heading' => __( 'Right Text1', 'finance' ),
				'param_name' => 'right_text1',
				'value'       => '',
				'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
			),
			array(
				'type' 				=> 'textfield',
				'heading' 			=> __( 'Counter Value2', 'finance' ),
				'param_name' 		=> 'counter_value2',
				'value'				=> '1000'
			),
			array(
				'type' => 'textfield',
				'holder' => 'p',
				'heading' => __( 'Right Text2', 'finance' ),
				'param_name' => 'right_text2',
				'value'       => '',
				'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
			),
			array(
				'type' 				=> 'textfield',
				'heading' 			=> __( 'Counter Value3', 'finance' ),
				'param_name' 		=> 'counter_value3',
				'value'				=> '1000'
			),
			array(
				'type' => 'textfield',
				'holder' => 'p',
				'heading' => __( 'Right Text3', 'finance' ),
				'param_name' => 'right_text3',
				'value'       => '',
				'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
			),
			array(
				'type' 				=> 'textfield',
				'heading' 			=> __( 'Counter Value4', 'finance' ),
				'param_name' 		=> 'counter_value4',
				'value'				=> '1000'
			),
			array(
				'type' => 'textfield',
				'holder' => 'p',
				'heading' => __( 'Right Text4', 'finance' ),
				'param_name' => 'right_text4',
				'value'       => '',
				'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
			),
			array(
				'type' 				=> 'textfield',
				'heading' 			=> __( 'Duration', 'finance' ),
				'param_name' 		=> 'duration',
				'value'				=> '2.5'
			),
	
			array(
				'type' 				=> 'iconpicker',
				'heading' 			=> __( 'Icon', 'finance' ),
				'param_name' 		=> 'icon',
				'value'				=> ''
			),
			array(
				'type' 				=> 'textfield',
				'heading' 			=> __( 'Icon Size', 'finance' ),
				'param_name' 		=> 'icon_size',
				'value'				=> '65',
				'description'       => __( 'Enter icon size in px', 'finance' )
			),
			array(
				'type' 				=> 'textfield',
				'heading' 			=> __( 'Icon Height', 'finance' ),
				'param_name' 		=> 'icon_height',
				'value'				=> '90',
				'description'       => __( 'Enter icon height in px', 'finance' )
			),
			array(
				'type' 				=> 'dropdown',
				'heading' 			=> __( 'Text alignment', 'finance' ),
				'param_name' 		=> 'icon_text_alignment',
				'value' => array(
					'Center' => 'center',
					'Left' => 'left',
					'Right' => 'right',
				),
				'description'       => __( 'Text alignment in block', 'finance' )
			),
			array(
				'type' 				=> 'colorpicker',
				'heading' 			=> __( 'Text color', 'finance' ),
				'param_name' 		=> 'icon_text_color',
				'description'       => __( 'Text color(white - default)', 'finance' )
			),
			array(
				'type' 				=> 'colorpicker',
				'heading' 			=> __( 'Counter text color', 'finance' ),
				'param_name' 		=> 'counter_text_color',
				'description'       => __( 'Counter Text color(yellow - default)', 'finance' )
			),
			array(
				'type'       => 'css_editor',
				'heading'    => __( 'Css', 'finance' ),
				'param_name' => 'css',
				'group'      => __( 'Design options', 'finance' )
			),
			array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
		)
	) );

	
/*------------------------------------------------------*/
/* Latest NEWS
/*------------------------------------------------------*/
vc_map( array(
	"name"                      => __("Latest News", "finance"),
	"base"                      => 'tmc_latest_news',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Recent Blog Posts', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		array(
			'type'        => 'textarea',
			'holder'      => 'h2',
			'heading'     => __( 'Widget Title', 'finance' ),
			'param_name'  => 'widget_title',
			'value'       => '',
			'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts to show","finance"),
			"param_name"	=> "number",
			"value"			=> "3",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Latest NEWS2
/*------------------------------------------------------*/
vc_map( array(
	"name"                      => __("Latest News 2", "finance"),
	"base"                      => 'tmc_latest_news2',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Recent Blog Posts', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		array(
			'type'        => 'textarea',
			'holder'      => 'h2',
			'heading'     => __( 'Widget Title', 'finance' ),
			'param_name'  => 'widget_title',
			'value'       => '',
			'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts to show","finance"),
			"param_name"	=> "number",
			"value"			=> "3",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Our Latest NEWS
/*------------------------------------------------------*/
vc_map( array(
	"name"                      => __("Our Latest News", "finance"),
	"base"                      => 'tmc_our_latest_news',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Recent Blog Posts', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		array(
			'type'        => 'textarea',
			'holder'      => 'h2',
			'heading'     => __( 'Widget Title', 'finance' ),
			'param_name'  => 'widget_title',
			'value'       => '',
			'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts to show","finance"),
			"param_name"	=> "number",
			"value"			=> "3",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* RECENT NEWS
/*------------------------------------------------------*/
vc_map( array(
	"name"                      => __("Recent News", "finance"),
	"base"                      => 'tmc_recent_news',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Recent Blog Posts', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		array(
			'type'        => 'textarea',
			'holder'      => 'h2',
			'heading'     => __( 'Widget Title', 'finance' ),
			'param_name'  => 'widget_title',
			'value'       => '',
			'description' => __('What text use as widget title. Leave blank if no title is needed.', 'finance')
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts to show","finance"),
			"param_name"	=> "number",
			"value"			=> "3",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );	

/*------------------------------------------------------*/
/* Testimonials
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("TMC Testimonials", "finance"),
	"base"                      => 'tmc_testimonials',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Display project listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay"
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' )
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300"
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("1 Columns", "finance") => "1",
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Our Testimonials
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Our Testimonials", "finance"),
	"base"                      => 'tmc_our_testimonials',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Display project listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay"
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' )
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300"
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("1 Columns", "finance") => "1",
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Testimonial full details Carousel
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("TMC Testimonials Full Details", "finance"),
	"base"                      => 'tmc_testimonialcrouselfulldetails',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Display project listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),
		
		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay"
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' )
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300"
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("1 Columns", "finance") => "1",
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* BROCHURE DOWNLOAD BUTTON
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Brocher Download Button", 'finance'),
	"base"                      => 'tmc_brochure_button',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Display Download Button', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'textfield',
			'heading'     => __( 'Text on the button', 'finance' ),
			'holder'      => 'button',
			'class'       => 'wpb_button',
			'param_name'  => 'btntitle',
			'value'       => __( 'Text on the button', 'finance' ),
			'description' => __( 'Text on the button.', 'finance' )
		),
		array(
			'type'        => 'attach_image',
			'heading'     => __( 'File URL (Link)', 'finance' ),
			'param_name'  => 'btnlink',
			'description' => __( 'Select the file to be downloaded.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Team Listing
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Team Listing", "finance"),
	"base"                      => 'tmc_teamlisting',
	"category"                  => __('TMC Team Listing', 'finance'),
	"description"               => __('Display project listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Our Team
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Our Team", "finance"),
	"base"                      => 'tmc_our_team',
	"category"                  => __('TMC Our Team', 'finance'),
	"description"               => __('Display Team listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),


		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Our project
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Our Project", "finance"),
	"base"                      => 'tmc_ourproject',
	"category"                  => __('TMC Our Project', 'finance'),
	"description"               => __('Display project listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Latest Causes
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Latest Causes", "finance"),
	"base"                      => 'tmc_latest_causes',
	"category"                  => __('TMC Our Project', 'finance'),
	"description"               => __('Display project listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Our Services
/*------------------------------------------------------*/
$page_ids = get_all_page_ids();
$pages = array();
for ( $i = 0; $i < count($page_ids); $i++ )
{
	$pages[get_the_title($page_ids[$i])] = $page_ids[$i];
}

vc_map( array(
	"name"                      => __("Our Services", "finance"),
	"base"                      => 'tmc_services',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Display serices list', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Best Services
/*------------------------------------------------------*/
$page_ids = get_all_page_ids();
$pages = array();
for ( $i = 0; $i < count($page_ids); $i++ )
{
	$pages[get_the_title($page_ids[$i])] = $page_ids[$i];
}

vc_map( array(
	"name"                      => __("Best Services", "finance"),
	"base"                      => 'tmc_best_services',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Display Best serices list', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* OUR EXPERTIZE & SERVICES
/*------------------------------------------------------*/
$page_ids = get_all_page_ids();
$pages = array();
for ( $i = 0; $i < count($page_ids); $i++ )
{
	$pages[get_the_title($page_ids[$i])] = $page_ids[$i];
}

vc_map( array(
	"name"                      => __("OUR EXPERTIZE & SERVICES", "finance"),
	"base"                      => 'tmc_our_expertize_services',
	"category"                  => __('OUR EXPERTIZE & SERVICES', 'finance'),
	"description"               => __('Display OUR EXPERTIZE & SERVICES', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("Grid", "finance")     => "grid",
				__("Carousel", "finance") => "carousel"
			)
		),

		array(
			"type"        => "checkbox",
			"heading"     => __("Carousel Autoplay","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "carousel_autoplay",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			"type"			 => "textfield",
			"class"			 => "",
			"heading"		 => __("Carousel Autoplay Speed","finance"),
			"param_name"	 => "carousel_autoplay_speed",
			"value"			 => "3000",
			'description'    => __( 'Carousel Autoplay Speed in millisecond', 'finance' ),
			"dependency"     => Array('element' => "layout", 'value' => array('carousel'))
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Carousel Speed","finance"),
			"param_name"	=> "carousel_speed",
			'description'    => __( 'Carousel Speed in millisecond', 'finance' ),
			"value"			=> "300",
			"dependency" => Array('element' => "layout", 'value' => array('carousel'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/* Code for Project Listing.. */

vc_map( array(
	"name"                      => __("Project Listing", "finance"),
	"base"                      => 'tmc_projectslisting',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Display project listing', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Orderby', 'finance' ),
			'param_name'  => 'orderby',
			'description' => __( 'Sort retrieved posts/pages by parameter', 'finance' ),
			'default'	  => 'none',
			'value'       => array(
				__("None", "finance")       => "none",
				__("ID", "finance")         => "ID",
				__("Title", "finance")      => "title",
				__("Name", "finance")       => "name",
				__("Random", "finance")     => "rand",
				__("Date", "finance")       => "date",
				__("Page Order", "finance") => "menu_order"
			)
		),

		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Number of posts","finance"),
			"param_name"	=> "number",
			"value"			=> "9",
			"description" 	=> "How many post to show?",
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Column', 'finance' ),
			'param_name'  => 'column',
			'description' => __( 'How many column will be display on a row?', 'finance' ),
			'default'	  => '3',
			'value'       => array(
				__("2 Columns", "finance") => "2",
				__("3 Columns", "finance") => "3",
				__("4 Columns", "finance") => "4",
				__("5 Columns", "finance") => "5"
			)
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Display Mode', 'finance' ),
			'param_name'  => 'layout',
			'description' => __( 'The layout your page children being display', 'finance' ),
			'value'       => array(
				__("filter", "finance")     => "filter",
				__("no-filter", "finance") => "no-filter"
			)
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Read More text","finance"),
			"param_name"	=> "readmore_text",
			"value"			=> "Read More",
			"description" 	=> "Custom your read more text, e.g. Read More, View Profile ...",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* Services Listing Links
/*------------------------------------------------------*/

vc_map( array(
	"name"                      => __("Services Listing Links", "finance"),
	"base"                      => 'tmc_serviceslistinglinks',
	"category"                  => __('TMC Elements', 'finance'),
	"description"               => __('Display Services Listing Links', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Order', 'finance' ),
			'param_name'  => 'order',
			'description' => __( 'Ascending or descending order', 'finance' ),
			'default'	  => 'DESC',
			'value'       => array(
				__("DESC", "finance") => "DESC",
				__("ASC", "finance") => "ASC"
			)
		),

		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );

/*------------------------------------------------------*/
/* CUSTOM HEADING
/*------------------------------------------------------*/
vc_map( array(
	"name"                      => __("Custom Heading", "finance"),
	"base"                      => 'tmc_custom_heading',
	"icon"                      => "",
	"show_settings_on_create"   => true,
	"category"                  => __('TMC Elements', 'finance'),
	"save_always" 				=> true,
	"params"                    => array(
		array(
			'type'        => 'textarea',
			'holder'      => 'h2',
			'heading'     => __( 'Heading', 'finance' ),
			'param_name'  => 'heading',
			'admin_label' => true,
			'value'       => '',
			'description' => __('Custom heading, allow simple HTML code.', 'finance')
		),
		array(
			"type"       => "colorpicker",
			"class"      => "",
			"heading"    => __("Heading Color","finance"),
			"param_name" => "heading_color",
			"value"      => ""
		),
		array(
			"type"        => "checkbox",
			"class"       => "",
			"heading"     => __("Display a colored line below heading?","finance"),
			"value"       => array( __("Yes.","finance") => "yes" ),
			"param_name"  => "colored_line",
			"description" => ""
		),

		array(
			'type'               => 'dropdown',
			'heading'            => __( 'Custom Line Color', 'finance' ),
			'param_name'         => 'line_color',
			'description'        => __( 'Heading custom line color.', 'finance' ),
			'value'              => array(
				__("Primary Color", "finance")   => "primary",
				__("Secondary Color", "finance") => "secondary",
				__("Custom Color", "finance") => "custom",
			)
		),
		array(
			"type"       => "colorpicker",
			"class"      => "",
			"heading"    => __("Custom Line Color","finance"),
			"param_name" => "line_custom_color",
			"value"      => "",
			"dependency" => Array('element' => "line_color", 'value' => array('custom'))
		),

		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Heading Position', 'finance' ),
			'param_name'  => 'position',
			'value'       => array(
				__("Left", "finance")   => "left",
				__("Center", "finance") => "center",
				__("Right", "finance")  => "right"
			)
		),
		array(
			'type'        => 'dropdown',
			'heading'     => __( 'Heading Size', 'finance' ),
			'param_name'  => 'size',
			'value'       => array(
				__("Large", "finance")   => "large",
				__("Medium", "finance") => "medium",
				__("Small", "finance")  => "small"
			)
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Custom Margin Top","finance"),
			"param_name"	=> "margin_top",
			"value"			=> "",
			"description" 	=> "Don't include \"px\" in your string. e.g \"50\"",
		),
		array(
			"type"			=> "textfield",
			"class"			=> "",
			"heading"		=> __("Custom Margin Bottom","finance"),
			"param_name"	=> "margin_bottom",
			"value"			=> "",
			"description" 	=> "Don't include \"px\" in your string. e.g \"50\"",
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Extra class name', 'finance' ),
			'param_name'  => 'el_class',
			'description' => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'finance' )
		)
	),
) );
}	
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {


	class WPBakeryShortCode_TMC_Animation_Block extends WPBakeryShortCodesContainer {
	}

	class WPBakeryShortCode_TMC_Gmap extends WPBakeryShortCodesContainer {
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_TMC_Contacts_Widget extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Info_Box extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Icon_Box extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Posts extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Contact extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Sidebar extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Gmap_Address extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Post_Bottom extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Post_About_Author extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Post_Comments extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Charts extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Spacing extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Clientlisting extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Our_Client extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Counter extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Recent_news extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Latest_news extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Latest_news2 extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Our_Latest_news extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Testimonialcrouselfulldetails extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Our_Testimonials extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Testimonials extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Teamlisting extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Our_Team extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Services extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Best_Services extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Our_Expertize_Services extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Ourproject extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Latest_Causes extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Projectslisting extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Serviceslistinglinks extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Custom_heading extends WPBakeryShortCode {
	}
	class WPBakeryShortCode_TMC_Brochure_Button extends WPBakeryShortCode {
	}	
}
