<?php
	/**
	 * The main template file.
	 *
	 * This is the most generic template file in a WordPress theme
	 * and one of the two required files for a theme (the other being style.css).
	 * It is used to display a page when nothing more specific matches a query.
	 * E.g., it puts together the home page when no home.php file exists.
	 * Learn more: http://codex.wordpress.org/Template_Hierarchy
	 *
	 * @package finance
	 */
	 finance_get_header(); 
	global $finance_option; 
	if ( ! empty($finance_option['blog_sidebar_type'])) 
	{
		$sidebar_type = $finance_option['blog_sidebar_type'];	
	} 
	else 
	{
		$sidebar_type = 'wp';
	}
	if ( $sidebar_type == 'wp' && isset($finance_option['blog_wp_sidebar'])  ) 
	{	
		$sidebar_id = $finance_option['blog_wp_sidebar'];	
	}
	else 
	{
			if(isset($finance_option['blog_vc_sidebar']))
			{
				$sidebar_id = $finance_option['blog_vc_sidebar'];
			}
	}
	if ( ! empty( $sidebar_id) ) 
	{
		 $sidebar_id =  $sidebar_id;	 
	} 
	else 
	{
		$sidebar_id = 'finance-right-sidebar';
	}
	if ( ! empty($finance_option['blog_sidebar_position'])) 
	{
		$sidebar_position = $finance_option['blog_sidebar_position'];
	}
	else
	{
		$sidebar_position = 'right';
	} 			
	$finance_layout = finance_get_structure( $sidebar_id, $sidebar_type, $sidebar_position ); ?>
	<?php echo translate($finance_layout['content_before']); ?>
	<div>
		<?php
			$posts_class = '';
			$paginate_links_data = paginate_links( array('type' => 'array') );
			if( empty( $paginate_links_data ) ) 
			{
				$posts_class .= ' no-paginate';
			}
		?>
		<div class="post_list_ul<?php echo translate($posts_class); ?>">
			<?php
			if ( have_posts() ) :
				while ( have_posts() ) : the_post(); ?>
					<div class="single-blog-post img-cap-effect">
						<div class="img-holder">
							<?php
							if( has_post_thumbnail( ) ) 
							{
								echo '<div class="post-thumbnail news-image">';
								the_post_thumbnail( 'blog-large' );
								echo '</div>'; 
								if(isset($finance_option['blog_metadata']) && $finance_option['blog_metadata'] == '1')
								{ 	
									if(isset($finance_option['blog_multi_checkbox']) && $finance_option['blog_multi_checkbox'][1] == '1')
									{ 	?>
										<div class="date-box">
											<span>
												<?php echo get_the_date("d"); ?>
											</span><br> 
											<?php echo get_the_date("M"); ?>
										</div>
										<?php 
									}
								} 
							} ?>
						</div>
						<?php 
						if(isset($finance_option['blog_metadata']) && $finance_option['blog_metadata'] == '1')
						{ 	?>					
							<div class="entry-meta post-page-meta">
								<?php if(isset($finance_option['blog_multi_checkbox']) && $finance_option['blog_multi_checkbox'][2] == '1')
								{ 	?>
									<span class="byline">
										<i class="fa fa-user"></i> 
										<?php echo esc_html__( 'By:', 'finance' );?> <?php the_author(); ?>
									</span>
									<?php 
								} 
								if(isset($finance_option['blog_multi_checkbox']) && $finance_option['blog_multi_checkbox'][4] == '1')
								{ 	?>
									<span class="posted-on">
										<i class="fa fa-tag"></i>
										<?php echo implode( ', ', wp_get_post_categories( get_the_ID(), array( 'fields' => 'names' ) ) ) ?>
									</span>
									<?php 
								} 
								if(isset($finance_option['blog_multi_checkbox']) && $finance_option['blog_multi_checkbox'][3] == '1')
								{ 	?>	
									<span class="comments-link">
										<i class="fa fa-comments-o"></i>
										<a href="<?php comments_link(); ?>"><?php comments_number(); ?>
										</a>
									</span>	
									<?php 
								} ?>	
							</div>
						<?php	
						} ?>
						<header class="entry-header">
							<?php 
								if ( 'post' == get_post_type() ) :
									if ( is_sticky( ) ) 
									{
										echo '<span class="genericon genericon-pinned"></span> ';
									}  endif; 
									the_title( sprintf( '<h3 class="entry-title "><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
						</header><!-- .entry-header -->
						<div class="entry-content">
							<div class="post_excerpt">
								<?php 
									the_content( sprintf(
														__( 'Read More %s <span class="meta-nav"></span>', 'finance' ), false )
												) ; ?>
							</div>
							<?php
								wp_link_pages( array(
													'before' => '<div class="page-links">' . __( 'Pages:', 'finance' ),
													'after'  => '</div>',
													)
											);
							?>
						</div><!-- .entry-content -->
					</div><!-- #post-## -->
				<?php	
				endwhile;
			elseif ( is_search() ) : 
				?>
				<div class="search-resutls">
					<?php 
						get_search_form(); 
					?>
				</div>
				<p>
					<?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'finance' ); ?>
				</p>
				<?php 
			else: 
				?>
				<p>
					<?php printf( wp_kses( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'finance' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'post-new.php' ) ) ); ?>
				</p>
				<?php 
			endif;
			?>
		</div>
	</div>
	<?php
	if(isset($finance_option['blog_pagination']) && $finance_option['blog_pagination'] == '1')
	{
		echo paginate_links( array(
									'type'      => 'list',
									'prev_text' => '<i class="fa fa-chevron-left"></i>',
									'next_text' => '<i class="fa fa-chevron-right"></i>',
									) 
							);
	} 
	echo translate($finance_layout['content_after']); 
	echo translate($finance_layout['sidebar_before']); 
	if ( $sidebar_id ) 
	{
		if ( $sidebar_type == 'wp' ) 
		{
			$sidebar = true;
		} 
		else 
		{
			$sidebar = get_post( $sidebar_id );
		}
	}
	$search_sidebar = '';
	if(is_search())
	{
		$search_sidebar = 'search-sidebar';
	}
	if ( isset( $sidebar ) ) 
	{
		if ( $sidebar_type == 'vc' ) 
		{ 	?>
			<div class="sidebar-area">
				<?php echo apply_filters( 'the_content', $sidebar->post_content ); ?>
			</div>
			<?php 
		} 
		else 
		{ 	?>
			<div class="sidebar-area default_widgets <?php echo esc_attr($search_sidebar); ?>">
				<?php dynamic_sidebar( $sidebar_id ); ?>
			</div>
			<?php 
		}
	}
	echo translate($finance_layout['sidebar_after']); ?>
<?php get_footer(); ?>