<?php
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );
$css_class .= ' ' . $class;
$css_class .= ' ' . $style;
?>
<div class="tmc_contacts_widget<?php echo esc_attr( $css_class ); ?>">
	<?php 
	if( $style == 'style_2' ) : ?>
		<ul>
			<?php 
				if( $phone ): ?>
					<li>
						<div class="icon">
							<i class="fa fa-phone"></i>
						</div>
						<div class="text"><strong>
							<?php echo esc_attr( $phone ); ?></strong>
						</div>
					</li>
					<?php 
				endif; 
				if( $email ): ?>
					<li>
						<div class="icon"><i class="fa fa-envelope"></i></div>
						<div class="text"><a href="mailto:<?php echo antispambot( $email ); ?>"><?php echo antispambot( $email ); ?></a></div>
					</li>
					<?php 
				endif; ?>
		</ul>
		<?php 
	elseif( $style == 'style_3' ) : ?>
		 <div class="information-company">
			 <?php 
				if( $address ): ?> 
					<div class="text-box"><span>Address:</span>
						<p>
							<?php echo wp_kses_post( $address ); ?>
						</p>
					</div>
					<?php 
				endif; ?>
			 <div class="text-box"><span>Advisor: <strong>Michale John</strong></span>
				<?php 
					if( $email ): ?>
						<a href="mailto:<?php echo antispambot( $email ); ?>"><?php echo antispambot( $email ); ?></a>
			<?php 	endif; ?>
					<p>
						<a href="#">http://financepro.com</a>
					</p>
			<?php	if( $phones ):
						$phones_arr = explode( ';', $phones );
						$phones_count = count( $phones_arr );
						$phones_showed = 0;
						if( !empty( $phones_arr ) && $phones_count > 0 ) : ?>
							<span class="phone">
								<?php foreach( $phones_arr as $phone_number ) : $phones_showed++; ?>
									<a href="tel:<?php echo esc_attr( str_replace(' ', '', $phone_number) ); ?>"><?php echo esc_html( $phone_number ); ?>
									</a>
								<?php echo ( ( $phones_count > $phones_showed ) ? '<br>' : ''); 
								endforeach; ?>
							</span>
				<?php	endif; 
					endif; 
					if( $schedule ): ?>
						<p class="time new-cs">
							<?php echo wp_kses_post( $schedule ); ?>
						</p>
						<?php 
					endif; ?>
			</div>
		</div>
		<?php 
	else: 
		if( $title ): ?>
			<h4 class="no_stripe">
				<?php echo esc_attr( $title ); ?>
			</h4>
			<?php 
		endif; ?>
		<ul>
			<?php 
			if( $address ): ?>
				<li>
					<div class="icon"><i class="fa fa-map-marker"></i></div>
					<div class="text"><?php echo wp_kses( $address, array( 'br' => array() ) ); ?></div>
				</li>
				<?php 
			endif; 
				if( $phone ): ?>
				<li>
					<div class="icon"><i class="fa fa-phone"></i></div>
					<div class="text"><?php echo esc_attr( $phone ); ?></div>
				</li>
				<?php 
			endif; 
			if( $email ): ?>
				<li>
					<div class="icon"><i class="fa fa-envelope"></i></div>
					<div class="text"><a href="mailto:<?php echo antispambot( $email ); ?>"><?php echo antispambot( $email ); ?></a>
					</div>
				</li>
				<?php 
			endif; ?>
		</ul>
		<?php 
		if( $facebook || $twitter || $linkedin || $google_plus || $skype ): ?>
			<ul class="socials">
					<?php 
					if( $facebook ): ?>
						<li>
							<a href="<?php echo esc_url( $facebook ); ?>" target="_blank" class="social-facebook"><i class="fa fa-facebook"></i>
							</a>
						</li>
						<?php 
					endif;
					if( $twitter ): ?>
						<li>
							<a href="<?php echo esc_url( $twitter ); ?>" target="_blank" class="social-twitter"><i class="fa fa-twitter"></i></a>
						</li>
						<?php 
					endif; 
					if( $linkedin ): ?>
						<li>
							<a href="<?php echo esc_url( $linkedin ); ?>" target="_blank" class="social-linkedin"><i class="fa fa-linkedin"></i></a>
						</li>
						<?php 
					endif;
					if( $google_plus ): ?>
						<li>
							<a href="<?php echo esc_url( $google_plus ); ?>" target="_blank" class="social-google-plus"><i class="fa fa-google-plus"></i></a>
						</li>
						<?php 
					endif; 
					if( $skype ): ?>
						<li>
							<a href="skype:<?php echo esc_attr( $skype ); ?>" class="social-skype"><i class="fa fa-skype"></i>
							</a>
						</li>
					<?php endif; ?>
			</ul>
		<?php endif; 
		endif; ?>
</div>