<?php
get_header(); ?>

<main class="ras-main-content">
    <div class="container">
        <header class="page-header">
            <h1 class="page-title"><?php the_archive_title(); ?></h1>
            <div class="archive-meta"><?php the_archive_description(); ?></div>
        </header>

        <?php if (have_posts()) : ?>
            <div class="row">
                <?php while (have_posts()) : the_post(); ?>
                    <div class="col-lg-4 col-md-6">
                        <?php get_template_part('template-parts/content', get_post_type()); ?>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php the_posts_navigation(); ?>
        <?php else : ?>
            <p><?php esc_html_e('Sorry, no posts matched your criteria.', 'rasin'); ?></p>
        <?php endif; ?>
    </div>
</main>

<?php
get_sidebar();
get_footer();
?>