<?php
/**
 * Rasin Theme Customizer
 *
 * @package Rasin
 */

function rasin_customize_register( $wp_customize ) {
    // Add a section for the header settings
    $wp_customize->add_section( 'rasin_header_settings', array(
        'title'    => __( 'Header Settings', 'rasin' ),
        'priority' => 30,
    ) );

    // Add a setting for the header text
    $wp_customize->add_setting( 'header_text', array(
        'default'   => __( 'Welcome to Rasin', 'rasin' ),
        'transport' => 'refresh',
    ) );

    // Add a control for the header text
    $wp_customize->add_control( 'header_text_control', array(
        'label'    => __( 'Header Text', 'rasin' ),
        'section'  => 'rasin_header_settings',
        'settings' => 'header_text',
        'type'     => 'text',
    ) );

    // Add a section for the footer settings
    $wp_customize->add_section( 'rasin_footer_settings', array(
        'title'    => __( 'Footer Settings', 'rasin' ),
        'priority' => 30,
    ) );

    // Add a setting for the footer text
    $wp_customize->add_setting( 'footer_text', array(
        'default'   => __( '© 2021 Rasin. All Rights Reserved.', 'rasin' ),
        'transport' => 'refresh',
    ) );

    // Add a control for the footer text
    $wp_customize->add_control( 'footer_text_control', array(
        'label'    => __( 'Footer Text', 'rasin' ),
        'section'  => 'rasin_footer_settings',
        'settings' => 'footer_text',
        'type'     => 'text',
    ) );
}

add_action( 'customize_register', 'rasin_customize_register' );
?>