<?php
get_header(); ?>

<main class="ras-main-content">
    <section class="ras-search-results">
        <div class="container">
            <h2 class="text-center mb-50"><?php printf( esc_html__( 'Search Results for: %s', 'rasin' ), '<span>' . get_search_query() . '</span>' ); ?></h2>

            <?php if ( have_posts() ) : ?>
                <div class="row">
                    <?php while ( have_posts() ) : the_post(); ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="ras-search-item">
                                <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                <p><?php the_excerpt(); ?></p>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            <?php else : ?>
                <h3 class="text-center"><?php esc_html_e( 'No results found.', 'rasin' ); ?></h3>
            <?php endif; ?>

            <?php get_template_part( 'template-parts/content', 'pagination' ); ?>
        </div>
    </section>
</main>

<?php
get_sidebar();
get_footer();
?>