<?php
if ( ! function_exists( 'gifam_setup' ) ) :

function gifam_setup() {

    /*
     * Make theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    /* Pinegrow generated Load Text Domain Begin */
    load_theme_textdomain( 'gifam', get_template_directory() . '/languages' );
    /* Pinegrow generated Load Text Domain End */

    // Add default posts and comments RSS feed links to head.
    add_theme_support( 'automatic-feed-links' );

    /*
     * Let WordPress manage the document title.
     */
    add_theme_support( 'title-tag' );
    
    /*
     * Enable support for Post Thumbnails on posts and pages.
     */
    add_theme_support( 'post-thumbnails' );
    //Support custom logo
    add_theme_support( 'custom-logo' );

    // Add menus.
    register_nav_menus( array(
        'primary' => __( 'Primary Menu', 'gifam' ),
        'social'  => __( 'Social Links Menu', 'gifam' ),
    ) );

/*
     * Register custom menu locations
     */
    /* Pinegrow generated Register Menus Begin */

    /* Pinegrow generated Register Menus End */
    
/*
    * Set image sizes
     */
    /* Pinegrow generated Image sizes Begin */

    /* Pinegrow generated Image sizes End */
    
    /*
     * Switch default core markup for search form, comment form, and comments
     * to output valid HTML5.
     */
    add_theme_support( 'html5', array(
        'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
    ) );

    /*
     * Enable support for Post Formats.
     */
    add_theme_support( 'post-formats', array(
        'aside', 'image', 'video', 'quote', 'link', 'gallery', 'status', 'audio', 'chat'
    ) );

    /*
     * Enable support for Page excerpts.
     */
     add_post_type_support( 'page', 'excerpt' );
}
endif; // gifam_setup

add_action( 'after_setup_theme', 'gifam_setup' );


if ( ! function_exists( 'gifam_init' ) ) :

function gifam_init() {

    
    // Use categories and tags with attachments
    register_taxonomy_for_object_type( 'category', 'attachment' );
    register_taxonomy_for_object_type( 'post_tag', 'attachment' );

    /*
     * Register custom post types. You can also move this code to a plugin.
     */
    /* Pinegrow generated Custom Post Types Begin */

    /* Pinegrow generated Custom Post Types End */
    
    /*
     * Register custom taxonomies. You can also move this code to a plugin.
     */
    /* Pinegrow generated Taxonomies Begin */

    /* Pinegrow generated Taxonomies End */

}
endif; // gifam_setup

add_action( 'init', 'gifam_init' );


if ( ! function_exists( 'gifam_custom_image_sizes_names' ) ) :

function gifam_custom_image_sizes_names( $sizes ) {

    /*
     * Add names of custom image sizes.
     */
    /* Pinegrow generated Image Sizes Names Begin*/
    /* This code will be replaced by returning names of custom image sizes. */
    /* Pinegrow generated Image Sizes Names End */
    return $sizes;
}
add_action( 'image_size_names_choose', 'gifam_custom_image_sizes_names' );
endif;// gifam_custom_image_sizes_names



if ( ! function_exists( 'gifam_widgets_init' ) ) :

function gifam_widgets_init() {

    /*
     * Register widget areas.
     */
    /* Pinegrow generated Register Sidebars Begin */

    /* Pinegrow generated Register Sidebars End */
}
add_action( 'widgets_init', 'gifam_widgets_init' );
endif;// gifam_widgets_init



if ( ! function_exists( 'gifam_customize_register' ) ) :

function gifam_customize_register( $wp_customize ) {
    // Do stuff with $wp_customize, the WP_Customize_Manager object.

    /* Pinegrow generated Customizer Controls Begin */

    /* Pinegrow generated Customizer Controls End */

}
add_action( 'customize_register', 'gifam_customize_register' );
endif;// gifam_customize_register


if ( ! function_exists( 'gifam_enqueue_scripts' ) ) :
    function gifam_enqueue_scripts() {

        /* Pinegrow generated Enqueue Scripts Begin */

    wp_deregister_script( 'gifam-emaildecode' );
    wp_enqueue_script( 'gifam-emaildecode', get_template_directory_uri() . '/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-modernizr' );
    wp_enqueue_script( 'gifam-modernizr', get_template_directory_uri() . '/js/modernizr-3.5.0.min.js', [], '2.8', true);

    wp_deregister_script( 'jquery' );
    wp_enqueue_script( 'jquery', get_template_directory_uri() . '/js/jquery.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-popper' );
    wp_enqueue_script( 'gifam-popper', get_template_directory_uri() . '/js/popper.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-bootstrap' );
    wp_enqueue_script( 'gifam-bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-jquerywaypoints' );
    wp_enqueue_script( 'gifam-jquerywaypoints', get_template_directory_uri() . '/js/jquery.waypoints.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-jquerycounterup' );
    wp_enqueue_script( 'gifam-jquerycounterup', get_template_directory_uri() . '/js/jquery.counterup.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-wow' );
    wp_enqueue_script( 'gifam-wow', get_template_directory_uri() . '/js/wow.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-slick' );
    wp_enqueue_script( 'gifam-slick', get_template_directory_uri() . '/js/slick.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-jqueryappear' );
    wp_enqueue_script( 'gifam-jqueryappear', get_template_directory_uri() . '/js/jquery.appear.js', [], '2.8', true);

    wp_deregister_script( 'gifam-jqueryaspieprogress' );
    wp_enqueue_script( 'gifam-jqueryaspieprogress', get_template_directory_uri() . '/js/jquery-asPieProgress.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-jquerymagnificpopup' );
    wp_enqueue_script( 'gifam-jquerymagnificpopup', get_template_directory_uri() . '/js/jquery.magnific-popup.min.js', [], '2.8', true);

    wp_deregister_script( 'gifam-main' );
    wp_enqueue_script( 'gifam-main', get_template_directory_uri() . '/js/main.js', [], '2.8', true);

    /* Pinegrow generated Enqueue Scripts End */

        /* Pinegrow generated Enqueue Styles Begin */

    wp_deregister_style( 'gifam-bootstrap' );
    wp_enqueue_style( 'gifam-bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-icofont' );
    wp_enqueue_style( 'gifam-icofont', get_template_directory_uri() . '/fonts/icofont.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-flaticon' );
    wp_enqueue_style( 'gifam-flaticon', get_template_directory_uri() . '/fonts/flaticon/flaticon.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-slick' );
    wp_enqueue_style( 'gifam-slick', get_template_directory_uri() . '/css/slick.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-magnificpopup' );
    wp_enqueue_style( 'gifam-magnificpopup', get_template_directory_uri() . '/css/magnific-popup.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-animate' );
    wp_enqueue_style( 'gifam-animate', get_template_directory_uri() . '/css/animate.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-style' );
    wp_enqueue_style( 'gifam-style', get_template_directory_uri() . '/css/style.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-responsive' );
    wp_enqueue_style( 'gifam-responsive', get_template_directory_uri() . '/css/responsive.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-nice' );
    wp_enqueue_style( 'gifam-nice', get_template_directory_uri() . '/css/nice-select.css', [], '2.8', 'all');

    wp_deregister_style( 'gifam-style-1' );
    wp_enqueue_style( 'gifam-style-1', get_bloginfo('stylesheet_url'), [], '2.8', 'all');

    /* Pinegrow generated Enqueue Styles End */

    }
    add_action( 'wp_enqueue_scripts', 'gifam_enqueue_scripts' );
endif;

function pgwp_sanitize_placeholder($input) { return $input; }
/*
 * Resource files included by Pinegrow.
 */
/* Pinegrow generated Include Resources Begin */
require_once "inc/custom.php";
if( !class_exists( 'PG_Helper_v2' ) ) { require_once "inc/wp_pg_helpers.php"; }

    /* Pinegrow generated Include Resources End */

/* Setting up theme supports options */

function gifam_setup_theme_supports() {
    // Don't edit anything between the following comments.
    /* Pinegrow generated Theme Supports Begin */
    
//Tell WP to scope loaded editor styles to the block editor                    
add_theme_support( 'editor-styles' );
    /* Pinegrow generated Theme Supports End */
}
add_action('after_setup_theme', 'gifam_setup_theme_supports');

/* End of setting up theme supports options */


/* Loading editor styles for blocks */

function gifam_add_blocks_editor_styles() {
// Add blocks editor styles. Don't edit anything between the following comments.
/* Pinegrow generated Load Blocks Editor Styles Begin */
    add_editor_style( 'css/style.css' );
    add_editor_style( 'css/slick.css' );
    add_editor_style( 'css/animate.css' );
    add_editor_style( 'css/bootstrap.min.css' );
    add_editor_style( 'css/responsive.css' );
    add_editor_style( 'css/nice-select.css' );

    /* Pinegrow generated Load Blocks Editor Styles End */
}
add_action('admin_init', 'gifam_add_blocks_editor_styles');

/* End of loading editor styles for blocks */


/* Control how block assets are loaded on the front-end */
function gifam_should_load_separate_core_block_assets() {
    /* Pinegrow generated Load Block Assets Separately Begin */
    //Load only assets of blocks that are used on the page
    add_filter( 'should_load_separate_core_block_assets', '__return_true' );

    /* Pinegrow generated Load Block Assets Separately End */
}
add_action('init', 'gifam_should_load_separate_core_block_assets');
/* End of controlling how block assets are loaded on the front-end */

?>