<?php include '../url.php'; ?>
<div id="wpwrap">
<?php include '../menu.php'; ?>
	<div id="wpcontent">
	<?php include '../wpadminbar.php'; ?>
		<div id="wpbody" role="main">
			<div id="wpbody-content" aria-label="Main content" tabindex="0" style="overflow: hidden;">
				<br><br>
				<?php
				ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

				
							// include '../../db.php';


// session_start();
require_once '../../db.php'; // contient $pdo = new PDO(...)

function e($str) {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

// Réponse JSON standard
function send_json($data) {
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');

    // Mise à jour de l’intro
    if (isset($_POST['update_intro'])) {
        $intro_title = $_POST['intro_title'] ?? '';
        $intro_text = $_POST['intro_text'] ?? '';
        $id = $_POST['id'] ?? 1;

        $stmt = $pdo->prepare("UPDATE services_portfolios SET intro_title = ?, intro_text = ? WHERE id = ?");
        $success = $stmt->execute([$intro_title, $intro_text, $id]);

        send_json([
            'success' => $success,
            'message' => $success ? "Intro updated successfully." : "Error updating intro."
        ]);
    }

    // Suppression d’un portfolio
    if (isset($_POST['delete_portfolio'])) {
        $id = (int) ($_POST['id'] ?? 0);

        if ($id === 1) {
            send_json(['success' => false, 'message' => 'Cannot delete intro.']);
        }

        $stmt = $pdo->prepare("DELETE FROM services_portfolios WHERE id = ?");
        $success = $stmt->execute([$id]);

        send_json([
            'success' => $success,
            'message' => $success ? "Portfolio deleted." : "Error deleting portfolio."
        ]);
    }

    // Ajout ou modification
    if (isset($_POST['save_portfolio'])) {
        $id = $_POST['id'] ?? null;
        $location = $_POST['location'] ?? '';
        $description = $_POST['description'] ?? '';
        $image = $_POST['image'] ?? '';

        if ($id && $id != 1) {
            $stmt = $pdo->prepare("UPDATE services_portfolios SET location = ?, description = ?, image = ? WHERE id = ?");
            $success = $stmt->execute([$location, $description, $image, $id]);
            $msg = $success ? 'Portfolio updated.' : 'Error updating portfolio.';
        } else {
            $stmt = $pdo->prepare("INSERT INTO services_portfolios (location, description, image) VALUES (?, ?, ?)");
            $success = $stmt->execute([$location, $description, $image]);
            $msg = $success ? 'Portfolio added.' : 'Error adding portfolio.';
        }

        send_json(['success' => $success, 'message' => $msg]);
    }

    send_json(['success' => false, 'message' => 'Invalid request.']);
}
?>


    <style>
        form {
            border: 1px solid #ccc;
            padding: 16px;
            margin-bottom: 20px;
            background-color: #f9f9f9;
        }
        input, textarea {
            width: 100%;
            margin-bottom: 10px;
            padding: 8px;
        }
        button {
            padding: 10px 15px;
            background-color: #0d6efd;
            color: #fff;
            border: none;
            cursor: pointer;
        }
        .message {
            margin: 10px 0;
            color: green;
        }
        .error {
            color: red;
        }
    </style>


<h1>Gestion des Portfolios</h1>

<?php
require_once '../../db.php';

$stmt = $pdo->query("SELECT * FROM services_portfolios ORDER BY id ASC");
$portfolios = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div id="message-box" class="message"></div>

<?php foreach ($portfolios as $item): ?>
    <?php if ($item['id'] == 1): ?>
        <!-- Intro form -->
        <form method="POST" action="">
            <h2>Intro (non supprimable)</h2>
            <input type="hidden" name="id" value="<?= $item['id'] ?>">
            <input type="text" name="intro_title" value="<?= htmlspecialchars($item['intro_title']) ?>" placeholder="Titre">
            <textarea name="intro_text" rows="4" placeholder="Texte"><?= htmlspecialchars($item['intro_text']) ?></textarea>
            <button type="submit" name="update_intro">Modifier l’intro</button>
        </form>
    <?php else: ?>
        <!-- Portfolio edit form -->
        <form method="POST" action="">
            <h3>Portfolio #<?= $item['id'] ?></h3>
            <input type="hidden" name="id" value="<?= $item['id'] ?>">
            <input type="text" name="location" value="<?= htmlspecialchars($item['location']) ?>" placeholder="Localisation">
            <textarea name="description" rows="4" placeholder="Description"><?= htmlspecialchars($item['description']) ?></textarea>
            <input type="text" name="image" value="<?= htmlspecialchars($item['image']) ?>" placeholder="Image (chemin)">
            <button type="submit" name="save_portfolio">Enregistrer</button>
            <button type="submit" name="delete_portfolio" style="background-color:red;">Supprimer</button>
        </form>
    <?php endif; ?>
<?php endforeach; ?>

<!-- Ajout d’un nouveau portfolio -->
<form method="POST" action="">
    <h2>Ajouter un nouveau portfolio</h2>
    <input type="text" name="location" placeholder="Localisation" required>
    <textarea name="description" rows="4" placeholder="Description" required></textarea>
    <input type="text" name="image" placeholder="Image (chemin)" required>
    <button type="submit" name="save_portfolio">Ajouter</button>
</form>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const forms = document.querySelectorAll("form");

    forms.forEach(form => {
        form.addEventListener("submit", async function (e) {
            e.preventDefault();

            const formData = new FormData(form);

            try {
                const response = await fetch(form.action, {
                    method: "POST",
                    body: formData
                });

                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }

                const result = await response.json();
                alert(result.message);
            } catch (error) {
                alert("Erreur serveur ou réponse invalide");
                console.error("Détail de l’erreur : ", error);
            }
        });
    });
});
</script>






				<div class="wrap"></div>
			</div>
			<!-- wpbody-content -->
			<div class="clear"></div>
		</div>
		<!-- wpbody -->
		<div class="clear"></div>
	</div>
  <?php include '../css.php'; ?>
