<?php
// Connexion à la base de données
$host = 'localhost';
$user = 'root';
$pass = 'root';
$db = 'gifam';
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die('Erreur de connexion à la base de données : ' . $conn->connect_error);
}
$message = '';
// Récupération de la page à éditer
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($id <= 0) {
    die('ID de page invalide.');
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title']);
    $slug = trim($_POST['slug']);
    $content = $_POST['content'];
    if ($title && $slug) {
        $stmt = $conn->prepare("UPDATE pages SET title=?, slug=?, content=?, updated_at=NOW() WHERE id=?");
        $stmt->bind_param('sssi', $title, $slug, $content, $id);
        if ($stmt->execute()) {
            header('Location: index.php?updated=1');
            exit;
        } else {
            $message = "Erreur lors de la mise à jour : " . $conn->error;
        }
        $stmt->close();
    } else {
        $message = "Veuillez remplir tous les champs obligatoires.";
    }
}
// Charger les données de la page
$stmt = $conn->prepare("SELECT * FROM pages WHERE id=?");
$stmt->bind_param('i', $id);
$stmt->execute();
$result = $stmt->get_result();
$page = $result->fetch_assoc();
$stmt->close();
if (!$page) {
    die('Page non trouvée.');
}
// Récupérer la liste des pages pour le parent
$parents = [];
$res = $conn->query("SELECT id, title, slug FROM pages WHERE id != $id ORDER BY slug ASC");
if ($res) {
    while($row = $res->fetch_assoc()) {
        $parents[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Éditer la page - GIFAM Admin</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    <style>
        body { background: #f8f9fa; }
        .admin-form { background: white; border-radius: 10px; box-shadow: 0 2px 12px rgba(0,0,0,0.07); margin-top: 40px; }
        .admin-header { background: #dc3545; color: white; border-radius: 10px 10px 0 0; padding: 30px 20px 20px; }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="admin-form p-4">
            <div class="admin-header mb-4">
                <h2 class="mb-0">Éditer la page</h2>
            </div>
            <?php if ($message): ?>
                <div class="alert alert-danger"><?php echo $message; ?></div>
            <?php endif; ?>
            <form method="post">
                <div class="mb-3">
                    <label for="parent_id" class="form-label">Page parente</label>
                    <select class="form-select" id="parent_id" name="parent_id">
                        <option value="">Aucune (page principale)</option>
                        <?php foreach($parents as $par): ?>
                            <option value="<?php echo $par['id']; ?>" <?php if($page['parent_id']==$par['id']) echo 'selected'; ?>><?php echo htmlspecialchars($par['title']) . ' (' . htmlspecialchars($par['slug']) . ')'; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="title" class="form-label">Titre de la page *</label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo htmlspecialchars($page['title']); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="slug" class="form-label">Slug (URL) * <small class="text-muted">(ex: about, services/investment, blog/article-1)</small></label>
                    <input type="text" class="form-control" id="slug" name="slug" value="<?php echo htmlspecialchars($page['slug']); ?>" required pattern="^[a-zA-Z0-9\-/]+$" title="Lettres, chiffres, tirets et slashs autorisés">
                </div>
                <div class="mb-3">
                    <label for="content" class="form-label">Contenu HTML</label>
                    <textarea class="form-control" id="content" name="content" rows="10"><?php echo htmlspecialchars($page['content']); ?></textarea>
                </div>
                <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                <a href="index.php" class="btn btn-secondary">Annuler</a>
            </form>
        </div>
    </div>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
      tinymce.init({
        selector: '#content',
        height: 400,
        menubar: false,
        plugins: [
          'advlist autolink lists link image charmap print preview anchor',
          'searchreplace visualblocks code fullscreen',
          'insertdatetime media table paste code help wordcount'
        ],
        toolbar: 'undo redo | formatselect | bold italic backcolor | \
        alignleft aligncenter alignright alignjustify | \
        bullist numlist outdent indent | removeformat | help',
        language: 'fr_FR'
      });
    </script>
</body>
</html>
<?php $conn->close(); ?> 
