<?php
// Connexion à la base de données
$host = 'localhost';
$user = 'root';
$pass = 'root';
$db = 'gifam';
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die('Erreur de connexion à la base de données : ' . $conn->connect_error);
}

// Liste des dossiers/pages à importer (à adapter selon votre arborescence)
$pages = [
    ['slug' => 'about', 'title' => 'À propos'],
    ['slug' => 'contact-us', 'title' => 'Contact'],
    ['slug' => 'investment', 'title' => 'Investissement'],
    ['slug' => 'investment/investment-management', 'title' => 'Gestion d’investissement'],
    ['slug' => 'investment/investment-in-bonds', 'title' => 'Investissement en obligations'],
    ['slug' => 'investment/mutual-funds', 'title' => 'Fonds communs de placement'],
    ['slug' => 'faq', 'title' => 'FAQ'],
    ['slug' => 'compnay-history', 'title' => 'Historique de la société'],
    ['slug' => 'privacy-policy', 'title' => 'Politique de confidentialité'],
    ['slug' => 'cookie-policy', 'title' => 'Politique de cookies'],
    ['slug' => 'legal-notices', 'title' => 'Mentions légales'],
    ['slug' => 'legal-disclaimer', 'title' => 'Avertissement légal'],
    ['slug' => 'terms-and-conditions', 'title' => 'Conditions générales'],
    ['slug' => 'our-services', 'title' => 'Nos services'],
    ['slug' => 'project-financing-consultation', 'title' => 'Consultation financement de projet'],
    ['slug' => 'investment-analysis-advisory', 'title' => 'Analyse & conseil investissement'],
    ['slug' => 'taxes-planning', 'title' => 'Planification fiscale'],
    ['slug' => 'business-growth', 'title' => 'Croissance entreprise'],
    // Ajoutez ici d'autres pages ou sous-pages si besoin
];

$imported = 0;
foreach ($pages as $p) {
    $slug = $p['slug'];
    $title = $p['title'];
    // Vérifier si la page existe déjà
    $stmt = $conn->prepare("SELECT id FROM pages WHERE slug=?");
    $stmt->bind_param('s', $slug);
    $stmt->execute();
    $stmt->store_result();
    if ($stmt->num_rows == 0) {
        // Insérer la page
        $stmt2 = $conn->prepare("INSERT INTO pages (title, slug, content) VALUES (?, ?, '')");
        $stmt2->bind_param('ss', $title, $slug);
        $stmt2->execute();
        $stmt2->close();
        $imported++;
    }
    $stmt->close();
}
$conn->close();
echo "$imported pages importées avec succès."; 
