<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="Contact GIFAM for your financial advisory, investment and asset management needs. Our team of experts is here to support you with personalized solutions.">
    <meta name="keywords" content="contact GIFAM, financial advisory, investment consulting, asset management, project financing, Cyprus">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title>Contact Us - GIFAM Investment Consulting</title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>contact-us/">Contact Us</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Hero Section -->
    <section class="contact-hero bg-primary text-white py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4">Let's Start Your Investment Journey</h1>
                        <p class="lead mb-4">
                            Ready to take your investment projects to the next level? Our team of financial experts is here to guide you through every step of your journey.
                        </p>
                        <div class="hero-stats">
                            <div class="row text-center">
                                <div class="col-4">
                                    <div class="stat-item">
                                        <h3 class="fw-bold">500+</h3>
                                        <p>Projects Completed</p>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="stat-item">
                                        <h3 class="fw-bold">50+</h3>
                                        <p>Countries Served</p>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="stat-item">
                                        <h3 class="fw-bold">24/7</h3>
                                        <p>Support Available</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hero-image text-center">
                        <img src="<?php echo $url; ?>images/case-study/case-study-1.jpg" alt="GIFAM Contact" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact-section py-5">
        <div class="container">
            <div class="row">
                <!-- Contact Information -->
                <div class="col-lg-5">
                    <div class="contact-info-card h-100">
                        <div class="card border-0 shadow-lg h-100">
                            <div class="card-body p-4">
                                <h2 class="card-title mb-4">Get In Touch</h2>
                                <p class="card-text mb-4">
                                    At GIFAM, we are committed to providing exceptional customer service. 
                                    Our team of financial experts is available to answer all your questions 
                                    and support you in your investment projects.
                                </p>

                                <div class="contact-details">
                                    <div class="contact-item d-flex align-items-start mb-4">
                                        <div class="contact-icon me-3">
                                            <i class="icofont-location-pin text-primary"></i>
                                        </div>
                                        <div class="contact-text">
                                            <h6 class="fw-bold mb-1">Our Address</h6>
                                            <address class="mb-0">
                                                AYIOU PAVLOU 61<br>
                                                AGIOS DOMETIOS<br>
                                                CYPRUS
                                            </address>
                                        </div>
                                    </div>

                                    <div class="contact-item d-flex align-items-start mb-4">
                                        <div class="contact-icon me-3">
                                            <i class="icofont-envelope text-primary"></i>
                                        </div>
                                        <div class="contact-text">
                                            <h6 class="fw-bold mb-1">Email Us</h6>
                                            <p class="mb-0">
                                                <a href="mailto:info@gifam.eu" class="text-decoration-none">
                                                    info@gifam.eu
                                                </a>
                                            </p>
                                        </div>
                                    </div>

                                    <div class="contact-item d-flex align-items-start mb-4">
                                        <div class="contact-icon me-3">
                                            <i class="icofont-phone text-primary"></i>
                                        </div>
                                        <div class="contact-text">
                                            <h6 class="fw-bold mb-1">Call Us</h6>
                                            <p class="mb-0">
                                                <a href="tel:+35796306456" class="text-decoration-none d-block">+35 796 306 456</a>
                                                <a href="tel:+971523801458" class="text-decoration-none d-block">+971 523 801 458</a>
                                                <a href="tel:+447747246568" class="text-decoration-none d-block">+44 774 724 6568</a>
                                            </p>
                                        </div>
                                    </div>

                                    <div class="contact-item d-flex align-items-start mb-4">
                                        <div class="contact-icon me-3">
                                            <i class="icofont-clock-time text-primary"></i>
                                        </div>
                                        <div class="contact-text">
                                            <h6 class="fw-bold mb-1">Business Hours</h6>
                                            <p class="mb-0">
                                                Monday - Friday: 9:00 AM - 6:00 PM (GMT+2)<br>
                                                Saturday: 9:00 AM - 2:00 PM<br>
                                                Sunday: Closed
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="social-links mt-4">
                                    <h6 class="fw-bold mb-3">Follow Us</h6>
                                    <div class="d-flex gap-3">
                                        <a href="#" class="social-link" aria-label="Facebook">
                                            <i class="icofont-facebook"></i>
                                        </a>
                                        <a href="#" class="social-link" aria-label="Twitter">
                                            <i class="icofont-twitter"></i>
                                        </a>
                                        <a href="#" class="social-link" aria-label="LinkedIn">
                                            <i class="icofont-linkedin"></i>
                                        </a>
                                        <a href="#" class="social-link" aria-label="Instagram">
                                            <i class="icofont-instagram"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Form -->
                <div class="col-lg-7">
                    <div class="contact-form-card">
                        <div class="card border-0 shadow-lg">
                            <div class="card-body p-4">
                                <h2 class="card-title mb-4">Send Us a Message</h2>
                                <p class="card-text mb-4">
                                    Fill out the form below and our team will contact you within 24 hours.
                                </p>
                                
                                <form class="contact-form" id="contactForm">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="name" class="form-label fw-bold">Full Name *</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       id="name" 
                                                       name="name"
                                                       placeholder="Your full name"
                                                       required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="email" class="form-label fw-bold">Email Address *</label>
                                                <input type="email" 
                                                       class="form-control" 
                                                       id="email" 
                                                       name="email"
                                                       placeholder="your.email@example.com"
                                                       required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="phone" class="form-label fw-bold">Phone Number</label>
                                                <input type="tel" 
                                                       class="form-control" 
                                                       id="phone" 
                                                       name="phone"
                                                       placeholder="+1 234 567 8900">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="company" class="form-label fw-bold">Company</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       id="company" 
                                                       name="company"
                                                       placeholder="Your company name">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="inquiry" class="form-label fw-bold">Type of Inquiry *</label>
                                                <select class="form-control" 
                                                        id="inquiry" 
                                                        name="inquiry"
                                                        required>
                                                    <option value="">Select an inquiry type</option>
                                                    <option value="investment">Investment Advisory</option>
                                                    <option value="project-financing">Project Financing</option>
                                                    <option value="asset-management">Asset Management</option>
                                                    <option value="risk-management">Risk Management</option>
                                                    <option value="market-entry">Market Entry Strategy</option>
                                                    <option value="mining-exploration">Mining Exploration</option>
                                                    <option value="oil-gas">Oil & Gas</option>
                                                    <option value="agritech">AgriTech</option>
                                                    <option value="real-estate">Real Estate Development</option>
                                                    <option value="telecommunications">Telecommunications</option>
                                                    <option value="infrastructure">Infrastructure</option>
                                                    <option value="general">General Inquiry</option>
                                                    <option value="other">Other</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="budget" class="form-label fw-bold">Estimated Budget</label>
                                                <select class="form-control" 
                                                        id="budget" 
                                                        name="budget">
                                                    <option value="">Select a budget range</option>
                                                    <option value="under-50k">Under €50,000</option>
                                                    <option value="50k-200k">€50,000 - €200,000</option>
                                                    <option value="200k-1m">€200,000 - €1,000,000</option>
                                                    <option value="1m-5m">€1,000,000 - €5,000,000</option>
                                                    <option value="over-5m">Over €5,000,000</option>
                                                    <option value="not-specified">Not specified</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="message" class="form-label fw-bold">Message *</label>
                                        <textarea class="form-control" 
                                                  id="message" 
                                                  name="message"
                                                  rows="6" 
                                                  placeholder="Describe your project or request in detail..."
                                                  style="min-height: 120px; resize: vertical;"
                                                  required></textarea>
                                    </div>

                                    <div class="form-group mb-4">
                                        <div class="form-check">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   id="privacy" 
                                                   name="privacy"
                                                   required>
                                            <label class="form-check-label" for="privacy">
                                                I accept the <a href="<?php echo $url; ?>privacy-policy/" target="_blank" class="text-decoration-none">privacy policy</a> *
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <button type="submit" 
                                                class="btn btn-primary btn-lg w-100"
                                                id="submitBtn">
                                            <i class="icofont-send-mail me-2"></i>
                                            Send Message
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Map Section -->
    <section class="map-section py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="text-center mb-4">
                        <h2 class="fw-bold">Find Our Office</h2>
                        <p class="lead">Visit us at our headquarters in Cyprus</p>
                    </div>
                    <div class="map-container">
                        <div class="card border-0 shadow-lg">
                            <div class="card-body p-0">
                                <iframe 
                                    src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3258.1234567890123!2d33.12345678901234!3d35.12345678901234!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzXCsDA3JzM0LjQiTiAzM8KwMDcjMzQuNCJF!5e0!3m2!1sen!2sus!4v1234567890123"
                                    width="100%" 
                                    height="450" 
                                    style="border:0;" 
                                    allowfullscreen="" 
                                    loading="lazy"
                                    referrerpolicy="no-referrer-when-downgrade"
                                    title="Map showing GIFAM office location in Cyprus">
                                </iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="faq-section py-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="text-center mb-5">
                        <h2 class="fw-bold">Frequently Asked Questions</h2>
                        <p class="lead">Get quick answers to common questions</p>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="faq-item mb-4">
                                <h5 class="fw-bold mb-2">How quickly will you respond to my inquiry?</h5>
                                <p class="mb-0">We typically respond within 24 hours during business days. For urgent matters, please call us directly.</p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="faq-item mb-4">
                                <h5 class="fw-bold mb-2">What information should I prepare for our first meeting?</h5>
                                <p class="mb-0">Please have your project details, budget range, and any specific requirements ready for discussion.</p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="faq-item mb-4">
                                <h5 class="fw-bold mb-2">Do you offer services internationally?</h5>
                                <p class="mb-0">Yes, we serve clients globally and have experience in over 50 countries across various industries.</p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="faq-item mb-4">
                                <h5 class="fw-bold mb-2">What is your minimum project size?</h5>
                                <p class="mb-0">We work with projects starting from €20 million, offering tailored solutions for each client's needs.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

<style>
    /* Hero Section */
    .contact-hero {
        background: linear-gradient(135deg, #000000 0%, #000000 100%);
        position: relative;
        overflow: hidden;
    }
    
    .contact-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.1;
    }
    
    .hero-content {
        position: relative;
        z-index: 2;
    }
    
    .stat-item {
        padding: 1rem;
        border-radius: 10px;
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
    }
    
    .stat-item h3 {
        font-size: 2rem;
        margin-bottom: 0.5rem;
    }
    
    /* Contact Section */
    .contact-info-card,
    .contact-form-card {
        transition: transform 0.3s ease;
    }
    
    .contact-info-card:hover,
    .contact-form-card:hover {
        transform: translateY(-5px);
    }
    
    .contact-icon {
        width: 40px;
        height: 40px;
        background: #dc3545;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    
    .contact-icon i {
        font-size: 1.2rem;
    }
    
    .social-links .social-link {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        background: #f8f9fa;
        border-radius: 50%;
        color: #666;
        text-decoration: none;
        transition: all 0.3s ease;
    }
    
    .social-links .social-link:hover {
        background: #d12907;
        color: white;
        transform: translateY(-2px);
    }
    
    /* Form Styling */
    .form-control {
        border: 2px solid #e9ecef;
        border-radius: 10px;
        padding: 0rem 1.25rem;
        font-size: 1rem;
        line-height: 1.5;
        min-height: 50px;
        background-color: #ffffff;
        color: #000000;
        transition: all 0.3s ease;
    }
    
    .form-control::placeholder {
        color: #6c757d;
        opacity: 0.8;
    }
    
    select.form-control:invalid {
        color: #6c757d;
    }
    
    select.form-control option:first-child {
        color: #6c757d;
        font-style: italic;
    }
    
    select.form-control {
        background-color: #ffffff;
        *background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23000000' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m1 6 7 7 7-7'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 1rem center;
        background-size: 16px 12px;
        padding-right: 2.5rem;
        color: #000000;
        font-weight: 500;
    }
    
    select.form-control option {
        background-color: #ffffff;
        color: #000000;
        padding: 0.5rem;
    }
    
    select.form-control:focus {
        background-color: #ffffff;
        color: #000000;
    }
    
    .form-control:focus {
        border-color:rgb(0, 0, 0);
        box-shadow: 0 0 0 0.2rem rgba(0, 0, 0, 0.25);
    }
    
    .form-label {
        color: #333;
        margin-bottom: 0.75rem;
        font-size: 1rem;
        font-weight: 600;
    }
    
    .btn-primary {
        background: linear-gradient(135deg,rgb(0, 0, 0) 0%,rgb(0, 0, 0) 100%);
        border: none;
        border-radius: 10px;
        padding: 0.75rem 2rem;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.4);
    }
    
    /* Map Section */
    .map-container {
        border-radius: 15px;
        overflow: hidden;
    }
    
    /* FAQ Section */
    .faq-item {
        padding: 1.5rem;
        background: #f8f9fa;
        border-radius: 10px;
        border-left: 4px solidrgb(0, 0, 0);
        transition: all 0.3s ease;
    }
    
    .faq-item:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .hero-stats {
            margin-top: 2rem;
        }
        
        .stat-item h3 {
            font-size: 1.5rem;
        }
        
        .contact-info-card,
        .contact-form-card {
            margin-bottom: 2rem;
        }
    }
    
    /* Animation Classes */
    .fade-in {
        animation: fadeIn 0.6s ease-in;
    }
    
    .slide-up {
        animation: slideUp 0.6s ease-out;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    
    @keyframes slideUp {
        from { 
            opacity: 0;
            transform: translateY(30px);
        }
        to { 
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

<script>
$(document).ready(function() {
    // Form validation and submission
    $('#contactForm').on('submit', function(e) {
        e.preventDefault();
        
        // Basic validation
        let isValid = true;
        const requiredFields = ['name', 'email', 'inquiry', 'message'];
        
        requiredFields.forEach(field => {
            const value = $(`#${field}`).val().trim();
            if (!value) {
                $(`#${field}`).addClass('is-invalid');
                isValid = false;
            } else {
                $(`#${field}`).removeClass('is-invalid');
            }
        });
        
        if (isValid) {
            // Show loading state
            $('#submitBtn').html('<i class="icofont-spinner-alt-4 me-2"></i>Sending...').prop('disabled', true);
            
            // Simulate form submission (replace with actual form handling)
            setTimeout(() => {
                $('#submitBtn').html('<i class="icofont-check-circled me-2"></i>Message Sent!').removeClass('btn-primary').addClass('btn-success');
                
                // Reset form after 3 seconds
                setTimeout(() => {
                    $('#contactForm')[0].reset();
                    $('#submitBtn').html('<i class="icofont-send-mail me-2"></i>Send Message').removeClass('btn-success').addClass('btn-primary').prop('disabled', false);
                }, 3000);
            }, 2000);
        }
    });
    
    // Add animation classes on scroll
    $(window).on('scroll', function() {
        $('.contact-info-card, .contact-form-card, .faq-item').each(function() {
            const elementTop = $(this).offset().top;
            const elementBottom = elementTop + $(this).outerHeight();
            const viewportTop = $(window).scrollTop();
            const viewportBottom = viewportTop + $(window).height();
            
            if (elementBottom > viewportTop && elementTop < viewportBottom) {
                $(this).addClass('fade-in');
            }
        });
    });
    
    // Initialize animations
    $('.contact-info-card, .contact-form-card').addClass('slide-up');
});
</script>

</body>
</html>
