﻿<?php
 include 'url.php';
 ?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="utf-8">
    <meta name="author" content="thecodude">
    <meta name="description" content="">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title>Gifam – Gifam Consulting</title>

    <!-- Balises SEO optimisées -->
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    <meta name="googlebot" content="index, follow">
    <meta name="bingbot" content="index, follow">
    <meta name="description" content="GIFAM - Conseil en investissement financier, gestion d'actifs, analyse financière, accompagnement de projets internationaux, expertise en gestion des risques, solutions de financement innovantes.">
    <meta name="keywords" content="investissement, finance, gestion d'actifs, analyse financière, conseil financier, financement de projet, gestion des risques, GIFAM, consulting, international, solutions financières">
    <link rel="canonical" href="https://www.gifam.eu/">
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="GIFAM – Conseil en investissement et gestion d'actifs">
    <meta property="og:description" content="Expertise en investissement, gestion d'actifs, analyse financière et accompagnement de projets internationaux.">
    <meta property="og:url" content="https://www.gifam.eu/">
    <meta property="og:image" content="https://www.gifam.eu/images/logos/logo_default.png">
    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="GIFAM – Conseil en investissement et gestion d'actifs">
    <meta name="twitter:description" content="Expertise en investissement, gestion d'actifs, analyse financière et accompagnement de projets internationaux.">
    <meta name="twitter:image" content="https://www.gifam.eu/images/logos/logo_default.png">

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css"> <!-- Template Stylesheet -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

</head>
<body>
<?php include 'header.php'; ?>

<main class="ras-main-content">

    <!-- Banner Start -->
    <section class="ras-banner ras-banner-1">
        <div class="slider-active text-center">
            <div class="ras-slide">
                <div class="container">
                    <div class="ras-slide-content">
                        <h3 class="ras-slide-sub-heading text-white">Financial Planners</h3>
                        <h2 class="ras-slide-heading text-white">FINANCIAL INVESTMENT ANALYSIS</h2>
                        <p class="ras-slide-desc text-white mb-50">At General Investment Fund Assets & Management Company (GIFAM), we specialize in the provision of financial support for a diverse range of global projects.</p>
                        <a href="<?php echo $url; ?>investment/" class="btn btn-primary btn-large hero-btn">Invest Now<i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <div class="ras-slide">
                <div class="container">
                    <div class="ras-slide-content">
                        <h3 class="ras-slide-sub-heading text-white">Financial Planners</h3>
                        <h2 class="ras-slide-heading text-white">FINANCIAL INVESTMENT ANALYSIS</h2>
                        <p class="ras-slide-desc text-white mb-50">At General Investment Fund Assets & Management Company (GIFAM), we specialize in the provision of financial support for a diverse range of global projects.</p>
                        <a href="<?php echo $url; ?>investment/" class="btn btn-primary btn-large hero-btn">Invest Now<i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <div class="ras-slide">
                <div class="container">
                    <div class="ras-slide-content">
                        <h3 class="ras-slide-sub-heading text-white">Financial Planners</h3>
                        <h2 class="ras-slide-heading text-white">FINANCIAL INVESTMENT ANALYSIS</h2>
                        <p class="ras-slide-desc text-white mb-50">At General Investment Fund Assets & Management Company (GIFAM), we specialize in the provision of financial support for a diverse range of global projects.</p>
                        <a href="<?php echo $url; ?>investment/" class="btn btn-primary btn-large hero-btn">Invest Now<i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Banner End -->

    <!-- Video Start -->
    <section class="ras-video">
        <h2 class="sr-only">Video</h2>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="ras-video-container wow fadeInUp">
                        <img src="<?php echo $url; ?>images/video/video-img.jpg" alt="Banner Video">
                        <a class="ras-vid-icon ras-video-lightbox vbox-item more" href="https://www.youtube.com/watch?time_continue=10&v=Vj3AUQNLbg4">
                            <i class="icofont-ui-play"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Video End -->

    <!-- Services Start -->
    <section class="ras-services ras-services-1 ras-service-1-spacer-bottom">
        <div class="container">
            <h2 class="mb-50 text-center wow fadeInUp">25 Years of Quality<br>Service in <span class="color-title">Finance</span></h2>
            <div class="row align-items-center mb-50">
                <div class="col-lg-4">
                    <div class="ras-services-item wow fadeInLeft">
                        <div class="ras-service-info">
                            <div class="d-flex flex-column justify-content-between">
                                <div class="ras-service-icon purple-bg-icon">
                                    <i class="flaticon-start-up"></i>
                                </div>
                                <div class="ras-service-title-wrap">
                                    <h3 class="ras-service-title"><a href="#">Project Financing Consultation</a></h3>
                                    <p class="ras-service-details">GIFAM can offer expert advice on securing financing for large-scale projects.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="ras-services-item wow fadeInLeft">
                        <div class="ras-service-info">
                            <div class="d-flex flex-column justify-content-between">
                                <div class="ras-service-icon orange-bg-icon">
                                    <i class="flaticon-digital-marketing"></i>
                                </div>
                                <div class="ras-service-title-wrap">
                                    <h3 class="ras-service-title"><a href="#">Investment Analysis and Advisory</a></h3>
                                    <p class="ras-service-details">Providing clients with comprehensive investment analysis and advice is crucial.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="ras-services-item wow fadeInLeft">
                        <div class="ras-service-info">
                            <div class="d-flex flex-column justify-content-between">
                                <div class="ras-service-icon skyblue-bg-icon">
                                    <i class="flaticon-strategy"></i>
                                </div>
                                <div class="ras-service-title-wrap">
                                    <h3 class="ras-service-title"><a href="#">Risk Management Consulting</a></h3>
                                    <p class="ras-service-details">In any financial venture, managing risk is paramount.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row align-items-center mb-50">
                <div class="col-lg-4">
                    <div class="ras-services-item wow fadeInLeft">
                        <div class="ras-service-info">
                            <div class="d-flex flex-column justify-content-between">
                                <div class="ras-service-icon purple-bg-icon">
                                    <i class="flaticon-web-programming"></i>
                                </div>
                                <div class="ras-service-title-wrap">
                                    <h3 class="ras-service-title"><a href="#">Asset Management and Portfolio</a></h3>
                                    <p class="ras-service-details">GIFAM can provide asset management services.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="ras-services-item wow fadeInLeft">
                        <div class="ras-service-info">
                            <div class="d-flex flex-column justify-content-between">
                                <div class="ras-service-icon orange-bg-icon">
                                    <i class="flaticon-vector"></i>
                                </div>
                                <div class="ras-service-title-wrap">
                                    <h3 class="ras-service-title"><a href="#">Market Entry and Expansion Strategy</a></h3>
                                    <p class="ras-service-details">New markets or expand their operations.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="ras-services-item wow fadeInLeft">
                        <div class="ras-service-info">
                            <div class="d-flex flex-column justify-content-between">
                                <div class="ras-service-icon skyblue-bg-icon">
                                    <i class="flaticon-checked"></i>
                                </div>
                                <div class="ras-service-title-wrap">
                                    <h3 class="ras-service-title"><a href="#">Corporate Financial Strategy Development</a></h3>
                                    <p class="ras-service-details">GIFAM can assist clients in developing.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Services End -->

    <!-- Who We Are Start -->
    <section class="ras-features ras-features-1 sec-spacer-bottom-120">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="ras-features-details wow fadeInLeft">
                        <h2>Who We Are</h2>
                        <p>At General Investment Fund Assets & Management Company (GIFAM), we specialize in the provision of financial support for a diverse range of global projects. As a company incorporated in Cyprus, we are strategically positioned to offer financial solutions on a global scale.</p>
                        <p>Where our commitment to your success is paramount. Specializing in substantial project financing, we offer bespoke solutions to bring your visionary projects to life. With a focus on projects over $50 million, we are your partners in growth and innovation.</p>
                        <p>Our Philosophy – At GIFAM, we believe in a partnership approach. We listen, analyze, and collaborate with our clients to provide the best financing solutions for ambitious projects. Our support extends beyond funding, ensuring you’re equipped to manage your new capital effectively.</p>
                        <div class="services-list wow fadeInLeft" data-wow-delay="0.3s" style="margin-top:30px;">
                            <a class="service-item" href="<?php echo $url; ?>project-financing-consultation/index.php"><i class="flaticon-start-up purple-bg-icon"></i> Project Financing Consultation</a>
                            <a class="service-item" href="<?php echo $url; ?>investment-analysis-advisory/index.php"><i class="flaticon-digital-marketing orange-bg-icon"></i> Investment Analysis and Advisory</a>
                            <a class="service-item" href="<?php echo $url; ?>risk-management-consulting/index.php"><i class="flaticon-strategy skyblue-bg-icon"></i> Risk Management Consulting</a>
                            <a class="service-item" href="<?php echo $url; ?>market-entry-strategy/index.php"><i class="flaticon-web-programming purple-bg-icon"></i> Market Entry and Strategy</a>
                            <a class="service-item" href="<?php echo $url; ?>corporate-financial-strategy/index.php"><i class="flaticon-vector orange-bg-icon"></i> Corporate Financial Strategy</a>
                            <a class="service-item" href="<?php echo $url; ?>mergers-acquisitions/index.php"><i class="flaticon-checked skyblue-bg-icon"></i> Mergers and Acquisitions</a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="ras-features-image wow fadeInRight" data-wow-duration="1s">
                        <img src="<?php echo $url; ?>images/features/feature-1.jpg" alt="Who We Are - GIFAM Team">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Who We Are End -->

    <!-- Our Strengths Start -->
    <section class="ras-why-choose-us ras-why-choose-us-1">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-5 col-md-12">
                    <h2 class="wow fadeInUp">OUR STRENGTHS</h2>
                    <p class="wow fadeInUp" data-wow-delay="0.2s">At GIFAM, we distinguish ourselves through our deep expertise in the financial sector and our ability to provide customized solutions. Our team of qualified experts combines international experience with in-depth knowledge of local markets, enabling us to provide first-class strategic advice to our clients.</p>
                    
                    <div class="strength-features wow fadeInUp" data-wow-delay="0.4s">
                        <div class="strength-item">
                            <i class="flaticon-start-up purple-bg-icon"></i>
                            <span>Investment Planning</span>
                        </div>
                        <div class="strength-item">
                            <i class="flaticon-digital-marketing orange-bg-icon"></i>
                            <span>Risk Management</span>
                        </div>
                        <div class="strength-item">
                            <i class="flaticon-strategy skyblue-bg-icon"></i>
                            <span>Portfolio Optimization</span>
                        </div>
                        <div class="strength-item">
                            <i class="flaticon-web-programming purple-bg-icon"></i>
                            <span>Asset Management</span>
                        </div>
                    </div>
                    
                    <p class="wow fadeInUp" data-wow-delay="0.6s">Our comprehensive approach ensures that every client receives personalized attention and strategic guidance tailored to their specific financial goals and market conditions.</p>
                </div>
                <div class="col-lg-7 col-md-12">
                    <div class="choose-us-items">
                        <div class="choose-us-item wow fadeInUp">
                            <div class="choose-us-icon purple-bg-icon">
                                <i class="flaticon-man"></i>
                            </div>
                            <div class="choose-us-details">
                                <h3>CORE COMPETENCY</h3>
                                <p>Strategic advisory in the development of investment projects and in raising the necessary funds for financing our clients’ ventures.</p>
                            </div>
                        </div>
                        <div class="choose-us-item wow fadeInUp">
                            <div class="choose-us-icon orange-bg-icon">
                                <i class="flaticon-checked"></i>
                            </div>
                            <div class="choose-us-details">
                                <h3>OUR CONSULTANTS</h3>
                                <p>At GIFAM, we have a team of experts in various key fields (architecture, construction, economics, and finance), which enables us to fulfill our commitments and facilitates the execution of our missions.</p>
                            </div>
                        </div>
                        <div class="choose-us-item wow fadeInUp">
                            <div class="choose-us-icon skyblue-bg-icon">
                                <i class="flaticon-man"></i>
                            </div>
                            <div class="choose-us-details">
                                <h3>CLIENT SERVICES</h3>
                                <p>We are committed to providing our clients and partners with premium, tailor-made customer service to meet their exacting standards.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Our Strengths End -->

    <!-- Recently completed projects Start -->
    <section class="ras-case-study ras-case-study-1">
        <div class="container">
            <h2 class="text-center mb-50 wow fadeInUp">Recently completed projects</h2>
            <div class="row align-items-center">
                <div class="col-md-12 col-lg-6">
                    <div class="ras-single-case-study wow fadeInLeft">
                        <div class="case-study-image case-study-orange">
                            <img src="<?php echo $url; ?>images/case-study/team-4786562_1920.jpg" alt="Mining Project">
                        </div>
                        <h4><a href="#" class="case-study-title">Mining Project</a></h4>
                        <p>Discover the untapped potential of the Tri-Border Area with our latest Mining Exploration Project. Our state-of-the-art exploration techniques, combined with a commitment to sustainability and community partnership, position us at the forefront of uncovering new resources. Join us in this exciting venture as we unlock the geological secrets of the Tri-Border Area, promising substantial returns.</p>
                    </div>
                </div>
                <div class="col-md-12 col-lg-6">
                    <div class="ras-single-case-study wow fadeInLeft">
                        <div class="case-study-image case-study-sky-blue">
                            <img src="<?php echo $url; ?>images/case-study/executive-3461929_1920.jpg" alt="Oil & Gas Project" style="margin-top:-26px">
                        </div>
                        <h4><a href="#" class="case-study-title">Oil & Gas Project</a></h4>
                        <p>Embark on a groundbreaking journey with our Oil & Gas Project spanning the MENA region and Sub-Saharan Africa. This venture taps into the vast, untapped reserves of these energy-rich territories, leveraging cutting-edge technology and sustainable practices. Our project is set to redefine the oil and gas landscape, ensuring responsible extraction and long-term value creation. Join.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Recently completed projects End -->

    <!-- Business overview Start -->
    <section class="ras-features ras-features-1 sec-spacer-bottom-120">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="ras-features-details wow fadeInRight">
                        <h2>Business overview</h2>
                        <p>From the initial Memorandum of Understanding (MoU) to achieving shareholder satisfaction, the journey of Commodities and Real Estate investment in Africa and the Middle East is a complex tapestry of strategic planning and execution. It begins with the MoU, laying the foundational agreements between parties, followed by rigorous geological surveys and feasibility studies to assess potential reserves. Navigating through regulatory approvals and securing necessary permits, the project then moves into the development phase, where infrastructure and extraction technologies are deployed. Throughout this process, continuous stakeholder engagement and adherence to environmental and social governance standards are paramount. The final phase focuses on efficient production and distribution, ensuring profitability and sustainability, ultimately leading to enhanced shareholder value and positive impacts on local communities.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Business overview End -->

    <!-- Testimonials Start -->
    <section class="ras-testimonial ras-testimonial-1 sec-spacer-bottom-100">
        <div class="container">
            <h2 class="text-center mb-50 wow fadeInUp">What Our Clients Say<br>About Our Services</h2>
            <div class="ras-slider-three-col">
                <div class="ras-single-testimonial">
                    <p>"GIFAM's expertise in project financing was exceptional. They helped us secure $75 million for our mining project in Africa. Their strategic approach and deep understanding of international markets made all the difference in our success."</p>
                    <div class="testi-info">
                        <h4 class="ras-testi-name">Sarah Mitchell</h4>
                        <p class="ras-testi-designation">CEO of Global Mining Ventures</p>
                    </div>
                    <div class="ras-rating">
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                    </div>
                    <img class="ras-testi-photo" src="<?php echo $url; ?>images/testimonial/testi-1.jpg" alt="Sarah Mitchell">
                </div>
                <div class="ras-single-testimonial">
                    <p>"The risk management strategies provided by GIFAM were invaluable for our oil & gas expansion. Their comprehensive analysis and tailored solutions helped us navigate complex regulatory environments across multiple countries."</p>
                    <div class="testi-info">
                        <h4 class="ras-testi-name">Ahmed Al-Rashid</h4>
                        <p class="ras-testi-designation">Managing Director, EnergyCorp</p>
                    </div>
                    <div class="ras-rating">
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                    </div>
                    <img class="ras-testi-photo" src="<?php echo $url; ?>images/testimonial/testi-2.jpg" alt="Ahmed Al-Rashid">
                </div>
                <div class="ras-single-testimonial">
                    <p>"Working with GIFAM transformed our investment portfolio. Their asset management services and strategic advisory helped us achieve 23% returns while maintaining optimal risk levels. Truly professional and results-driven."</p>
                    <div class="testi-info">
                        <h4 class="ras-testi-name">Michael Chen</h4>
                        <p class="ras-testi-designation">Investment Director, Pacific Holdings</p>
                    </div>
                    <div class="ras-rating">
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                    </div>
                    <img class="ras-testi-photo" src="<?php echo $url; ?>images/testimonial/testi-3.jpg" alt="Michael Chen">
                </div>

                <div class="ras-single-testimonial">
                    <p>"GIFAM's market entry strategy for our European expansion was brilliant. Their local market knowledge combined with international expertise gave us the competitive edge we needed. Highly recommended for any global venture."</p>
                    <div class="testi-info">
                        <h4 class="ras-testi-name">Elena Rodriguez</h4>
                        <p class="ras-testi-designation">CFO, TechInnovate Solutions</p>
                    </div>
                    <div class="ras-rating">
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                    </div>
                    <img class="ras-testi-photo" src="<?php echo $url; ?>images/testimonial/testi-4.jpg" alt="Elena Rodriguez">
                </div>

                <div class="ras-single-testimonial">
                    <p>"The financial analysis and advisory services from GIFAM exceeded our expectations. Their team's attention to detail and commitment to our success resulted in a 40% increase in our project's profitability within the first year."</p>
                    <div class="testi-info">
                        <h4 class="ras-testi-name">David Thompson</h4>
                        <p class="ras-testi-designation">President, Real Estate Development Corp</p>
                    </div>
                    <div class="ras-rating">
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                        <i class="icofont-star"></i>
                    </div>
                    <img class="ras-testi-photo" src="<?php echo $url; ?>images/testimonial/testi-5.jpg" alt="David Thompson">
                </div>
            </div>
        </div>
    </section>
    <!-- Testimonials End -->

    <!-- Newsletter Start -->
    <section class="ras-newsletter-1">
        <div class="container">
            <div class="row flex-column align-items-center">
                <h2 class="text-center wow fadeInUp">To get weekly & monthly our news<br>subscribe Newsletter.</h2>
                <label for="subscribe" class="sr-only">Subscribe</label>
                <input type="email" placeholder="Enter your email" id="subscribe" class="wow fadeInUp">
                <a href="#" class="btn btn-primary btn-large wow fadeInUp">Subscribe</a>
            </div>

        </div>
    </section>
    <!-- Newsletter End-->

    <!-- Blog Start -->
    <section class="ras-blog ras-blog-2">
        <div class="container">
            <h2 class="text-center mb-50 wow fadeInUp">See our latest & popular tips & tricks<br> <span class="color-title">from our Experts</span></h2>

            <div class="ras-blog-2-slider">
                <div class="ras-blog-single">
                    <div class="ras-blog-img">
                        <a href="<?php echo $url; ?>blog-details.php"><img src="<?php echo $url; ?>images/blog/blog-1.jpg" alt="How to growing your business tips & tricks"></a>
                    </div>
                    <div class="ras-blog-info">

                        <div class="ras-blog-meta">
                            <h3 class="ras-blog-user"><i class="icofont-user-alt-3"></i> <a href="#"> Philip Hobs</a>
                            </h3>
                            <h3 class="ras-blog-user"><i class="icofont-clock-time"></i> <a href="#"> 02feb,2021</a>
                            </h3>
                        </div>

                        <h3 class="ras-blog-title"><a href="blog-details.php">How to growing your business
                            tips & tricks</a></h3>

                        <a href="blog-details.php" class="ras-blog-read-more"><i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
                <div class="ras-blog-single">
                    <div class="ras-blog-img">
                        <a href="<?php echo $url; ?>blog-details.php"><img src="<?php echo $url; ?>images/blog/blog-2.jpg" alt="How to growing your business tips & tricks"></a>
                    </div>
                    <div class="ras-blog-info">

                        <div class="ras-blog-meta">
                            <h3 class="ras-blog-user"><i class="icofont-user-alt-3"></i> <a href="#"> Philip Hobs</a>
                            </h3>
                            <h3 class="ras-blog-user"><i class="icofont-clock-time"></i> <a href="#"> 02feb,2021</a>
                            </h3>
                        </div>

                        <h3 class="ras-blog-title"><a href="blog-details.php">How to growing your business
                            tips & tricks</a></h3>

                        <a href="blog-details.php" class="ras-blog-read-more"><i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
                <div class="ras-blog-single">
                    <div class="ras-blog-img">
                        <a href="<?php echo $url; ?>blog-details.php"><img src="<?php echo $url; ?>images/blog/blog-3.jpg" alt="How to growing your business tips & tricks"></a>
                    </div>
                    <div class="ras-blog-info">

                        <div class="ras-blog-meta">
                            <h3 class="ras-blog-user"><i class="icofont-user-alt-3"></i> <a href="#"> Philip Hobs</a>
                            </h3>
                            <h3 class="ras-blog-user"><i class="icofont-clock-time"></i> <a href="#"> 02feb,2021</a>
                            </h3>
                        </div>

                        <h3 class="ras-blog-title"><a href="blog-details.php">How to growing your business
                            tips & tricks</a></h3>

                        <a href="blog-details.php" class="ras-blog-read-more"><i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
                <div class="ras-blog-single">
                    <div class="ras-blog-img">
                        <a href="blog-details.php"><img src="images/blog/blog-4.jpg" alt="How to growing your business tips & tricks"></a>
                    </div>
                    <div class="ras-blog-info">

                        <div class="ras-blog-meta">
                            <h3 class="ras-blog-user"><i class="icofont-user-alt-3"></i> <a href="#"> Philip Hobs</a>
                            </h3>
                            <h3 class="ras-blog-user"><i class="icofont-clock-time"></i> <a href="#"> 02feb,2021</a>
                            </h3>
                        </div>

                        <h3 class="ras-blog-title"><a href="blog-details.php">How to growing your business
                            tips & tricks</a></h3>

                        <a href="blog-details.php" class="ras-blog-read-more"><i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
                <div class="ras-blog-single">
                    <div class="ras-blog-img">
                        <a href="blog-details.php"><img src="images/blog/blog-5.jpg" alt="How to growing your business tips & tricks"></a>
                    </div>
                    <div class="ras-blog-info">

                        <div class="ras-blog-meta">
                            <h3 class="ras-blog-user"><i class="icofont-user-alt-3"></i> <a href="#"> Philip Hobs</a>
                            </h3>
                            <h3 class="ras-blog-user"><i class="icofont-clock-time"></i> <a href="#"> 02feb,2021</a>
                            </h3>
                        </div>

                        <h3 class="ras-blog-title"><a href="blog-details.php">How to growing your business
                            tips & tricks</a></h3>

                        <a href="blog-details.php" class="ras-blog-read-more"><i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
                <div class="ras-blog-single">
                    <div class="ras-blog-img">
                        <a href="blog-details.php"><img src="images/blog/blog-6.jpg" alt="How to growing your business tips & tricks"></a>
                    </div>
                    <div class="ras-blog-info">

                        <div class="ras-blog-meta">
                            <h3 class="ras-blog-user"><i class="icofont-user-alt-3"></i> <a href="#"> Philip Hobs</a>
                            </h3>
                            <h3 class="ras-blog-user"><i class="icofont-clock-time"></i> <a href="#"> 02feb,2021</a>
                            </h3>
                        </div>

                        <h3 class="ras-blog-title"><a href="blog-details.php">How to growing your business
                            tips & tricks</a></h3>

                        <a href="blog-details.php" class="ras-blog-read-more"><i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>

                <div class="ras-blog-single">
                    <div class="ras-blog-img">
                        <a href="blog-details.php"><img src="images/blog/blog-7.jpg" alt="How to growing your business tips & tricks"></a>
                    </div>
                    <div class="ras-blog-info">

                        <div class="ras-blog-meta">
                            <h3 class="ras-blog-user"><i class="icofont-user-alt-3"></i> <a href="#"> Philip Hobs</a>
                            </h3>
                            <h3 class="ras-blog-user"><i class="icofont-clock-time"></i> <a href="#"> 02feb,2021</a>
                            </h3>
                        </div>

                        <h3 class="ras-blog-title"><a href="blog-details.php">How to growing your business
                            tips & tricks</a></h3>

                        <a href="blog-details.php" class="ras-blog-read-more"><i class="icofont-long-arrow-right"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Blog End-->
</main>


<?php include 'footer.php'; ?>

</body>
</html>