<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Investissement en Obligations - GIFAM | Sécurité et Rendement</title>
    <meta name="description" content="Découvrez les solutions d'investissement en obligations proposées par GIFAM : sécurité, rendement stable, diversification et accompagnement sur mesure.">
    <meta name="keywords" content="obligations, investissement, rendement, sécurité, diversification, GIFAM, gestion de portefeuille">
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo $url; ?>investment-in-bonds/">
    <meta property="og:title" content="Investissement en Obligations - GIFAM">
    <meta property="og:description" content="Solutions d'investissement en obligations : sécurité, rendement stable, diversification.">
    <meta property="og:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo $url; ?>investment-in-bonds/">
    <meta property="twitter:title" content="Investissement en Obligations - GIFAM">
    <meta property="twitter:description" content="Solutions d'investissement en obligations : sécurité, rendement stable, diversification.">
    <meta property="twitter:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo $url; ?>images/logos/fav.png">
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/responsive.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/icofont.css">
    <style>
        .bonds-hero {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        .bonds-hero::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: url('<?php echo $url; ?>images/primary-blur-bg.png') center/cover;
            opacity: 0.1;
        }
        .bonds-hero .container { position: relative; z-index: 2; }
        .bonds-section { padding: 80px 0; }
        .bonds-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid #f0f0f0;
        }
        .bonds-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15);
        }
        .bonds-icon {
            width: 80px; height: 80px;
            background: #DB2913;
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            margin-bottom: 25px; color: white; font-size: 2rem;
        }
        .bonds-list li {
            padding-left: 25px; position: relative; margin-bottom: 10px;
        }
        .bonds-list li::before {
            content: '✓'; position: absolute; left: 0; color: #ff6b35; font-weight: bold;
        }
        .cta-section {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white; padding: 80px 0; text-align: center;
        }
        .cta-button {
            background: #DB2913;
            color: white; padding: 15px 40px; border-radius: 50px;
            text-decoration: none; font-weight: 600; display: inline-block;
            margin-top: 30px; transition: all 0.3s ease; border: none;
        }
        .cta-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(219,41,19,0.4);
            color: white; text-decoration: none;
        }
        .btn-primary {
            background: #DB2913 !important;
            border-color: #DB2913 !important;
        }
        .btn-primary:hover, .btn-primary:focus {
            background: #a81f0f !important;
            border-color: #a81f0f !important;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>
<!-- Hero Section -->
<section class="bonds-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4">Investissement en Obligations</h1>
                <p class="lead mb-4">Sécurisez votre capital et bénéficiez d'un rendement stable grâce à notre expertise en obligations d'État, d'entreprise et internationales.</p>
                <div class="hero-buttons">
                    <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Demander un Conseil</a>
                    <a href="#bonds-types" class="btn btn-outline-light btn-lg">Types d'Obligations</a>
                </div>
            </div>
            <div class="col-lg-6">
                <img src="<?php echo $url; ?>images/case-study/case-study-2.jpg" alt="Obligations" class="img-fluid rounded-3">
            </div>
        </div>
    </div>
</section>
<!-- Pourquoi investir en obligations -->
<section class="bonds-section bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4">Pourquoi Investir en Obligations ?</h2>
                <p class="lead">Les obligations offrent sécurité, prévisibilité et diversification à votre portefeuille. Elles conviennent aux investisseurs recherchant un revenu régulier et une protection du capital.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-shield"></i></div>
                    <h4>Sécurité du Capital</h4>
                    <ul class="bonds-list">
                        <li>Moins volatil que les actions</li>
                        <li>Remboursement à l'échéance</li>
                        <li>Idéal pour la préservation du patrimoine</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-money-bag"></i></div>
                    <h4>Revenu Régulier</h4>
                    <ul class="bonds-list">
                        <li>Coupons fixes ou variables</li>
                        <li>Versements périodiques</li>
                        <li>Prévisibilité des flux de trésorerie</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-chart-pie"></i></div>
                    <h4>Diversification</h4>
                    <ul class="bonds-list">
                        <li>Réduit le risque global du portefeuille</li>
                        <li>Complément aux actions et autres actifs</li>
                        <li>Large choix de secteurs et de maturités</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Types d'obligations -->
<section id="bonds-types" class="bonds-section">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4">Types d'Obligations Proposées</h2>
                <p class="lead">GIFAM vous accompagne dans la sélection des meilleures obligations selon vos objectifs et votre profil d'investisseur.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-bank"></i></div>
                    <h4>Obligations d'État</h4>
                    <ul class="bonds-list">
                        <li>Sécurité maximale</li>
                        <li>Émissions souveraines</li>
                        <li>Idéal pour les profils prudents</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-building"></i></div>
                    <h4>Obligations d'Entreprise</h4>
                    <ul class="bonds-list">
                        <li>Rendement supérieur</li>
                        <li>Large choix de secteurs</li>
                        <li>Différents niveaux de risque</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-globe"></i></div>
                    <h4>Obligations Internationales</h4>
                    <ul class="bonds-list">
                        <li>Diversification géographique</li>
                        <li>Opportunités sur les marchés émergents</li>
                        <li>Protection contre l'inflation</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Processus d'investissement -->
<section class="bonds-section bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4">Notre Processus d'Investissement</h2>
                <p class="lead">Un accompagnement sur mesure à chaque étape pour sécuriser et optimiser vos placements obligataires.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-users-alt-3"></i></div>
                    <h5>Analyse du Profil</h5>
                    <p>Évaluation de vos objectifs, horizon de placement et tolérance au risque.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-handshake-deal"></i></div>
                    <h5>Sélection des Obligations</h5>
                    <p>Choix des meilleures obligations selon vos critères et le contexte de marché.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-chart-growth"></i></div>
                    <h5>Gestion et Suivi</h5>
                    <p>Suivi régulier, rééquilibrage et reporting transparent de votre portefeuille.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="bonds-card">
                    <div class="bonds-icon"><i class="icofont-certificate"></i></div>
                    <h5>Optimisation Fiscale</h5>
                    <p>Conseils pour maximiser le rendement net après impôts.</p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="display-5 fw-bold mb-4">Sécurisez Votre Avenir Financier</h2>
                <p class="lead mb-4">Contactez nos experts pour une stratégie obligataire personnalisée et bénéficiez d'un accompagnement sur mesure.</p>
                <a href="<?php echo $url; ?>contact-us/" class="cta-button">Prendre Rendez-vous</a>
            </div>
        </div>
    </div>
</section>
<?php include '../footer.php'; ?>
<!-- JavaScript Files -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>
<script>
    $(document).ready(function() {
        // Smooth scrolling for anchor links
        $('a[href^="#"]').on('click', function(event) {
            var target = $(this.getAttribute('href'));
            if (target.length) {
                event.preventDefault();
                $('html, body').stop().animate({
                    scrollTop: target.offset().top - 100
                }, 1000);
            }
        });
        // Hover effect
        $('.bonds-card').hover(
            function() { $(this).find('.bonds-icon').css('transform', 'scale(1.1)'); },
            function() { $(this).find('.bonds-icon').css('transform', 'scale(1)'); }
        );
    });
</script>
</body>
</html> 