<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Fonds Communs de Placement - GIFAM | Diversification et Performance</title>
    <meta name="description" content="Découvrez les avantages des fonds communs de placement avec GIFAM : diversification, gestion professionnelle, accessibilité et performance pour tous les profils d'investisseurs.">
    <meta name="keywords" content="fonds communs de placement, mutual funds, diversification, gestion professionnelle, GIFAM, investissement collectif">
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo $url; ?>mutual-funds/">
    <meta property="og:title" content="Fonds Communs de Placement - GIFAM">
    <meta property="og:description" content="Diversification, gestion professionnelle et performance avec les fonds communs de placement GIFAM.">
    <meta property="og:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo $url; ?>mutual-funds/">
    <meta property="twitter:title" content="Fonds Communs de Placement - GIFAM">
    <meta property="twitter:description" content="Diversification, gestion professionnelle et performance avec les fonds communs de placement GIFAM.">
    <meta property="twitter:image" content="<?php echo $url; ?>images/logos/logo-colored.svg">
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo $url; ?>images/logos/fav.png">
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/responsive.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/icofont.css">
    <style>
        .funds-hero {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        .funds-hero::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: url('<?php echo $url; ?>images/primary-blur-bg.png') center/cover;
            opacity: 0.1;
        }
        .funds-hero .container { position: relative; z-index: 2; }
        .funds-section { padding: 80px 0; }
        .funds-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid #f0f0f0;
        }
        .funds-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0,0,0,0.15);
        }
        .funds-icon {
            width: 80px; height: 80px;
            background: #DB2913;
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            margin-bottom: 25px; color: white; font-size: 2rem;
        }
        .funds-list li {
            padding-left: 25px; position: relative; margin-bottom: 10px;
        }
        .funds-list li::before {
            content: '✓'; position: absolute; left: 0; color: #ff6b35; font-weight: bold;
        }
        .cta-section {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            color: white; padding: 80px 0; text-align: center;
        }
        .cta-button {
            background: #DB2913;
            color: white; padding: 15px 40px; border-radius: 50px;
            text-decoration: none; font-weight: 600; display: inline-block;
            margin-top: 30px; transition: all 0.3s ease; border: none;
        }
        .cta-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(219,41,19,0.4);
            color: white; text-decoration: none;
        }
        .btn-primary {
            background: #DB2913 !important;
            border-color: #DB2913 !important;
        }
        .btn-primary:hover, .btn-primary:focus {
            background: #a81f0f !important;
            border-color: #a81f0f !important;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>
<!-- Hero Section -->
<section class="funds-hero">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <h1 class="display-4 fw-bold mb-4">Fonds Communs de Placement</h1>
                <p class="lead mb-4">Accédez à une gestion collective performante et diversifiée, adaptée à tous les profils d'investisseurs grâce à notre sélection de fonds mutualisés.</p>
                <div class="hero-buttons">
                    <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Demander un Conseil</a>
                    <a href="#funds-types" class="btn btn-outline-light btn-lg">Types de Fonds</a>
                </div>
            </div>
            <div class="col-lg-6">
                <img src="<?php echo $url; ?>images/case-study/case-study-3.jpg" alt="Fonds Communs de Placement" class="img-fluid rounded-3">
            </div>
        </div>
    </div>
</section>
<!-- Avantages des fonds communs -->
<section class="funds-section bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4">Pourquoi Choisir les Fonds Communs de Placement ?</h2>
                <p class="lead">Les fonds mutualisés offrent une diversification instantanée, une gestion professionnelle et une accessibilité à tous les investisseurs, même avec un capital modeste.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-chart-pie"></i></div>
                    <h4>Diversification</h4>
                    <ul class="funds-list">
                        <li>Répartition sur de nombreux actifs</li>
                        <li>Réduction du risque spécifique</li>
                        <li>Accès à différents marchés</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-briefcase"></i></div>
                    <h4>Gestion Professionnelle</h4>
                    <ul class="funds-list">
                        <li>Experts dédiés à la sélection des actifs</li>
                        <li>Suivi et ajustement permanents</li>
                        <li>Stratégies adaptées au marché</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-money-bag"></i></div>
                    <h4>Performance Accessible</h4>
                    <ul class="funds-list">
                        <li>Investissement dès 100 €</li>
                        <li>Frais mutualisés réduits</li>
                        <li>Transparence et liquidité</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Types de fonds -->
<section id="funds-types" class="funds-section">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4">Types de Fonds Proposés</h2>
                <p class="lead">GIFAM sélectionne pour vous les meilleurs fonds selon votre profil et vos objectifs.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-globe"></i></div>
                    <h4>Fonds Actions</h4>
                    <ul class="funds-list">
                        <li>Investissement en actions internationales</li>
                        <li>Potentiel de croissance élevé</li>
                        <li>Adapté aux profils dynamiques</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-bank"></i></div>
                    <h4>Fonds Obligataires</h4>
                    <ul class="funds-list">
                        <li>Investissement en obligations publiques et privées</li>
                        <li>Stabilité et rendement régulier</li>
                        <li>Idéal pour les profils prudents</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-pie-chart"></i></div>
                    <h4>Fonds Diversifiés</h4>
                    <ul class="funds-list">
                        <li>Mix d'actions, obligations et autres actifs</li>
                        <li>Équilibre entre risque et rendement</li>
                        <li>Gestion flexible</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Processus d'investissement -->
<section class="funds-section bg-light">
    <div class="container">
        <div class="row text-center mb-5">
            <div class="col-lg-8 mx-auto">
                <h2 class="display-5 fw-bold mb-4">Notre Processus d'Investissement</h2>
                <p class="lead">Un accompagnement personnalisé à chaque étape pour optimiser votre investissement collectif.</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-lg-3 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-users-alt-3"></i></div>
                    <h5>Analyse du Profil</h5>
                    <p>Évaluation de vos objectifs, horizon de placement et tolérance au risque.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-handshake-deal"></i></div>
                    <h5>Sélection des Fonds</h5>
                    <p>Choix des fonds adaptés à votre profil et au contexte de marché.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-chart-growth"></i></div>
                    <h5>Gestion et Suivi</h5>
                    <p>Suivi régulier, rééquilibrage et reporting transparent de votre portefeuille.</p>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="funds-card">
                    <div class="funds-icon"><i class="icofont-certificate"></i></div>
                    <h5>Optimisation Fiscale</h5>
                    <p>Conseils pour maximiser le rendement net après impôts.</p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto text-center">
                <h2 class="display-5 fw-bold mb-4">Investissez Facilement et Sereinement</h2>
                <p class="lead mb-4">Contactez nos conseillers pour une stratégie de fonds communs personnalisée et bénéficiez d'une gestion professionnelle.</p>
                <a href="<?php echo $url; ?>contact-us/" class="cta-button">Prendre Rendez-vous</a>
            </div>
        </div>
    </div>
</section>
<?php include '../footer.php'; ?>
<!-- JavaScript Files -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>
<script>
    $(document).ready(function() {
        // Smooth scrolling for anchor links
        $('a[href^="#"]').on('click', function(event) {
            var target = $(this.getAttribute('href'));
            if (target.length) {
                event.preventDefault();
                $('html, body').stop().animate({
                    scrollTop: target.offset().top - 100
                }, 1000);
            }
        });
        // Hover effect
        $('.funds-card').hover(
            function() { $(this).find('.funds-icon').css('transform', 'scale(1.1)'); },
            function() { $(this).find('.funds-icon').css('transform', 'scale(1)'); }
        );
    });
</script>
</body>
</html> 