<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Legal Disclaimer - GIFAM | Important Legal Information & Disclaimers</title>
    <meta name="description" content="Important legal disclaimers and limitations of liability for GIFAM services. Read our comprehensive legal disclaimer for investment and consulting services.">
    <meta name="keywords" content="legal disclaimer, investment disclaimer, risk disclosure, liability limitation, GIFAM legal">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    
    <style>
        .disclaimer-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #d12907;
        }
        
        .warning-box {
            background: #dc354514;
    border: 1px solid #dc3545;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .risk-disclosure {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .liability-box {
                background: #dc354514;
    border: 1px solid #dc3545;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .update-badge {
            display: inline-block;
            background: #dc3545;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .disclaimer-highlight {
            background: #f8f9fa;
            border-left: 4px solid #dc3545;
            padding: 15px;
            margin: 15px 0;
        }
        
        .legal-notice {
            background: #dc35450d;
    border: 1px solid #dc3545;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>legal-notices/">Legal Notices</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>legal-disclaimer/">Legal Disclaimer</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
    <br><br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1>Legal Disclaimer</h1>
                            <p class="lead">This comprehensive legal disclaimer outlines important limitations, disclaimers, and legal information regarding GIFAM's services, website, and business operations. Please read this document carefully before using our services.</p>
                            <div class="update-badge">Last Updated: 11, 07, 2025</div>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/case-study/case-study-4.jpg" alt="Legal Disclaimer" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Important Notice -->
                    <div class="warning-box">
                        <h4><i class="icofont-warning text-warning"></i> Important Legal Notice</h4>
                        <p class="mb-0"><strong>By accessing and using this website or our services, you acknowledge that you have read, understood, and agree to be bound by the terms and conditions outlined in this legal disclaimer.</strong></p>
                    </div>

                    <!-- General Disclaimer -->
                    <div class="disclaimer-section">
                        <h2>1. General Disclaimer</h2>
                        <p>The information, materials, and services provided on this website and through GIFAM's business operations are provided "as is" and "as available" without any warranties of any kind, either express or implied.</p>
                        
                        <div class="disclaimer-highlight">
                            <h5>No Warranties</h5>
                            <p>GIFAM makes no representations or warranties regarding the accuracy, completeness, reliability, or suitability of any information, products, or services contained on this website or provided through our services.</p>
                        </div>
                    </div>

                    <!-- Investment Disclaimer -->
                    <div class="disclaimer-section">
                        <h2>2. Investment Disclaimer</h2>
                        
                        <div class="risk-disclosure">
                            <h4><i class="icofont-exclamation-triangle text-danger"></i> Investment Risk Warning</h4>
                            <p><strong>All investments carry inherent risks, and there is no guarantee of returns or profit. Past performance does not guarantee future results.</strong></p>
                        </div>
                        
                        <h4>2.1 No Investment Advice</h4>
                        <p>The information provided on this website and through our services is for informational and educational purposes only. It does not constitute:</p>
                        <ul>
                            <li>Investment advice or recommendations</li>
                            <li>Financial planning advice</li>
                            <li>Tax advice</li>
                            <li>Legal advice</li>
                            <li>An offer to buy or sell any security</li>
                        </ul>

                        <h4>2.2 Investment Risks</h4>
                        <p>Investors should be aware of the following risks:</p>
                        <ul>
                            <li><strong>Market Risk:</strong> The value of investments can go down as well as up</li>
                            <li><strong>Liquidity Risk:</strong> Some investments may be difficult to sell quickly</li>
                            <li><strong>Currency Risk:</strong> Exchange rate fluctuations can affect returns</li>
                            <li><strong>Political Risk:</strong> Changes in government policy can impact investments</li>
                            <li><strong>Regulatory Risk:</strong> Changes in laws and regulations can affect investments</li>
                        </ul>

                        <h4>2.3 Professional Advice</h4>
                        <p>We strongly recommend that you:</p>
                        <ul>
                            <li>Consult with qualified financial advisors before making investment decisions</li>
                            <li>Conduct your own research and due diligence</li>
                            <li>Consider your personal financial situation and risk tolerance</li>
                            <li>Understand the specific risks associated with any investment</li>
                        </ul>
                    </div>

                    <!-- Financial Services Disclaimer -->
                    <div class="disclaimer-section">
                        <h2>3. Financial Services Disclaimer</h2>
                        
                        <h4>3.1 Regulatory Compliance</h4>
                        <p>GIFAM operates in compliance with applicable financial services regulations. However, the specific regulatory requirements may vary by jurisdiction.</p>
                        
                        <h4>3.2 Service Limitations</h4>
                        <ul>
                            <li>Our services are not suitable for all investors</li>
                            <li>We do not guarantee specific investment returns</li>
                            <li>Investment decisions remain the responsibility of the client</li>
                            <li>We are not responsible for investment losses</li>
                        </ul>

                        <h4>3.3 Tax and Legal Considerations</h4>
                        <p>Tax laws and regulations vary by jurisdiction and may change over time. We recommend consulting with qualified tax and legal professionals regarding your specific situation.</p>
                    </div>

                    <!-- Website and Content Disclaimer -->
                    <div class="disclaimer-section">
                        <h2>4. Website and Content Disclaimer</h2>
                        
                        <h4>4.1 Information Accuracy</h4>
                        <p>While we strive to provide accurate and up-to-date information, we make no representations or warranties regarding:</p>
                        <ul>
                            <li>The accuracy, completeness, or reliability of website content</li>
                            <li>The availability or uninterrupted access to our website</li>
                            <li>The absence of errors, viruses, or other harmful components</li>
                            <li>The compatibility of our website with your device or browser</li>
                        </ul>

                        <h4>4.2 Third-Party Content</h4>
                        <p>Our website may contain links to third-party websites, content, or services. We:</p>
                        <ul>
                            <li>Do not endorse or control third-party content</li>
                            <li>Are not responsible for the accuracy or reliability of third-party information</li>
                            <li>Do not guarantee the security of third-party websites</li>
                            <li>Recommend reviewing third-party privacy policies and terms</li>
                        </ul>

                        <h4>4.3 Website Availability</h4>
                        <p>We reserve the right to modify, suspend, or discontinue our website or any part thereof at any time without notice. We are not liable for any damages resulting from website unavailability.</p>
                    </div>

                    <!-- Limitation of Liability -->
                    <div class="disclaimer-section">
                        <h2>5. Limitation of Liability</h2>
                        
                        <div class="liability-box">
                            <h4><i class="icofont-shield-check text-info"></i> Important Limitation</h4>
                            <p><strong>To the maximum extent permitted by applicable law, GIFAM shall not be liable for any direct, indirect, incidental, special, consequential, or punitive damages arising from your use of our website or services.</strong></p>
                        </div>
                        
                        <h4>5.1 Scope of Limitation</h4>
                        <p>This limitation of liability applies to damages arising from:</p>
                        <ul>
                            <li>Use of our website or services</li>
                            <li>Investment decisions or losses</li>
                            <li>Reliance on information provided</li>
                            <li>Website errors or technical issues</li>
                            <li>Third-party actions or content</li>
                            <li>Data loss or security breaches</li>
                        </ul>

                        <h4>5.2 Exceptions</h4>
                        <p>This limitation does not apply to:</p>
                        <ul>
                            <li>Intentional misconduct or fraud</li>
                            <li>Gross negligence</li>
                            <li>Violations of applicable law</li>
                            <li>Personal injury or death</li>
                        </ul>
                    </div>

                    <!-- Indemnification -->
                    <div class="disclaimer-section">
                        <h2>6. Indemnification</h2>
                        <p>By using our website or services, you agree to indemnify and hold harmless GIFAM, its officers, directors, employees, agents, and affiliates from and against any claims, damages, losses, liabilities, costs, or expenses (including reasonable attorneys' fees) arising from:</p>
                        <ul>
                            <li>Your use of our website or services</li>
                            <li>Your violation of these terms</li>
                            <li>Your violation of any applicable law or regulation</li>
                            <li>Your infringement of any third-party rights</li>
                        </ul>
                    </div>

                    <!-- Jurisdiction and Governing Law -->
                    <div class="disclaimer-section">
                        <h2>7. Jurisdiction and Governing Law</h2>
                        
                        <h4>7.1 Applicable Law</h4>
                        <p>This disclaimer and your use of our website and services are governed by the laws of the jurisdiction in which GIFAM operates, without regard to conflict of law principles.</p>
                        
                        <h4>7.2 Jurisdiction</h4>
                        <p>Any disputes arising from this disclaimer or your use of our services shall be subject to the exclusive jurisdiction of the courts in our primary business location.</p>
                        
                        <h4>7.3 International Users</h4>
                        <p>If you access our website or services from outside our primary jurisdiction, you are responsible for compliance with local laws and regulations.</p>
                    </div>

                    <!-- Severability -->
                    <div class="disclaimer-section">
                        <h2>8. Severability</h2>
                        <p>If any provision of this legal disclaimer is found to be invalid, illegal, or unenforceable, the remaining provisions shall continue in full force and effect. The invalid provision shall be modified to the minimum extent necessary to make it valid and enforceable.</p>
                    </div>

                    <!-- Changes to Disclaimer -->
                    <div class="disclaimer-section">
                        <h2>9. Changes to This Disclaimer</h2>
                        <p>We reserve the right to modify or update this legal disclaimer at any time. Changes will be effective immediately upon posting on our website. Your continued use of our website or services after any changes constitutes acceptance of the updated disclaimer.</p>
                    </div>

                    <!-- Contact Information -->
                    <div class="legal-notice">
                        <h2>10. Contact Information</h2>
                        <p>If you have any questions about this legal disclaimer or need clarification on any terms, please contact us:</p>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Legal Department</h4>
                                <p><strong>Email:</strong> legal@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4568<br>
                                <strong>Address:</strong> 123 Business Street, Suite 100, New York, NY 10001</p>
                            </div>
                            <div class="col-lg-6">
                                <h4>General Inquiries</h4>
                                <p><strong>Email:</strong> info@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4569<br>
                                <strong>Response Time:</strong> Within 48 hours</p>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Questions About Our Legal Disclaimers?</h3>
                                <p class="lead mb-4">Our legal team is here to help clarify any questions about our disclaimers, limitations, or legal terms.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Contact Legal Team</a>
                                <a href="<?php echo $url; ?>terms-and-conditions/" class="btn btn-outline-primary btn-lg">Read Terms & Conditions</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

</body>
</html> 
