<?php
include '../url.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    
    <!-- SEO Meta Tags -->
    <title><?php echo isset($page_title) ? $page_title : 'GIFAM - Investment Advisory and Asset Management'; ?></title>
    <meta name="description" content="<?php echo isset($page_description) ? $page_description : 'Expertise in investment, asset management, financial analysis and international project support.'; ?>">
    <meta name="keywords" content="<?php echo isset($page_keywords) ? $page_keywords : 'investment, finance, asset management, financial analysis, financial advisory, project financing, risk management, GIFAM, consulting, international, financial solutions'; ?>">
    <meta name="author" content="GIFAM">
    <meta name="robots" content="index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="<?php echo isset($canonical_url) ? $canonical_url : 'https://www.gifam.eu/'; ?>">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo isset($og_title) ? $og_title : 'GIFAM – Investment Advisory and Asset Management'; ?>">
    <meta property="og:description" content="<?php echo isset($og_description) ? $og_description : 'Expertise in investment, asset management, financial analysis and international project support.'; ?>">
    <meta property="og:url" content="<?php echo isset($og_url) ? $og_url : 'https://www.gifam.eu/'; ?>">
    <meta property="og:image" content="<?php echo isset($og_image) ? $og_image : 'https://www.gifam.eu/images/logos/logo_default.png'; ?>">
    <meta property="og:site_name" content="GIFAM">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo isset($twitter_title) ? $twitter_title : 'GIFAM – Investment Advisory and Asset Management'; ?>">
    <meta name="twitter:description" content="<?php echo isset($twitter_description) ? $twitter_description : 'Expertise in investment, asset management, financial analysis and international project support.'; ?>">
    <meta name="twitter:image" content="<?php echo isset($twitter_image) ? $twitter_image : 'https://www.gifam.eu/images/logos/logo_default.png'; ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">
    <link rel="apple-touch-icon" href="<?php echo $url; ?>images/logos/cropped-FavIconGifam-1-180x180.png">
    
    <!-- Preload Critical Resources -->
    <link rel="preload" href="<?php echo $url; ?>css/bootstrap.min.css" as="style">
    <link rel="preload" href="<?php echo $url; ?>css/style.css" as="style">
    <link rel="preload" href="<?php echo $url; ?>js/jquery.min.js" as="script">
    
    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" href="<?php echo $url; ?>fonts/flaticon/flaticon.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/slick.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/magnific-popup.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/responsive.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/accessibility.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/contact.css">
    <link rel="stylesheet" href="<?php echo $url; ?>css/services.css">
    
    <!-- IE Compatibility -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <!-- Structured Data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "GIFAM",
        "url": "https://www.gifam.eu",
        "logo": "https://www.gifam.eu/images/logos/logo_default.png",
        "description": "Investment Advisory and Asset Management",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "AYIOU PAVLOU 61",
            "addressLocality": "AGIOS DOMETIOS",
            "addressCountry": "CYPRUS"
        },
        "contactPoint": {
            "@type": "ContactPoint",
            "telephone": "+35796306456",
            "contactType": "customer service",
            "email": "info@gifam.eu"
        }
    }
    </script>
</head>

<body class="<?php echo isset($body_class) ? $body_class : ''; ?>">
    <!-- Skip to main content for accessibility -->
    <a href="#main-content" class="sr-only sr-only-focusable">Skip to main content</a>
    
    <!-- Header -->
    <?php include '../templates/header.php'; ?>
    
    <!-- Main Content -->
    <main id="main-content" class="ras-main-content">
        <?php if (isset($page_content)) echo $page_content; ?>
    </main>
    
    <!-- Footer -->
    <?php include '../templates/footer.php'; ?>
    
    <!-- Back to Top Button -->
    <button id="back-to-top" class="back-to-top" aria-label="Back to top">
        <i class="icofont-rocket"></i>
    </button>
    
    <!-- JavaScript Files -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/popper.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
    <script src="<?php echo $url; ?>js/jquery.waypoints.min.js"></script>
    <script src="<?php echo $url; ?>js/jquery.counterup.min.js"></script>
    <script src="<?php echo $url; ?>js/wow.min.js"></script>
    <script src="<?php echo $url; ?>js/slick.min.js"></script>
    <script src="<?php echo $url; ?>js/jquery.appear.js"></script>
    <script src="<?php echo $url; ?>js/jquery-asPieProgress.min.js"></script>
    <script src="<?php echo $url; ?>js/jquery.magnific-popup.min.js"></script>
    <script src="<?php echo $url; ?>js/main.js"></script>
    <script src="<?php echo $url; ?>js/accessibility.js"></script>
    
    <!-- Page Specific Scripts -->
    <?php if (isset($page_scripts)) echo $page_scripts; ?>
</body>
</html> 
