<?php include '../url.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms and Conditions - GIFAM | Service Agreement & User Terms</title>
    <meta name="description" content="GIFAM's comprehensive terms and conditions outline the rules, rights, and responsibilities for using our services, website, and business operations.">
    <meta name="keywords" content="terms and conditions, service agreement, user terms, GIFAM terms, legal agreement">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    
    <style>
        .terms-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #d12907;
        }
        
        .agreement-box {
            background: #fff;
            border: 1px solid #dc3545;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .important-notice {
            background: #dc354521;
    border: 1px solid #dc354570;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .prohibited-activities {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .update-badge {
            display: inline-block;
            background: #dc3545;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .terms-highlight {
            background: #f8f9fa;
            border-left: 4px solid #28a745;
            padding: 15px;
            margin: 15px 0;
        }
        
        .legal-notice {
                        background: #dc354521;
    border: 1px solid #dc354570;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .service-table {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .service-table table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .service-table th,
        .service-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        
        .service-table th {
            background: #d12907;
            color: white;
            font-weight: 600;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>legal-notices/">Legal Notices</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>terms-and-conditions/">Terms and Conditions</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
    <br><br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1>Terms and Conditions</h1>
                            <p class="lead">These Terms and Conditions govern your use of GIFAM's website, services, and business operations. By accessing or using our services, you agree to be bound by these terms and all applicable laws and regulations.</p>
                            <div class="update-badge">Last Updated: 11, 07, 2025</div>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/case-study/case-study-5.jpg" alt="Terms and Conditions" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Agreement Notice -->
                    <div class="agreement-box">
                        <h4><i class="icofont-handshake-deal text-primary"></i> Agreement to Terms</h4>
                        <p class="mb-0"><strong>By accessing and using GIFAM's website or services, you acknowledge that you have read, understood, and agree to be bound by these Terms and Conditions. If you do not agree to these terms, please do not use our services.</strong></p>
                    </div>

                    <!-- Introduction -->
                    <div class="terms-section">
                        <h2>1. Introduction and Acceptance</h2>
                        
                        <h4>1.1 Service Description</h4>
                        <p>GIFAM provides comprehensive investment and consulting services, including but not limited to:</p>
                        
                        <div class="service-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Service Category</th>
                                        <th>Description</th>
                                        <th>Scope</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong>Investment Services</strong></td>
                                        <td>Portfolio management, investment analysis, and financial advisory</td>
                                        <td>Global markets and asset classes</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Consulting Services</strong></td>
                                        <td>Business strategy, feasibility studies, and project management</td>
                                        <td>Multiple industries and sectors</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Digital Services</strong></td>
                                        <td>Website access, online tools, and digital platforms</td>
                                        <td>24/7 online availability</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Support Services</strong></td>
                                        <td>Client support, technical assistance, and account management</td>
                                        <td>Dedicated client service</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h4>1.2 Eligibility</h4>
                        <p>To use our services, you must:</p>
                        <ul>
                            <li>Be at least 18 years old or have parental consent</li>
                            <li>Have the legal capacity to enter into binding agreements</li>
                            <li>Provide accurate and complete information</li>
                            <li>Comply with all applicable laws and regulations</li>
                        </ul>

                        <h4>1.3 Account Registration</h4>
                        <p>When creating an account with GIFAM, you agree to:</p>
                        <ul>
                            <li>Provide accurate, current, and complete information</li>
                            <li>Maintain and update your account information</li>
                            <li>Protect your account credentials and security</li>
                            <li>Notify us immediately of any unauthorized access</li>
                        </ul>
                    </div>

                    <!-- Service Usage -->
                    <div class="terms-section">
                        <h2>2. Service Usage and Restrictions</h2>
                        
                        <h4>2.1 Permitted Use</h4>
                        <p>You may use our services for lawful purposes only, including:</p>
                        <ul>
                            <li>Accessing investment information and analysis</li>
                            <li>Using our consulting and advisory services</li>
                            <li>Communicating with our team</li>
                            <li>Accessing educational content and resources</li>
                        </ul>

                        <h4>2.2 Prohibited Activities</h4>
                        <div class="prohibited-activities">
                            <p><strong>The following activities are strictly prohibited:</strong></p>
                            <ul>
                                <li>Using our services for illegal or unauthorized purposes</li>
                                <li>Attempting to gain unauthorized access to our systems</li>
                                <li>Interfering with or disrupting our services</li>
                                <li>Transmitting viruses, malware, or harmful code</li>
                                <li>Harassing, abusing, or threatening other users</li>
                                <li>Violating intellectual property rights</li>
                                <li>Engaging in fraudulent or deceptive practices</li>
                                <li>Using automated systems to access our services</li>
                            </ul>
                        </div>

                        <h4>2.3 Service Availability</h4>
                        <p>While we strive to maintain high service availability, we do not guarantee uninterrupted access to our services. We may:</p>
                        <ul>
                            <li>Perform maintenance and updates</li>
                            <li>Modify or discontinue services with notice</li>
                            <li>Limit access during peak usage periods</li>
                            <li>Suspend services for security or legal reasons</li>
                        </ul>
                    </div>

                    <!-- Privacy and Data Protection -->
                    <div class="terms-section">
                        <h2>3. Privacy and Data Protection</h2>
                        
                        <h4>3.1 Data Collection and Use</h4>
                        <p>We collect and process personal data in accordance with our Privacy Policy and applicable data protection laws. By using our services, you consent to:</p>
                        <ul>
                            <li>Collection of personal information for service delivery</li>
                            <li>Use of data for account management and support</li>
                            <li>Processing of data for security and compliance</li>
                            <li>Sharing of data with authorized third parties</li>
                        </ul>

                        <h4>3.2 Data Security</h4>
                        <p>We implement appropriate security measures to protect your data, including:</p>
                        <ul>
                            <li>Encryption of sensitive information</li>
                            <li>Regular security audits and updates</li>
                            <li>Access controls and authentication</li>
                            <li>Incident response procedures</li>
                        </ul>

                        <h4>3.3 Your Rights</h4>
                        <p>You have the right to:</p>
                        <ul>
                            <li>Access your personal data</li>
                            <li>Request correction of inaccurate data</li>
                            <li>Request deletion of your data</li>
                            <li>Object to processing of your data</li>
                            <li>Data portability</li>
                        </ul>
                    </div>

                    <!-- Financial Terms -->
                    <div class="terms-section">
                        <h2>4. Financial Terms and Payment</h2>
                        
                        <h4>4.1 Service Fees</h4>
                        <p>Our services may be subject to fees as outlined in our service agreements. Fees are:</p>
                        <ul>
                            <li>Charged in the currency specified in your agreement</li>
                            <li>Due according to the payment schedule</li>
                            <li>Subject to applicable taxes and charges</li>
                            <li>Non-refundable unless otherwise specified</li>
                        </ul>

                        <h4>4.2 Payment Methods</h4>
                        <p>We accept various payment methods including:</p>
                        <ul>
                            <li>Bank transfers and wire transfers</li>
                            <li>Credit and debit cards</li>
                            <li>Digital payment platforms</li>
                            <li>Corporate payment arrangements</li>
                        </ul>

                        <h4>4.3 Late Payments</h4>
                        <p>Late payments may result in:</p>
                        <ul>
                            <li>Service suspension or termination</li>
                            <li>Late payment fees and interest</li>
                            <li>Collection procedures</li>
                            <li>Legal action if necessary</li>
                        </ul>
                    </div>

                    <!-- Intellectual Property -->
                    <div class="terms-section">
                        <h2>5. Intellectual Property Rights</h2>
                        
                        <h4>5.1 Our Rights</h4>
                        <p>GIFAM retains all rights to:</p>
                        <ul>
                            <li>Our website content and design</li>
                            <li>Proprietary software and technology</li>
                            <li>Brand names, logos, and trademarks</li>
                            <li>Research, analysis, and reports</li>
                            <li>Business methodologies and processes</li>
                        </ul>

                        <h4>5.2 Your Rights</h4>
                        <p>You retain rights to:</p>
                        <ul>
                            <li>Your personal data and information</li>
                            <li>Content you create and submit</li>
                            <li>Your business information and materials</li>
                        </ul>

                        <h4>5.3 License to Use</h4>
                        <p>We grant you a limited, non-exclusive license to:</p>
                        <ul>
                            <li>Access and use our website</li>
                            <li>Use our services as intended</li>
                            <li>Download and print materials for personal use</li>
                            <li>Share information within your organization</li>
                        </ul>
                    </div>

                    <!-- Limitation of Liability -->
                    <div class="terms-section">
                        <h2>6. Limitation of Liability</h2>
                        
                        <div class="important-notice">
                            <h4><i class="icofont-shield-check text-warning"></i> Important Limitation</h4>
                            <p><strong>To the maximum extent permitted by law, GIFAM shall not be liable for any indirect, incidental, special, consequential, or punitive damages arising from your use of our services.</strong></p>
                        </div>
                        
                        <h4>6.1 Scope of Liability</h4>
                        <p>Our liability is limited to:</p>
                        <ul>
                            <li>Direct damages caused by our gross negligence</li>
                            <li>Breach of our contractual obligations</li>
                            <li>Violations of applicable laws</li>
                            <li>Personal injury or death</li>
                        </ul>

                        <h4>6.2 Exclusions</h4>
                        <p>We are not liable for:</p>
                        <ul>
                            <li>Investment losses or market fluctuations</li>
                            <li>Third-party actions or content</li>
                            <li>Force majeure events</li>
                            <li>Your failure to follow our advice</li>
                            <li>Data loss due to your actions</li>
                        </ul>
                    </div>

                    <!-- Indemnification -->
                    <div class="terms-section">
                        <h2>7. Indemnification</h2>
                        <p>You agree to indemnify and hold harmless GIFAM, its officers, directors, employees, and agents from and against any claims, damages, losses, liabilities, costs, or expenses (including reasonable attorneys' fees) arising from:</p>
                        <ul>
                            <li>Your use of our services</li>
                            <li>Your violation of these terms</li>
                            <li>Your violation of any applicable law</li>
                            <li>Your infringement of third-party rights</li>
                            <li>Your negligent or intentional acts</li>
                        </ul>
                    </div>

                    <!-- Termination -->
                    <div class="terms-section">
                        <h2>8. Termination and Suspension</h2>
                        
                        <h4>8.1 Termination by You</h4>
                        <p>You may terminate your account or service agreement by:</p>
                        <ul>
                            <li>Providing written notice to us</li>
                            <li>Completing any required exit procedures</li>
                            <li>Settling any outstanding obligations</li>
                            <li>Returning any company property</li>
                        </ul>

                        <h4>8.2 Termination by Us</h4>
                        <p>We may terminate or suspend your access for:</p>
                        <ul>
                            <li>Violation of these terms</li>
                            <li>Non-payment of fees</li>
                            <li>Fraudulent or illegal activities</li>
                            <li>Security concerns</li>
                            <li>Business reasons with notice</li>
                        </ul>

                        <h4>8.3 Effect of Termination</h4>
                        <p>Upon termination:</p>
                        <ul>
                            <li>Your access to services will cease</li>
                            <li>We may delete your account data</li>
                            <li>Outstanding fees remain due</li>
                            <li>Certain terms survive termination</li>
                        </ul>
                    </div>

                    <!-- Dispute Resolution -->
                    <div class="terms-section">
                        <h2>9. Dispute Resolution</h2>
                        
                        <h4>9.1 Informal Resolution</h4>
                        <p>We encourage resolving disputes informally through:</p>
                        <ul>
                            <li>Direct communication with our team</li>
                            <li>Customer service channels</li>
                            <li>Mediation or negotiation</li>
                        </ul>

                        <h4>9.2 Formal Proceedings</h4>
                        <p>If informal resolution fails:</p>
                        <ul>
                            <li>Disputes will be resolved through arbitration</li>
                            <li>Arbitration will be conducted in our jurisdiction</li>
                            <li>Decisions will be binding and final</li>
                            <li>Class action lawsuits are waived</li>
                        </ul>

                        <h4>9.3 Governing Law</h4>
                        <p>These terms are governed by the laws of our primary business jurisdiction, without regard to conflict of law principles.</p>
                    </div>

                    <!-- Changes to Terms -->
                    <div class="terms-section">
                        <h2>10. Changes to Terms</h2>
                        
                        <h4>10.1 Modification Rights</h4>
                        <p>We reserve the right to modify these terms at any time. Changes will be:</p>
                        <ul>
                            <li>Posted on our website with notice</li>
                            <li>Effective immediately or as specified</li>
                            <li>Communicated through appropriate channels</li>
                            <li>Applicable to all users</li>
                        </ul>

                        <h4>10.2 Acceptance of Changes</h4>
                        <p>Your continued use of our services after changes constitutes acceptance of the modified terms. If you disagree with changes, you must:</p>
                        <ul>
                            <li>Stop using our services</li>
                            <li>Terminate your account</li>
                            <li>Contact us for assistance</li>
                        </ul>
                    </div>

                    <!-- Miscellaneous -->
                    <div class="terms-section">
                        <h2>11. Miscellaneous</h2>
                        
                        <h4>11.1 Severability</h4>
                        <p>If any provision of these terms is found to be invalid or unenforceable, the remaining provisions will continue in full force and effect.</p>

                        <h4>11.2 Entire Agreement</h4>
                        <p>These terms constitute the entire agreement between you and GIFAM regarding our services, superseding all prior agreements and understandings.</p>

                        <h4>11.3 Waiver</h4>
                        <p>Our failure to enforce any provision of these terms does not constitute a waiver of that provision or any other provision.</p>

                        <h4>11.4 Assignment</h4>
                        <p>You may not assign your rights or obligations under these terms without our written consent. We may assign our rights and obligations to any party.</p>
                    </div>

                    <!-- Contact Information -->
                    <div class="legal-notice">
                        <h2>12. Contact Information</h2>
                        <p>If you have any questions about these Terms and Conditions, please contact us:</p>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Legal Department</h4>
                                <p><strong>Email:</strong> legal@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4568<br>
                                <strong>Address:</strong> 123 Business Street, Suite 100, New York, NY 10001</p>
                            </div>
                            <div class="col-lg-6">
                                <h4>General Inquiries</h4>
                                <p><strong>Email:</strong> info@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4569<br>
                                <strong>Response Time:</strong> Within 48 hours</p>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Questions About Our Terms and Conditions?</h3>
                                <p class="lead mb-4">Our legal team is here to help clarify any questions about our terms, conditions, or service agreements.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Contact Legal Team</a>
                                <a href="<?php echo $url; ?>privacy-policy/" class="btn btn-outline-primary btn-lg">Read Privacy Policy</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

</body>
</html> 