<?php
include '../url.php';
// Connexion à la base de données (à adapter)
// $conn = mysqli_connect('localhost', 'utilisateur', 'motdepasse', 'nom_de_la_base');
include '../db.php';
if (!$conn) {
    die('Erreur de connexion à la base de données');
}
$about = [];
$sql = "SELECT variable_name, type, contenu, url FROM about";
$result = mysqli_query($conn, $sql);
while ($row = mysqli_fetch_assoc($result)) {
    $about[$row['variable_name']] = $row;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="GIFAM - General Investment Fund Assets & Management Company. Specialized in financial support for global projects. Based in Cyprus with branches worldwide.">
    <meta name="keywords" content="GIFAM, investment fund, financial support, global projects, Cyprus, Brussels, asset management, project financing">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title>About GIFAM - General Investment Fund Assets & Management Company</title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url . ltrim($about['about_breadcrumb_home']['url'], '/'); ?>"><?php echo $about['about_breadcrumb_home']['contenu']; ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url . ltrim($about['about_breadcrumb_about']['url'], '/'); ?>"><?php echo $about['about_breadcrumb_about']['contenu']; ?></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
<br>
<br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h2><?php echo $about['about_title']['contenu']; ?></h2>
                            <p class="lead"><?php echo $about['about_hero_p1']['contenu']; ?></p>
                            <p><?php echo $about['about_hero_p2']['contenu']; ?></p>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url . $about['about_hero_img']['url']; ?>" alt="<?php echo $about['about_hero_img']['contenu']; ?>" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Company Overview -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo $about['about_global_presence_title']['contenu']; ?></h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-world" style="font-size: 3rem; color: #dc3545;"></i>
                                </div>
                                <h4><?php echo $about['about_global_presence_cyprus_title']['contenu']; ?></h4>
                                <p><?php echo $about['about_global_presence_cyprus_p']['contenu']; ?></p>
                                <ul class="list-unstyled">
                                    <li><?php echo $about['about_global_presence_cyprus_l1']['contenu']; ?></li>
                                    <li><?php echo $about['about_global_presence_cyprus_l2']['contenu']; ?></li>
                                    <li><?php echo $about['about_global_presence_cyprus_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-building" style="font-size: 3rem; color: #dc3545;"></i>
                                </div>
                                <h4><?php echo $about['about_global_presence_brussels_title']['contenu']; ?></h4>
                                <p><?php echo $about['about_global_presence_brussels_p']['contenu']; ?></p>
                                <ul class="list-unstyled">
                                    <li><?php echo $about['about_global_presence_brussels_l1']['contenu']; ?></li>
                                    <li><?php echo $about['about_global_presence_brussels_l2']['contenu']; ?></li>
                                    <li><?php echo $about['about_global_presence_brussels_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-globe" style="font-size: 3rem; color: #ffc107;"></i>
                                </div>
                                <h4><?php echo $about['about_global_presence_network_title']['contenu']; ?></h4>
                                <p><?php echo $about['about_global_presence_network_p']['contenu']; ?></p>
                                <ul class="list-unstyled">
                                    <li><?php echo $about['about_global_presence_network_l1']['contenu']; ?></li>
                                    <li><?php echo $about['about_global_presence_network_l2']['contenu']; ?></li>
                                    <li><?php echo $about['about_global_presence_network_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Our Mission & Vision -->
                    <div class="row mb-5">
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded h-100">
                                <h3><i class="icofont-target text-primary me-2"></i><?php echo $about['about_mission_title']['contenu']; ?></h3>
                                <p><?php echo $about['about_mission_p']['contenu']; ?></p>
                                <ul class="list-unstyled">
                                    <li><?php echo $about['about_mission_l1']['contenu']; ?></li>
                                    <li><?php echo $about['about_mission_l2']['contenu']; ?></li>
                                    <li><?php echo $about['about_mission_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded h-100">
                                <h3><i class="icofont-eye text-success me-2"></i><?php echo $about['about_vision_title']['contenu']; ?></h3>
                                <p><?php echo $about['about_vision_p']['contenu']; ?></p>
                                <ul class="list-unstyled">
                                    <li><?php echo $about['about_vision_l1']['contenu']; ?></li>
                                    <li><?php echo $about['about_vision_l2']['contenu']; ?></li>
                                    <li><?php echo $about['about_vision_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Core Values -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo $about['about_values_title']['contenu']; ?></h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                    <i class="icofont-shield" style="font-size: 2rem;"></i>
                                </div>
                                <h5><?php echo $about['about_values_integrity_title']['contenu']; ?></h5>
                                <p><?php echo $about['about_values_integrity_p']['contenu']; ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-success text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                    <i class="icofont-light-bulb" style="font-size: 2rem;"></i>
                                </div>
                                <h5><?php echo $about['about_values_innovation_title']['contenu']; ?></h5>
                                <p><?php echo $about['about_values_innovation_p']['contenu']; ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-warning text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                    <i class="icofont-users" style="font-size: 2rem;"></i>
                                </div>
                                <h5><?php echo $about['about_values_excellence_title']['contenu']; ?></h5>
                                <p><?php echo $about['about_values_excellence_p']['contenu']; ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-info text-white rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                                    <i class="icofont-handshake-deal" style="font-size: 2rem;"></i>
                                </div>
                                <h5><?php echo $about['about_values_partnership_title']['contenu']; ?></h5>
                                <p><?php echo $about['about_values_partnership_p']['contenu']; ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Services Overview -->
                    <div class="row mb-5">
                        <div class="col-lg-6">
                            <img src="<?php echo $url . $about['about_services_img']['url']; ?>" alt="<?php echo $about['about_services_img']['contenu']; ?>" class="img-fluid rounded shadow">
                        </div>
                        <div class="col-lg-6">
                            <h3><?php echo $about['about_services_title']['contenu']; ?></h3>
                            <p><?php echo $about['about_services_intro']['contenu']; ?></p>
                            <div class="feature-list">
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo $about['about_services_project_title']['contenu']; ?></h5>
                                        <p><?php echo $about['about_services_project_p']['contenu']; ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo $about['about_services_analysis_title']['contenu']; ?></h5>
                                        <p><?php echo $about['about_services_analysis_p']['contenu']; ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo $about['about_services_risk_title']['contenu']; ?></h5>
                                        <p><?php echo $about['about_services_risk_p']['contenu']; ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo $about['about_services_asset_title']['contenu']; ?></h5>
                                        <p><?php echo $about['about_services_asset_p']['contenu']; ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Global Reach -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo $about['about_reach_title']['contenu']; ?></h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url . $about['about_reach_europe_img']['url']; ?>" alt="<?php echo $about['about_reach_europe_img']['contenu']; ?>" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5><?php echo $about['about_reach_europe_title']['contenu']; ?></h5>
                                <p><?php echo $about['about_reach_europe_p']['contenu']; ?></p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url . $about['about_reach_me_img']['url']; ?>" alt="<?php echo $about['about_reach_me_img']['contenu']; ?>" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5><?php echo $about['about_reach_me_title']['contenu']; ?></h5>
                                <p><?php echo $about['about_reach_me_p']['contenu']; ?></p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="text-center">
                                <img src="<?php echo $url . $about['about_reach_global_img']['url']; ?>" alt="<?php echo $about['about_reach_global_img']['contenu']; ?>" class="img-fluid rounded mb-3" style="height: 200px; object-fit: cover; width: 100%;">
                                <h5><?php echo $about['about_reach_global_title']['contenu']; ?></h5>
                                <p><?php echo $about['about_reach_global_p']['contenu']; ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Why Choose GIFAM -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo $about['about_why_title']['contenu']; ?></h3>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded">
                                <h4><i class="icofont-chart-flow text-primary me-2"></i><?php echo $about['about_why_expert_title']['contenu']; ?></h4>
                                <p><?php echo $about['about_why_expert_p']['contenu']; ?></p>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded">
                                <h4><i class="icofont-globe text-success me-2"></i><?php echo $about['about_why_network_title']['contenu']; ?></h4>
                                <p><?php echo $about['about_why_network_p']['contenu']; ?></p>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded">
                                <h4><i class="icofont-shield-check text-warning me-2"></i><?php echo $about['about_why_compliance_title']['contenu']; ?></h4>
                                <p><?php echo $about['about_why_compliance_p']['contenu']; ?></p>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="bg-light p-4 rounded">
                                <h4><i class="icofont-handshake-deal text-info me-2"></i><?php echo $about['about_why_client_title']['contenu']; ?></h4>
                                <p><?php echo $about['about_why_client_p']['contenu']; ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3><?php echo $about['about_cta_title']['contenu']; ?></h3>
                                <p class="lead mb-4"><?php echo $about['about_cta_p']['contenu']; ?></p>
                                <a href="<?php echo $url . ltrim($about['about_cta_btn_contact']['url'], '/'); ?>" class="btn btn-primary btn-lg me-3"><?php echo $about['about_cta_btn_contact']['contenu']; ?></a>
                                <a href="<?php echo $url . ltrim($about['about_cta_btn_services']['url'], '/'); ?>" class="btn btn-outline-primary btn-lg"><?php echo $about['about_cta_btn_services']['contenu']; ?></a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

</body>
</html>
<?php mysqli_close($conn); ?>
