<?php include '../url.php'; ?>
<?php include '../db.php'; ?>
<?php
// Récupération des données dynamiques pour la page business-growth
$business = [];
$stmt = $pdo->query("SELECT variable_name, type, contenu, url FROM business_growth");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $business[$row['variable_name']] = $row;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Business Growth Consulting - GIFAM | Strategies for Sustainable Success</title>
    <meta name="description" content="Boost your business with GIFAM's business growth consulting services: strategy, innovation, digital transformation, and operational excellence.">
    <meta name="keywords" content="business growth, consulting, strategy, innovation, digital transformation, GIFAM">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    <style>
        .growth-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #d12907;
        }
        .growth-benefit {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 20px;
            border: 1px solid #e9ecef;
            transition: all 0.3s ease;
        }
        .growth-benefit:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.15);
        }
        .growth-benefit h5 {
            color: #d12907;
            margin-bottom: 15px;
        }
        .growth-strategy {
            background: #e3f2fd;
            border: 1px solid #2196f3;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .growth-table {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .growth-table table {
            width: 100%;
            border-collapse: collapse;
        }
        .growth-table th,
        .growth-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        .growth-table th {
            background: #d12907;
            color: white;
            font-weight: 600;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>
<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url . ltrim($business['business_breadcrumb_home']['url'], '/'); ?>"><?php echo $business['business_breadcrumb_home']['contenu']; ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url . ltrim($business['business_breadcrumb_services']['url'], '/'); ?>"><?php echo $business['business_breadcrumb_services']['contenu']; ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url . ltrim($business['business_breadcrumb_growth']['url'], '/'); ?>"><?php echo $business['business_breadcrumb_growth']['contenu']; ?></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
    <br><br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1><?php echo $business['business_hero_title']['contenu']; ?></h1>
                            <p class="lead"><?php echo $business['business_hero_lead']['contenu']; ?></p>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url . $business['business_hero_img']['url']; ?>" alt="<?php echo $business['business_hero_img']['contenu']; ?>" class="img-fluid rounded shadow">
                        </div>
                    </div>
                    <!-- Growth Overview -->
                    <div class="growth-section">
                        <h2><?php echo $business['business_approach_title']['contenu']; ?></h2>
                        <p><?php echo $business['business_approach_p']['contenu']; ?></p>
                        <div class="row">
                            <div class="col-lg-6">
                                <h4><?php echo $business['business_approach_pillars_title']['contenu']; ?></h4>
                                <ul>
                                    <li><?php echo $business['business_approach_pillars_l1']['contenu']; ?></li>
                                    <li><?php echo $business['business_approach_pillars_l2']['contenu']; ?></li>
                                    <li><?php echo $business['business_approach_pillars_l3']['contenu']; ?></li>
                                    <li><?php echo $business['business_approach_pillars_l4']['contenu']; ?></li>
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h4><?php echo $business['business_approach_benefits_title']['contenu']; ?></h4>
                                <ul>
                                    <li><?php echo $business['business_approach_benefits_l1']['contenu']; ?></li>
                                    <li><?php echo $business['business_approach_benefits_l2']['contenu']; ?></li>
                                    <li><?php echo $business['business_approach_benefits_l3']['contenu']; ?></li>
                                    <li><?php echo $business['business_approach_benefits_l4']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- Growth Services -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo $business['business_services_title']['contenu']; ?></h3>
                        </div>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="growth-benefit">
                                <div class="text-center mb-3">
                                    <i class="icofont-light-bulb" style="font-size: 3rem; color: #d12907;"></i>
                                </div>
                                <h5><?php echo $business['business_services_strategy_title']['contenu']; ?></h5>
                                <p><?php echo $business['business_services_strategy_p']['contenu']; ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_strategy_l1']['contenu']; ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_strategy_l2']['contenu']; ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_strategy_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="growth-benefit">
                                <div class="text-center mb-3">
                                    <i class="icofont-rocket" style="font-size: 3rem; color: #dc3545;"></i>
                                </div>
                                <h5><?php echo $business['business_services_digital_title']['contenu']; ?></h5>
                                <p><?php echo $business['business_services_digital_p']['contenu']; ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_digital_l1']['contenu']; ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_digital_l2']['contenu']; ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_digital_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="growth-benefit">
                                <div class="text-center mb-3">
                                    <i class="icofont-chart-bar-graph" style="font-size: 3rem; color: #dc3545;"></i>
                                </div>
                                <h5><?php echo $business['business_services_operational_title']['contenu']; ?></h5>
                                <p><?php echo $business['business_services_operational_p']['contenu']; ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_operational_l1']['contenu']; ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_operational_l2']['contenu']; ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo $business['business_services_operational_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- Growth Strategies -->
                    <div class="growth-section">
                        <h2><?php echo $business['business_methodology_title']['contenu']; ?></h2>
                        <div class="growth-strategy">
                            <h4><i class="icofont-chart-flow text-primary"></i> <?php echo $business['business_methodology_method_title']['contenu']; ?></h4>
                            <p><?php echo $business['business_methodology_method_p']['contenu']; ?></p>
                        </div>
                        <div class="row">
                            <div class="col-lg-6">
                                <h4><?php echo $business['business_methodology_market_title']['contenu']; ?></h4>
                                <ul>
                                    <li><?php echo $business['business_methodology_market_l1']['contenu']; ?></li>
                                    <li><?php echo $business['business_methodology_market_l2']['contenu']; ?></li>
                                    <li><?php echo $business['business_methodology_market_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h4><?php echo $business['business_methodology_innovation_title']['contenu']; ?></h4>
                                <ul>
                                    <li><?php echo $business['business_methodology_innovation_l1']['contenu']; ?></li>
                                    <li><?php echo $business['business_methodology_innovation_l2']['contenu']; ?></li>
                                    <li><?php echo $business['business_methodology_innovation_l3']['contenu']; ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- Growth Table -->
                    <div class="growth-section">
                        <h2><?php echo $business['business_why_title']['contenu']; ?></h2>
                        <div class="growth-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Advantage</th>
                                        <th>Description</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><strong><?php echo $business['business_why_advantage1']['contenu']; ?></strong></td>
                                        <td><?php echo $business['business_why_desc1']['contenu']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo $business['business_why_advantage2']['contenu']; ?></strong></td>
                                        <td><?php echo $business['business_why_desc2']['contenu']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo $business['business_why_advantage3']['contenu']; ?></strong></td>
                                        <td><?php echo $business['business_why_desc3']['contenu']; ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong><?php echo $business['business_why_advantage4']['contenu']; ?></strong></td>
                                        <td><?php echo $business['business_why_desc4']['contenu']; ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3><?php echo $business['business_cta_title']['contenu']; ?></h3>
                                <p class="lead mb-4"><?php echo $business['business_cta_p']['contenu']; ?></p>
                                <a href="<?php echo $url . ltrim($business['business_cta_btn_consult']['url'], '/'); ?>" class="btn btn-primary btn-lg me-3"><?php echo $business['business_cta_btn_consult']['contenu']; ?></a>
                                <a href="<?php echo $url . ltrim($business['business_cta_btn_services']['url'], '/'); ?>" class="btn btn-outline-primary btn-lg"><?php echo $business['business_cta_btn_services']['contenu']; ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include '../footer.php'; ?>
<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>
</body>
</html> 
