<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Business Loan";
$query = "SELECT * FROM business_loan WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Project Financing Consultation - GIFAM',
        'meta_description' => 'Project Financing Consultation - Expert advice on securing financing for large-scale projects',
        'meta_keywords' => 'project financing, business loan, financing consultation, GIFAM',
        'hero_title' => 'Project Financing Consultation',
        'hero_subtitle' => 'GIFAM offers expert advice on securing financing for large-scale projects. Our comprehensive approach includes evaluating project feasibility, assisting in the preparation of financial documents and proposals, and guiding you through the entire financing process.',
        'hero_image' => '../wp-content/uploads/2016/11/service-4.jpg',
        'services_title' => 'Our Project Financing Services',
        'service_1_title' => 'Project Feasibility Analysis',
        'service_1_icon' => 'icofont-chart-flow-alt-1',
        'service_1_description' => 'Comprehensive evaluation of project viability including market analysis, financial projections, and risk assessment.',
        'service_1_point_1' => 'Market research and analysis',
        'service_1_point_2' => 'Financial modeling',
        'service_1_point_3' => 'Risk assessment',
        'service_2_title' => 'Financial Documentation',
        'service_2_icon' => 'icofont-document-folder',
        'service_2_description' => 'Professional preparation of all required financial documents and proposals for lenders and investors.',
        'service_2_point_1' => 'Business plan development',
        'service_2_point_2' => 'Financial statements',
        'service_2_point_3' => 'Investment memorandums',
        'service_3_title' => 'Lender Negotiation',
        'service_3_icon' => 'icofont-handshake-deal',
        'service_3_description' => 'Expert negotiation with financial institutions to secure the best terms and conditions for your project.',
        'service_3_point_1' => 'Lender identification',
        'service_3_point_2' => 'Term negotiation',
        'service_3_point_3' => 'Rate optimization',
        'process_title' => 'Our Project Financing Process',
        'step_1_title' => 'Initial Assessment',
        'step_1_description' => 'We evaluate your project requirements and financial needs to develop a customized financing strategy.',
        'step_2_title' => 'Documentation Preparation',
        'step_2_description' => 'Our team prepares all necessary financial documents, business plans, and investment proposals.',
        'step_3_title' => 'Lender Matching',
        'step_3_description' => 'We identify and approach the most suitable lenders for your specific project requirements.',
        'step_4_title' => 'Deal Closure',
        'step_4_description' => 'We negotiate the best terms and facilitate the closing of your project financing deal.',
        'features_title' => 'Why Choose GIFAM for Project Financing?',
        'features_image' => '../images/case-study/case-study-1.jpg',
        'feature_1_title' => 'Expert Team',
        'feature_1_description' => 'Our experienced financial consultants have successfully facilitated numerous large-scale project financings.',
        'feature_2_title' => 'Comprehensive Approach',
        'feature_2_description' => 'We handle every aspect of the financing process, from initial assessment to deal closure.',
        'feature_3_title' => 'Strong Network',
        'feature_3_description' => 'Extensive relationships with banks, financial institutions, and alternative lenders.',
        'cta_title' => 'Ready to Finance Your Project?',
        'cta_subtitle' => 'Let our experts help you secure the financing you need for your large-scale project.',
        'cta_button_text' => 'Get Started Today',
        'cta_button_link' => '../contact-us/',
        'cta_button_2_text' => 'View All Services',
        'cta_button_2_link' => '../our-services/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="../images/logos/fav.png">

    <title><?php echo htmlspecialchars($page_data['page_title']); ?></title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="../css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="../css/animate.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>our-services/">Our Services</a></li>
                        <li class="breadcrumb-item"><a href="./">Project Financing Consultation</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Page Title -->
<br><br>

    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h2><?php echo htmlspecialchars($page_data['hero_title']); ?></h2>
                            <p class="lead"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url . htmlspecialchars($page_data['hero_image']); ?>" alt="Project Financing" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Services Grid -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['services_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_1_icon']); ?>" style="font-size: 3rem; color: #007bff;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_1_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_point_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_point_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_1_point_3']); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_2_icon']); ?>" style="font-size: 3rem; color: #dc3545;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_2_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_point_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_point_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_2_point_3']); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="<?php echo htmlspecialchars($page_data['service_3_icon']); ?>" style="font-size: 3rem; color: #ffc107;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['service_3_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_point_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_point_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['service_3_point_3']); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Process Section -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['process_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="process-step mb-3">
                                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                        <span class="h4 mb-0">1</span>
                                    </div>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="process-step mb-3">
                                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                        <span class="h4 mb-0">2</span>
                                    </div>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="process-step mb-3">
                                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                        <span class="h4 mb-0">3</span>
                                    </div>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="process-step mb-3">
                                    <div class="bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                        <span class="h4 mb-0">4</span>
                                    </div>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Features Section -->
                    <div class="row mb-5">
                        <div class="col-lg-6">
                            <h3><?php echo htmlspecialchars($page_data['features_title']); ?></h3>
                            <div class="feature-list">
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['feature_1_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['feature_1_description']); ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['feature_2_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['feature_2_description']); ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['feature_3_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['feature_3_description']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <img src="<?php echo $url . htmlspecialchars($page_data['features_image']); ?>" alt="Project Financing Success" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3><?php echo htmlspecialchars($page_data['cta_title']); ?></h3>
                                <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
                                <a href="<?php echo $url . htmlspecialchars($page_data['cta_button_link']); ?>" class="btn btn-primary btn-lg me-3"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
                                <a href="<?php echo $url . htmlspecialchars($page_data['cta_button_2_link']); ?>" class="btn btn-outline-primary btn-lg"><?php echo htmlspecialchars($page_data['cta_button_2_text']); ?></a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="../js/jquery.min.js"></script>
<script src="../js/bootstrap.min.js"></script>
<script src="../js/main.js"></script>

</body>
</html> 
