<?php
include '../url.php';
include '../db.php';

// Récupération des données dynamiques de la page
$page_title = "Company History";
$query = "SELECT * FROM company_history WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Valeurs par défaut si la table est vide
if (!$page_data) {
    $page_data = [
        'page_title' => 'Company History - GIFAM Investment Consulting',
        'meta_description' => 'Company History - Discover GIFAM\'s journey and expertise in investment consulting, mining exploration, oil & gas, AgriTech, real estate, telecommunications, and infrastructure development.',
        'meta_keywords' => 'GIFAM history, company background, investment consulting, mining exploration, oil gas, AgriTech, real estate, telecommunications, infrastructure',
        'intro_1_text' => 'We guide our clients in adopting innovative technologies for site surveying, data analysis, and extraction techniques, increasing efficiency and reducing environmental footprint. Our services extend to navigating regulatory compliance and securing funding, ensuring a smooth transition from initial exploration to full-scale operation.',
        'intro_1_image' => 'images/case-study/case-study-1.jpg',
        'intro_2_text' => 'GIFAM is a leading consultancy in the oil and gas sector, offering a comprehensive suite of services to clients aiming to invest in this dynamic industry. Our goal is to empower our clients with the insights and strategies needed to make informed decisions, maximize returns, and sustainably grow their presence in the global oil and gas market.',
        'intro_2_image' => 'images/case-study/case-study-2.jpg',
        'expert_title' => 'Let our experts help take your wealth to the next level',
        'expert_text' => 'We provide clients with comprehensive investment analysis and advice. This involves assessing investment opportunities, performing market analysis, technical, economical and financial studies while offering strategic recommendations. GIFAM\'s expertise in various sectors like Mineral Explorations, Oil & Gas, Agriculture, Telecommunications, Agritech, Real Estate Development and so on allows us to give informed advice tailored to each client\'s specific needs and goals.',
        'mining_title' => 'Mining Exploration',
        'mining_subtitle' => 'Specialized Consultancy Services',
        'mining_text' => 'GIFAM offers specialized consultancy services in mining exploration, catering to clients eager to explore and capitalize on mineral resources. Our approach combines cutting-edge geological survey techniques with comprehensive market analysis, ensuring a holistic view of the project\'s potential. [...]',
        'mining_video' => 'https://www.youtube.com/embed/Vj3AUQNLbg4?feature=oembed',
        'oil_title' => 'Oil & Gas Exploration',
        'oil_subtitle' => 'GIFAM is a leading consultancy in the oil and gas sector',
        'oil_text' => 'Our approach is rooted in deep market analysis and technical expertise, ensuring that every oil and gas project we handle is optimized for success. [...]',
        'oil_video' => 'https://www.youtube.com/embed/vD0kbdIS6kE?feature=oembed',
        'agritech_title' => 'AgriTech',
        'agritech_subtitle' => 'In the rapidly evolving field of AgriTech, GIFAM stands as a beacon of innovation and expertise',
        'agritech_text' => 'We provide comprehensive consultancy services to clients looking to invest in agricultural technology, a sector that is revolutionizing the way we produce, process, and distribute food. [...]',
        'agritech_image' => 'images/case-study/case-study-3.jpg',
        'realestate_title' => 'Real Estate Development',
        'realestate_subtitle' => 'GIFAM offers a comprehensive suite of services for clients interested in real estate development',
        'realestate_text' => 'An industry known for its complexity and potential for high returns. Our expertise lies in guiding our clients through every stage of the real estate development process, from initial concept to final construction. [...]',
        'realestate_image' => 'images/case-study/case-study-4.jpg',
        'telecom_title' => 'Telecommunication',
        'telecom_subtitle' => 'We provide comprehensive services to clients keen on investing in telecommunications',
        'telecom_text' => 'At GIFAM Consulting, we specialize in steering businesses towards success in the dynamic and ever-evolving telecommunication industry. [...]',
        'telecom_image' => 'images/case-study/case-study-5.jpg',
        'infra_title' => 'Highways / Roads / Railways Constructions',
        'infra_subtitle' => 'GIFAM offers unparalleled expertise to guide investments',
        'infra_text' => 'In the realm of highways, roads, and railways construction, GIFAM Consulting offers unparalleled expertise to guide investments in this critical infrastructure sector. [...]',
        'infra_image' => 'images/case-study/case-study-6.jpg',
        'cta_title' => 'GIFAM innovates in resource-leveling customer service for state of the art customer service.',
        'cta_button_text' => 'Contact Us',
        'cta_button_link' => '../contact-us/',
        'procedure_title' => 'CONSULTANCY PROCEDURE',
        'procedure_subtitle' => 'Our investment project consultancy process is meticulously designed to transform our clients\' visions into actionable, successful strategies.',
        'procedure_steps' => '[{"title":"Initial Consultation and Receipt of Letter of Intent (LOI)","text":"The journey begins when a client expresses interest in investing, often through a Letter of Intent. This document signals their serious commitment and outlines their preliminary objectives. Our team reviews the LOI to understand the project\'s scope, goals, and the client\'s expectations."},{"title":"NEEDS ASSESSMENT & PROJECT SCOPING","text":"We conduct detailed discussions with the client to delve deeper into their specific needs, challenges, and aspirations. [...]"},{"title":"Feasibility Analysis","text":"Our experts carry out a feasibility study, examining the viability of the project from various angles including financial, technical, legal, and environmental aspects. [...]"},{"title":"Strategy Development","text":"Based on the insights gained, we formulate a strategic plan. [...]"},{"title":"Risk Management Planning","text":"Identifying and planning for potential risks is a cornerstone of our approach. [...]"},{"title":"Financial Analysis and Funding Advice","text":"We offer detailed financial analysis, including budgeting, forecasting, and investment return analysis. [...]"},{"title":"Regulatory Compliance and Legal Framework","text":"Ensuring compliance with relevant laws and regulations is crucial. [...]"},{"title":"Customized Consultancy Offer","text":"Integrating all the insights and strategies, we craft a tailor-made consultancy offer. [...]"},{"title":"Client Review and Feedback","text":"The client reviews our offer, providing feedback and requesting any adjustments. [...]"},{"title":"Final Agreement and Project Kick-off","text":"Upon mutual agreement, we formalize the consultancy engagement and kick off the project, providing continuous support and guidance throughout the implementation phase."}]',
        'procedure_image' => 'images/case-study/case-study-1.jpg'
    ];
}
// Décodage des étapes de procédure (JSON)
$procedure_steps = json_decode($page_data['procedure_steps'] ?? '[]', true);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title><?php echo htmlspecialchars($page_data['page_title']); ?></title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>compnay-history/">Company History</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Introduction Section -->
                    <div class="row mb-5">
                        <div class="col-md-6">
                            <div class="intro-text">
                                <p style="text-align: left;">
                                    <?php echo htmlspecialchars($page_data['intro_1_text']); ?>
                                </p>
                            </div>
                            <div class="intro-image">
                                <img src="<?php echo $url; ?><?php echo htmlspecialchars($page_data['intro_1_image']); ?>" alt="Mining Exploration" class="img-fluid rounded shadow">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="intro-text">
                                <p style="text-align: left;">
                                    <?php echo htmlspecialchars($page_data['intro_2_text']); ?>
                                </p>
                            </div>
                            <div class="intro-image">
                                <img src="<?php echo $url; ?><?php echo htmlspecialchars($page_data['intro_2_image']); ?>" alt="Oil & Gas" class="img-fluid rounded shadow">
                            </div>
                        </div>
                    </div>

                    <!-- Expert Services Section -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="expert-services text-center">
                                <h3 class="mb-4"><?php echo htmlspecialchars($page_data['expert_title']); ?></h3>
                                <p class="lead">
                                    <?php echo htmlspecialchars($page_data['expert_text']); ?>
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Mining Exploration Section -->
                    <div class="row mb-5 align-items-center">
                        <div class="col-md-6">
                            <div class="service-content">
                                <h1 class="service-title">
                                    <span style="color: #000000;"><strong><?php echo htmlspecialchars($page_data['mining_title']); ?></strong></span>
                                </h1>
                                <h3 class="service-subtitle"><?php echo htmlspecialchars($page_data['mining_subtitle']); ?></h3>
                                <p>
                                    <?php echo htmlspecialchars($page_data['mining_text']); ?>
                                </p>
                                <p>
                                    In the realm of risk management, we focus on mitigating operational, environmental, and financial risks, ensuring that your project adheres to the highest safety and sustainability standards. Our expertise also extends to navigating the complex web of legal and regulatory requirements specific to mining, ensuring full compliance and smooth project progression.
                                </p>
                                <p>
                                    At GIFAM, we understand that technology plays a pivotal role in modern mining exploration. We guide our clients in adopting innovative technologies for site surveying, data analysis, and extraction techniques, increasing efficiency and reducing environmental footprint. Whether you are exploring new mining opportunities or seeking to expand existing operations, GIFAM is your trusted partner in transforming mining exploration ventures into successful, profitable enterprises.
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="video-container">
                                <div class="embed-responsive embed-responsive-16by9">
                                    <iframe class="embed-responsive-item" src="<?php echo htmlspecialchars($page_data['mining_video']); ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Oil & Gas Section -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="video-container text-center mb-4">
                                <div class="embed-responsive embed-responsive-16by9" style="max-width: 800px; margin: 0 auto;">
                                    <iframe class="embed-responsive-item" src="<?php echo htmlspecialchars($page_data['oil_video']); ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                                </div>
                            </div>
                            <div class="service-content text-center">
                                <h1 class="service-title"><strong><?php echo htmlspecialchars($page_data['oil_title']); ?></strong></h1>
                                <h4 class="service-subtitle"><?php echo htmlspecialchars($page_data['oil_subtitle']); ?></h4>
                                <p>
                                    <?php echo htmlspecialchars($page_data['oil_text']); ?>
                                </p>
                                <p>
                                    We also provide strategic guidance in project management, from exploration and drilling to production and distribution, ensuring operational efficiency and environmental compliance. At GIFAM, we understand the critical importance of technological integration in this sector, and our advisory services encompass the latest innovations in drilling techniques, reservoir management, and emissions reduction.
                                </p>
                                <p>
                                    Our goal is to empower our clients with the insights and strategies needed to make informed decisions, maximize returns, and sustainably grow their presence in the global oil and gas market.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- AgriTech Section -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="service-image text-center mb-4">
                                <img src="<?php echo $url; ?><?php echo htmlspecialchars($page_data['agritech_image']); ?>" alt="AgriTech" class="img-fluid rounded shadow">
                            </div>
                            <div class="service-content">
                                <h1 class="service-title"><strong><?php echo htmlspecialchars($page_data['agritech_title']); ?></strong></h1>
                                <h4 class="service-subtitle"><?php echo htmlspecialchars($page_data['agritech_subtitle']); ?></h4>
                                <p>
                                    <?php echo htmlspecialchars($page_data['agritech_text']); ?>
                                </p>
                                <p>
                                    Our services include detailed feasibility studies that assess the potential of various AgriTech innovations, from precision farming and drone technology to AI-driven crop management and automated irrigation systems. We focus on maximizing crop yield, optimizing resource use, and reducing environmental impact. GIFAM's risk management strategies are tailored to the unique challenges of AgriTech, addressing factors like technological adaptability, market volatility, and climate change.
                                </p>
                                <p>
                                    We also assist in securing funding and navigating the complex landscape of regulatory compliance, ensuring that your AgriTech venture is both financially viable and legally sound. By staying at the forefront of technological advancements in agriculture, GIFAM empowers its clients to lead the way in sustainable, efficient, and profitable farming practices, ushering in a new era of food security and environmental stewardship.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Real Estate Development Section -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="service-image text-center mb-4">
                                <img src="<?php echo $url; ?><?php echo htmlspecialchars($page_data['realestate_image']); ?>" alt="Real Estate Development" class="img-fluid rounded shadow">
                            </div>
                            <div class="service-content">
                                <h1 class="service-title"><strong><?php echo htmlspecialchars($page_data['realestate_title']); ?></strong></h1>
                                <h4 class="service-subtitle"><?php echo htmlspecialchars($page_data['realestate_subtitle']); ?></h4>
                                <p>
                                    <?php echo htmlspecialchars($page_data['realestate_text']); ?>
                                </p>
                                <p>
                                    We start with in-depth market studies and feasibility analyses to identify lucrative opportunities and mitigate risks. Our team specializes in understanding local market trends, zoning laws, and regulatory requirements, ensuring your project aligns with current demands and future growth potentials. We also offer financial and risk management solutions tailored to the unique aspects of real estate projects, such as fluctuating market conditions, project financing, and investment structuring.
                                </p>
                                <p>
                                    GIFAM's project management expertise ensures that your development stays on schedule and within budget, addressing challenges in site selection, design, construction, and marketing. Our approach integrates sustainable practices and innovative technologies, aligning with modern demands for energy efficiency and environmental responsibility.
                                </p>
                                <p>
                                    Whether your focus is residential, commercial, or mixed-use developments, GIFAM provides the strategic insight and practical guidance necessary to navigate the real estate development landscape successfully, transforming your vision into a profitable and sustainable reality.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Telecommunications Section -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="service-image text-center mb-4">
                                <img src="<?php echo $url; ?><?php echo htmlspecialchars($page_data['telecom_image']); ?>" alt="Telecommunications" class="img-fluid rounded shadow">
                            </div>
                            <div class="service-content">
                                <h1 class="service-title"><strong><?php echo htmlspecialchars($page_data['telecom_title']); ?></strong></h1>
                                <h4 class="service-subtitle"><?php echo htmlspecialchars($page_data['telecom_subtitle']); ?></h4>
                                <p>
                                    <?php echo htmlspecialchars($page_data['telecom_text']); ?>
                                </p>
                                <p>
                                    Our team of experts offers tailored strategies for network expansion, technological upgrades, and competitive positioning. We excel in navigating the challenges of deploying new technologies like 5G, IoT, and cloud services, ensuring our clients are at the forefront of innovation.
                                </p>
                                <p>
                                    Our approach involves not just adapting to changes in the telecommunications landscape but anticipating them, enabling our clients to make informed investment decisions and achieve long-term profitability in this high-stakes market.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Infrastructure Section -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="service-image text-center mb-4">
                                <img src="<?php echo $url; ?><?php echo htmlspecialchars($page_data['infra_image']); ?>" alt="Highways Roads Railways Constructions" class="img-fluid rounded shadow">
                            </div>
                            <div class="service-content">
                                <h1 class="service-title"><strong><?php echo htmlspecialchars($page_data['infra_title']); ?></strong></h1>
                                <h4 class="service-subtitle"><?php echo htmlspecialchars($page_data['infra_subtitle']); ?></h4>
                                <p>
                                    <?php echo htmlspecialchars($page_data['infra_text']); ?>
                                </p>
                                <p>
                                    Our team excels in navigating the intricate web of regulations and logistical challenges inherent in infrastructure projects. We provide end-to-end project management, from initial planning and environmental impact assessments to the intricacies of procurement and construction oversight. Our risk management strategies are designed to mitigate potential delays and cost overruns, safeguarding our clients' interests.
                                </p>
                                <p>
                                    Furthermore, we leverage cutting-edge technology and innovative engineering solutions to enhance efficiency and durability in construction. Whether it's implementing smart road technologies or integrating advanced materials for longevity, our focus remains on delivering high-quality, future-proof infrastructure. By partnering with GIFAM Consulting, investors in the highways, roads, and railways sector can expect a path that leads not just to successful project completion, but to long-term infrastructural assets that yield ongoing economic benefits.
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Contact CTA Section -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <div class="cta-section text-center bg-primary text-white p-5 rounded">
                                <h2><strong><?php echo htmlspecialchars($page_data['cta_title']); ?></strong></h2>
                                <a class="btn btn-light btn-lg mt-3" href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
                            </div>
                        </div>
                    </div>

                    <!-- Consultancy Procedure Section -->
                    <div class="row mb-5">
                        <div class="col-md-6">
                            <div class="procedure-image">
                                <img src="<?php echo $url; ?><?php echo htmlspecialchars($page_data['procedure_image']); ?>" alt="Consultancy Procedure" class="img-fluid rounded shadow">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="procedure-content">
                                <h2 class="procedure-title"><?php echo htmlspecialchars($page_data['procedure_title']); ?></h2>
                                <h3 class="procedure-subtitle"><?php echo htmlspecialchars($page_data['procedure_subtitle']); ?></h3>
                                
                                <?php foreach ($procedure_steps as $step): ?>
                                <div class="procedure-step">
                                    <h4><span style="color: #ff0000;"><strong><?php echo htmlspecialchars($step['title']); ?></strong></span></h4>
                                    <p>
                                        <?php echo htmlspecialchars($step['text']); ?>
                                    </p>
                                </div>
                                <?php endforeach; ?>

                                <div class="procedure-conclusion">
                                    <p>
                                        Each step in our process is designed to build a foundation of trust, transparency, and tailored expertise, ensuring that our clients' investment projects are not just successful but also sustainable and forward-looking.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

<style>
    .main-container {
        padding: 80px 0;
    }
    
    .service-title {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        color: #333;
    }
    
    .service-subtitle {
        font-size: 1.5rem;
        font-weight: 600;
        margin-bottom: 1.5rem;
        color: #666;
    }
    
    .service-content {
        padding: 2rem 0;
    }
    
    .service-image img {
        max-width: 100%;
        height: auto;
    }
    
    .video-container {
        margin: 2rem 0;
    }
    
    .embed-responsive {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    .cta-section {
        background: linear-gradient(135deg, #dc3545 0%, #0288d1 100%);
        border-radius: 15px;
        padding: 3rem;
    }
    
    .procedure-title {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 1rem;
        color: #333;
    }
    
    .procedure-subtitle {
        font-size: 1.2rem;
        font-weight: 600;
        margin-bottom: 2rem;
        color: #666;
    }
    
    .procedure-step {
        margin-bottom: 2rem;
        padding: 1.5rem;
        background: #f8f9fa;
        border-radius: 10px;
        border-left: 4px solid #dc3545;
    }
    
    .procedure-step h4 {
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 1rem;
    }
    
    .procedure-conclusion {
        margin-top: 2rem;
        padding: 1.5rem;
        background: #e8f5e8;
        border-radius: 10px;
        border-left: 4px solid #dc3545;
    }
    
    .intro-text {
        margin-bottom: 2rem;
    }
    
    .intro-image {
        margin-bottom: 2rem;
    }
    
    .expert-services {
        background: #f8f9fa;
        padding: 3rem;
        border-radius: 15px;
        margin: 3rem 0;
    }
    
    .expert-services h3 {
        color: #333;
        font-weight: 700;
    }
    
    .expert-services .lead {
        color: #666;
        font-size: 1.1rem;
        line-height: 1.8;
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .service-title {
            font-size: 2rem;
        }
        
        .service-subtitle {
            font-size: 1.2rem;
        }
        
        .procedure-title {
            font-size: 1.5rem;
        }
        
        .expert-services {
            padding: 2rem;
        }
        
        .cta-section {
            padding: 2rem;
        }
    }
</style>

</body>
</html>
