<?php
include '../db.php';

// Sécurité : filtrer les entrées
$name    = trim($_POST['name'] ?? '');
$email   = trim($_POST['email'] ?? '');
$phone   = trim($_POST['phone'] ?? '');
$company = trim($_POST['company'] ?? '');
$inquiry = trim($_POST['inquiry'] ?? '');
$budget  = trim($_POST['budget'] ?? '');
$message = trim($_POST['message'] ?? '');
$ip      = $_SERVER['REMOTE_ADDR'] ?? '';

header('Content-Type: application/json');

if ($name && $email && $message) {
    // 1. Enregistrement en base
    $stmt = $conn->prepare("INSERT INTO contact_messages (name, email, phone, company, inquiry, budget, message, ip_address) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssssss", $name, $email, $phone, $company, $inquiry, $budget, $message, $ip);
    $stmt->execute();

    // 2. Envoi email
    $to = "info@gifam.eu"; // Mets ici l'adresse de destination
    $subject = "Nouveau message de contact GIFAM";
    $body = "Nom: $name\nEmail: $email\nTéléphone: $phone\nSociété: $company\nType de demande: $inquiry\nBudget: $budget\nMessage:\n$message\n\nIP: $ip";
    $headers = "From: $email\r\nReply-To: $email\r\n";
    mail($to, $subject, $body, $headers);

    // 3. Réponse AJAX
    echo json_encode(['success' => true, 'message' => 'Votre message a bien été envoyé.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Merci de remplir tous les champs obligatoires.']);
} 