<?php 
include '../url.php';
include '../db.php';

// Récupération des données dynamiques de la page contact
$page_title = "Contact Us";
$query = "SELECT * FROM contact_us WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Valeurs par défaut si la table est vide
if (!$page_data) {
    $page_data = [
        'page_title' => 'Contact Us - GIFAM Investment Consulting',
        'meta_description' => 'Contact GIFAM for your financial advisory, investment and asset management needs. Our team of experts is here to support you with personalized solutions.',
        'meta_keywords' => 'contact GIFAM, financial advisory, investment consulting, asset management, project financing, Cyprus',
        'hero_title' => "Let's Start Your Investment Journey",
        'hero_text' => 'Ready to take your investment projects to the next level? Our team of financial experts is here to guide you through every step of your journey.',
        'hero_image' => 'images/case-study/case-study-1.jpg',
        'stat_1_number' => '500+',
        'stat_1_label' => 'Projects Completed',
        'stat_2_number' => '50+',
        'stat_2_label' => 'Countries Served',
        'stat_3_number' => '24/7',
        'stat_3_label' => 'Support Available',
        'contact_title' => 'Get In Touch',
        'contact_text' => 'At GIFAM, we are committed to providing exceptional customer service. Our team of financial experts is available to answer all your questions and support you in your investment projects.',
        'address_title' => 'Our Address',
        'address' => 'AYIOU PAVLOU 61<br>AGIOS DOMETIOS<br>CYPRUS',
        'email_title' => 'Email Us',
        'email' => 'info@gifam.eu',
        'phone_title' => 'Call Us',
        'phone_1' => '+35 796 306 456',
        'phone_2' => '+971 523 801 458',
        'phone_3' => '+44 774 724 6568',
        'hours_title' => 'Business Hours',
        'hours' => 'Monday - Friday: 9:00 AM - 6:00 PM (GMT+2)<br>Saturday: 9:00 AM - 2:00 PM<br>Sunday: Closed',
        'social_title' => 'Follow Us',
        'facebook' => '#',
        'twitter' => '#',
        'linkedin' => '#',
        'instagram' => '#',
        'form_title' => 'Send Us a Message',
        'form_text' => 'Fill out the form below and our team will contact you within 24 hours.',
        'label_name' => 'Full Name *',
        'label_email' => 'Email Address *',
        'label_phone' => 'Phone Number',
        'label_company' => 'Company',
        'label_inquiry' => 'Type of Inquiry *',
        'label_budget' => 'Estimated Budget',
        'label_message' => 'Message *',
        'label_privacy' => 'I accept the <a href="../privacy-policy/" target="_blank" class="text-decoration-none">privacy policy</a> *',
        'submit_text' => 'Send Message',
        'inquiry_options' => 'investment,Investment Advisory;project-financing,Project Financing;asset-management,Asset Management;risk-management,Risk Management;market-entry,Market Entry Strategy;mining-exploration,Mining Exploration;oil-gas,Oil & Gas;agritech,AgriTech;real-estate,Real Estate Development;telecommunications,Telecommunications;infrastructure,Infrastructure;general,General Inquiry;other,Other',
        'budget_options' => 'under-50k,Under €50,000;50k-200k,€50,000 - €200,000;200k-1m,€200,000 - €1,000,000;1m-5m,€1,000,000 - €5,000,000;over-5m,Over €5,000,000;not-specified,Not specified',
        'map_title' => 'Find Our Office',
        'map_text' => 'Visit us at our headquarters in Cyprus',
        'map_iframe' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3258.1234567890123!2d33.12345678901234!3d35.12345678901234!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMzXCsDA3JzM0LjQiTiAzM8KwMDcjMzQuNCJF!5e0!3m2!1sen!2sus!4v1234567890123',
        'faq_title' => 'Frequently Asked Questions',
        'faq_text' => 'Get quick answers to common questions',
        'faq_1_q' => 'How quickly will you respond to my inquiry?',
        'faq_1_a' => 'We typically respond within 24 hours during business days. For urgent matters, please call us directly.',
        'faq_2_q' => 'What information should I prepare for our first meeting?',
        'faq_2_a' => 'Please have your project details, budget range, and any specific requirements ready for discussion.',
        'faq_3_q' => 'Do you offer services internationally?',
        'faq_3_a' => 'Yes, we serve clients globally and have experience in over 50 countries across various industries.',
        'faq_4_q' => 'What is your minimum project size?',
        'faq_4_a' => 'We work with projects starting from €20 million, offering tailored solutions for each client\'s needs.'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="<?php echo $page_data['meta_description']; ?>">
    <meta name="keywords" content="<?php echo $page_data['meta_keywords']; ?>">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">

    <title><?php echo $page_data['page_title']; ?></title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>contact-us/">Contact Us</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <!-- Hero Section -->
    <section class="contact-hero bg-primary text-white py-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4"><?php echo $page_data['hero_title']; ?></h1>
                        <p class="lead mb-4"><?php echo $page_data['hero_text']; ?></p>
                        <div class="hero-stats">
                            <div class="row text-center">
                                <div class="col-4">
                                    <div class="stat-item">
                                        <h3 class="fw-bold"><?php echo $page_data['stat_1_number']; ?></h3>
                                        <p><?php echo $page_data['stat_1_label']; ?></p>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="stat-item">
                                        <h3 class="fw-bold"><?php echo $page_data['stat_2_number']; ?></h3>
                                        <p><?php echo $page_data['stat_2_label']; ?></p>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="stat-item">
                                        <h3 class="fw-bold"><?php echo $page_data['stat_3_number']; ?></h3>
                                        <p><?php echo $page_data['stat_3_label']; ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="hero-image text-center">
                        <img src="<?php echo $url; ?><?php echo $page_data['hero_image']; ?>" alt="GIFAM Contact" class="img-fluid rounded shadow-lg">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact-section py-5">
        <div class="container">
            <div class="row">
                <!-- Contact Information -->
                <div class="col-lg-5">
                    <div class="contact-info-card h-100">
                        <div class="card border-0 shadow-lg h-100">
                            <div class="card-body p-4">
                                <h2 class="card-title mb-4"><?php echo $page_data['contact_title']; ?></h2>
                                <p class="card-text mb-4"><?php echo $page_data['contact_text']; ?></p>

                                <div class="contact-details">
                                    <div class="contact-item d-flex align-items-start mb-4">
                                        <div class="contact-icon me-3">
                                            <i class="icofont-location-pin text-primary"></i>
                                        </div>
                                        <div class="contact-text">
                                            <h6 class="fw-bold mb-1"><?php echo $page_data['address_title']; ?></h6>
                                            <address class="mb-0">
                                                <?php echo $page_data['address']; ?>
                                            </address>
                                        </div>
                                    </div>

                                    <div class="contact-item d-flex align-items-start mb-4">
                                        <div class="contact-icon me-3">
                                            <i class="icofont-envelope text-primary"></i>
                                        </div>
                                        <div class="contact-text">
                                            <h6 class="fw-bold mb-1"><?php echo $page_data['email_title']; ?></h6>
                                            <p class="mb-0">
                                                <a href="mailto:<?php echo $page_data['email']; ?>" class="text-decoration-none">
                                                    <?php echo $page_data['email']; ?>
                                                </a>
                                            </p>
                                        </div>
                                    </div>
                                    <style>a {
    color: #6b6a75 !important;
    transition: var(--transition);
    outline: none !important;
}</style>

                                    <div class="contact-item d-flex align-items-start mb-4">
                                        <div class="contact-icon me-3">
                                            <i class="icofont-phone text-primary"></i>
                                        </div>
                                        <div class="contact-text">
                                            <h6 class="fw-bold mb-1" style="color:!#000;"><?php echo $page_data['phone_title']; ?></h6>
                                            <p class="mb-0">
                                                <a href="tel:<?php echo str_replace('+', '', $page_data['phone_1']); ?>" class="text-decoration-none d-block"><?php echo $page_data['phone_1']; ?></a>
                                                <a href="tel:<?php echo str_replace('', '', $page_data['phone_2']); ?>" class="text-decoration-none d-block"><?php echo $page_data['phone_2']; ?></a>
                                                <a href="tel:<?php echo str_replace('', '', $page_data['phone_3']); ?>" class="text-decoration-none d-block"><?php echo $page_data['phone_3']; ?></a>
                                            </p>
                                        </div>
                                    </div>

                                    <div class="contact-item d-flex align-items-start mb-4">
                                        <div class="contact-icon me-3">
                                            <i class="icofont-clock-time text-primary"></i>
                                        </div>
                                        <div class="contact-text">
                                            <h6 class="fw-bold mb-1"><?php echo $page_data['hours_title']; ?></h6>
                                            <p class="mb-0">
                                                <?php echo $page_data['hours']; ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>

                                <div class="social-links mt-4">
                                    <h6 class="fw-bold mb-3"><?php echo $page_data['social_title']; ?></h6>
                                    <div class="d-flex gap-3">
                                        <a href="<?php echo $page_data['facebook']; ?>" class="social-link" aria-label="Facebook">
                                            <i class="icofont-facebook"></i>
                                        </a>
                                        <a href="<?php echo $page_data['twitter']; ?>" class="social-link" aria-label="Twitter">
                                            <i class="icofont-twitter"></i>
                                        </a>
                                        <a href="<?php echo $page_data['linkedin']; ?>" class="social-link" aria-label="LinkedIn">
                                            <i class="icofont-linkedin"></i>
                                        </a>
                                        <a href="<?php echo $page_data['instagram']; ?>" class="social-link" aria-label="Instagram">
                                            <i class="icofont-instagram"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Contact Form -->
                <div class="col-lg-7">
                    <div class="contact-form-card">
                        <div class="card border-0 shadow-lg">
                            <div class="card-body p-4">
                                <h2 class="card-title mb-4"><?php echo $page_data['form_title']; ?></h2>
                                <p class="card-text mb-4"><?php echo $page_data['form_text']; ?></p>
                                
                                <form class="contact-form" id="contactForm">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="name" class="form-label fw-bold"><?php echo $page_data['label_name']; ?></label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       id="name" 
                                                       name="name"
                                                       placeholder="Your full name"
                                                       required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="email" class="form-label fw-bold"><?php echo $page_data['label_email']; ?></label>
                                                <input type="email" 
                                                       class="form-control" 
                                                       id="email" 
                                                       name="email"
                                                       placeholder="your.email@example.com"
                                                       required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="phone" class="form-label fw-bold"><?php echo $page_data['label_phone']; ?></label>
                                                <input type="tel" 
                                                       class="form-control" 
                                                       id="phone" 
                                                       name="phone"
                                                       placeholder="+1 234 567 8900">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="company" class="form-label fw-bold"><?php echo $page_data['label_company']; ?></label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       id="company" 
                                                       name="company"
                                                       placeholder="Your company name">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="inquiry" class="form-label fw-bold"><?php echo $page_data['label_inquiry']; ?></label>
                                                <select class="form-control" 
                                                        id="inquiry" 
                                                        name="inquiry"
                                                        required>
                                                    <option value="">Select an inquiry type</option>
                                                    <?php
                                                    $inquiry_options = explode(';', $page_data['inquiry_options']);
                                                    foreach ($inquiry_options as $option) {
                                                        list($value, $label) = explode(',', $option);
                                                        echo "<option value=\"$value\">$label</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <label for="budget" class="form-label fw-bold"><?php echo $page_data['label_budget']; ?></label>
                                                <select class="form-control" 
                                                        id="budget" 
                                                        name="budget">
                                                    <option value="">Select a budget range</option>
                                                    <?php
                                                    $budget_options = explode(';', $page_data['budget_options']);
                                                    foreach ($budget_options as $option) {
                                                        list($value, $label) = explode(',', $option);
                                                        echo "<option value=\"$value\">$label</option>";
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group mb-3">
                                        <label for="message" class="form-label fw-bold"><?php echo $page_data['label_message']; ?></label>
                                        <textarea class="form-control" 
                                                  id="message" 
                                                  name="message"
                                                  rows="6" 
                                                  placeholder="Describe your project or request in detail..."
                                                  style="min-height: 120px; resize: vertical;"
                                                  required></textarea>
                                    </div>

                                    <div class="form-group mb-4">
                                        <div class="form-check">
                                            <input class="form-check-input" 
                                                   type="checkbox" 
                                                   id="privacy" 
                                                   name="privacy"
                                                   required>
                                            <label class="form-check-label" for="privacy">
                                                <?php echo $page_data['label_privacy']; ?>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <button type="submit" 
                                                class="btn btn-primary btn-lg w-100"
                                                id="submitBtn">
                                            <i class="icofont-send-mail me-2"></i>
                                            <?php echo $page_data['submit_text']; ?>
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script>
    document.getElementById('contactForm').addEventListener('submit', function(e) {
        e.preventDefault();
        var form = this;
        var formData = new FormData(form);
        fetch('contact-process.php', {
            method: 'POST',
            body: formData
        })
        .then(r => r.json())
        .then(data => {
            alert(data.message);
            if (data.success) form.reset();
        })
        .catch(() => alert('Erreur lors de l\'envoi.'));
    });
    </script>
    <!-- Map Section -->
    <section class="map-section py-5 bg-light">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="text-center mb-4">
                        <h2 class="fw-bold"><?php echo $page_data['map_title']; ?></h2>
                        <p class="lead"><?php echo $page_data['map_text']; ?></p>
                    </div>
                    <div class="map-container">
                        <div class="card border-0 shadow-lg">
                            <div class="card-body p-0">
                                <iframe 
                                    src="<?php echo $page_data['map_iframe']; ?>"
                                    width="100%" 
                                    height="450" 
                                    style="border:0;" 
                                    allowfullscreen="" 
                                    loading="lazy"
                                    referrerpolicy="no-referrer-when-downgrade"
                                    title="Map showing GIFAM office location in Cyprus">
                                </iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="faq-section py-5">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="text-center mb-5">
                        <h2 class="fw-bold"><?php echo $page_data['faq_title']; ?></h2>
                        <p class="lead"><?php echo $page_data['faq_text']; ?></p>
                    </div>
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="faq-item mb-4">
                                <h5 class="fw-bold mb-2"><?php echo $page_data['faq_1_q']; ?></h5>
                                <p class="mb-0"><?php echo $page_data['faq_1_a']; ?></p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="faq-item mb-4">
                                <h5 class="fw-bold mb-2"><?php echo $page_data['faq_2_q']; ?></h5>
                                <p class="mb-0"><?php echo $page_data['faq_2_a']; ?></p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="faq-item mb-4">
                                <h5 class="fw-bold mb-2"><?php echo $page_data['faq_3_q']; ?></h5>
                                <p class="mb-0"><?php echo $page_data['faq_3_a']; ?></p>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="faq-item mb-4">
                                <h5 class="fw-bold mb-2"><?php echo $page_data['faq_4_q']; ?></h5>
                                <p class="mb-0"><?php echo $page_data['faq_4_a']; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

<style>
    /* Hero Section */
    .contact-hero {
        background: linear-gradient(135deg, #000000 0%, #000000 100%);
        position: relative;
        overflow: hidden;
    }
    
    .contact-hero::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.1;
    }
    
    .hero-content {
        position: relative;
        z-index: 2;
    }
    
    .stat-item {
        padding: 1rem;
        border-radius: 10px;
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(10px);
    }
    
    .stat-item h3 {
        font-size: 2rem;
        margin-bottom: 0.5rem;
    }
    
    /* Contact Section */
    .contact-info-card,
    .contact-form-card {
        transition: transform 0.3s ease;
    }
    
    .contact-info-card:hover,
    .contact-form-card:hover {
        transform: translateY(-5px);
    }
    
    .contact-icon {
        width: 40px;
        height: 40px;
        background: #dc3545;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
    }
    
    .contact-icon i {
        font-size: 1.2rem;
    }
    
    .social-links .social-link {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        background: #f8f9fa;
        border-radius: 50%;
        color: #666;
        text-decoration: none;
        transition: all 0.3s ease;
    }
    
    .social-links .social-link:hover {
        background: #d12907;
        color: white;
        transform: translateY(-2px);
    }
    
    /* Form Styling */
    .form-control {
        border: 2px solid #e9ecef;
        border-radius: 10px;
        padding: 0rem 1.25rem;
        font-size: 1rem;
        line-height: 1.5;
        min-height: 50px;
        background-color: #ffffff;
        color: #000000;
        transition: all 0.3s ease;
    }
    
    .form-control::placeholder {
        color: #6c757d;
        opacity: 0.8;
    }
    
    select.form-control:invalid {
        color: #6c757d;
    }
    
    select.form-control option:first-child {
        color: #6c757d;
        font-style: italic;
    }
    
    select.form-control {
        background-color: #ffffff;
        *background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23000000' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m1 6 7 7 7-7'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 1rem center;
        background-size: 16px 12px;
        padding-right: 2.5rem;
        color: #000000;
        font-weight: 500;
    }
    
    select.form-control option {
        background-color: #ffffff;
        color: #000000;
        padding: 0.5rem;
    }
    
    select.form-control:focus {
        background-color: #ffffff;
        color: #000000;
    }
    
    .form-control:focus {
        border-color:rgb(0, 0, 0);
        box-shadow: 0 0 0 0.2rem rgba(0, 0, 0, 0.25);
    }
    
    .form-label {
        color: #333;
        margin-bottom: 0.75rem;
        font-size: 1rem;
        font-weight: 600;
    }
    
    .btn-primary {
        background: linear-gradient(135deg,rgb(0, 0, 0) 0%,rgb(0, 0, 0) 100%);
        border: none;
        border-radius: 10px;
        padding: 0.75rem 2rem;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.4);
    }
    
    /* Map Section */
    .map-container {
        border-radius: 15px;
        overflow: hidden;
    }
    
    /* FAQ Section */
    .faq-item {
        padding: 1.5rem;
        background: #f8f9fa;
        border-radius: 10px;
        border-left: 4px solidrgb(0, 0, 0);
        transition: all 0.3s ease;
    }
    
    .faq-item:hover {
        background: #e9ecef;
        transform: translateX(5px);
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .hero-stats {
            margin-top: 2rem;
        }
        
        .stat-item h3 {
            font-size: 1.5rem;
        }
        
        .contact-info-card,
        .contact-form-card {
            margin-bottom: 2rem;
        }
    }
    
    /* Animation Classes */
    .fade-in {
        animation: fadeIn 0.6s ease-in;
    }
    
    .slide-up {
        animation: slideUp 0.6s ease-out;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    
    @keyframes slideUp {
        from { 
            opacity: 0;
            transform: translateY(30px);
        }
        to { 
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>

<script>
document.getElementById('contactForm').addEventListener('submit', function(e) {
    e.preventDefault();
    var form = this;
    var formData = new FormData(form);
    fetch('contact-process.php', {
        method: 'POST',
        body: formData
    })
    .then(r => r.json())
    .then(data => {
        alert(data.message);
        if (data.success) form.reset();
    })
    .catch(() => alert('Erreur lors de l\'envoi.'));
});
</script>

</body>
</html>
