<?php
include '../url.php';
include '../db.php';

// Récupération des données dynamiques de la page
$page_title = "Cookie Policy";
$query = "SELECT * FROM cookie_policy WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Valeurs par défaut si la table est vide
if (!$page_data) {
    $page_data = [
        'page_title' => 'Cookie Policy - GIFAM | Cookie Management & Tracking Technologies',
        'meta_description' => 'GIFAM\'s comprehensive cookie policy explains how we use cookies and tracking technologies to enhance your browsing experience while respecting your privacy.',
        'meta_keywords' => 'cookie policy, cookies, tracking technologies, GDPR, privacy, GIFAM',
        'hero_title' => 'Cookie Policy',
        'hero_text' => 'This Cookie Policy explains how GIFAM uses cookies and similar tracking technologies on our website to enhance your browsing experience while respecting your privacy and data protection rights.',
        'hero_image' => 'images/case-study/case-study-3.jpg',
        'update_date' => 'Last Updated: 11, 07, 2025',
        'section_1_title' => '1. What Are Cookies?',
        'section_1_text' => 'Cookies are small text files that are stored on your device (computer, tablet, or mobile phone) when you visit a website. They help websites remember information about your visit, such as your preferred language and other settings, which can make your next visit easier and the site more useful to you.<br><br><strong>How Cookies Work:</strong><ul><li><strong>Storage:</strong> Cookies are stored in your browser\'s file directory</li><li><strong>Transmission:</strong> They are sent back to the website on subsequent visits</li><li><strong>Functionality:</strong> They enable websites to remember your preferences and settings</li><li><strong>Security:</strong> They help maintain secure sessions and prevent fraud</li></ul>',
        'section_2_title' => '2. Types of Cookies We Use',
        'section_2_text' => 'Description of types of cookies used by GIFAM.',
        'essential_table' => '[{"name":"session_id","purpose":"Maintains user session and security","duration":"Session","type":"Essential"},{"name":"csrf_token","purpose":"Protects against cross-site request forgery","duration":"Session","type":"Essential"},{"name":"language","purpose":"Remembers your language preference","duration":"1 year","type":"Essential"}]',
        'analytics_table' => '[{"name":"_ga","purpose":"Google Analytics - tracks unique visitors","duration":"2 years","type":"Analytics"},{"name":"_gid","purpose":"Google Analytics - tracks session data","duration":"24 hours","type":"Analytics"},{"name":"_gat","purpose":"Google Analytics - throttles request rate","duration":"1 minute","type":"Analytics"}]',
        'marketing_table' => '[{"name":"fr","purpose":"Facebook advertising","duration":"3 months","type":"Marketing"},{"name":"IDE","purpose":"Google advertising","duration":"1 year","type":"Marketing"}]',
        'preferences_table' => '[{"name":"cookie_preferences","purpose":"Stores your cookie preferences","duration":"1 year","type":"Preferences"}]',
        'section_3_title' => '3. How to Control Cookies',
        'section_3_text' => 'You can control and/or delete cookies as you wish – for details, see aboutcookies.org. You can delete all cookies that are already on your computer and you can set most browsers to prevent them from being placed. If you do this, however, you may have to manually adjust some preferences every time you visit a site and some services and functionalities may not work.',
        'browser_instructions' => '<strong>Browser Instructions:</strong><ul><li><strong>Chrome:</strong> Settings > Privacy and security > Cookies and other site data</li><li><strong>Firefox:</strong> Options > Privacy & Security > Cookies and Site Data</li><li><strong>Safari:</strong> Preferences > Privacy > Cookies and website data</li><li><strong>Edge:</strong> Settings > Site permissions > Cookies and site data</li></ul>',
        'section_4_title' => '4. Changes to This Cookie Policy',
        'section_4_text' => 'We may update our Cookie Policy from time to time. We encourage you to review this page periodically for any changes. Changes are effective when they are posted on this page.',
        'section_5_title' => '5. Contact Us',
        'section_5_text' => 'If you have any questions about our Cookie Policy, please contact us at info@gifam.eu.'
    ];
}
// Décodage des tableaux de cookies (JSON)
$essential_table = json_decode($page_data['essential_table'] ?? '[]', true);
$analytics_table = json_decode($page_data['analytics_table'] ?? '[]', true);
$marketing_table = json_decode($page_data['marketing_table'] ?? '[]', true);
$preferences_table = json_decode($page_data['preferences_table'] ?? '[]', true);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">
    
    <style>
        .cookie-section {
            background: #fff;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            border-left: 4px solid #dc3545;
        }
        
        .cookie-table {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .cookie-table table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .cookie-table th,
        .cookie-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }
        
        .cookie-table th {
            background: #dc3545;
            color: white;
            font-weight: 600;
        }
        
        .cookie-type {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin: 2px;
        }
        
        .cookie-essential {
            background: #dc3545;
            color: white;
        }
        
        .cookie-analytics {
            background: #dc3545;
            color: white;
        }
        
        .cookie-marketing {
            background: #dc3545;
            color: #fff;
        }
        
        .cookie-preferences {
            background: #dc3545;
            color: white;
        }
        
        .browser-instructions {
                background: #dc35450a;
    border: 1px solid #dc3545;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        
        .update-badge {
            display: inline-block;
            background: #dc3545;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-bottom: 15px;
        }
        
        .cookie-controls {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 25px;
            margin: 20px 0;
        }
        
        .cookie-controls h4 {
            color: #dc3545;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>legal-notices/">Legal Notices</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>cookie-policy/">Cookie Policy</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->
    <br><br>
    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h1><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                            <p class="lead"><?php echo htmlspecialchars($page_data['hero_text']); ?></p>
                            <div class="update-badge"><?php echo htmlspecialchars($page_data['update_date']); ?></div>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>images/case-study/case-study-3.jpg" alt="Cookie Management" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- What Are Cookies -->
                    <div class="cookie-section">
                        <h2><?php echo htmlspecialchars($page_data['section_1_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['section_1_text']); ?></p>
                    </div>

                    <!-- Types of Cookies -->
                    <div class="cookie-section">
                        <h2><?php echo htmlspecialchars($page_data['section_2_title']); ?></h2>
                        
                        <h4>2.1 Essential Cookies</h4>
                        <p>These cookies are necessary for the website to function properly. They enable basic functions like page navigation, access to secure areas, and form submissions. The website cannot function properly without these cookies.</p>
                        
                        <div class="cookie-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Cookie Name</th>
                                        <th>Purpose</th>
                                        <th>Duration</th>
                                        <th>Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($essential_table as $cookie): ?>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($cookie['name']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($cookie['purpose']); ?></td>
                                        <td><?php echo htmlspecialchars($cookie['duration']); ?></td>
                                        <td><span class="cookie-type cookie-essential"><?php echo htmlspecialchars($cookie['type']); ?></span></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <h4>2.2 Analytics Cookies</h4>
                        <p>These cookies help us understand how visitors interact with our website by collecting and reporting information anonymously. This helps us improve our website and services.</p>
                        
                        <div class="cookie-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Cookie Name</th>
                                        <th>Purpose</th>
                                        <th>Duration</th>
                                        <th>Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($analytics_table as $cookie): ?>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($cookie['name']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($cookie['purpose']); ?></td>
                                        <td><?php echo htmlspecialchars($cookie['duration']); ?></td>
                                        <td><span class="cookie-type cookie-analytics"><?php echo htmlspecialchars($cookie['type']); ?></span></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <h4>2.3 Marketing Cookies</h4>
                        <p>These cookies are used to track visitors across websites to display relevant and engaging advertisements. They may be set by us or by third-party advertising partners.</p>
                        
                        <div class="cookie-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Cookie Name</th>
                                        <th>Purpose</th>
                                        <th>Duration</th>
                                        <th>Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($marketing_table as $cookie): ?>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($cookie['name']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($cookie['purpose']); ?></td>
                                        <td><?php echo htmlspecialchars($cookie['duration']); ?></td>
                                        <td><span class="cookie-type cookie-marketing"><?php echo htmlspecialchars($cookie['type']); ?></span></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>

                        <h4>2.4 Preference Cookies</h4>
                        <p>These cookies allow the website to remember choices you make (such as your username, language, or region) and provide enhanced, more personal features.</p>
                        
                        <div class="cookie-table">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Cookie Name</th>
                                        <th>Purpose</th>
                                        <th>Duration</th>
                                        <th>Type</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($preferences_table as $cookie): ?>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($cookie['name']); ?></strong></td>
                                        <td><?php echo htmlspecialchars($cookie['purpose']); ?></td>
                                        <td><?php echo htmlspecialchars($cookie['duration']); ?></td>
                                        <td><span class="cookie-type cookie-preferences"><?php echo htmlspecialchars($cookie['type']); ?></span></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- How We Use Cookies -->
                    <div class="cookie-section">
                        <h2>3. How We Use Cookies</h2>
                        
                        <h4>3.1 Website Functionality</h4>
                        <ul>
                            <li><strong>Authentication:</strong> To keep you signed in and secure</li>
                            <li><strong>Security:</strong> To protect against fraud and unauthorized access</li>
                            <li><strong>Forms:</strong> To remember your information when filling out forms</li>
                            <li><strong>Navigation:</strong> To maintain your session and preferences</li>
                        </ul>

                        <h4>3.2 Analytics and Performance</h4>
                        <ul>
                            <li><strong>Traffic Analysis:</strong> To understand how visitors use our website</li>
                            <li><strong>Performance Monitoring:</strong> To identify and fix technical issues</li>
                            <li><strong>User Experience:</strong> To improve website design and functionality</li>
                            <li><strong>Content Optimization:</strong> To provide relevant and useful content</li>
                        </ul>

                        <h4>3.3 Personalization</h4>
                        <ul>
                            <li><strong>Content Customization:</strong> To show relevant information based on your interests</li>
                            <li><strong>Language Preferences:</strong> To display content in your preferred language</li>
                            <li><strong>Theme Settings:</strong> To remember your visual preferences</li>
                            <li><strong>Feature Preferences:</strong> To customize your experience</li>
                        </ul>
                    </div>

                    <!-- Third-Party Cookies -->
                    <div class="cookie-section">
                        <h2>4. Third-Party Cookies</h2>
                        <p>Some cookies on our website are set by third-party services that we use to enhance your experience. These services include:</p>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Google Analytics</h4>
                                <p>We use Google Analytics to understand how visitors interact with our website. Google Analytics uses cookies to collect information about your use of our website, including your IP address.</p>
                                <p><strong>Privacy Policy:</strong> <a href="https://policies.google.com/privacy" target="_blank">Google Privacy Policy</a></p>
                            </div>
                            <div class="col-lg-6">
                                <h4>Facebook Pixel</h4>
                                <p>We use Facebook Pixel to track conversions and optimize our advertising campaigns. This helps us provide more relevant content and advertisements.</p>
                                <p><strong>Privacy Policy:</strong> <a href="https://www.facebook.com/policy.php" target="_blank">Facebook Privacy Policy</a></p>
                            </div>
                        </div>
                    </div>

                    <!-- Managing Cookies -->
                    <div class="cookie-section">
                        <h2>5. Managing Your Cookie Preferences</h2>
                        
                        <div class="cookie-controls">
                            <h4>5.1 Browser Settings</h4>
                            <p>You can control and manage cookies through your browser settings. Here's how to manage cookies in popular browsers:</p>
                            
                            <div class="browser-instructions">
                                <h5>Chrome</h5>
                                <ol>
                                    <li>Click the three dots in the top right corner</li>
                                    <li>Select "Settings" → "Privacy and security"</li>
                                    <li>Click "Cookies and other site data"</li>
                                    <li>Choose your preferred settings</li>
                                </ol>
                                
                                <h5>Firefox</h5>
                                <ol>
                                    <li>Click the menu button in the top right</li>
                                    <li>Select "Settings" → "Privacy & Security"</li>
                                    <li>Scroll to "Cookies and Site Data"</li>
                                    <li>Choose your preferred settings</li>
                                </ol>
                                
                                <h5>Safari</h5>
                                <ol>
                                    <li>Click "Safari" in the menu bar</li>
                                    <li>Select "Preferences" → "Privacy"</li>
                                    <li>Choose your cookie settings</li>
                                </ol>
                                
                                <h5>Edge</h5>
                                <ol>
                                    <li>Click the three dots in the top right</li>
                                    <li>Select "Settings" → "Cookies and site permissions"</li>
                                    <li>Click "Cookies and site data"</li>
                                    <li>Choose your preferred settings</li>
                                </ol>
                            </div>
                        </div>

                        <h4>5.2 Cookie Consent</h4>
                        <p>When you first visit our website, you'll see a cookie consent banner that allows you to:</p>
                        <ul>
                            <li><strong>Accept All Cookies:</strong> Allow all types of cookies</li>
                            <li><strong>Accept Essential Only:</strong> Allow only necessary cookies</li>
                            <li><strong>Customize Settings:</strong> Choose which types of cookies to accept</li>
                            <li><strong>Learn More:</strong> Access detailed information about our cookie policy</li>
                        </ul>

                        <h4>5.3 Opt-Out Options</h4>
                        <p>You can opt out of specific types of cookies:</p>
                        <ul>
                            <li><strong>Analytics:</strong> Use browser extensions or privacy tools to block analytics cookies</li>
                            <li><strong>Marketing:</strong> Visit the Digital Advertising Alliance or Network Advertising Initiative</li>
                            <li><strong>Social Media:</strong> Adjust your privacy settings on social media platforms</li>
                        </ul>
                    </div>

                    <!-- Impact of Disabling Cookies -->
                    <div class="cookie-section">
                        <h2>6. Impact of Disabling Cookies</h2>
                        <p>While you can disable cookies, please be aware that doing so may affect your browsing experience:</p>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Essential Cookies</h4>
                                <p><strong>Impact:</strong> Website may not function properly</p>
                                <ul>
                                    <li>Unable to stay logged in</li>
                                    <li>Forms may not work correctly</li>
                                    <li>Security features may be compromised</li>
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h4>Non-Essential Cookies</h4>
                                <p><strong>Impact:</strong> Reduced personalization and functionality</p>
                                <ul>
                                    <li>Less relevant content and ads</li>
                                    <li>Preferences not remembered</li>
                                    <li>Limited analytics capabilities</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Updates to Cookie Policy -->
                    <div class="cookie-section">
                        <h2><?php echo htmlspecialchars($page_data['section_4_title']); ?></h2>
                        <p><?php echo htmlspecialchars($page_data['section_4_text']); ?></p>
                    </div>

                    <!-- Contact Information -->
                    <div class="cookie-section">
                        <h2>8. Contact Us</h2>
                        <p>If you have any questions about our use of cookies or this Cookie Policy, please contact us:</p>
                        
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Data Protection Officer</h4>
                                <p><strong>Email:</strong> dpo@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4567<br>
                                <strong>Address:</strong> 123 Business Street, Suite 100, New York, NY 10001</p>
                            </div>
                            <div class="col-lg-6">
                                <h4>General Inquiries</h4>
                                <p><strong>Email:</strong> privacy@gifam.eu<br>
                                <strong>Phone:</strong> +1 (555) 123-4568<br>
                                <strong>Response Time:</strong> Within 48 hours</p>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Questions About Our Cookie Policy?</h3>
                                <p class="lead mb-4">Our privacy team is here to help clarify any questions about how we use cookies and tracking technologies.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Contact Privacy Team</a>
                                <a href="<?php echo $url; ?>privacy-policy/" class="btn btn-outline-primary btn-lg">Read Privacy Policy</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="<?php echo $url; ?>js/jquery.min.js"></script>
<script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
<script src="<?php echo $url; ?>js/main.js"></script>

</body>
</html> 
