<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Corporate Financial Strategy";
$query = "SELECT * FROM corporate_financial_strategy WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Corporate Financial Strategy',
        'meta_description' => 'Expertise in corporate financial strategy. Optimize your financial structure and maximize value for your shareholders.',
        'meta_keywords' => 'financial strategy, corporate finance, financial optimization, treasury management, GIFAM',
        'hero_title' => 'Corporate Financial Strategy',
        'hero_subtitle' => 'Optimize your financial structure, maximize value for your shareholders and ensure sustainable growth of your company.',
        'hero_button_text' => 'Optimize your strategy',
        'hero_button_link' => '#contact',
        'components_title' => 'Financial Strategy Components',
        'component_1_title' => 'Treasury Management',
        'component_1_description' => 'Optimization of cash flows, liquidity management and financial forecasting.',
        'component_1_icon' => 'icofont-coins',
        'component_2_title' => 'Capital Structure',
        'component_2_description' => 'Optimization of debt, equity and weighted average cost of capital.',
        'component_2_icon' => 'icofont-chart-line',
        'component_3_title' => 'Resource Allocation',
        'component_3_description' => 'Investment strategy and optimal allocation of financial resources.',
        'component_3_icon' => 'icofont-target',
        'metrics_title' => 'Key Financial Metrics',
        'metric_1_value' => '15%',
        'metric_1_label' => 'Average ROE',
        'metric_2_value' => '25%',
        'metric_2_label' => 'Revenue Growth',
        'metric_3_value' => '8%',
        'metric_3_label' => 'Optimized WACC',
        'metric_4_value' => '2.5x',
        'metric_4_label' => 'Debt/EBITDA Ratio',
        'process_title' => 'Optimization Process',
        'step_1_title' => 'Financial Diagnosis',
        'step_1_description' => 'Complete analysis of current financial situation and identification of improvement opportunities.',
        'step_2_title' => 'Goal Setting',
        'step_2_description' => 'Establishment of financial objectives aligned with the company\'s overall strategy.',
        'step_3_title' => 'Strategy Development',
        'step_3_description' => 'Creation of a personalized financial strategy with detailed action plans.',
        'step_4_title' => 'Implementation & Monitoring',
        'step_4_description' => 'Implementation of the strategy with continuous monitoring and adjustments.',
        'solutions_title' => 'Financial Solutions',
        'solution_1_title' => 'Structured Financing',
        'solution_1_description' => 'Financing solutions adapted to the specific needs of your company.',
        'solution_1_icon' => 'icofont-bank',
        'solution_2_title' => 'Risk Management',
        'solution_2_description' => 'Coverage and protection strategies against financial risks.',
        'solution_2_icon' => 'icofont-shield',
        'solution_3_title' => 'Financial Reporting',
        'solution_3_description' => 'Dashboards and financial reports for optimal decision making.',
        'solution_3_icon' => 'icofont-chart-bar',
        'value_title' => 'Value Creation',
        'value_1_title' => 'Organic Growth',
        'value_1_description' => 'Strategies to stimulate internal growth and improve profitability.',
        'value_1_icon' => 'icofont-trending-up',
        'value_2_title' => 'Mergers & Acquisitions',
        'value_2_description' => 'Support in strategic transactions to create value.',
        'value_2_icon' => 'icofont-handshake',
        'value_3_title' => 'Diversification',
        'value_3_description' => 'Diversification strategies to reduce risks and optimize returns.',
        'value_3_icon' => 'icofont-diversify',
        'cta_title' => 'Optimize your financial strategy now',
        'cta_subtitle' => 'Our team of corporate finance experts is here to support you.',
        'cta_button_text' => 'Start optimization',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">
    
<!-- Inject:css -->
<link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    
    <style>
        :root {
            --primary-color: #dc3545;
            --secondary-color: #212529;
            --accent-color:rgb(0, 0, 0);
            --success-color:rgb(0, 0, 0);
            --info-color:rgb(0, 0, 0);
            --warning-color:rgb(0, 0, 0);
        }
        
        .corporate-hero {
            background: linear-gradient(135deg, var(--accent-color) 0%, var(--accent-color) 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        
        .corporate-hero::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="finance" width="25" height="25" patternUnits="userSpaceOnUse"><rect width="25" height="25" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/><circle cx="12.5" cy="12.5" r="2" fill="rgba(255,255,255,0.1)"/></pattern></defs><rect width="100" height="100" fill="url(%23finance)"/></svg>');
            opacity: 0.3;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
        }
        
        .strategy-components {
            padding: 80px 0;
            background: white;
        }
        
        .component-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            padding: 40px 30px;
            margin-bottom: 30px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .component-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--primary-color));
        }
        
        .component-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .component-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-color));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .component-icon i {
            color: white;
            font-size: 32px;
        }
        
        .financial-metrics {
            background: var(--secondary-color);
            color: white;
            padding: 80px 0;
        }
        
        .metric-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }
        
        .metric-card {
            background: rgba(255,255,255,0.1);
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.2);
            transition: all 0.3s ease;
        }
        
        .metric-card:hover {
            transform: translateY(-5px);
            background: rgba(255,255,255,0.15);
        }
        
        .metric-value {
            font-size: 2.5rem;
            font-weight: bold;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        
        .metric-label {
            font-size: 1.1rem;
            opacity: 0.9;
        }
        
        .optimization-process {
            padding: 80px 0;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        }
        
        .process-timeline {
            position: relative;
            padding-left: 50px;
        }
        
        .process-timeline::before {
            content: '';
            position: absolute;
            left: 20px;
            top: 0;
            bottom: 0;
            width: 3px;
            background: linear-gradient(to bottom, var(--primary-color), var(--primary-color));
        }
        
        .timeline-item {
            position: relative;
            margin-bottom: 40px;
            padding-left: 30px;
        }
        
        .timeline-item::before {
            content: '';
            position: absolute;
            left: -25px;
            top: 10px;
            width: 15px;
            height: 15px;
            background: var(--primary-color);
            border-radius: 50%;
            border: 3px solid white;
            box-shadow: 0 0 0 3px var(--primary-color);
        }
        
        .solutions-section {
            padding: 80px 0;
            background: white;
        }
        
        .solution-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            text-align: center;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            margin-bottom: 30px;
            border: 2px solid transparent;
        }
        
        .solution-card:hover {
            transform: translateY(-10px);
            border-color: var(--primary-color);
        }
        
        .solution-icon {
            width: 70px;
            height: 70px;
            background: var(--primary-color);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }
        
        .solution-icon i {
            color: white;
            font-size: 28px;
        }
        
        .value-creation {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-color) 100%);
            color: white;
            padding: 80px 0;
        }
        
        .value-card {
            background: rgba(255,255,255,0.1);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.2);
        }
        
        .value-icon {
            width: 60px;
            height: 60px;
            background: rgba(255,255,255,0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 20px;
        }
        
        .value-icon i {
            color: white;
            font-size: 24px;
        }
        
        .btn-corporate {
            background: linear-gradient(45deg, var(--primary-color), var(--primary-color));
            color: white;
            border: none;
            padding: 15px 40px;
            border-radius: 50px;
            font-weight: bold;
            transition: all 0.3s ease;
        }
        
        .btn-corporate:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(220, 53, 69, 0.3);
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="corporate-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                        <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-light btn-lg"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="text-center">
                        <i class="icofont-chart-pie" style="font-size: 150px; opacity: 0.8;"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Strategy Components -->
    <section class="strategy-components">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['components_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="component-card">
                        <div class="component-icon">
                            <i class="<?php echo htmlspecialchars($page_data['component_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['component_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['component_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="component-card">
                        <div class="component-icon">
                            <i class="<?php echo htmlspecialchars($page_data['component_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['component_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['component_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="component-card">
                        <div class="component-icon">
                            <i class="<?php echo htmlspecialchars($page_data['component_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['component_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['component_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Financial Metrics -->
    <section class="financial-metrics">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['metrics_title']); ?></h2>
            <div class="metric-grid">
                <div class="metric-card">
                    <div class="metric-value"><?php echo htmlspecialchars($page_data['metric_1_value']); ?></div>
                    <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_1_label']); ?></div>
                </div>
                <div class="metric-card">
                    <div class="metric-value"><?php echo htmlspecialchars($page_data['metric_2_value']); ?></div>
                    <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_2_label']); ?></div>
                </div>
                <div class="metric-card">
                    <div class="metric-value"><?php echo htmlspecialchars($page_data['metric_3_value']); ?></div>
                    <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_3_label']); ?></div>
                </div>
                <div class="metric-card">
                    <div class="metric-value"><?php echo htmlspecialchars($page_data['metric_4_value']); ?></div>
                    <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_4_label']); ?></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Optimization Process -->
    <section class="optimization-process">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="process-timeline">
                        <div class="timeline-item">
                            <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                            <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                        </div>
                        <div class="timeline-item">
                            <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                            <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                        </div>
                        <div class="timeline-item">
                            <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                            <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                        </div>
                        <div class="timeline-item">
                            <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                            <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Solutions Section -->
    <section class="solutions-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['solutions_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="solution-card">
                        <div class="solution-icon">
                            <i class="<?php echo htmlspecialchars($page_data['solution_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['solution_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['solution_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="solution-card">
                        <div class="solution-icon">
                            <i class="<?php echo htmlspecialchars($page_data['solution_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['solution_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['solution_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="solution-card">
                        <div class="solution-icon">
                            <i class="<?php echo htmlspecialchars($page_data['solution_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['solution_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['solution_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Value Creation -->
    <section class="value-creation">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['value_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="value-card">
                        <div class="value-icon">
                            <i class="<?php echo htmlspecialchars($page_data['value_1_icon']); ?>"></i>
                        </div>
                        <h5><?php echo htmlspecialchars($page_data['value_1_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['value_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="value-card">
                        <div class="value-icon">
                            <i class="<?php echo htmlspecialchars($page_data['value_2_icon']); ?>"></i>
                        </div>
                        <h5><?php echo htmlspecialchars($page_data['value_2_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['value_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="value-card">
                        <div class="value-icon">
                            <i class="<?php echo htmlspecialchars($page_data['value_3_icon']); ?>"></i>
                        </div>
                        <h5><?php echo htmlspecialchars($page_data['value_3_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['value_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section" style="background: linear-gradient(45deg, var(--accent-color), var(--accent-color)); color: white; padding: 80px 0; text-align: center;">
        <div class="container">
            <h2 class="mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
            <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
            <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn-corporate btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
        </div>
    </section>

    <?php include '../footer.php'; ?>
    
    <!-- Scripts -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 