<?php
include '../url.php';
include '../db.php';

// Récupération des données dynamiques de la page
$page_title = "Financial Planning";
$query = "SELECT * FROM financial_planning WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Valeurs par défaut si la table est vide
if (!$page_data) {
    $page_data = [
        'page_title' => 'Risk Management Consulting - GIFAM',
        'meta_description' => 'Risk Management Consulting - Comprehensive risk assessment and mitigation strategies',
        'meta_keywords' => 'risk management, consulting, risk assessment, mitigation, GIFAM',
        'hero_title' => 'Risk Management Consulting',
        'hero_text' => 'In any financial venture, managing risk is paramount. GIFAM offers comprehensive risk assessment and mitigation strategies, helping clients understand potential risks in their projects or investments and advising on how to manage or hedge these risks effectively.',
        'hero_image' => 'wp-content/uploads/2016/11/service-1.jpg',
        'risk_types_title' => 'Types of Risks We Manage',
        'risk_1_title' => 'Market Risk',
        'risk_1_icon' => 'icofont-chart-flow-alt-2',
        'risk_1_text' => 'Analysis and management of risks related to market fluctuations, interest rates, and economic conditions.',
        'risk_1_point_1' => 'Market volatility analysis',
        'risk_1_point_2' => 'Interest rate risk',
        'risk_1_point_3' => 'Currency risk management',
        'risk_2_title' => 'Operational Risk',
        'risk_2_icon' => 'icofont-shield-check',
        'risk_2_text' => 'Identification and mitigation of risks related to internal processes, systems, and human factors.',
        'risk_2_point_1' => 'Process risk assessment',
        'risk_2_point_2' => 'Technology risk management',
        'risk_2_point_3' => 'Human error prevention',
        'risk_3_title' => 'Compliance Risk',
        'risk_3_icon' => 'icofont-law-document',
        'risk_3_text' => 'Management of regulatory and legal risks to ensure full compliance with applicable laws and regulations.',
        'risk_3_point_1' => 'Regulatory compliance',
        'risk_3_point_2' => 'Legal risk assessment',
        'risk_3_point_3' => 'Policy development',
        'process_title' => 'Our Risk Management Process',
        'process_1_title' => 'Risk Identification',
        'process_1_text' => 'Comprehensive analysis to identify all potential risks affecting your business or investments.',
        'process_2_title' => 'Risk Assessment',
        'process_2_text' => 'Evaluation of risk probability and potential impact to prioritize risk management efforts.',
        'process_3_title' => 'Strategy Development',
        'process_3_text' => 'Development of customized risk mitigation strategies and contingency plans.',
        'process_4_title' => 'Implementation & Monitoring',
        'process_4_text' => 'Execution of risk management strategies with ongoing monitoring and adjustment.',
        'process_image' => 'images/case-study/case-study-2.jpg',
        'tools_title' => 'Risk Management Tools & Techniques',
        'tool_1_title' => 'Risk Modeling',
        'tool_1_icon' => 'icofont-chart-flow-alt-1',
        'tool_1_text' => 'Advanced statistical models to quantify and predict potential risks.',
        'tool_2_title' => 'Risk Dashboards',
        'tool_2_icon' => 'icofont-dashboard-web',
        'tool_2_text' => 'Real-time monitoring dashboards for continuous risk tracking.',
        'tool_3_title' => 'Scenario Analysis',
        'tool_3_icon' => 'icofont-chart-pie',
        'tool_3_text' => 'What-if analysis to evaluate different risk scenarios and outcomes.',
        'tool_4_title' => 'Hedging Strategies',
        'tool_4_icon' => 'icofont-shield-check',
        'tool_4_text' => 'Financial instruments and strategies to hedge against specific risks.',
        'benefits_image' => 'images/case-study/case-study-3.jpg',
        'benefits_title' => 'Benefits of Professional Risk Management',
        'benefit_1_title' => 'Loss Prevention',
        'benefit_1_text' => 'Proactive identification and mitigation of risks to prevent significant financial losses.',
        'benefit_2_title' => 'Improved Decision Making',
        'benefit_2_text' => 'Better-informed decisions based on comprehensive risk analysis and assessment.',
        'benefit_3_title' => 'Regulatory Compliance',
        'benefit_3_text' => 'Ensuring all activities comply with relevant laws and regulations.'
    ];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="author" content="GIFAM">
    <meta name="description" content="Risk Management Consulting - Comprehensive risk assessment and mitigation strategies">

    <!-- responsive tag -->
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--favicon icon-->
    <link rel="icon" type="image/png" href="../images/logos/fav.png">

    <title><?php echo htmlspecialchars($page_data['page_title']); ?></title>

    <!-- Inject:css -->
    <link rel="stylesheet" type="text/css" href="../css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="../fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="../css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="../css/animate.css">
    <link rel="stylesheet" type="text/css" href="../css/style.css">
    <link rel="stylesheet" type="text/css" href="../css/responsive.css">

    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>
<body>
<?php include '../header.php'; ?>

<div id="main">
    <!-- Breadcrumb Start -->
    <div class="ras-breadcrumb">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <ul class="ras-breadcrumb-menu">
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo $url; ?>our-services/">Our Services</a></li>
                        <li class="breadcrumb-item"><a href="./">Risk Management Consulting</a></li>
                    </ul>

                </div>
            </div>
        </div>
    </div>
    <!-- Breadcrumb End -->

    <br><br>

    <!-- Main Content -->
    <div class="container main-container">
        <div class="content-area">
            <div class="entry-content">
                <div class="wpb-content-wrapper">
                    
                    <!-- Hero Section -->
                    <div class="row mb-5">
                        <div class="col-lg-8">
                            <h2><?php echo htmlspecialchars($page_data['hero_title']); ?></h2>
                            <p class="lead"><?php echo htmlspecialchars($page_data['hero_text']); ?></p>
                        </div>
                        <div class="col-lg-4">
                            <img src="<?php echo $url; ?>wp-content/uploads/2016/11/service-1.jpg" alt="Risk Management" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Risk Types -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['risk_types_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-<?php echo htmlspecialchars($page_data['risk_1_icon']); ?>" style="font-size: 3rem; color: #dc3545;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['risk_1_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['risk_1_text']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_1_point_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_1_point_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_1_point_3']); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-<?php echo htmlspecialchars($page_data['risk_2_icon']); ?>" style="font-size: 3rem; color: #ffc107;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['risk_2_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['risk_2_text']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_2_point_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_2_point_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_2_point_3']); ?></li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-4">
                            <div class="service-card h-100 p-4 border rounded shadow-sm">
                                <div class="text-center mb-3">
                                    <i class="icofont-<?php echo htmlspecialchars($page_data['risk_3_icon']); ?>" style="font-size: 3rem; color: #6f42c1;"></i>
                                </div>
                                <h4><?php echo htmlspecialchars($page_data['risk_3_title']); ?></h4>
                                <p><?php echo htmlspecialchars($page_data['risk_3_text']); ?></p>
                                <ul class="list-unstyled">
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_3_point_1']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_3_point_2']); ?></li>
                                    <li><i class="icofont-check-circled text-success"></i> <?php echo htmlspecialchars($page_data['risk_3_point_3']); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Risk Management Process -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['process_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="process-timeline">
                                <div class="d-flex mb-4">
                                    <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">1</span>
                                    </div>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['process_1_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['process_1_text']); ?></p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">2</span>
                                    </div>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['process_2_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['process_2_text']); ?></p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">3</span>
                                    </div>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['process_3_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['process_3_text']); ?></p>
                                    </div>
                                </div>
                                
                                <div class="d-flex mb-4">
                                    <div class="bg-danger text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                                        <span class="h6 mb-0">4</span>
                                    </div>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['process_4_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['process_4_text']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-6">
                            <img src="<?php echo $url; ?>images/case-study/case-study-2.jpg" alt="Risk Management Process" class="img-fluid rounded shadow">
                        </div>
                    </div>

                    <!-- Risk Management Tools -->
                    <div class="row mb-5">
                        <div class="col-12">
                            <h3 class="text-center mb-4"><?php echo htmlspecialchars($page_data['tools_title']); ?></h3>
                        </div>
                        
                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded mb-3">
                                    <i class="icofont-<?php echo htmlspecialchars($page_data['tool_1_icon']); ?>" style="font-size: 2.5rem; color: #007bff;"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['tool_1_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['tool_1_text']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded mb-3">
                                    <i class="icofont-<?php echo htmlspecialchars($page_data['tool_2_icon']); ?>" style="font-size: 2.5rem; color: #dc3545;"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['tool_2_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['tool_2_text']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded mb-3">
                                    <i class="icofont-<?php echo htmlspecialchars($page_data['tool_3_icon']); ?>" style="font-size: 2.5rem; color: #ffc107;"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['tool_3_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['tool_3_text']); ?></p>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-4">
                            <div class="text-center">
                                <div class="bg-light p-4 rounded mb-3">
                                    <i class="icofont-<?php echo htmlspecialchars($page_data['tool_4_icon']); ?>" style="font-size: 2.5rem; color: #dc3545;"></i>
                                </div>
                                <h5><?php echo htmlspecialchars($page_data['tool_4_title']); ?></h5>
                                <p><?php echo htmlspecialchars($page_data['tool_4_text']); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Benefits Section -->
                    <div class="row mb-5">
                        <div class="col-lg-6">
                            <img src="<?php echo $url; ?>images/case-study/case-study-3.jpg" alt="Risk Management Benefits" class="img-fluid rounded shadow">
                        </div>
                        <div class="col-lg-6">
                            <h3><?php echo htmlspecialchars($page_data['benefits_title']); ?></h3>
                            <div class="feature-list">
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['benefit_1_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['benefit_1_text']); ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['benefit_2_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['benefit_2_text']); ?></p>
                                    </div>
                                </div>
                                <div class="d-flex align-items-start mb-3">
                                    <i class="icofont-check-circled text-success mt-1 me-3"></i>
                                    <div>
                                        <h5><?php echo htmlspecialchars($page_data['benefit_3_title']); ?></h5>
                                        <p><?php echo htmlspecialchars($page_data['benefit_3_text']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CTA Section -->
                    <div class="row">
                        <div class="col-12">
                            <div class="bg-light p-5 rounded text-center">
                                <h3>Protect Your Business with Expert Risk Management</h3>
                                <p class="lead mb-4">Don't leave your business vulnerable to unforeseen risks. Let our experts help you develop a comprehensive risk management strategy.</p>
                                <a href="<?php echo $url; ?>contact-us/" class="btn btn-primary btn-lg me-3">Get Risk Assessment</a>
                                <a href="<?php echo $url; ?>our-services/" class="btn btn-outline-primary btn-lg">View All Services</a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include '../footer.php'; ?>

<!-- Scripts -->
<script src="../js/jquery.min.js"></script>
<script src="../js/bootstrap.min.js"></script>
<script src="../js/main.js"></script>

</body>
</html> 
