<?php 
include '../url.php';
include '../db.php';

// Récupération des données de la page depuis la base de données
$page_title = "Insurance Consulting";
$query = "SELECT * FROM insurance_consulting WHERE page_name = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $page_title);
$stmt->execute();
$result = $stmt->get_result();
$page_data = $result->fetch_assoc();

// Si la page n'existe pas, créer des données par défaut
if (!$page_data) {
    $page_data = [
        'page_title' => 'Insurance Consulting',
        'meta_description' => 'Conseil expert en assurance pour entreprises et particuliers. Optimisez votre couverture et réduisez vos risques.',
        'meta_keywords' => 'assurance, consulting, gestion des risques, GIFAM, protection, entreprise, particulier',
        'hero_title' => 'Insurance Consulting',
        'hero_subtitle' => 'Des solutions sur mesure pour protéger vos actifs et optimiser votre gestion des risques.',
        'hero_button_text' => 'Demander un audit',
        'hero_button_link' => '#contact',
        'services_title' => 'Nos services en assurance',
        'service_1_title' => 'Audit de couverture',
        'service_1_description' => 'Analyse complète de vos contrats et identification des lacunes de couverture.',
        'service_1_icon' => 'icofont-search-1',
        'service_2_title' => 'Optimisation des polices',
        'service_2_description' => 'Recommandations pour optimiser vos garanties et réduire vos coûts.',
        'service_2_icon' => 'icofont-settings',
        'service_3_title' => 'Gestion des sinistres',
        'service_3_description' => 'Accompagnement dans la gestion et la déclaration de sinistres.',
        'service_3_icon' => 'icofont-warning',
        'process_title' => 'Notre démarche',
        'step_1_title' => 'Analyse des besoins',
        'step_1_description' => 'Évaluation personnalisée de vos besoins en assurance.',
        'step_2_title' => 'Étude des contrats',
        'step_2_description' => 'Analyse détaillée de vos contrats existants.',
        'step_3_title' => 'Optimisation',
        'step_3_description' => 'Proposition de solutions adaptées et négociation avec les assureurs.',
        'step_4_title' => 'Suivi & gestion',
        'step_4_description' => 'Accompagnement continu et gestion des évolutions.',
        'metrics_title' => 'Nos chiffres clés',
        'metric_1_number' => '100+',
        'metric_1_label' => 'Clients accompagnés',
        'metric_2_number' => '15M€',
        'metric_2_label' => "Valeur d'actifs protégés",
        'metric_3_number' => '98%',
        'metric_3_label' => 'Satisfaction clients',
        'metric_4_number' => '24h',
        'metric_4_label' => 'Délai moyen de réponse',
        'cta_title' => 'Prêt à sécuriser votre avenir ?',
        'cta_subtitle' => 'Nos experts vous conseillent pour une protection optimale.',
        'cta_button_text' => 'Contactez-nous',
        'cta_button_link' => '../contact-us/'
    ];
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_data['page_title']); ?> - GIFAM</title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo htmlspecialchars($page_data['meta_description']); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($page_data['meta_keywords']); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo $url; ?>images/logos/fav.png">
    
<!-- Inject:css -->
<link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>fonts/icofont.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/nice-select.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/style.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $url; ?>css/responsive.css">
    <style>
        :root {
            --primary-color: #007bff;
            --secondary-color: #212529;
            --accent-color: #17a2b8;
        }
        .ic-hero {
            background: linear-gradient(135deg, var(--accent-color) 0%, var(--accent-color) 100%);
            color: white;
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }
        .ic-hero::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0; bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 100 100\'><defs><pattern id=\'ic\' width=\'40\' height=\'40\' patternUnits=\'userSpaceOnUse\'><circle cx=\'20\' cy=\'20\' r=\'3\' fill=\'rgba(255,255,255,0.1)\'/></pattern></defs><rect width=\'100\' height=\'100\' fill=\'url(%23ic)\'/></svg>');
            opacity: 0.3;
        }
        .hero-content { position: relative; z-index: 2; }
        .ic-services { padding: 80px 0; background: white; }
        .service-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            padding: 40px 30px;
            margin-bottom: 30px;
            text-align: center;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        .service-card::before {
            content: '';
            position: absolute;
            top: 0; left: 0; right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--primary-color), var(--primary-color));
        }
        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        .service-icon {
            width: 80px; height: 80px;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-color));
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            margin: 0 auto 25px;
        }
        .service-icon i { color: white; font-size: 32px; }
        .process-section {
            background: var(--secondary-color);
            color: white;
            padding: 80px 0;
        }
        .process-step {
            background: rgba(255,255,255,0.1);
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.2);
            position: relative;
        }
        .process-step::before {
            content: '';
            position: absolute;
            top: 0; left: 0;
            width: 5px; height: 100%;
            background: linear-gradient(to bottom, var(--primary-color), var(--primary-color));
        }
        .step-number {
            width: 60px; height: 60px;
            background: var(--primary-color);
            color: white;
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-size: 20px; font-weight: bold;
            margin-bottom: 20px;
        }
        .success-metrics {
            padding: 80px 0;
            background: white;
        }
        .metric-item {
            text-align: center;
            padding: 30px;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: 20px;
            margin-bottom: 30px;
        }
        .metric-number {
            font-size: 3rem;
            font-weight: bold;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        .metric-label {
            color: var(--secondary-color);
            font-weight: 600;
        }
        .cta-section {
            background: linear-gradient(45deg, var(--accent-color), var(--accent-color));
            color: white;
            padding: 80px 0;
            text-align: center;
        }
        .btn-ic {
            background: linear-gradient(45deg, var(--primary-color), var(--primary-color));
            color: white;
            border: none;
            padding: 15px 40px;
            border-radius: 50px;
            font-weight: bold;
            transition: all 0.3s ease;
        }
        .btn-ic:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(0,123,255,0.3);
        }
    </style>
</head>
<body>
    <?php include '../header.php'; ?>

    <!-- Hero Section -->
    <section class="ic-hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <div class="hero-content">
                        <h1 class="display-4 fw-bold mb-4"><?php echo htmlspecialchars($page_data['hero_title']); ?></h1>
                        <p class="lead mb-4"><?php echo htmlspecialchars($page_data['hero_subtitle']); ?></p>
                        <a href="<?php echo htmlspecialchars($page_data['hero_button_link']); ?>" class="btn btn-light btn-lg"><?php echo htmlspecialchars($page_data['hero_button_text']); ?></a>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="text-center">
                        <i class="icofont-shield" style="font-size: 150px; opacity: 0.8;"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="ic-services">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['services_title']); ?></h2>
            <div class="row">
                <div class="col-lg-4">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_1_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_1_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_2_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_2_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="<?php echo htmlspecialchars($page_data['service_3_icon']); ?>"></i>
                        </div>
                        <h4><?php echo htmlspecialchars($page_data['service_3_title']); ?></h4>
                        <p><?php echo htmlspecialchars($page_data['service_3_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section class="process-section">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['process_title']); ?></h2>
            <div class="row">
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number">1</div>
                        <h5><?php echo htmlspecialchars($page_data['step_1_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_1_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number">2</div>
                        <h5><?php echo htmlspecialchars($page_data['step_2_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_2_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number">3</div>
                        <h5><?php echo htmlspecialchars($page_data['step_3_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_3_description']); ?></p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="process-step">
                        <div class="step-number">4</div>
                        <h5><?php echo htmlspecialchars($page_data['step_4_title']); ?></h5>
                        <p><?php echo htmlspecialchars($page_data['step_4_description']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Success Metrics -->
    <section class="success-metrics">
        <div class="container">
            <h2 class="text-center mb-5"><?php echo htmlspecialchars($page_data['metrics_title']); ?></h2>
            <div class="row">
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_1_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_1_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_2_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_2_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_3_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_3_label']); ?></div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="metric-item">
                        <div class="metric-number"><?php echo htmlspecialchars($page_data['metric_4_number']); ?></div>
                        <div class="metric-label"><?php echo htmlspecialchars($page_data['metric_4_label']); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <h2 class="mb-4"><?php echo htmlspecialchars($page_data['cta_title']); ?></h2>
            <p class="lead mb-4"><?php echo htmlspecialchars($page_data['cta_subtitle']); ?></p>
            <a href="<?php echo htmlspecialchars($page_data['cta_button_link']); ?>" class="btn-ic btn-lg"><?php echo htmlspecialchars($page_data['cta_button_text']); ?></a>
        </div>
    </section>

    <?php include '../footer.php'; ?>
    
    <!-- Scripts -->
    <script src="<?php echo $url; ?>js/jquery.min.js"></script>
    <script src="<?php echo $url; ?>js/bootstrap.min.js"></script>
</body>
</html> 
