-- Création de la table investment_analysis_advisory pour stocker les données de la page
CREATE TABLE IF NOT EXISTS `investment_analysis_advisory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(255) NOT NULL,
  `page_title` varchar(255) DEFAULT NULL,
  `meta_description` text,
  `meta_keywords` text,
  `hero_title` varchar(255) DEFAULT NULL,
  `hero_subtitle` text,
  `hero_button_text` varchar(255) DEFAULT NULL,
  `hero_button_link` varchar(255) DEFAULT NULL,
  `analysis_1_title` varchar(255) DEFAULT NULL,
  `analysis_1_description` text,
  `analysis_1_icon` varchar(100) DEFAULT NULL,
  `analysis_2_title` varchar(255) DEFAULT NULL,
  `analysis_2_description` text,
  `analysis_2_icon` varchar(100) DEFAULT NULL,
  `analysis_3_title` varchar(255) DEFAULT NULL,
  `analysis_3_description` text,
  `analysis_3_icon` varchar(100) DEFAULT NULL,
  `metrics_title` varchar(255) DEFAULT NULL,
  `metric_1_number` varchar(50) DEFAULT NULL,
  `metric_1_label` varchar(255) DEFAULT NULL,
  `metric_2_number` varchar(50) DEFAULT NULL,
  `metric_2_label` varchar(255) DEFAULT NULL,
  `metric_3_number` varchar(50) DEFAULT NULL,
  `metric_3_label` varchar(255) DEFAULT NULL,
  `metric_4_number` varchar(50) DEFAULT NULL,
  `metric_4_label` varchar(255) DEFAULT NULL,
  `strategy_title` varchar(255) DEFAULT NULL,
  `step_1_title` varchar(255) DEFAULT NULL,
  `step_1_description` text,
  `step_2_title` varchar(255) DEFAULT NULL,
  `step_2_description` text,
  `step_3_title` varchar(255) DEFAULT NULL,
  `step_3_description` text,
  `step_4_title` varchar(255) DEFAULT NULL,
  `step_4_description` text,
  `expertise_title` varchar(255) DEFAULT NULL,
  `expertise_1_title` varchar(255) DEFAULT NULL,
  `expertise_1_description` text,
  `expertise_1_icon` varchar(100) DEFAULT NULL,
  `expertise_2_title` varchar(255) DEFAULT NULL,
  `expertise_2_description` text,
  `expertise_2_icon` varchar(100) DEFAULT NULL,
  `expertise_3_title` varchar(255) DEFAULT NULL,
  `expertise_3_description` text,
  `expertise_3_icon` varchar(100) DEFAULT NULL,
  `cta_title` varchar(255) DEFAULT NULL,
  `cta_subtitle` text,
  `cta_button_text` varchar(255) DEFAULT NULL,
  `cta_button_link` varchar(255) DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_name` (`page_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insertion des données pour la page Investment Analysis and Advisory
INSERT INTO `investment_analysis_advisory` (
  `page_name`,
  `page_title`,
  `meta_description`,
  `meta_keywords`,
  `hero_title`,
  `hero_subtitle`,
  `hero_button_text`,
  `hero_button_link`,
  `analysis_1_title`,
  `analysis_1_description`,
  `analysis_1_icon`,
  `analysis_2_title`,
  `analysis_2_description`,
  `analysis_2_icon`,
  `analysis_3_title`,
  `analysis_3_description`,
  `analysis_3_icon`,
  `metrics_title`,
  `metric_1_number`,
  `metric_1_label`,
  `metric_2_number`,
  `metric_2_label`,
  `metric_3_number`,
  `metric_3_label`,
  `metric_4_number`,
  `metric_4_label`,
  `strategy_title`,
  `step_1_title`,
  `step_1_description`,
  `step_2_title`,
  `step_2_description`,
  `step_3_title`,
  `step_3_description`,
  `step_4_title`,
  `step_4_description`,
  `expertise_title`,
  `expertise_1_title`,
  `expertise_1_description`,
  `expertise_1_icon`,
  `expertise_2_title`,
  `expertise_2_description`,
  `expertise_2_icon`,
  `expertise_3_title`,
  `expertise_3_description`,
  `expertise_3_icon`,
  `cta_title`,
  `cta_subtitle`,
  `cta_button_text`,
  `cta_button_link`
) VALUES (
  'Investment Analysis and Advisory',
  'Investment Analysis and Advisory',
  'Expertise in financial analysis and investment advisory. Optimize your portfolios with our personalized strategies.',
  'financial analysis, investment advisory, portfolio management, investment strategy, GIFAM',
  'Investment Analysis and Advisory',
  'Optimize your investments with our expertise in financial analysis and personalized investment strategies.',
  'Consult our experts',
  '#contact',
  'Portfolio Analysis',
  'Complete evaluation of your current portfolio with personalized optimization recommendations.',
  'icofont-chart-pie',
  'Investment Strategy',
  'Development of investment strategies adapted to your objectives and risk profile.',
  'icofont-target',
  'Risk Management',
  'Identification and mitigation of risks to protect and optimize your investments.',
  'icofont-shield',
  'Our Performance',
  '15+',
  'Years of experience',
  '500+',
  'Managed portfolios',
  '25%',
  'Average return',
  '98%',
  'Satisfied clients',
  'Our Strategic Approach',
  'Initial Analysis',
  'Evaluation of your financial situation, objectives and risk tolerance.',
  'Strategy Development',
  'Creation of a personalized and diversified investment strategy.',
  'Implementation',
  'Implementation of the strategy with continuous monitoring and adjustments.',
  'Continuous Optimization',
  'Regular monitoring and optimization of the portfolio.',
  'Our Areas of Expertise',
  'International Markets',
  'Access to international financial markets with expertise in geographical diversification.',
  'icofont-globe',
  'Real Estate Investment',
  'Real estate investment strategies with in-depth market analysis.',
  'icofont-building',
  'Structured Products',
  'Innovative investment solutions adapted to complex markets.',
  'icofont-coins',
  'Ready to optimize your investments?',
  'Our experts are here to guide you towards financial success.',
  'Start now',
  '../contact-us/'
) ON DUPLICATE KEY UPDATE
  `page_title` = VALUES(`page_title`),
  `meta_description` = VALUES(`meta_description`),
  `meta_keywords` = VALUES(`meta_keywords`),
  `hero_title` = VALUES(`hero_title`),
  `hero_subtitle` = VALUES(`hero_subtitle`),
  `hero_button_text` = VALUES(`hero_button_text`),
  `hero_button_link` = VALUES(`hero_button_link`),
  `analysis_1_title` = VALUES(`analysis_1_title`),
  `analysis_1_description` = VALUES(`analysis_1_description`),
  `analysis_1_icon` = VALUES(`analysis_1_icon`),
  `analysis_2_title` = VALUES(`analysis_2_title`),
  `analysis_2_description` = VALUES(`analysis_2_description`),
  `analysis_2_icon` = VALUES(`analysis_2_icon`),
  `analysis_3_title` = VALUES(`analysis_3_title`),
  `analysis_3_description` = VALUES(`analysis_3_description`),
  `analysis_3_icon` = VALUES(`analysis_3_icon`),
  `metrics_title` = VALUES(`metrics_title`),
  `metric_1_number` = VALUES(`metric_1_number`),
  `metric_1_label` = VALUES(`metric_1_label`),
  `metric_2_number` = VALUES(`metric_2_number`),
  `metric_2_label` = VALUES(`metric_2_label`),
  `metric_3_number` = VALUES(`metric_3_number`),
  `metric_3_label` = VALUES(`metric_3_label`),
  `metric_4_number` = VALUES(`metric_4_number`),
  `metric_4_label` = VALUES(`metric_4_label`),
  `strategy_title` = VALUES(`strategy_title`),
  `step_1_title` = VALUES(`step_1_title`),
  `step_1_description` = VALUES(`step_1_description`),
  `step_2_title` = VALUES(`step_2_title`),
  `step_2_description` = VALUES(`step_2_description`),
  `step_3_title` = VALUES(`step_3_title`),
  `step_3_description` = VALUES(`step_3_description`),
  `step_4_title` = VALUES(`step_4_title`),
  `step_4_description` = VALUES(`step_4_description`),
  `expertise_title` = VALUES(`expertise_title`),
  `expertise_1_title` = VALUES(`expertise_1_title`),
  `expertise_1_description` = VALUES(`expertise_1_description`),
  `expertise_1_icon` = VALUES(`expertise_1_icon`),
  `expertise_2_title` = VALUES(`expertise_2_title`),
  `expertise_2_description` = VALUES(`expertise_2_description`),
  `expertise_2_icon` = VALUES(`expertise_2_icon`),
  `expertise_3_title` = VALUES(`expertise_3_title`),
  `expertise_3_description` = VALUES(`expertise_3_description`),
  `expertise_3_icon` = VALUES(`expertise_3_icon`),
  `cta_title` = VALUES(`cta_title`),
  `cta_subtitle` = VALUES(`cta_subtitle`),
  `cta_button_text` = VALUES(`cta_button_text`),
  `cta_button_link` = VALUES(`cta_button_link`); 